/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.mutator.configuration;

import com.google.common.reflect.ClassPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.configuration.ConfigurationReader;

public abstract class ConfiguredObjectBuilder {
    private static final ConcurrentHashMap<String, List<ClassPath.ClassInfo>> SCAN_URL_TO_CLASS_INFOS = new ConcurrentHashMap();
    public static final String CONFIGURATION_SCAN_URLS = "global.scanUrls";
    public static final String CONFIGURATION_CLASS_NAME = "className";
    private final Configuration configuration;
    private final Map<String, String> sparkConfiguration;

    public ConfiguredObjectBuilder(Configuration configuration, Map<String, String> sparkConfiguration) {
        this.configuration = configuration;
        this.sparkConfiguration = sparkConfiguration;
        try {
            List scanUrls = (List)configuration.get(CONFIGURATION_SCAN_URLS, Collections.singletonList("org.openstreetmap.atlas")).value();
            if (scanUrls.stream().anyMatch(scanUrl -> !SCAN_URL_TO_CLASS_INFOS.containsKey(scanUrl))) {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                ClassPath classPath = ClassPath.from((ClassLoader)loader);
                for (String scanUrl2 : scanUrls) {
                    if (SCAN_URL_TO_CLASS_INFOS.containsKey(scanUrl2)) continue;
                    SCAN_URL_TO_CLASS_INFOS.put(scanUrl2, new ArrayList());
                    for (ClassPath.ClassInfo classInfo : classPath.getTopLevelClassesRecursive(scanUrl2)) {
                        SCAN_URL_TO_CLASS_INFOS.get(scanUrl2).add(classInfo);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new CoreException("Unable to build objects with {}.", new Object[]{this.getClass().getSimpleName(), e});
        }
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    protected Class<?> getClass(String configurationRoot) {
        String className = this.getClassName(configurationRoot);
        Class<?> clazz = null;
        for (ClassPath.ClassInfo classInfo : SCAN_URL_TO_CLASS_INFOS.values().stream().flatMap(Collection::stream).collect(Collectors.toList())) {
            if (!classInfo.getSimpleName().equals(className)) continue;
            try {
                clazz = Thread.currentThread().getContextClassLoader().loadClass(classInfo.getName());
            }
            catch (Exception e) {
                throw new CoreException("Cannot build {}", new Object[]{className, e});
            }
        }
        return clazz;
    }

    protected String getClassName(String configurationRoot) {
        return (String)new ConfigurationReader(configurationRoot).configurationValue(this.configuration, CONFIGURATION_CLASS_NAME, (Object)configurationRoot);
    }

    protected Map<String, String> getSparkConfiguration() {
        return this.sparkConfiguration;
    }
}

