/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.mutator.configuration;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.atlas.mutator.configuration.AtlasMutationLevel;
import org.openstreetmap.atlas.mutator.configuration.AtlasMutatorConfiguration;
import org.openstreetmap.atlas.mutator.configuration.InputDependency;
import org.openstreetmap.atlas.mutator.configuration.broadcast.ConfiguredBroadcastable;
import org.openstreetmap.atlas.mutator.configuration.mutators.ConfiguredAtlasChangeGenerator;
import org.openstreetmap.atlas.mutator.configuration.parsing.ConfiguredAtlasFetcher;
import org.openstreetmap.atlas.mutator.configuration.parsing.ConfiguredDynamicAtlasPolicy;
import org.openstreetmap.atlas.mutator.configuration.parsing.ConfiguredSubAtlas;
import org.openstreetmap.atlas.mutator.configuration.parsing.mergeforgiveness.ConfiguredMergeForgivenessPolicy;
import org.openstreetmap.atlas.utilities.configuration.ConfiguredFilter;

public class AtlasMutatorConfigurationDetails {
    private final AtlasMutatorConfiguration configuration;
    private final Map<String, ConfiguredAtlasChangeGenerator> mutators;
    private final Map<String, ConfiguredDynamicAtlasPolicy> dynamicAtlasPolicies;
    private final Map<String, ConfiguredFilter> filters;
    private final Map<String, InputDependency> inputDependencies;
    private final Map<String, ConfiguredAtlasFetcher> fetchers;
    private final Map<String, ConfiguredSubAtlas> subAtlases;
    private final Map<String, ConfiguredMergeForgivenessPolicy> mergeForgivenessPolicies;
    private final Map<String, ConfiguredBroadcastable> broadcastables;

    public AtlasMutatorConfigurationDetails(AtlasMutatorConfiguration configuration) {
        this.configuration = configuration;
        this.mutators = new HashMap<String, ConfiguredAtlasChangeGenerator>();
        this.dynamicAtlasPolicies = new HashMap<String, ConfiguredDynamicAtlasPolicy>();
        this.filters = new HashMap<String, ConfiguredFilter>();
        this.inputDependencies = new HashMap<String, InputDependency>();
        this.fetchers = new HashMap<String, ConfiguredAtlasFetcher>();
        this.subAtlases = new HashMap<String, ConfiguredSubAtlas>();
        this.mergeForgivenessPolicies = new HashMap<String, ConfiguredMergeForgivenessPolicy>();
        this.broadcastables = new HashMap<String, ConfiguredBroadcastable>();
        this.discoverExtendedConfigurationMaps();
    }

    public Set<String> getAllConfigurationMapKeys() {
        HashSet<String> allKeys = new HashSet<String>();
        allKeys.addAll(Arrays.asList("_mutator", "_level", "_dynamicAtlasPolicy", "_filter", "_inputDependency", "_fetcher", "_subAtlas", "_mergeForgivenessPolicy", "_broadcastable"));
        allKeys.addAll(this.configuration.getCountryToMutationLevels().keySet());
        allKeys.addAll(this.mutators.keySet());
        allKeys.addAll(this.dynamicAtlasPolicies.keySet());
        allKeys.addAll(this.filters.keySet());
        allKeys.addAll(this.inputDependencies.keySet());
        allKeys.addAll(this.fetchers.keySet());
        allKeys.addAll(this.subAtlases.keySet());
        allKeys.addAll(this.mergeForgivenessPolicies.keySet());
        allKeys.addAll(this.broadcastables.keySet());
        return allKeys;
    }

    public Map<String, ConfiguredBroadcastable> getBroadcastables() {
        return this.broadcastables;
    }

    public Map<String, ConfiguredDynamicAtlasPolicy> getDynamicAtlasPolicies() {
        return this.dynamicAtlasPolicies;
    }

    public Map<String, ConfiguredAtlasFetcher> getFetchers() {
        return this.fetchers;
    }

    public Map<String, ConfiguredFilter> getFilters() {
        return this.filters;
    }

    public Map<String, InputDependency> getInputDependencies() {
        return this.inputDependencies;
    }

    public Map<String, ConfiguredMergeForgivenessPolicy> getMergeForgivenessPolicies() {
        return this.mergeForgivenessPolicies;
    }

    public Map<String, ConfiguredAtlasChangeGenerator> getMutators() {
        return this.mutators;
    }

    public Map<String, ConfiguredSubAtlas> getSubAtlases() {
        return this.subAtlases;
    }

    private void discoverExtendedConfigurationMaps() {
        ConfiguredSubAtlas subAtlas;
        for (Map.Entry<String, List<AtlasMutationLevel>> entry : this.configuration.getCountryToMutationLevels().entrySet()) {
            for (AtlasMutationLevel level : entry.getValue()) {
                ConfiguredDynamicAtlasPolicy generationPolicy = level.getConfiguredGenerationPolicy();
                ConfiguredDynamicAtlasPolicy applicationPolicy = level.getConfiguredApplicationPolicy();
                if (!this.dynamicAtlasPolicies.containsKey(generationPolicy.getName())) {
                    this.dynamicAtlasPolicies.put(generationPolicy.getName(), generationPolicy);
                }
                if (!this.dynamicAtlasPolicies.containsKey(applicationPolicy.getName())) {
                    this.dynamicAtlasPolicies.put(applicationPolicy.getName(), applicationPolicy);
                }
                for (ConfiguredAtlasChangeGenerator mutator : level.getMutators()) {
                    if (this.mutators.containsKey(mutator.getName())) continue;
                    this.mutators.put(mutator.getName(), mutator);
                }
            }
        }
        for (Map.Entry<String, Object> entry : this.dynamicAtlasPolicies.entrySet()) {
            ConfiguredFilter filter = ((ConfiguredDynamicAtlasPolicy)entry.getValue()).getEntitiesToConsiderForExpansion();
            if (filter != null) {
                this.filters.put(filter.getName(), filter);
            }
            ((ConfiguredDynamicAtlasPolicy)entry.getValue()).getInputDependency().ifPresent(inputDependency -> this.inputDependencies.put(inputDependency.getPathName(), (InputDependency)inputDependency));
            ConfiguredAtlasFetcher fetcher = ((ConfiguredDynamicAtlasPolicy)entry.getValue()).getConfiguredFetcher();
            if (fetcher == null) continue;
            this.fetchers.put(fetcher.getName(), fetcher);
        }
        for (Map.Entry<String, Object> entry : this.mutators.entrySet()) {
            Map<String, ConfiguredBroadcastable> broadcastVariables;
            for (InputDependency dependency : ((ConfiguredAtlasChangeGenerator)entry.getValue()).getInputDependencies()) {
                if (this.inputDependencies.containsKey(dependency.getPathName())) continue;
                this.inputDependencies.put(dependency.getPathName(), dependency);
            }
            ConfiguredMergeForgivenessPolicy policy = ((ConfiguredAtlasChangeGenerator)entry.getValue()).getMergeForgivenessPolicy();
            if (policy != null && !this.mergeForgivenessPolicies.containsKey(policy.getOwner()) && !policy.policyIsEmpty()) {
                this.mergeForgivenessPolicies.put(policy.getOwner(), policy);
            }
            if ((broadcastVariables = ((ConfiguredAtlasChangeGenerator)entry.getValue()).getBroadcastVariablesNeeded()) == null) continue;
            this.broadcastables.putAll(broadcastVariables);
        }
        for (Map.Entry<String, Object> entry : this.inputDependencies.entrySet()) {
            subAtlas = ((InputDependency)entry.getValue()).getSubAtlas();
            if (subAtlas == null) continue;
            this.subAtlases.put(subAtlas.getName(), subAtlas);
        }
        for (Map.Entry<String, Object> entry : this.fetchers.entrySet()) {
            subAtlas = ((ConfiguredAtlasFetcher)entry.getValue()).getSubAtlas();
            if (subAtlas == null || this.subAtlases.containsKey(subAtlas.getName())) continue;
            this.subAtlases.put(subAtlas.getName(), subAtlas);
        }
        this.mergeForgivenessPolicies.put(this.configuration.getGlobalMergeForgivenessPolicy().getOwner(), this.configuration.getGlobalMergeForgivenessPolicy());
    }
}

