/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.mutator.configuration;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.Path;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.generator.AtlasGeneratorParameters;
import org.openstreetmap.atlas.generator.tools.streaming.ResourceFileSystem;
import org.openstreetmap.atlas.mutator.AtlasMutatorParameters;
import org.openstreetmap.atlas.mutator.configuration.AtlasMutatorConfiguration;
import org.openstreetmap.atlas.streaming.resource.OutputStreamWritableResource;
import org.openstreetmap.atlas.streaming.resource.WritableResource;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasMutatorConfigurationCommand
extends Command {
    public static final Command.Switch<WritableResource> OUTPUT = new Command.Switch("output", "Resource to save output", value -> {
        try {
            return new OutputStreamWritableResource((OutputStream)new ResourceFileSystem().create(new Path(value)));
        }
        catch (IOException e) {
            throw new CoreException("Could not save to {}", new Object[]{value, e});
        }
    }, Command.Optionality.OPTIONAL);
    private static final Logger logger = LoggerFactory.getLogger(AtlasMutatorConfigurationCommand.class);

    public static void main(String[] args) {
        new AtlasMutatorConfigurationCommand().run(args);
    }

    protected int onRun(CommandMap command) {
        WritableResource output;
        Map<String, String> configurationMap = ResourceFileSystem.simpleconfiguration();
        Set<String> countries = ((StringList)command.get(AtlasGeneratorParameters.COUNTRIES)).stream().collect(Collectors.toSet());
        Configuration configuration = AtlasMutatorParameters.mutatorsConfiguration(command, configurationMap);
        boolean groupCountries = (Boolean)command.get(AtlasMutatorParameters.GROUP_COUNTRIES);
        AtlasMutatorConfiguration atlasMutatorConfiguration = new AtlasMutatorConfiguration(countries, null, null, "input", "output", configurationMap, configuration, groupCountries, true, true);
        String result = atlasMutatorConfiguration.detailsString();
        if (logger.isInfoEnabled()) {
            logger.info("Parsed configuration:\n{}", (Object)result);
        }
        if ((output = (WritableResource)command.get(OUTPUT)) != null) {
            output.writeAndClose(result);
        }
        return 0;
    }

    protected Command.SwitchList switches() {
        return new Command.SwitchList().with(new Command.Switch[]{AtlasMutatorParameters.MUTATOR_CONFIGURATION_RESOURCE, AtlasMutatorParameters.MUTATOR_CONFIGURATION_JSON, AtlasGeneratorParameters.COUNTRIES, AtlasMutatorParameters.GROUP_COUNTRIES, OUTPUT});
    }
}

