/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.mutator.configuration;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.boundary.CountryBoundaryMap;
import org.openstreetmap.atlas.geography.converters.jts.JtsPolygonToMultiPolygonConverter;
import org.openstreetmap.atlas.geography.sharding.Sharding;
import org.openstreetmap.atlas.mutator.configuration.AtlasMutationLevel;
import org.openstreetmap.atlas.mutator.configuration.AtlasMutatorConfigurationDetails;
import org.openstreetmap.atlas.mutator.configuration.parsing.AtlasMutatorConfigurationParser;
import org.openstreetmap.atlas.mutator.configuration.parsing.mergeforgiveness.ConfiguredMergeForgivenessPolicy;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.maps.MultiMap;
import org.openstreetmap.atlas.utilities.tuples.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasMutatorConfiguration
implements Serializable {
    public static final String GROUP_PREFIX = "GROUP";
    public static final String TYPE_JSON_PROPERTY = "type";
    public static final String MUTATORS_JSON_PROPERTY = "mutators";
    public static final String LEVELS_JSON_PROPERTY = "levels";
    public static final String DYNAMIC_ATLAS_POLICIES_JSON_PROPERTY = "dynamicAtlasPolicies";
    public static final String FILTERS_JSON_PROPERTY = "filters";
    public static final String INPUT_DEPENDENCIES_JSON_PROPERTY = "inputDependencies";
    public static final String FETCHERS_JSON_PROPERTY = "fetchers";
    public static final String SUB_ATLASES_JSON_PROPERTY = "subAtlases";
    public static final String MERGE_FORGIVENESS_POLICIES_JSON_PROPERTY = "mergeForgivenessPolicies";
    public static final String BROADCASTABLES_JSON_PROPERTY = "broadcastables";
    private static final long serialVersionUID = 6108679410416988121L;
    private static final Logger logger = LoggerFactory.getLogger(AtlasMutatorConfiguration.class);
    private final Sharding sharding;
    private final transient CountryBoundaryMap boundaries;
    private final String input;
    private final String output;
    private final Map<String, String> sparkConfiguration;
    private final Map<String, List<AtlasMutationLevel>> countryToMutationLevels;
    private final ConfiguredMergeForgivenessPolicy globalMergeForgivenessPolicy;

    public AtlasMutatorConfiguration(Set<String> countries, Sharding sharding, CountryBoundaryMap boundaries, String input, String output, Map<String, String> sparkConfiguration, Configuration mutatorsConfiguration, boolean groupCountries, boolean allowRDD, boolean preloadRDD, boolean validateBoundaries) {
        this.sharding = sharding;
        this.boundaries = boundaries;
        this.input = input;
        this.output = output;
        this.sparkConfiguration = sparkConfiguration;
        this.countryToMutationLevels = new AtlasMutatorConfigurationParser(this, mutatorsConfiguration, sparkConfiguration).generateCountryToMutationLevels(countries, groupCountries, allowRDD, preloadRDD);
        this.globalMergeForgivenessPolicy = ConfiguredMergeForgivenessPolicy.fromGlobal(mutatorsConfiguration);
        logger.debug("For global read mergeForgivenessPolicy\n{}", (Object)this.globalMergeForgivenessPolicy);
        if (validateBoundaries) {
            this.validateCountryAndBoundaries(countries);
        }
    }

    public AtlasMutatorConfiguration(Set<String> countries, Sharding sharding, CountryBoundaryMap boundaries, String input, String output, Map<String, String> sparkConfiguration, Configuration mutatorsConfiguration, boolean groupCountries, boolean allowRDD, boolean preloadRDD) {
        this(countries, sharding, boundaries, input, output, sparkConfiguration, mutatorsConfiguration, groupCountries, allowRDD, preloadRDD, true);
    }

    public MultiPolygon boundary(String country) {
        if (this.boundaries.countryBoundary(country) == null) {
            throw new CoreException("Country {} has no boundaries in the boundary file", new Object[]{country});
        }
        JtsPolygonToMultiPolygonConverter jtsPolygonToMultiPolygonConverter = new JtsPolygonToMultiPolygonConverter();
        return this.boundaries.countryBoundary(country).stream().map(arg_0 -> ((JtsPolygonToMultiPolygonConverter)jtsPolygonToMultiPolygonConverter).convert(arg_0)).reduce(new MultiPolygon(new MultiMap()), (left, right) -> {
            MultiMap outersToInners = new MultiMap();
            outersToInners.addAll(left.getOuterToInners());
            outersToInners.addAll(right.getOuterToInners());
            return new MultiPolygon(outersToInners);
        });
    }

    public Tuple<Tuple<String, Set<String>>, List<AtlasMutationLevel>> countryOrGroupAndLevelList(String countryOrGroup) {
        List<AtlasMutationLevel> levels = this.countryToMutationLevels.get(countryOrGroup);
        if (levels != null) {
            Set<String> countries = levels.iterator().next().getCountries();
            return new Tuple((Object)new Tuple((Object)countryOrGroup, countries), levels);
        }
        return null;
    }

    public Map<Tuple<String, Set<String>>, List<AtlasMutationLevel>> countryOrGroupsToLevelLists() {
        HashMap<Tuple<String, Set<String>>, List<AtlasMutationLevel>> result = new HashMap<Tuple<String, Set<String>>, List<AtlasMutationLevel>>();
        for (String countryOrGroupKey : this.countryToMutationLevels.keySet()) {
            Tuple<Tuple<String, Set<String>>, List<AtlasMutationLevel>> countryOrGroupTolevel = this.countryOrGroupAndLevelList(countryOrGroupKey);
            if (countryOrGroupTolevel == null) {
                throw new CoreException("Key {} not found in countryToMutationLevels, this should not happen!", new Object[]{countryOrGroupKey});
            }
            result.put((Tuple<String, Set<String>>)((Tuple)countryOrGroupTolevel.getFirst()), (List)countryOrGroupTolevel.getSecond());
        }
        return result;
    }

    public Map<Tuple<String, Set<String>>, String> details() {
        HashMap<Tuple<String, Set<String>>, String> result = new HashMap<Tuple<String, Set<String>>, String>();
        for (String countryOrGroupKey : this.countryToMutationLevels.keySet()) {
            Tuple<Tuple<String, Set<String>>, String> details = this.details(countryOrGroupKey);
            if (details == null) {
                throw new CoreException("Key {} not found in countryToMutationLevels, this should not happen!", new Object[]{countryOrGroupKey});
            }
            result.put((Tuple<String, Set<String>>)((Tuple)details.getFirst()), (String)details.getSecond());
        }
        return result;
    }

    public Tuple<Tuple<String, Set<String>>, String> details(String countryOrGroup) {
        List<AtlasMutationLevel> levels = this.countryToMutationLevels.get(countryOrGroup);
        if (levels != null) {
            Set<String> countries = levels.iterator().next().getCountries();
            StringList levelsStringList = new StringList();
            for (AtlasMutationLevel level : levels) {
                levelsStringList.add("    " + level.details());
            }
            return new Tuple((Object)new Tuple((Object)countryOrGroup, countries), (Object)levelsStringList.join(System.lineSeparator()));
        }
        return null;
    }

    public String detailsString(String countryOrGroup) {
        Tuple<Tuple<String, Set<String>>, String> detailsTuple = this.details(countryOrGroup);
        StringList countryAndLevels = new StringList();
        if (detailsTuple != null) {
            Tuple countryTuple = (Tuple)detailsTuple.getFirst();
            String levels = (String)detailsTuple.getSecond();
            String logMessage = "AtlasMutator %s and levels for ";
            logMessage = ((String)countryTuple.getFirst()).startsWith(GROUP_PREFIX) ? String.format(logMessage, "group") : String.format(logMessage, "country");
            StringList countryList = new StringList((Iterable)countryTuple.getSecond());
            String countryListDescription = " (" + countryList.join(", ") + ")";
            countryAndLevels.add(logMessage + (String)countryTuple.getFirst() + (String)(countryList.size() > 1 ? countryListDescription : "") + ":");
            countryAndLevels.add(levels);
            return countryAndLevels.join(System.lineSeparator());
        }
        return null;
    }

    public String detailsString() {
        StringList countryAndLevels = new StringList();
        for (String countryOrGroupKey : new TreeSet<String>(this.countryToMutationLevels.keySet())) {
            String detailsForCountry = this.detailsString(countryOrGroupKey);
            if (detailsForCountry == null) {
                throw new CoreException("Key {} not found in countryToMutationLevels, this should not happen!", new Object[]{countryOrGroupKey});
            }
            countryAndLevels.add(detailsForCountry);
        }
        return countryAndLevels.join(System.lineSeparator());
    }

    public CountryBoundaryMap getBoundaries() {
        return this.boundaries;
    }

    public AtlasMutatorConfigurationDetails getConfigurationDetails() {
        return new AtlasMutatorConfigurationDetails(this);
    }

    public Map<String, List<AtlasMutationLevel>> getCountryToMutationLevels() {
        return this.countryToMutationLevels;
    }

    public ConfiguredMergeForgivenessPolicy getGlobalMergeForgivenessPolicy() {
        return this.globalMergeForgivenessPolicy;
    }

    public String getInput() {
        return this.input;
    }

    public String getOutput() {
        return this.output;
    }

    public Sharding getSharding() {
        return this.sharding;
    }

    public Map<String, String> getSparkConfiguration() {
        return this.sparkConfiguration;
    }

    public boolean isEmpty() {
        return this.countryToMutationLevels.isEmpty();
    }

    public JsonObject toJson() {
        JsonObject configurationJson = new JsonObject();
        JsonArray mutatorObjects = new JsonArray();
        JsonArray levelObjects = new JsonArray();
        JsonArray dynamicAtlasPolicyObjects = new JsonArray();
        JsonArray filterObjects = new JsonArray();
        JsonArray inputDependencyObjects = new JsonArray();
        JsonArray fetcherObjects = new JsonArray();
        JsonArray subAtlasObjects = new JsonArray();
        JsonArray mergeForgivenessPolicyObjects = new JsonArray();
        JsonArray broadcastableObjects = new JsonArray();
        AtlasMutatorConfigurationDetails configurationDetails = this.getConfigurationDetails();
        for (Map.Entry<String, List<AtlasMutationLevel>> countryOrGroupAndLevels : this.countryToMutationLevels.entrySet()) {
            countryOrGroupAndLevels.getValue().stream().map(AtlasMutationLevel::toJson).forEach(arg_0 -> ((JsonArray)levelObjects).add(arg_0));
        }
        for (String mutatorName : new TreeSet<String>(configurationDetails.getMutators().keySet())) {
            mutatorObjects.add((JsonElement)configurationDetails.getMutators().get(mutatorName).toJson());
        }
        for (String policyName : new TreeSet<String>(configurationDetails.getDynamicAtlasPolicies().keySet())) {
            dynamicAtlasPolicyObjects.add((JsonElement)configurationDetails.getDynamicAtlasPolicies().get(policyName).toJson());
        }
        for (String filterName : new TreeSet<String>(configurationDetails.getFilters().keySet())) {
            filterObjects.add((JsonElement)configurationDetails.getFilters().get(filterName).toJson());
        }
        for (String dependencyName : new TreeSet<String>(configurationDetails.getInputDependencies().keySet())) {
            inputDependencyObjects.add((JsonElement)configurationDetails.getInputDependencies().get(dependencyName).toJson());
        }
        for (String fetcherName : new TreeSet<String>(configurationDetails.getFetchers().keySet())) {
            fetcherObjects.add((JsonElement)configurationDetails.getFetchers().get(fetcherName).toJson());
        }
        for (String subAtlasName : new TreeSet<String>(configurationDetails.getSubAtlases().keySet())) {
            subAtlasObjects.add((JsonElement)configurationDetails.getSubAtlases().get(subAtlasName).toJson());
        }
        for (String mergeForgivenessPolicyName : new TreeSet<String>(configurationDetails.getMergeForgivenessPolicies().keySet())) {
            mergeForgivenessPolicyObjects.add((JsonElement)configurationDetails.getMergeForgivenessPolicies().get(mergeForgivenessPolicyName).toJson());
        }
        for (String broadcastableName : new TreeSet<String>(configurationDetails.getBroadcastables().keySet())) {
            broadcastableObjects.add((JsonElement)configurationDetails.getBroadcastables().get(broadcastableName).toJson());
        }
        configurationJson.add(MUTATORS_JSON_PROPERTY, (JsonElement)mutatorObjects);
        configurationJson.add(LEVELS_JSON_PROPERTY, (JsonElement)levelObjects);
        configurationJson.add(DYNAMIC_ATLAS_POLICIES_JSON_PROPERTY, (JsonElement)dynamicAtlasPolicyObjects);
        configurationJson.add(FILTERS_JSON_PROPERTY, (JsonElement)filterObjects);
        configurationJson.add(INPUT_DEPENDENCIES_JSON_PROPERTY, (JsonElement)inputDependencyObjects);
        configurationJson.add(FETCHERS_JSON_PROPERTY, (JsonElement)fetcherObjects);
        configurationJson.add(SUB_ATLASES_JSON_PROPERTY, (JsonElement)subAtlasObjects);
        configurationJson.add(MERGE_FORGIVENESS_POLICIES_JSON_PROPERTY, (JsonElement)mergeForgivenessPolicyObjects);
        configurationJson.add(BROADCASTABLES_JSON_PROPERTY, (JsonElement)broadcastableObjects);
        return configurationJson;
    }

    public String toString() {
        return "AtlasMutatorConfiguration [input=" + this.input + ", output=" + this.output + "]";
    }

    private void validateCountryAndBoundaries(Set<String> countries) {
        if (this.boundaries == null) {
            return;
        }
        Set missingCountries = countries.stream().filter(country -> !this.boundaries.getCountryNameToBoundaryMap().containsKey(country)).collect(Collectors.toSet());
        if (!missingCountries.isEmpty()) {
            throw new CoreException("Country(ies) {} do(es) not have a boundary.", new Object[]{missingCountries});
        }
    }
}

