/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.mutator.configuration;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.spark.broadcast.Broadcast;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.generator.tools.spark.utilities.SparkFileHelper;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.dynamic.policy.DynamicAtlasPolicy;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlas;
import org.openstreetmap.atlas.geography.boundary.CountryBoundaryMap;
import org.openstreetmap.atlas.geography.boundary.CountryShardListing;
import org.openstreetmap.atlas.geography.sharding.CountryShard;
import org.openstreetmap.atlas.geography.sharding.Shard;
import org.openstreetmap.atlas.geography.sharding.Sharding;
import org.openstreetmap.atlas.mutator.configuration.AtlasMutatorConfiguration;
import org.openstreetmap.atlas.mutator.configuration.InputDependency;
import org.openstreetmap.atlas.mutator.configuration.mutators.ConfiguredAtlasChangeGenerator;
import org.openstreetmap.atlas.mutator.configuration.parsing.ConfiguredAtlasFetcher;
import org.openstreetmap.atlas.mutator.configuration.parsing.ConfiguredDynamicAtlasPolicy;
import org.openstreetmap.atlas.utilities.collections.Sets;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.maps.MultiMapWithSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasMutationLevel
implements Serializable {
    public static final String COUNTRY_INDEX_SEPARATOR = "_";
    public static final String INTERMEDIATE_FOLDER_NAME = "intermediate";
    public static final String TYPE_JSON_PROPERTY_VALUE = "_level";
    public static final String COUNTRY_OR_GROUP_JSON_PROPERTY = "countryOrGroup";
    public static final String GROUP_CONTENTS_JSON_PROPERTY = "groupContents";
    public static final String LEVEL_INDEX_JSON_PROPERTY = "levelIndex";
    public static final String LEVEL_SOURCE_TYPE_JSON_PROPERTY = "levelSourceType";
    public static final String MUTATORS_JSON_PROPERTY = "mutators";
    public static final String INPUT_DEPENDENCIES_PROVIDE_JSON_PROPERTY = "inputDependenciesToProvide";
    public static final String INPUT_DEPENDENCIES_REQUEST_JSON_PROPERTY = "inputDependenciesToRequest";
    public static final String DYNAMIC_ATLAS_POLICY_GENERATION_JSON_PROPERTY = "dynamicAtlasPolicyGeneration";
    public static final String DYNAMIC_ATLAS_POLICY_APPLICATION_JSON_PROPERTY = "dynamicAtlasPolicyApplication";
    public static final String PARENT_NEEDS_RDD_INPUT_JSON_PROPERTY = "parentNeedsRDDInput";
    public static final String CHILD_NEEDS_RDD_INPUT_JSON_PROPERTY = "childNeedsRDDInput";
    public static final String CHILD_CAN_PRELOAD_RDD_INPUT_JSON_PROPERTY = "childCanPreloadRDDInput";
    public static final String MAX_LEVEL_INDEX_JSON_PROPERTY = "maximumLevelIndex";
    public static final String ADD_MUTATION_TAGS_JSON_PROPERTY = "addMutationTags";
    private static final long serialVersionUID = 2921374291315186276L;
    private static final Logger logger = LoggerFactory.getLogger(AtlasMutationLevel.class);
    private final AtlasMutatorConfiguration atlasMutatorConfiguration;
    private final String countryGroup;
    private final Set<String> countries;
    private final Set<ConfiguredAtlasChangeGenerator> mutators;
    private final int levelIndex;
    private final int maximumLevelIndex;
    private final Set<InputDependency> inputDependenciesToRequest;
    private final ConfiguredDynamicAtlasPolicy dynamicAtlasPolicyGeneration;
    private final ConfiguredDynamicAtlasPolicy dynamicAtlasPolicyApplication;
    private final Set<InputDependency> inputDependenciesToProvide;
    private final Set<String> debugIncludeListedMutators = new HashSet<String>();
    private final Set<String> debugIncludeListedShards = new HashSet<String>();
    private boolean addMutationTags;
    private boolean allowRDD = false;
    private boolean preloadRDD = false;
    private final Map<String, Broadcast<?>> broadcastVariables;
    private boolean parentNeedsRDDInput = false;
    private boolean childNeedsRDDInput = false;
    private boolean childCanPreloadRDDInput = false;

    private static String getName(String country, int levelIndex) {
        return country + COUNTRY_INDEX_SEPARATOR + levelIndex;
    }

    public AtlasMutationLevel(AtlasMutatorConfiguration atlasMutatorConfiguration, String countryGroup, Set<String> countries, Set<ConfiguredAtlasChangeGenerator> mutators, int levelIndex, int maximumLevelIndex) {
        this.atlasMutatorConfiguration = atlasMutatorConfiguration;
        this.countryGroup = countryGroup;
        this.countries = countries;
        this.mutators = mutators;
        this.levelIndex = levelIndex;
        this.maximumLevelIndex = maximumLevelIndex;
        this.inputDependenciesToRequest = this.inputDependenciesToRequest(mutators);
        this.dynamicAtlasPolicyGeneration = this.dynamicAtlasPolicy(mutators, ConfiguredAtlasChangeGenerator::getDynamicAtlasPolicyGeneration);
        this.dynamicAtlasPolicyApplication = this.dynamicAtlasPolicy(mutators, ConfiguredAtlasChangeGenerator::getDynamicAtlasPolicyApplication);
        this.inputDependenciesToProvide = new HashSet<InputDependency>();
        this.addMutationTags = true;
        this.broadcastVariables = new HashMap();
    }

    public void addBroadcastVariable(String name, Broadcast<?> broadcast) {
        this.broadcastVariables.put(name, broadcast);
    }

    public void addDebugWhiteListedMutator(String name) {
        this.debugIncludeListedMutators.add(name);
    }

    public void addDebugWhiteListedShard(String name) {
        this.debugIncludeListedShards.add(name);
    }

    public boolean canPreloadAtlasRDD() {
        return this.preloadRDD && this.canSourceAtlasObjectsFromRDD();
    }

    public boolean canRequestSourceAtlasObjectsFromRDD() {
        return this.levelIndex > 0 && !this.parentNeedsRDDInput && this.canSourceAtlasObjectsFromRDD();
    }

    public boolean canSourceAtlasObjectsFromRDD() {
        return this.dynamicAtlasPolicyGeneration.isPreDetermined() && this.dynamicAtlasPolicyApplication.isPreDetermined();
    }

    public String details() {
        StringBuilder result = new StringBuilder();
        result.append(this);
        if (this.requestSourceAtlasObjectsFromRDD()) {
            result.append(": RDDLEVEL,");
        } else if (this.canPreloadAtlasRDD()) {
            result.append(": RDDFS,");
        } else {
            result.append(": FS,");
        }
        StringList mutations = new StringList();
        this.mutators.stream().map(ConfiguredAtlasChangeGenerator::toString).sorted().forEach(arg_0 -> ((StringList)mutations).add(arg_0));
        result.append(mutations.join(","));
        return result.toString();
    }

    public boolean equals(Object other) {
        if (other instanceof AtlasMutationLevel) {
            return other.toString().equals(this.toString());
        }
        return false;
    }

    public Optional<InputDependency> getApplicationInputDependencyToRequest() {
        return this.dynamicAtlasPolicyApplication.getInputDependency();
    }

    public DynamicAtlasPolicy getApplicationPolicy(CountryShard countryShard) {
        return this.getPolicy(countryShard, this.dynamicAtlasPolicyApplication, "an application");
    }

    public Function<CountryShard, Set<CountryShard>> getApplicationShardExplorer() {
        return this.getShardExplorer(this.dynamicAtlasPolicyApplication);
    }

    public AtlasMutatorConfiguration getAtlasMutatorConfiguration() {
        return this.atlasMutatorConfiguration;
    }

    public Map<String, Object> getBroadcastVariables() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Broadcast<?>> entry : this.broadcastVariables.entrySet()) {
            try {
                result.put(entry.getKey(), entry.getValue().getValue());
            }
            catch (Exception e) {
                throw new CoreException("{}: Unable to read broadcast variable \"{}\"", new Object[]{this, entry.getKey(), e});
            }
        }
        return result;
    }

    public ConfiguredDynamicAtlasPolicy getConfiguredApplicationPolicy() {
        return this.dynamicAtlasPolicyApplication;
    }

    public ConfiguredDynamicAtlasPolicy getConfiguredGenerationPolicy() {
        return this.dynamicAtlasPolicyGeneration;
    }

    public Set<String> getCountries() {
        return this.countries;
    }

    public String getCountryGroup() {
        return this.countryGroup;
    }

    public Set<String> getDebugIncludeListedMutators() {
        return this.debugIncludeListedMutators;
    }

    public Set<String> getDebugIncludeListedShards() {
        return this.debugIncludeListedShards;
    }

    public Optional<InputDependency> getGenerationInputDependencyToRequest() {
        return this.dynamicAtlasPolicyGeneration.getInputDependency();
    }

    public DynamicAtlasPolicy getGenerationPolicy(CountryShard countryShard) {
        return this.getPolicy(countryShard, this.dynamicAtlasPolicyGeneration, "a generation");
    }

    public Function<CountryShard, Set<CountryShard>> getGenerationShardExplorer() {
        return this.getShardExplorer(this.dynamicAtlasPolicyGeneration);
    }

    public Set<InputDependency> getInputDependenciesToProvide() {
        return ImmutableSet.copyOf(this.inputDependenciesToProvide);
    }

    public Set<InputDependency> getInputDependenciesToRequest() {
        return ImmutableSet.copyOf(this.inputDependenciesToRequest);
    }

    public int getLevelIndex() {
        return this.levelIndex;
    }

    public String getLevelSourceType() {
        if (this.requestSourceAtlasObjectsFromRDD()) {
            return "RDDLEVEL";
        }
        if (this.canPreloadAtlasRDD()) {
            return "RDDFS";
        }
        return "FS";
    }

    public int getMaximumLevelIndex() {
        return this.maximumLevelIndex;
    }

    public Set<ConfiguredAtlasChangeGenerator> getMutators() {
        return this.mutators;
    }

    public String getOutputAtlasPath() {
        String outputPath = this.levelIndex == this.maximumLevelIndex ? this.atlasMutatorConfiguration.getOutput() : this.getIntermediateOutput(this.atlasMutatorConfiguration.getOutput());
        return outputPath;
    }

    public String getOutputAtlasPath(InputDependency inputDependency) {
        return this.getIntermediateOutput(this.atlasMutatorConfiguration.getOutput(), this + "_inputDependency_" + inputDependency.getPathName());
    }

    public DynamicAtlasPolicy getRDDBasedApplicationPolicy(CountryShard countryShard, Map<CountryShard, PackedAtlas> shardToAtlasMap) {
        return this.getRDDBasedPolicy(this.dynamicAtlasPolicyApplication, countryShard, shardToAtlasMap, "an application");
    }

    public DynamicAtlasPolicy getRDDBasedGenerationPolicy(CountryShard countryShard, Map<CountryShard, PackedAtlas> shardToAtlasMap) {
        return this.getRDDBasedPolicy(this.dynamicAtlasPolicyGeneration, countryShard, shardToAtlasMap, "a generation");
    }

    public Function<CountryShard, Optional<Atlas>> getSourceFetcher() {
        return countryShard -> ConfiguredAtlasFetcher.direct().getFetcher(this.getParentAtlasPath(), countryShard.getCountry(), this.atlasMutatorConfiguration.getSparkConfiguration()).apply(countryShard.getShard());
    }

    public String groupAndIndex() {
        return AtlasMutationLevel.getName(this.countryGroup, this.levelIndex);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean isAddMutationTags() {
        return this.addMutationTags;
    }

    public boolean isChildCanPreloadRDDInput() {
        return this.childCanPreloadRDDInput;
    }

    public boolean isChildNeedsRDDInput() {
        return this.childNeedsRDDInput;
    }

    public boolean isLast() {
        return this.levelIndex == this.maximumLevelIndex;
    }

    public boolean isParentNeedsRDDInput() {
        return this.parentNeedsRDDInput;
    }

    public boolean isSimilarTo(AtlasMutationLevel other) {
        return this.getLevelIndex() == other.getLevelIndex() && this.getMaximumLevelIndex() == other.getMaximumLevelIndex() && this.getMutators().equals(other.getMutators()) && this.getInputDependenciesToRequest().equals(other.getInputDependenciesToRequest()) && this.getInputDependenciesToProvide().equals(other.getInputDependenciesToProvide()) && this.dynamicAtlasPolicyApplication.equals(other.dynamicAtlasPolicyApplication) && this.dynamicAtlasPolicyGeneration.equals(other.dynamicAtlasPolicyGeneration);
    }

    public AtlasMutationLevel merge(AtlasMutationLevel other, String groupName) {
        if (!this.isSimilarTo(other)) {
            throw new CoreException("Cannot merge {} and {} which are not similar.", new Object[]{this, other});
        }
        HashSet<String> mergedCountries = new HashSet<String>();
        mergedCountries.addAll(this.countries);
        mergedCountries.addAll(other.countries);
        AtlasMutationLevel result = new AtlasMutationLevel(this.atlasMutatorConfiguration, groupName, mergedCountries, this.mutators, this.levelIndex, this.maximumLevelIndex);
        result.addInputDependenciesToProvide(this.getInputDependenciesToProvide());
        result.childNeedsRDDInput = this.childNeedsRDDInput;
        result.childCanPreloadRDDInput = this.childCanPreloadRDDInput;
        result.parentNeedsRDDInput = this.parentNeedsRDDInput;
        result.allowRDD = this.allowRDD;
        result.preloadRDD = this.preloadRDD;
        return result;
    }

    public void notifyOfChildLevel(AtlasMutationLevel childLevel) {
        this.childNeedsRDDInput = childLevel.requestSourceAtlasObjectsFromRDD();
        this.childCanPreloadRDDInput = childLevel.canPreloadAtlasRDD();
    }

    public void notifyOfParentLevel(AtlasMutationLevel parentLevel) {
        parentLevel.addInputDependenciesToProvide(this.inputDependenciesToRequest);
        this.parentNeedsRDDInput = parentLevel.requestSourceAtlasObjectsFromRDD();
    }

    public boolean requestSourceAtlasObjectsFromRDD() {
        return this.allowRDD && this.canRequestSourceAtlasObjectsFromRDD();
    }

    public void setAddMutationTags(boolean addMutationTags) {
        this.addMutationTags = addMutationTags;
    }

    public void setAllowRDD(boolean allowRDD) {
        this.allowRDD = allowRDD;
    }

    public void setPreloadRDD(boolean preloadRDD) {
        this.preloadRDD = preloadRDD;
    }

    public List<CountryShard> shards() {
        MultiMapWithSet countryToShardMap = CountryShardListing.countryToShardList(this.countries, (CountryBoundaryMap)this.atlasMutatorConfiguration.getBoundaries(), (Sharding)this.atlasMutatorConfiguration.getSharding());
        return countryToShardMap.entrySet().stream().flatMap(entry -> ((Set)entry.getValue()).stream().map(shard -> new CountryShard((String)entry.getKey(), shard))).collect(Collectors.toList());
    }

    public JsonObject toJson() {
        JsonObject levelJson = new JsonObject();
        levelJson.addProperty("type", TYPE_JSON_PROPERTY_VALUE);
        levelJson.addProperty(COUNTRY_OR_GROUP_JSON_PROPERTY, this.countryGroup);
        if (!this.countries.isEmpty()) {
            levelJson.addProperty(GROUP_CONTENTS_JSON_PROPERTY, new StringList(this.countries).join(","));
        }
        levelJson.addProperty(LEVEL_INDEX_JSON_PROPERTY, (Number)this.levelIndex);
        levelJson.addProperty(LEVEL_SOURCE_TYPE_JSON_PROPERTY, this.getLevelSourceType());
        JsonArray mutatorsArray = new JsonArray();
        for (String mutatorName : new TreeSet(this.mutators.stream().map(ConfiguredAtlasChangeGenerator::getName).collect(Collectors.toSet()))) {
            mutatorsArray.add((JsonElement)new JsonPrimitive(mutatorName));
        }
        levelJson.add(MUTATORS_JSON_PROPERTY, (JsonElement)mutatorsArray);
        if (!this.inputDependenciesToProvide.isEmpty()) {
            levelJson.addProperty(INPUT_DEPENDENCIES_PROVIDE_JSON_PROPERTY, new StringList(this.getInputDependenciesToProvide().stream().map(InputDependency::toString).collect(Collectors.toList())).join(","));
        }
        if (!this.inputDependenciesToRequest.isEmpty()) {
            levelJson.addProperty(INPUT_DEPENDENCIES_REQUEST_JSON_PROPERTY, new StringList(this.getInputDependenciesToRequest().stream().map(InputDependency::toString).collect(Collectors.toList())).join(","));
        }
        levelJson.addProperty(DYNAMIC_ATLAS_POLICY_GENERATION_JSON_PROPERTY, this.dynamicAtlasPolicyGeneration.toStringCompact());
        levelJson.addProperty(DYNAMIC_ATLAS_POLICY_APPLICATION_JSON_PROPERTY, this.dynamicAtlasPolicyApplication.toStringCompact());
        levelJson.addProperty(PARENT_NEEDS_RDD_INPUT_JSON_PROPERTY, Boolean.valueOf(this.parentNeedsRDDInput));
        levelJson.addProperty(CHILD_NEEDS_RDD_INPUT_JSON_PROPERTY, Boolean.valueOf(this.childNeedsRDDInput));
        levelJson.addProperty(CHILD_CAN_PRELOAD_RDD_INPUT_JSON_PROPERTY, Boolean.valueOf(this.childCanPreloadRDDInput));
        levelJson.addProperty(MAX_LEVEL_INDEX_JSON_PROPERTY, (Number)this.maximumLevelIndex);
        levelJson.addProperty(ADD_MUTATION_TAGS_JSON_PROPERTY, Boolean.valueOf(this.addMutationTags));
        return levelJson;
    }

    public String toString() {
        return AtlasMutationLevel.getName(this.countryGroup, this.levelIndex);
    }

    private void addInputDependenciesToProvide(Set<InputDependency> inputDependencies) {
        this.inputDependenciesToProvide.addAll(inputDependencies);
        this.validateInputDependencyGroup(this.inputDependenciesToProvide);
    }

    private Map<Shard, PackedAtlas> backToShard(Map<CountryShard, PackedAtlas> countryShardToAtlasMap) {
        HashMap<Shard, PackedAtlas> result = new HashMap<Shard, PackedAtlas>();
        countryShardToAtlasMap.forEach((countryShard, packedAtlas) -> result.put(countryShard.getShard(), (PackedAtlas)packedAtlas));
        return result;
    }

    private ConfiguredDynamicAtlasPolicy dynamicAtlasPolicy(Set<ConfiguredAtlasChangeGenerator> mutators, Function<ConfiguredAtlasChangeGenerator, ConfiguredDynamicAtlasPolicy> mutatorToPolicy) {
        Set result = mutators.stream().map(mutatorToPolicy).collect(Collectors.toSet());
        if (result.isEmpty()) {
            throw new CoreException("{}: Cannot have zero dynamic atlas policy per level.", new Object[]{this});
        }
        if (result.size() > 1) {
            throw new CoreException("{}: Cannot have more than one dynamic atlas policy per level.", new Object[]{this});
        }
        return (ConfiguredDynamicAtlasPolicy)result.iterator().next();
    }

    private String getIntermediateOutput(String output, int index) {
        return this.getIntermediateOutput(output, AtlasMutationLevel.getName(this.countryGroup, index));
    }

    private String getIntermediateOutput(String output, String built) {
        return SparkFileHelper.combine(output, INTERMEDIATE_FOLDER_NAME, built);
    }

    private String getIntermediateOutput(String output) {
        return this.getIntermediateOutput(output, this.levelIndex);
    }

    private String getParentAtlasPath() {
        String parentPath;
        if (this.levelIndex == 0) {
            parentPath = this.atlasMutatorConfiguration.getInput();
        } else {
            int index = this.levelIndex - 1;
            parentPath = this.getIntermediateOutput(this.atlasMutatorConfiguration.getOutput(), index);
        }
        return parentPath;
    }

    private DynamicAtlasPolicy getPolicy(CountryShard countryShard, ConfiguredDynamicAtlasPolicy configuredDynamicAtlasPolicy, String message) {
        if (this.canSourceAtlasObjectsFromRDD()) {
            logger.warn("{} could use {} policy that is RDD Based", (Object)this, (Object)message);
        }
        return configuredDynamicAtlasPolicy.getPolicy(Sets.hashSet((Object[])new Shard[]{countryShard.getShard()}), this.atlasMutatorConfiguration.getSharding(), this.getParentAtlasPath(), this.atlasMutatorConfiguration.getSparkConfiguration(), countryShard.getCountry());
    }

    private DynamicAtlasPolicy getRDDBasedPolicy(ConfiguredDynamicAtlasPolicy configuredDynamicAtlasPolicy, CountryShard countryShard, Map<CountryShard, PackedAtlas> shardToAtlasMap, String message) {
        if (!this.canSourceAtlasObjectsFromRDD()) {
            throw new CoreException("{} should not use {} policy that is RDD Based", new Object[]{this, message});
        }
        return configuredDynamicAtlasPolicy.getRDDBasedPolicy(Sets.hashSet((Object[])new Shard[]{countryShard.getShard()}), this.atlasMutatorConfiguration.getSharding(), this.backToShard(shardToAtlasMap));
    }

    private Function<CountryShard, Set<CountryShard>> getShardExplorer(ConfiguredDynamicAtlasPolicy policy) {
        return (Function<CountryShard, Set> & Serializable)countryShard -> policy.getShardExplorer(this.atlasMutatorConfiguration.getSharding()).apply(countryShard.getShard()).stream().map(shard -> new CountryShard(countryShard.getCountry(), shard)).collect(Collectors.toSet());
    }

    private Set<InputDependency> inputDependenciesToRequest(Set<ConfiguredAtlasChangeGenerator> mutators) {
        HashSet<InputDependency> result = new HashSet<InputDependency>();
        for (ConfiguredAtlasChangeGenerator mutator : mutators) {
            result.addAll(mutator.getInputDependencies());
        }
        this.validateInputDependencyGroup(result);
        return result;
    }

    private void validateInputDependencyGroup(Set<InputDependency> result) {
        ArrayList<InputDependency> internal = new ArrayList<InputDependency>(result);
        for (int index = 0; index < result.size(); ++index) {
            for (int jndex = index + 1; jndex < result.size(); ++jndex) {
                InputDependency dependencyI = (InputDependency)internal.get(index);
                InputDependency dependencyJ = (InputDependency)internal.get(jndex);
                if (dependencyI.getPathName().equals(dependencyJ.getPathName())) continue;
                throw new CoreException("Two input dependency list for {} and {} collided on the path {}", new Object[]{dependencyI.getOwner(), dependencyJ.getOwner(), dependencyI.getPathName()});
            }
        }
    }
}

