/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.mutator.command;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.jline.reader.Completer;
import org.jline.reader.EndOfFileException;
import org.jline.reader.History;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.UserInterruptException;
import org.jline.reader.impl.completer.StringsCompleter;
import org.jline.reader.impl.history.DefaultHistory;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.boundary.CountryBoundaryMap;
import org.openstreetmap.atlas.geography.sharding.Sharding;
import org.openstreetmap.atlas.geography.sharding.SlippyTileSharding;
import org.openstreetmap.atlas.mutator.AtlasMutatorParameters;
import org.openstreetmap.atlas.mutator.configuration.AtlasMutationLevel;
import org.openstreetmap.atlas.mutator.configuration.AtlasMutatorConfiguration;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.command.AtlasShellToolsException;
import org.openstreetmap.atlas.utilities.command.abstractcommand.AbstractAtlasShellToolsCommand;
import org.openstreetmap.atlas.utilities.command.abstractcommand.CommandOutputDelegate;
import org.openstreetmap.atlas.utilities.command.abstractcommand.OptionAndArgumentDelegate;
import org.openstreetmap.atlas.utilities.command.parsing.ArgumentArity;
import org.openstreetmap.atlas.utilities.command.parsing.ArgumentOptionality;
import org.openstreetmap.atlas.utilities.command.parsing.OptionOptionality;
import org.openstreetmap.atlas.utilities.command.terminal.TTYAttribute;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.tuples.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationInfoCommand
extends AbstractAtlasShellToolsCommand {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationInfoCommand.class);
    private static final String ALLOW_RDD_OPTION_LONG = "allowRDD";
    private static final String ALLOW_RDD_OPTION_DESCRIPTION = "Allow eligible mutation levels to source data from previous level's RDD.";
    private static final String PRELOAD_RDD_OPTION_LONG = "preloadRDD";
    private static final String PRELOAD_RDD_OPTION_DESCRIPTION = "Allow eligible mutation levels to preload atlas data into an RDD before processing mutations.";
    private static final String GROUP_COUNTRIES_OPTION_LONG = "group-countries";
    private static final String GROUP_COUNTRIES_OPTION_DESCRIPTION = "Allow the driver to group countries with similar level configurations together.";
    private static final String COUNTRIES_OPTION_LONG = "countries";
    private static final String COUNTRIES_OPTION_DESCRIPTION = "Comma separated list of countries for the mutator configuration.";
    private static final String COUNTRIES_OPTION_HINT = "country-list";
    private static final String CONFIGURATION_RESOURCE_OPTION_LONG = "config-resource";
    private static final String CONFIGURATION_RESOURCE_OPTION_DESCRIPTION = "Comma-separated list of configuration resources. These can be either http URLs or local files.";
    private static final String CONFIGURATION_RESOURCE_OPTION_HINT = "config-resources";
    private static final String CONFIGURATION_JSON_OPTION_LONG = "config-json";
    private static final String CONFIGURATION_JSON_OPTION_DESCRIPTION = "Read the configuration from JSON format.";
    private static final String CONFIGURATION_JSON_OPTION_HINT = "json";
    private static final String DISABLE_JLINE_OPTION_LONG = "disable-jline";
    private static final String DISABLE_JLINE_OPTION_DESCRIPTION = "Disable jLine input features in interactive mode. Try this if interactive mode causes issues for your terminal.";
    private static final String MODE_ARGUMENT_HINT = "mode";
    private static final String MODE_PRINT = "print";
    private static final String MODE_DETAILS = "details";
    private static final String MODE_INTERACTIVE = "interactive";
    private static final String ARGS_ARGUMENT_HINT = "mode-args";
    private static final String CONFIG_EMPTY_MESSAGE = "the AtlasMutatorConfiguration was empty";
    private final OptionAndArgumentDelegate optionAndArgumentDelegate = this.getOptionAndArgumentDelegate();
    private final CommandOutputDelegate outputDelegate = this.getCommandOutputDelegate();
    private History history;
    private Terminal terminal;

    public static void main(String[] args) {
        new ConfigurationInfoCommand().runSubcommandAndExit(args);
    }

    public int execute() {
        Optional<Configuration> configOptional;
        String countriesString = (String)this.optionAndArgumentDelegate.getOptionArgument(COUNTRIES_OPTION_LONG).orElseThrow(AtlasShellToolsException::new);
        Set<String> countries = this.parseCommaSeparatedStrings(countriesString).stream().collect(Collectors.toSet());
        if (this.optionAndArgumentDelegate.hasVerboseOption()) {
            this.outputDelegate.printlnCommandMessage("loading config resources...");
        }
        String configResource = this.optionAndArgumentDelegate.getOptionArgument(CONFIGURATION_RESOURCE_OPTION_LONG).orElse("");
        String configJson = this.optionAndArgumentDelegate.getOptionArgument(CONFIGURATION_JSON_OPTION_LONG).orElse("");
        if (configJson.isEmpty() && configResource.isEmpty()) {
            this.outputDelegate.printlnErrorMessage("no configurations were supplied");
            return 1;
        }
        StringList configList = new StringList();
        if (!configResource.isEmpty()) {
            configList = StringList.split((String)configResource, (String)",");
        }
        try {
            configOptional = AtlasMutatorParameters.mutatorsConfiguration(configList, configJson, this.getFileSystem());
        }
        catch (Exception exception) {
            logger.error("Could not fetch Configuration object using configList {}", (Object)configList, (Object)exception);
            this.outputDelegate.printlnErrorMessage("failed to fetch Configuration object, please check logs for details");
            return 1;
        }
        if (configOptional.isEmpty()) {
            this.outputDelegate.printlnErrorMessage("no configurations could be processed, please check logs for details");
            return 1;
        }
        Configuration configuration = configOptional.get();
        Set configDataKeySet = configuration.configurationDataKeySet();
        if (configDataKeySet.isEmpty()) {
            this.outputDelegate.printlnErrorMessage("supplied configuration was empty, please check logs for details");
            return 1;
        }
        if (configDataKeySet.size() == 1 && "404".equals(configDataKeySet.iterator().next())) {
            this.outputDelegate.printlnErrorMessage("apparent 404 error when fetching configuration, please check the resource URL");
            return 1;
        }
        String mode = (String)this.optionAndArgumentDelegate.getUnaryArgument(MODE_ARGUMENT_HINT).orElseThrow(AtlasShellToolsException::new);
        if (MODE_PRINT.equals(mode)) {
            return this.executePrintMode(countries, configuration);
        }
        if (MODE_DETAILS.equals(mode)) {
            return this.executeDetailsMode(countries, configuration);
        }
        if (MODE_INTERACTIVE.equals(mode)) {
            return this.executeInteractiveMode(countries, configuration);
        }
        this.outputDelegate.printlnErrorMessage(String.format("unknown mode '%s': try '%s', '%s', or '%s'", mode, MODE_PRINT, MODE_DETAILS, MODE_INTERACTIVE));
        return 1;
    }

    public String getCommandName() {
        return "config-info";
    }

    public String getSimpleDescription() {
        return "get information about an atlas-mutator configuration";
    }

    public void registerManualPageSections() {
        this.addManualPageSection("DESCRIPTION", ConfigurationInfoCommand.class.getResourceAsStream("ConfigurationInfoCommandDescriptionSection.txt"));
        this.addManualPageSection("EXAMPLES", ConfigurationInfoCommand.class.getResourceAsStream("ConfigurationInfoCommandExamplesSection.txt"));
    }

    public void registerOptionsAndArguments() {
        this.registerOption(ALLOW_RDD_OPTION_LONG, ALLOW_RDD_OPTION_DESCRIPTION, OptionOptionality.OPTIONAL, new Integer[0]);
        this.registerOption(PRELOAD_RDD_OPTION_LONG, PRELOAD_RDD_OPTION_DESCRIPTION, OptionOptionality.OPTIONAL, new Integer[0]);
        this.registerOption(GROUP_COUNTRIES_OPTION_LONG, GROUP_COUNTRIES_OPTION_DESCRIPTION, OptionOptionality.OPTIONAL, new Integer[0]);
        this.registerOptionWithRequiredArgument(COUNTRIES_OPTION_LONG, COUNTRIES_OPTION_DESCRIPTION, OptionOptionality.REQUIRED, COUNTRIES_OPTION_HINT, new Integer[0]);
        this.registerOptionWithRequiredArgument(CONFIGURATION_RESOURCE_OPTION_LONG, CONFIGURATION_RESOURCE_OPTION_DESCRIPTION, OptionOptionality.OPTIONAL, CONFIGURATION_RESOURCE_OPTION_HINT, new Integer[0]);
        this.registerOptionWithRequiredArgument(CONFIGURATION_JSON_OPTION_LONG, CONFIGURATION_JSON_OPTION_DESCRIPTION, OptionOptionality.OPTIONAL, CONFIGURATION_JSON_OPTION_HINT, new Integer[0]);
        this.registerOption(DISABLE_JLINE_OPTION_LONG, DISABLE_JLINE_OPTION_DESCRIPTION, OptionOptionality.OPTIONAL, new Integer[0]);
        this.registerArgument(MODE_ARGUMENT_HINT, ArgumentArity.UNARY, ArgumentOptionality.REQUIRED, new Integer[0]);
        this.registerArgument(ARGS_ARGUMENT_HINT, ArgumentArity.VARIADIC, ArgumentOptionality.OPTIONAL, new Integer[0]);
        super.registerOptionsAndArguments();
    }

    private boolean containsAllTerms(String string, List<String> terms) {
        for (String term : terms) {
            if (string.contains(term)) continue;
            return false;
        }
        return true;
    }

    private int executeDetailsMode(Set<String> countries, Configuration configuration) {
        List searchTerms = this.optionAndArgumentDelegate.getVariadicArgument(ARGS_ARGUMENT_HINT);
        Optional<AtlasMutatorConfiguration> atlasMutatorConfigurationOptional = this.getConfiguration(countries, configuration);
        if (atlasMutatorConfigurationOptional.isEmpty()) {
            this.outputDelegate.printlnErrorMessage(CONFIG_EMPTY_MESSAGE);
            return 1;
        }
        JsonObject configObject = atlasMutatorConfigurationOptional.get().toJson();
        if (searchTerms.isEmpty()) {
            this.outputDelegate.printlnStdout(this.getPrettyGson().toJson((JsonElement)configObject), new TTYAttribute[0]);
            return 0;
        }
        this.searchJsonObjectForTermsAndPrint(configObject, searchTerms);
        return 0;
    }

    private int executeInteractiveMode(Set<String> countries, Configuration configuration) {
        String readLine;
        this.outputDelegate.printlnCommandMessage("starting interactive mode...");
        Optional<AtlasMutatorConfiguration> atlasMutatorConfigurationOptional = this.getConfiguration(countries, configuration);
        if (atlasMutatorConfigurationOptional.isEmpty()) {
            this.outputDelegate.printlnErrorMessage(CONFIG_EMPTY_MESSAGE);
            return 1;
        }
        AtlasMutatorConfiguration atlasMutatorConfiguration = atlasMutatorConfigurationOptional.get();
        Set<String> configurationKeys = atlasMutatorConfiguration.getConfigurationDetails().getAllConfigurationMapKeys();
        JsonObject configObject = atlasMutatorConfiguration.toJson();
        this.outputDelegate.printlnStdout("", new TTYAttribute[0]);
        this.outputDelegate.printlnStdout("-------- Atlas Mutator Configuration Interactive Exploration --------", new TTYAttribute[]{TTYAttribute.BOLD, TTYAttribute.GREEN});
        this.outputDelegate.printlnStdout("Please enter search terms separated by spaces.", new TTYAttribute[0]);
        this.outputDelegate.printlnStdout("", new TTYAttribute[0]);
        this.outputDelegate.printlnStdout("--- Controls ---", new TTYAttribute[]{TTYAttribute.BOLD});
        if (this.optionAndArgumentDelegate.hasOption(DISABLE_JLINE_OPTION_LONG)) {
            this.outputDelegate.printlnStdout("CTRL-D: exit", new TTYAttribute[0]);
            this.outputDelegate.printlnStdout("CTRL-C: exit", new TTYAttribute[0]);
        } else {
            this.outputDelegate.printlnStdout("CTRL-D: exit", new TTYAttribute[0]);
            this.outputDelegate.printlnStdout("CTRL-C: reset prompt", new TTYAttribute[0]);
            this.outputDelegate.printlnStdout("CTRL-L: clear screen", new TTYAttribute[0]);
            this.outputDelegate.printlnStdout("CTRL-R: history search", new TTYAttribute[0]);
            this.outputDelegate.printlnStdout("Arrow keys: navigate history or current line", new TTYAttribute[0]);
            this.outputDelegate.printlnStdout("<TAB>: autocomplete current line", new TTYAttribute[0]);
        }
        String prompt = this.getTTYStringBuilderForStdout().append((Object)"search terms", new TTYAttribute[]{TTYAttribute.BOLD, TTYAttribute.BLUE}).append((Object)"> ", new TTYAttribute[]{TTYAttribute.BOLD, TTYAttribute.RED}).toString();
        while ((readLine = this.optionAndArgumentDelegate.hasOption(DISABLE_JLINE_OPTION_LONG) ? this.readLineWithJavaIO(prompt) : this.readLineWithJLine(prompt, configurationKeys)) != null) {
            String[] lineSplit = readLine.split("\\s+");
            this.searchJsonObjectForTermsAndPrint(configObject, Arrays.asList(lineSplit));
        }
        if (this.terminal != null) {
            try {
                this.terminal.close();
            }
            catch (IOException exception) {
                throw new CoreException("Could not close terminal", (Throwable)exception);
            }
        }
        return 0;
    }

    private int executePrintMode(Set<String> countries, Configuration configuration) {
        ArrayList<String> countryCodesToPrint = this.optionAndArgumentDelegate.getVariadicArgument(ARGS_ARGUMENT_HINT);
        Optional<AtlasMutatorConfiguration> atlasMutatorConfigurationOptional = this.getConfiguration(countries, configuration);
        if (atlasMutatorConfigurationOptional.isEmpty()) {
            this.outputDelegate.printlnErrorMessage(CONFIG_EMPTY_MESSAGE);
            return 1;
        }
        AtlasMutatorConfiguration atlasMutatorConfiguration = atlasMutatorConfigurationOptional.get();
        if (countryCodesToPrint.isEmpty()) {
            countryCodesToPrint = new ArrayList<String>(new TreeSet<String>(atlasMutatorConfiguration.getCountryToMutationLevels().keySet()));
        }
        for (String countryOrGroupCode : countryCodesToPrint) {
            Tuple<Tuple<String, Set<String>>, List<AtlasMutationLevel>> countryOrGroupAndLevels = atlasMutatorConfiguration.countryOrGroupAndLevelList(countryOrGroupCode);
            Tuple<Tuple<String, Set<String>>, String> countryOrGroupAndDetails = atlasMutatorConfiguration.details(countryOrGroupCode);
            if (countryOrGroupAndDetails != null) {
                Tuple countryOrGroup = (Tuple)countryOrGroupAndLevels.getFirst();
                this.outputDelegate.printStdout("Level information for ", new TTYAttribute[]{TTYAttribute.BOLD});
                this.outputDelegate.printlnStdout((String)countryOrGroup.getFirst() + " (" + new StringList((Iterable)countryOrGroup.getSecond()).join(",") + ")", new TTYAttribute[]{TTYAttribute.BOLD, TTYAttribute.GREEN});
                this.outputDelegate.printlnStdout((String)countryOrGroupAndDetails.getSecond(), new TTYAttribute[]{TTYAttribute.GREEN});
            } else {
                this.outputDelegate.printlnWarnMessage(countryOrGroupCode + " was not found in the configuration");
            }
            this.outputDelegate.printlnStdout("", new TTYAttribute[0]);
        }
        return 0;
    }

    private Optional<AtlasMutatorConfiguration> getConfiguration(Set<String> countries, Configuration configuration) {
        AtlasMutatorConfiguration mutatorConfiguration;
        if (this.optionAndArgumentDelegate.hasVerboseOption()) {
            this.outputDelegate.printlnCommandMessage("constructing configuration...");
        }
        if ((mutatorConfiguration = new AtlasMutatorConfiguration(countries, (Sharding)new SlippyTileSharding(1), new CountryBoundaryMap(), "input", "output", new HashMap<String, String>(), configuration, this.optionAndArgumentDelegate.hasOption(GROUP_COUNTRIES_OPTION_LONG), this.optionAndArgumentDelegate.hasOption(ALLOW_RDD_OPTION_LONG), this.optionAndArgumentDelegate.hasOption(PRELOAD_RDD_OPTION_LONG), false)).isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(mutatorConfiguration);
    }

    private Gson getPrettyGson() {
        return new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    }

    private StringList parseCommaSeparatedStrings(String string) {
        StringList stringList = new StringList();
        if (string.isEmpty()) {
            return stringList;
        }
        stringList.addAll((Iterable)Arrays.stream(string.split(",")).collect(Collectors.toList()));
        return stringList;
    }

    private String readLineWithJLine(String prompt, Set<String> configurationKeys) {
        String line;
        if (this.history == null) {
            this.history = new DefaultHistory();
        }
        try {
            this.terminal = TerminalBuilder.builder().build();
        }
        catch (IOException exception) {
            throw new CoreException("Could not build terminal", (Throwable)exception);
        }
        StringsCompleter completer = new StringsCompleter(configurationKeys);
        LineReader reader = LineReaderBuilder.builder().history(this.history).completer((Completer)completer).terminal(this.terminal).build();
        while (true) {
            try {
                line = reader.readLine(prompt);
            }
            catch (UserInterruptException exception) {
                continue;
            }
            catch (EndOfFileException exception) {
                return null;
            }
            break;
        }
        return line;
    }

    private String readLineWithJavaIO(String prompt) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.getInStream()));
        this.outputDelegate.printStdout(prompt, new TTYAttribute[0]);
        try {
            return reader.readLine();
        }
        catch (IOException exception) {
            throw new CoreException("Could not read line from InputStream", (Throwable)exception);
        }
    }

    private void searchForMatchAndPrint(JsonElement element, List<String> searchTerms) {
        String elementString = element.toString();
        if (this.containsAllTerms(elementString, searchTerms)) {
            String prettyElement = this.getPrettyGson().toJson(element);
            for (String searchTerm : searchTerms) {
                prettyElement = prettyElement.replace(searchTerm, this.getTTYStringBuilderForStdout().append((Object)searchTerm, new TTYAttribute[]{TTYAttribute.RED, TTYAttribute.BOLD}).toString());
            }
            this.outputDelegate.printlnStdout(prettyElement, new TTYAttribute[0]);
        }
    }

    private void searchJsonObjectForTermsAndPrint(JsonObject configObject, List<String> searchTerms) {
        for (JsonElement element : configObject.getAsJsonArray("mutators")) {
            this.searchForMatchAndPrint(element, searchTerms);
        }
        for (JsonElement element : configObject.getAsJsonArray("levels")) {
            this.searchForMatchAndPrint(element, searchTerms);
        }
        for (JsonElement element : configObject.getAsJsonArray("dynamicAtlasPolicies")) {
            this.searchForMatchAndPrint(element, searchTerms);
        }
        for (JsonElement element : configObject.getAsJsonArray("filters")) {
            this.searchForMatchAndPrint(element, searchTerms);
        }
        for (JsonElement element : configObject.getAsJsonArray("inputDependencies")) {
            this.searchForMatchAndPrint(element, searchTerms);
        }
        for (JsonElement element : configObject.getAsJsonArray("fetchers")) {
            this.searchForMatchAndPrint(element, searchTerms);
        }
        for (JsonElement element : configObject.getAsJsonArray("subAtlases")) {
            this.searchForMatchAndPrint(element, searchTerms);
        }
        for (JsonElement element : configObject.getAsJsonArray("mergeForgivenessPolicies")) {
            this.searchForMatchAndPrint(element, searchTerms);
        }
        for (JsonElement element : configObject.getAsJsonArray("broadcastables")) {
            this.searchForMatchAndPrint(element, searchTerms);
        }
    }
}

