/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.mutator;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.generator.AtlasGeneratorParameters;
import org.openstreetmap.atlas.generator.tools.caching.HadoopAtlasFileCache;
import org.openstreetmap.atlas.generator.tools.spark.utilities.SparkFileHelper;
import org.openstreetmap.atlas.geography.atlas.change.Change;
import org.openstreetmap.atlas.geography.atlas.change.FeatureChange;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlas;
import org.openstreetmap.atlas.geography.sharding.CountryShard;
import org.openstreetmap.atlas.geography.sharding.Shard;
import org.openstreetmap.atlas.geography.sharding.SlippyTile;
import org.openstreetmap.atlas.mutator.AtlasMutatorHelper;
import org.openstreetmap.atlas.mutator.AtlasMutatorParameters;
import org.openstreetmap.atlas.mutator.configuration.AtlasMutationLevel;
import org.openstreetmap.atlas.mutator.configuration.AtlasMutatorConfiguration;
import org.openstreetmap.atlas.mutator.configuration.InputDependency;
import org.openstreetmap.atlas.mutator.persistence.FeatureChangeOutputFormat;
import org.openstreetmap.atlas.streaming.resource.AbstractWritableResource;
import org.openstreetmap.atlas.streaming.resource.FileSuffix;
import org.openstreetmap.atlas.streaming.resource.OutputStreamWritableResource;
import org.openstreetmap.atlas.streaming.resource.WritableResource;
import org.openstreetmap.atlas.utilities.collections.Maps;
import org.openstreetmap.atlas.utilities.collections.Sets;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;
import org.openstreetmap.atlas.utilities.tuples.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class AtlasMutatorUntangled
extends Command {
    private static final Logger logger = LoggerFactory.getLogger(AtlasMutatorUntangled.class);
    private static final Command.Switch<Integer> LEVEL_INDEX = new Command.Switch("levelIndex", "The level index to run for that country.", Integer::parseInt, Command.Optionality.OPTIONAL, "0");
    private static final Command.Switch<Shard> SHARD = new Command.Switch("shard", "The shard to run for that country.", SlippyTile::forName, Command.Optionality.REQUIRED);
    private static final Command.Switch<Boolean> RUN_ALL_LEVELS_UP_TO = new Command.Switch("runAllLevelsUpTo", "If true, this will run all the levels until the specified level for the specified shard.", Boolean::parseBoolean, Command.Optionality.OPTIONAL, "false");
    private static final String ERROR = "Error";
    private Map<String, String> sparkConfiguration = Maps.hashMap((Object[])new String[0]);

    public static void main(String[] args) {
        new HadoopAtlasFileCache("", Maps.hashMap((Object[])new String[0])).invalidate();
        new AtlasMutatorUntangled().runWithoutQuitting(args);
    }

    protected int onRun(CommandMap command) {
        List<AtlasMutationLevel> levels = this.getLevels(command);
        Integer levelIndex = (Integer)command.get(LEVEL_INDEX);
        Shard shard = (Shard)command.get(SHARD);
        boolean runAllLevelsUpTo = (Boolean)command.get(RUN_ALL_LEVELS_UP_TO);
        this.forceFeedBroadcastVariables(levels);
        for (int index = 0; index <= levelIndex; ++index) {
            if (!runAllLevelsUpTo && index != levelIndex) continue;
            AtlasMutationLevel runnableLevel = levels.get(index);
            AtlasMutatorParameters.debugMutations(command).forEach(runnableLevel::addDebugWhiteListedMutator);
            this.start(runnableLevel, new CountryShard(runnableLevel.getCountries().iterator().next(), shard));
        }
        return 0;
    }

    protected Command.SwitchList switches() {
        return AtlasMutatorParameters.switches().with(new Command.Switch[]{LEVEL_INDEX, SHARD, RUN_ALL_LEVELS_UP_TO});
    }

    protected AtlasMutatorUntangled withSparkConfiguration(Map<String, String> sparkConfiguration) {
        this.sparkConfiguration = sparkConfiguration;
        return this;
    }

    private void forceFeedBroadcastVariables(List<AtlasMutationLevel> levels) {
        HashMap broadcastVariables = new HashMap();
        levels.forEach(level -> level.getMutators().forEach(mutator -> mutator.getBroadcastVariablesNeeded().forEach((name, value) -> {
            if (!broadcastVariables.containsKey(name)) {
                broadcastVariables.put(name, value.read(this.sparkConfiguration));
            }
        })));
        levels.forEach(level -> level.getMutators().forEach(mutator -> broadcastVariables.forEach(mutator::addBroadcastVariable)));
    }

    private String getCountry(CommandMap command) {
        StringList countries = (StringList)command.get(AtlasGeneratorParameters.COUNTRIES);
        if (countries.size() != 1) {
            throw new CoreException("Number of countries has to be exactly 1.");
        }
        return countries.get(0);
    }

    private AtlasMutationLevel getLevel(CommandMap command) {
        Integer levelIndex = (Integer)command.get(LEVEL_INDEX);
        if (levelIndex < 0) {
            throw new CoreException("levelIndex has to be >= 0");
        }
        String country = this.getCountry(command);
        List<AtlasMutationLevel> levels = this.getLevels(command);
        if (levels.size() <= levelIndex) {
            throw new CoreException("Country {} mutation levels do not contain index {}", new Object[]{country, levelIndex});
        }
        AtlasMutationLevel level = levels.get(levelIndex);
        if (level.getLevelIndex() != levelIndex.intValue()) {
            throw new CoreException("Country {} mutation levels are malformed. Expected level index {} but found level index {} instead.", new Object[]{country, levelIndex, level.getLevelIndex()});
        }
        return level;
    }

    private List<AtlasMutationLevel> getLevels(CommandMap command) {
        Map<String, List<AtlasMutationLevel>> countryToMutationLevels;
        String country = this.getCountry(command);
        AtlasMutatorConfiguration atlasMutatorConfiguration = AtlasMutatorParameters.atlasMutatorConfiguration(command, this.sparkConfiguration);
        if (logger.isInfoEnabled()) {
            logger.info("AtlasMutator country and levels:\n\n{}\n", atlasMutatorConfiguration.details());
        }
        if (!(countryToMutationLevels = atlasMutatorConfiguration.getCountryToMutationLevels()).containsKey(country)) {
            throw new CoreException("Configuration does not contain country {}", new Object[]{country});
        }
        return countryToMutationLevels.get(country);
    }

    private Configuration hadoopConfiguration() {
        Configuration result = new Configuration();
        this.sparkConfiguration.forEach((arg_0, arg_1) -> ((Configuration)result).set(arg_0, arg_1));
        return result;
    }

    private AbstractWritableResource outputResource(AtlasMutationLevel level, CountryShard countryShard, String type) {
        return this.outputResource(SparkFileHelper.parentPath(level.getOutputAtlasPath()) + "/logs/" + countryShard.getCountry() + "-" + level.getLevelIndex() + "-" + type + "/" + countryShard.getCountry() + "-" + level.getLevelIndex() + "-" + type + "_" + countryShard.getShard().getName() + FileSuffix.GEO_JSON.toString());
    }

    private AbstractWritableResource outputResource(String path) {
        try {
            return new OutputStreamWritableResource((OutputStream)new Path(path).getFileSystem(this.hadoopConfiguration()).create(new Path(path)));
        }
        catch (IOException | IllegalArgumentException e) {
            throw new CoreException("Unable to write to {}", new Object[]{path, e});
        }
    }

    private void start(AtlasMutationLevel level, CountryShard countryShard) {
        ArrayList shardFeatureChangesRDD;
        try {
            shardFeatureChangesRDD = Lists.newArrayList((Iterator)AtlasMutatorHelper.shardToFeatureChanges(level).call((Object)countryShard));
        }
        catch (Exception e) {
            throw new CoreException(ERROR, (Throwable)e);
        }
        shardFeatureChangesRDD.forEach(tuple -> {
            CountryShard countryShardInternal = (CountryShard)tuple._1();
            AbstractWritableResource outputResource = this.outputResource(level, countryShardInternal, "generated");
            new LocalFeatureChangeOutputFormat().save((List)tuple._2(), outputResource);
        });
        List shardAssignedFeatureChangesRDD0 = shardFeatureChangesRDD.stream().flatMap(tuple -> {
            try {
                return Lists.newArrayList((Iterator)AtlasMutatorHelper.shardFeatureChangesToAssignedShardFeatureChanges(level).call(tuple)).stream();
            }
            catch (Exception e) {
                throw new CoreException(ERROR, (Throwable)e);
            }
        }).collect(Collectors.toList());
        List shardAssignedFeatureChangesRDD1 = shardAssignedFeatureChangesRDD0.stream().filter(tuple -> countryShard.equals(tuple._1())).collect(Collectors.toList());
        HashMap<CountryShard, List> shardAssignedFeatureChangesRDD2 = new HashMap<CountryShard, List>();
        for (Tuple2 shardToList : shardAssignedFeatureChangesRDD1) {
            CountryShard shardInternal2 = (CountryShard)shardToList._1();
            List value = (List)shardToList._2();
            if (shardAssignedFeatureChangesRDD2.containsKey(shardInternal2)) {
                try {
                    shardAssignedFeatureChangesRDD2.put(shardInternal2, (List)AtlasMutatorHelper.assignedToConcatenatedFeatureChanges(level).call((Object)((List)shardAssignedFeatureChangesRDD2.get(shardInternal2)), (Object)value));
                    continue;
                }
                catch (Exception e) {
                    throw new CoreException(ERROR, (Throwable)e);
                }
            }
            shardAssignedFeatureChangesRDD2.put(shardInternal2, value);
        }
        shardAssignedFeatureChangesRDD2.forEach((countryShardInternal, featureChanges) -> {
            AbstractWritableResource outputResource = this.outputResource(level, (CountryShard)countryShardInternal, "assigned");
            new LocalFeatureChangeOutputFormat().save((List<FeatureChange>)featureChanges, outputResource);
        });
        List shardAppliedFeatureChangesRDD = shardAssignedFeatureChangesRDD2.entrySet().stream().map(entry -> new Tuple2((Object)((CountryShard)entry.getKey()), (Object)((List)entry.getValue()))).map(tuple -> {
            try {
                return AtlasMutatorHelper.assignedToShardAppliedFeatureChanges(level).call(tuple);
            }
            catch (Exception e) {
                throw new CoreException(ERROR, (Throwable)e);
            }
        }).collect(Collectors.toList());
        List shardChangeRDD = shardAppliedFeatureChangesRDD.stream().map(tuple -> {
            try {
                return AtlasMutatorHelper.featureChangeListToChange(level).call(tuple);
            }
            catch (Exception e) {
                throw new CoreException(ERROR, (Throwable)e);
            }
        }).collect(Collectors.toList());
        List changedAtlasRDD = shardChangeRDD.stream().flatMap(tuple -> {
            try {
                return Lists.newArrayList((Iterator)AtlasMutatorHelper.changeToAtlas(level).call(tuple)).stream();
            }
            catch (Exception e) {
                throw new CoreException(ERROR, (Throwable)e);
            }
        }).collect(Collectors.toList());
        changedAtlasRDD.stream().filter(tuple -> ((Tuple)tuple._2()).getSecond() != null).forEach(tuple -> {
            CountryShard countryShardInternal = (CountryShard)tuple._1();
            AbstractWritableResource outputResource = this.outputResource(level, countryShardInternal, "applied");
            new LocalFeatureChangeOutputFormat().save(((Change)((Tuple)tuple._2()).getSecond()).getFeatureChanges(), outputResource);
        });
        Set populatedShards = changedAtlasRDD.stream().map(tuple -> ((CountryShard)tuple._1()).getName()).map(CountryShard::forName).collect(Collectors.toSet());
        List unChangedAtlasRDD = Sets.hashSet((Object[])new CountryShard[]{countryShard}).stream().filter(shardInternal -> !populatedShards.contains(shardInternal)).flatMap(shardInternal -> {
            try {
                return Lists.newArrayList((Iterator)AtlasMutatorHelper.untouchedShardToPotentialSourcePackedAtlas(level).call(shardInternal)).stream();
            }
            catch (Exception e) {
                throw new CoreException(ERROR, (Throwable)e);
            }
        }).collect(Collectors.toList());
        ArrayList allUpdatedAtlasShardsRDD = new ArrayList();
        allUpdatedAtlasShardsRDD.addAll(changedAtlasRDD.stream().filter(tuple -> ((Tuple)tuple._2()).getSecond() != null).map(tuple -> new Tuple2((Object)((CountryShard)tuple._1()), (Object)((PackedAtlas)((Tuple)tuple._2()).getFirst()))).collect(Collectors.toList()));
        allUpdatedAtlasShardsRDD.addAll(unChangedAtlasRDD);
        allUpdatedAtlasShardsRDD.forEach(tuple -> {
            CountryShard countryShardInternal = (CountryShard)tuple._1();
            String country = countryShardInternal.getCountry();
            ((PackedAtlas)tuple._2()).save((WritableResource)this.outputResource(level.getOutputAtlasPath() + "/" + country + "/" + countryShard.getName() + ".atlas"));
        });
        for (InputDependency inputDependency : level.getInputDependenciesToProvide()) {
            allUpdatedAtlasShardsRDD.stream().flatMap(tuple -> {
                try {
                    return Lists.newArrayList((Iterator)AtlasMutatorHelper.inputDependencyFilteredAtlas(level, inputDependency).call(tuple)).stream();
                }
                catch (Exception e) {
                    throw new CoreException(ERROR, (Throwable)e);
                }
            }).forEach(tuple -> {
                CountryShard countryShardInternal = (CountryShard)tuple._1();
                String country = countryShardInternal.getCountry();
                ((PackedAtlas)tuple._2()).save((WritableResource)this.outputResource(level.getOutputAtlasPath(inputDependency) + "/" + country + "/" + countryShard.getName() + ".atlas"));
            });
        }
    }

    private static class LocalFeatureChangeOutputFormat
    extends FeatureChangeOutputFormat {
        private LocalFeatureChangeOutputFormat() {
        }

        @Override
        protected void save(List<FeatureChange> value, AbstractWritableResource out) {
            super.save(value, out);
        }
    }
}

