/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.mutator;

import java.io.Serializable;
import java.nio.file.FileSystem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.spark.Partitioner;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.generator.AtlasGeneratorParameters;
import org.openstreetmap.atlas.generator.sharding.AtlasSharding;
import org.openstreetmap.atlas.generator.tools.spark.SparkJob;
import org.openstreetmap.atlas.generator.tools.spark.persistence.PersistenceTools;
import org.openstreetmap.atlas.geography.boundary.CountryBoundaryMap;
import org.openstreetmap.atlas.geography.sharding.CountryShard;
import org.openstreetmap.atlas.geography.sharding.Sharding;
import org.openstreetmap.atlas.mutator.configuration.AtlasMutatorConfiguration;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.streaming.resource.StringResource;
import org.openstreetmap.atlas.streaming.resource.http.GetResource;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.configuration.MergedConfiguration;
import org.openstreetmap.atlas.utilities.configuration.StandardConfiguration;
import org.openstreetmap.atlas.utilities.conversion.StringConverter;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;
import org.openstreetmap.atlas.utilities.scalars.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AtlasMutatorParameters {
    public static final Command.Switch<StringList> MUTATOR_CONFIGURATION_RESOURCE = new Command.Switch("mutatorConfigurationResource", "Comma-separated list of configuration resources.", value -> StringList.split((String)value, (String)","), Command.Optionality.OPTIONAL);
    public static final Command.Switch<String> MUTATOR_CONFIGURATION_JSON = new Command.Switch("mutatorConfigurationJson", "Json formatted configuration.", StringConverter.IDENTITY, Command.Optionality.OPTIONAL);
    public static final Command.Switch<String> INPUT_ATLAS = new Command.Switch("atlas", "Path to the input Atlas folder", StringConverter.IDENTITY, Command.Optionality.REQUIRED);
    public static final Command.Switch<String> SHARDING_PROVIDED = new Command.Switch("sharding", "Provided sharding tree to override the one from the Atlas folder. Use at your own risk! If they do not match with the input folder, the job's behavior is undefined.", StringConverter.IDENTITY, Command.Optionality.OPTIONAL, "");
    public static final Command.Switch<String> BOUNDARIES_PROVIDED = new Command.Switch("boundaries", "Provided boundary file to override the one from the Atlas folder. Use at your own risk! If they do not match with the input folder, the job's behavior is undefined.", StringConverter.IDENTITY, Command.Optionality.OPTIONAL, "");
    public static final Command.Switch<Integer> COUNTRY_CONCURRENCY = new Command.Switch("countryConcurrency", "The number of countries that are submitted to the Spark Cluster at the same time.", Integer::parseInt, Command.Optionality.OPTIONAL, "300");
    public static final Command.Switch<Boolean> ADD_MUTATION_TAGS = new Command.Switch("addMutationTags", "Whether or not to add a tag to each feature touched by a mutation with the mutation name.", Boolean::parseBoolean, Command.Optionality.OPTIONAL, "true");
    public static final Command.Switch<Boolean> ALLOW_RDD = new Command.Switch("allowRDD", "Whether or not to allow eligible mutation levels to source data from previous level's RDD", Boolean::parseBoolean, Command.Optionality.OPTIONAL, "false");
    public static final Command.Switch<Duration> SUBMISSION_STAGGERING_WAIT = new Command.Switch("submissionStaggeringWaitInSeconds", "How long to wait between each country submission to the driver", value -> Duration.seconds((double)Double.parseDouble(value)), Command.Optionality.OPTIONAL, "0.0");
    public static final Command.Switch<Boolean> GROUP_COUNTRIES = new Command.Switch("groupCountries", "When true, this allows the driver to group countries together by similarity in levels.", Boolean::parseBoolean, Command.Optionality.OPTIONAL, "true");
    public static final Command.Switch<Boolean> PRELOAD_RDD = new Command.Switch("preloadRDD", "Whether or not to allow eligible mutation levels to preload atlas data into an RDD before processing mutations", Boolean::parseBoolean, Command.Optionality.OPTIONAL, "false");
    public static final Command.Switch<Integer> DEBUG_SKIP_TO_LEVEL = new Command.Switch("debugSkipToLevel", "What level to skip to", Integer::parseInt, Command.Optionality.OPTIONAL, "0");
    public static final Command.Switch<Integer> DEBUG_STOP_AT_LEVEL = new Command.Switch("debugStopAtLevel", "What level to stop at", Integer::parseInt, Command.Optionality.OPTIONAL, String.valueOf(Integer.MAX_VALUE));
    public static final Command.Switch<Boolean> DEBUG_APPLIED_RDD_PERSIST_USE_SER = new Command.Switch("debugAppliedRDDPersistUseSer", "When persisting shardAppliedFeatureChangesRDD, if true use MEMORY_AND_DISK_SER. If false, uses MEMORY_AND_DISK", Boolean::parseBoolean, Command.Optionality.OPTIONAL, "false");
    private static final StringConverter<StringList> DEBUG_CSV = value -> value.isEmpty() ? new StringList() : StringList.split((String)value, (String)",");
    public static final Command.Switch<StringList> DEBUG_SHARDS = new Command.Switch("debugShards", "Comma separated list of shards of interest", DEBUG_CSV, Command.Optionality.OPTIONAL, "");
    public static final Command.Switch<StringList> DEBUG_MUTATIONS = new Command.Switch("debugMutations", "Comma separated list of mutations of interest", DEBUG_CSV, Command.Optionality.OPTIONAL, "");
    private static final Logger logger = LoggerFactory.getLogger(AtlasMutatorParameters.class);
    public static final Command.Switch<DebugFeatureChangeOutput> DEBUG_FEATURE_CHANGE_OUTPUT = new Command.Switch("debugFeatureChangeOutput", "Whether to save every stage of the feature changes. Values are \"" + DebugFeatureChangeOutput.ALL + "\", \"" + DebugFeatureChangeOutput.APPLIED + "\", or \"" + DebugFeatureChangeOutput.NONE + "\"", value -> {
        try {
            return DebugFeatureChangeOutput.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            logger.error("{} \"{}\" is not recognized! Using {} instead.", new Object[]{DebugFeatureChangeOutput.class.getSimpleName(), value, DebugFeatureChangeOutput.APPLIED});
            return DebugFeatureChangeOutput.APPLIED;
        }
    }, Command.Optionality.OPTIONAL, DebugFeatureChangeOutput.APPLIED.name());

    public static CountryBoundaryMap boundaries(CommandMap command, Map<String, String> configuration) {
        String providedBoundaries = (String)command.get(BOUNDARIES_PROVIDED);
        if (!providedBoundaries.isEmpty()) {
            return CountryBoundaryMap.fromPlainText((Resource)SparkJob.resource(providedBoundaries, configuration));
        }
        String input = AtlasMutatorParameters.input(command);
        return new PersistenceTools(configuration).boundaries(input);
    }

    public static Set<String> countries(CommandMap command) {
        return ((StringList)command.get(AtlasGeneratorParameters.COUNTRIES)).stream().collect(Collectors.toSet());
    }

    public static Integer countryConcurrency(CommandMap command) {
        return (Integer)command.get(COUNTRY_CONCURRENCY);
    }

    public static DebugFeatureChangeOutput debugFeatureChangeOutput(CommandMap command) {
        return (DebugFeatureChangeOutput)((Object)command.get(DEBUG_FEATURE_CHANGE_OUTPUT));
    }

    public static Configuration mutatorsConfiguration(CommandMap command, Map<String, String> sparkConfiguration) {
        Optional<Configuration> configurationOptional = AtlasMutatorParameters.mutatorsConfiguration((StringList)command.get(MUTATOR_CONFIGURATION_RESOURCE), (String)command.get(MUTATOR_CONFIGURATION_JSON), sparkConfiguration);
        if (!configurationOptional.isPresent()) {
            throw new CoreException("The configuration is empty!");
        }
        Configuration configuration = configurationOptional.get();
        return configuration;
    }

    public static Optional<Configuration> mutatorsConfiguration(StringList resources, String json, FileSystem sourceFileSystem) {
        return AtlasMutatorParameters.mutatorsConfiguration(resources, json, null, sourceFileSystem);
    }

    public static Optional<Configuration> mutatorsConfiguration(StringList resources, String json, Map<String, String> sparkConfiguration) {
        return AtlasMutatorParameters.mutatorsConfiguration(resources, json, sparkConfiguration, null);
    }

    public static Comparator<CountryShard> shardComparator() {
        return (Comparator & Serializable)(shard1, shard2) -> shard1.getName().compareTo(shard2.getName());
    }

    public static Partitioner shardPartitioner(final Set<CountryShard> countryShards) {
        final HashMap<CountryShard, Integer> shardToIndex = new HashMap<CountryShard, Integer>();
        int index = 0;
        for (CountryShard countryShard : countryShards) {
            shardToIndex.put(countryShard, index);
            ++index;
        }
        return new Partitioner(){
            private static final long serialVersionUID = -779349575361610965L;

            public int getPartition(Object object) {
                if (object instanceof CountryShard) {
                    return (Integer)shardToIndex.get(object);
                }
                throw new CoreException("{} is not a CountryShard.", new Object[]{object});
            }

            public int numPartitions() {
                return countryShards.size();
            }
        };
    }

    public static Sharding sharding(CommandMap command, Map<String, String> configuration) {
        String providedSharding = (String)command.get(SHARDING_PROVIDED);
        if (!providedSharding.isEmpty()) {
            return AtlasSharding.forString(providedSharding, configuration);
        }
        String input = AtlasMutatorParameters.input(command);
        try {
            return new PersistenceTools(configuration).sharding(input);
        }
        catch (Exception e) {
            throw new CoreException("Unable to find sharding tree in {}", new Object[]{input, e});
        }
    }

    public static Duration submissionStaggering(CommandMap command) {
        return (Duration)command.get(SUBMISSION_STAGGERING_WAIT);
    }

    protected static AtlasMutatorConfiguration atlasMutatorConfiguration(CommandMap command, Map<String, String> sparkConfiguration) {
        String input = AtlasMutatorParameters.input(command);
        String output = AtlasMutatorParameters.output(command);
        boolean groupCountries = AtlasMutatorParameters.isGroupCountries(command);
        boolean allowRDD = AtlasMutatorParameters.isAllowRDD(command);
        boolean preloadRDD = AtlasMutatorParameters.isPreloadRDD(command);
        return new AtlasMutatorConfiguration(AtlasMutatorParameters.countries(command), AtlasMutatorParameters.sharding(command, sparkConfiguration), AtlasMutatorParameters.boundaries(command, sparkConfiguration), input, output, sparkConfiguration, AtlasMutatorParameters.mutatorsConfiguration(command, sparkConfiguration), groupCountries, allowRDD, preloadRDD);
    }

    protected static StringList debugMutations(CommandMap command) {
        return (StringList)command.get(DEBUG_MUTATIONS);
    }

    protected static StringList debugShards(CommandMap command) {
        return (StringList)command.get(DEBUG_SHARDS);
    }

    protected static boolean isAddMutationTags(CommandMap command) {
        return (Boolean)command.get(ADD_MUTATION_TAGS);
    }

    protected static boolean isAllowRDD(CommandMap command) {
        return (Boolean)command.get(ALLOW_RDD);
    }

    protected static boolean isAppliedRDDPersistUseSer(CommandMap command) {
        return (Boolean)command.get(DEBUG_APPLIED_RDD_PERSIST_USE_SER);
    }

    protected static boolean isGroupCountries(CommandMap command) {
        return (Boolean)command.get(GROUP_COUNTRIES);
    }

    protected static boolean isPreloadRDD(CommandMap command) {
        return (Boolean)command.get(PRELOAD_RDD);
    }

    protected static int startLevel(CommandMap command) {
        int result = (Integer)command.get(DEBUG_SKIP_TO_LEVEL);
        if (result < 0) {
            throw new CoreException("Debug Start Level {} has to be > 0", new Object[]{result});
        }
        return result;
    }

    protected static int stopLevel(CommandMap command) {
        int result = (Integer)command.get(DEBUG_STOP_AT_LEVEL);
        if (result < 0) {
            throw new CoreException("Debug Stop Level {} has to be > 0", new Object[]{result});
        }
        return result;
    }

    protected static Command.SwitchList switches() {
        return new Command.SwitchList().with(new Command.Switch[]{AtlasGeneratorParameters.COUNTRIES, AtlasGeneratorParameters.CODE_VERSION, AtlasGeneratorParameters.DATA_VERSION, AtlasGeneratorParameters.ATLAS_SCHEME, MUTATOR_CONFIGURATION_JSON, MUTATOR_CONFIGURATION_RESOURCE, INPUT_ATLAS, SHARDING_PROVIDED, BOUNDARIES_PROVIDED, COUNTRY_CONCURRENCY, DEBUG_FEATURE_CHANGE_OUTPUT, DEBUG_SKIP_TO_LEVEL, DEBUG_STOP_AT_LEVEL, DEBUG_SHARDS, DEBUG_MUTATIONS, DEBUG_APPLIED_RDD_PERSIST_USE_SER, PersistenceTools.COPY_SHARDING_AND_BOUNDARIES, ADD_MUTATION_TAGS, ALLOW_RDD, SUBMISSION_STAGGERING_WAIT, GROUP_COUNTRIES, PRELOAD_RDD});
    }

    static String input(CommandMap command) {
        return (String)command.get(INPUT_ATLAS);
    }

    static String output(CommandMap command) {
        return (String)command.get(SparkJob.OUTPUT);
    }

    private static List<Configuration> loadConfigurationsFromResourcePath(String resourcePath, Map<String, String> sparkConfiguration, FileSystem sourceFileSystem) {
        ArrayList<Configuration> mutatorConfigurations = new ArrayList<Configuration>();
        if (resourcePath.startsWith("http")) {
            mutatorConfigurations.add((Configuration)new StandardConfiguration((Resource)new GetResource(resourcePath)));
        } else if (sparkConfiguration != null) {
            mutatorConfigurations.add((Configuration)new StandardConfiguration(SparkJob.resource(resourcePath, sparkConfiguration)));
            logger.debug("Loaded configuration using SparkJob.resource");
        } else if (sourceFileSystem != null) {
            mutatorConfigurations.add((Configuration)new StandardConfiguration((Resource)new File(resourcePath, sourceFileSystem)));
            logger.debug("Loaded configuration using FileSystem");
        } else {
            throw new CoreException("sparkConfiguration and sourceFileSystem cannot both be null!");
        }
        return mutatorConfigurations;
    }

    private static Optional<Configuration> mutatorsConfiguration(StringList resources, String json, Map<String, String> sparkConfiguration, FileSystem sourceFileSystem) {
        ArrayList<Object> mutatorConfigurations = new ArrayList<Object>();
        if (resources != null && !resources.isEmpty()) {
            for (String resourcePath : resources) {
                mutatorConfigurations.addAll(AtlasMutatorParameters.loadConfigurationsFromResourcePath(resourcePath, sparkConfiguration, sourceFileSystem));
            }
        }
        if (json != null && !json.isEmpty()) {
            mutatorConfigurations.add(0, new StandardConfiguration((Resource)new StringResource(json)));
        }
        if (mutatorConfigurations.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new MergedConfiguration(mutatorConfigurations));
    }

    private AtlasMutatorParameters() {
    }

    public static enum DebugFeatureChangeOutput {
        ALL,
        APPLIED,
        NONE;

    }
}

