/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.mutator;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.api.java.function.PairFunction;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.exception.change.FeatureChangeMergeException;
import org.openstreetmap.atlas.generator.tools.json.PersistenceJsonParser;
import org.openstreetmap.atlas.generator.tools.spark.utilities.SparkFileHelper;
import org.openstreetmap.atlas.geography.GeometricSurface;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.AtlasMetaData;
import org.openstreetmap.atlas.geography.atlas.change.Change;
import org.openstreetmap.atlas.geography.atlas.change.ChangeAtlas;
import org.openstreetmap.atlas.geography.atlas.change.ChangeBuilder;
import org.openstreetmap.atlas.geography.atlas.change.ChangeType;
import org.openstreetmap.atlas.geography.atlas.change.FeatureChange;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteArea;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteEntity;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteLineItem;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteLocationItem;
import org.openstreetmap.atlas.geography.atlas.dynamic.DynamicAtlas;
import org.openstreetmap.atlas.geography.atlas.dynamic.policy.DynamicAtlasPolicy;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.LineItem;
import org.openstreetmap.atlas.geography.atlas.items.LocationItem;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlas;
import org.openstreetmap.atlas.geography.atlas.sub.AtlasCutType;
import org.openstreetmap.atlas.geography.sharding.CountryShard;
import org.openstreetmap.atlas.geography.sharding.Shard;
import org.openstreetmap.atlas.mutator.configuration.AtlasMutationLevel;
import org.openstreetmap.atlas.mutator.configuration.InputDependency;
import org.openstreetmap.atlas.mutator.configuration.mutators.ConfiguredAtlasChangeGenerator;
import org.openstreetmap.atlas.mutator.configuration.parsing.ConfiguredSubAtlas;
import org.openstreetmap.atlas.mutator.configuration.parsing.mergeforgiveness.ConfiguredMergeForgivenessPolicy;
import org.openstreetmap.atlas.mutator.filtering.ChangeFilter;
import org.openstreetmap.atlas.utilities.collections.Maps;
import org.openstreetmap.atlas.utilities.maps.MultiMap;
import org.openstreetmap.atlas.utilities.scalars.Duration;
import org.openstreetmap.atlas.utilities.threads.Pool;
import org.openstreetmap.atlas.utilities.threads.Result;
import org.openstreetmap.atlas.utilities.time.Time;
import org.openstreetmap.atlas.utilities.tuples.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;
import scala.Tuple2;

public final class AtlasMutatorHelper
implements Serializable {
    private static final long serialVersionUID = 3761422875454997973L;
    private static final Logger logger = LoggerFactory.getLogger(AtlasMutatorHelper.class);
    private static final String ERROR_IN_MUTATION = "{}: Shard {}: Error generating FeatureChanges for {} after {}";
    private static final int EXECUTE_MUTATIONS_THREADS = 5;

    public static String getAlternateSubFolderOutput(String output, String name) {
        return SparkFileHelper.combine(SparkFileHelper.parentPath(output), name);
    }

    protected static Function2<List<FeatureChange>, List<FeatureChange>, List<FeatureChange>> assignedToConcatenatedFeatureChanges(AtlasMutationLevel level) {
        String message = "Concatenating two FeatureChange lists: [L: {}, R: {}, UUID: {}]";
        return (Function2 & Serializable)(list1, list2) -> {
            String uuid = UUID.randomUUID().toString();
            String leftSize = String.valueOf(list1.size());
            String rightSize = String.valueOf(list2.size());
            Time start = Time.now();
            try {
                List result = list1;
                result.addAll(list2);
                return result;
            }
            catch (Exception e) {
                throw AtlasMutatorHelper.exception(start, level, "Concatenating two FeatureChange lists: [L: {}, R: {}, UUID: {}]", e, leftSize, rightSize, uuid).get();
            }
        };
    }

    protected static PairFunction<Tuple2<CountryShard, List<FeatureChange>>, CountryShard, List<FeatureChange>> assignedToShardAppliedFeatureChanges(AtlasMutationLevel level) {
        String message = "Shard {}: Merging FeatureChanges.";
        return (PairFunction & Serializable)tuple -> {
            CountryShard countryShard = (CountryShard)tuple._1();
            Time start = AtlasMutatorHelper.startTime(level, "Shard {}: Merging FeatureChanges.", countryShard.getName());
            try {
                MultiMap indexed = new MultiMap();
                ((List)tuple._2()).forEach(featureChange -> indexed.add((Object)AtlasMutatorHelper.featureChangeKey(featureChange), featureChange));
                ArrayList<FeatureChange> result = new ArrayList<FeatureChange>();
                for (Map.Entry entry : indexed.entrySet()) {
                    List value = (List)entry.getValue();
                    if (value.size() > 1) {
                        LinkedList newValue = Lists.newLinkedList((Iterable)value);
                        while (newValue.size() > 1) {
                            FeatureChange first = (FeatureChange)newValue.poll();
                            FeatureChange second = (FeatureChange)newValue.poll();
                            FeatureChange merged = AtlasMutatorHelper.merge(level, first, second);
                            newValue.add(merged);
                        }
                        result.add((FeatureChange)newValue.peek());
                        continue;
                    }
                    result.add((FeatureChange)value.get(0));
                }
                AtlasMutatorHelper.logTime(start, level, "Shard {}: Merging FeatureChanges.", countryShard.getName());
                return new Tuple2((Object)countryShard, result);
            }
            catch (Exception e) {
                throw AtlasMutatorHelper.exception(start, level, "Shard {}: Merging FeatureChanges.", e, countryShard.getName()).get();
            }
        };
    }

    protected static PairFlatMapFunction<Tuple2<CountryShard, Tuple2<Change, org.apache.spark.api.java.Optional<Map<CountryShard, PackedAtlas>>>>, CountryShard, Tuple<PackedAtlas, Change>> changeAndShardToAtlasMapToAtlas(AtlasMutationLevel level) {
        return (PairFlatMapFunction & Serializable)tuple -> {
            CountryShard countryShard = (CountryShard)tuple._1();
            Tuple2 changeAndShardToAtlasMap = (Tuple2)tuple._2();
            Change change = (Change)changeAndShardToAtlasMap._1();
            Map shardToAtlasMap = (Map)((org.apache.spark.api.java.Optional)changeAndShardToAtlasMap._2()).orElse(new HashMap());
            Serializable getThePolicyFunction = (BiFunction<AtlasMutationLevel, CountryShard, DynamicAtlasPolicy> & Serializable)(levelInternal, shardInternal) -> levelInternal.getRDDBasedApplicationPolicy((CountryShard)shardInternal, shardToAtlasMap);
            Tuple2 source = new Tuple2((Object)countryShard, (Object)change);
            return AtlasMutatorHelper.changeToAtlas(level, (BiFunction<AtlasMutationLevel, CountryShard, DynamicAtlasPolicy>)((Object)getThePolicyFunction)).call((Object)source);
        };
    }

    protected static PairFlatMapFunction<Tuple2<CountryShard, Change>, CountryShard, Tuple<PackedAtlas, Change>> changeToAtlas(AtlasMutationLevel level) {
        return (PairFlatMapFunction & Serializable)tuple -> AtlasMutatorHelper.changeToAtlas(level, AtlasMutationLevel::getApplicationPolicy).call(tuple);
    }

    protected static PairFlatMapFunction<Tuple2<CountryShard, Change>, CountryShard, Tuple<PackedAtlas, Change>> changeToAtlas(AtlasMutationLevel level, BiFunction<AtlasMutationLevel, CountryShard, DynamicAtlasPolicy> levelAndShardToPolicyFunction) {
        String message1 = "Shard {}: Applying Change to Atlas.";
        String message2 = "Shard {}: Applying Change to Atlas. Loaded {} shards for that which took {}. ChangeFilter operation took {}.";
        return (PairFlatMapFunction & Serializable)tuple -> {
            CountryShard countryShard = (CountryShard)tuple._1();
            if (!level.getDebugIncludeListedShards().isEmpty() && !level.getDebugIncludeListedShards().contains(countryShard.getShard().getName())) {
                if (logger.isWarnEnabled()) {
                    String message = "Shard {}: Applying Change to Atlas. It is not in debugShards. Skipping!";
                    logger.warn("Shard {}: Applying Change to Atlas. It is not in debugShards. Skipping!", (Object)countryShard.getName());
                }
                return Collections.emptyIterator();
            }
            Change change = (Change)tuple._2();
            String numberOfShards = "0";
            String dynamicAtlasDuration = Duration.ZERO.toString();
            String changeFilterDuration = Duration.ZERO.toString();
            Time start = AtlasMutatorHelper.startTime(level, "Shard {}: Applying Change to Atlas.", countryShard.getName());
            try {
                Optional<Change> stripped;
                String changeAtlasName = countryShard.getName();
                ArrayList<Tuple2> result = new ArrayList<Tuple2>();
                ChangeAtlas changeAtlas = null;
                DynamicAtlasPolicy policy = (DynamicAtlasPolicy)levelAndShardToPolicyFunction.apply(level, countryShard);
                if (((Optional)policy.getAtlasFetcher().apply(countryShard.getShard())).isPresent()) {
                    Time dynamicAtlasStart = Time.now();
                    DynamicAtlas dynamicAtlas = new DynamicAtlas(policy);
                    dynamicAtlas.preemptiveLoad();
                    dynamicAtlasDuration = dynamicAtlasStart.elapsedSince().toString();
                    numberOfShards = String.valueOf(dynamicAtlas.getNumberOfShardsLoaded());
                    Time changeFilterStart = Time.now();
                    stripped = new ChangeFilter(dynamicAtlas).apply(change);
                    changeFilterDuration = changeFilterStart.elapsedSince().toString();
                    if (stripped.isPresent()) {
                        changeAtlas = AtlasMutatorHelper.createChangeAtlas(Optional.of(dynamicAtlas), changeAtlasName, stripped.get());
                    }
                } else {
                    numberOfShards = "1";
                    Time changeFilterStart = Time.now();
                    stripped = new ChangeFilter(countryShard.getShard()).apply(change);
                    changeFilterDuration = changeFilterStart.elapsedSince().toString();
                    if (stripped.isPresent()) {
                        changeAtlas = AtlasMutatorHelper.attemptNewChangeAtlas(level, countryShard, changeAtlasName, stripped.get());
                    }
                }
                if (changeAtlas != null) {
                    Optional packedAtlasOption = changeAtlas.subAtlas((GeometricSurface)countryShard.bounds(), AtlasCutType.SOFT_CUT);
                    if (packedAtlasOption.isPresent()) {
                        result.add(new Tuple2((Object)countryShard, (Object)new Tuple((Object)((PackedAtlas)packedAtlasOption.get()), (Object)stripped.flatMap(ChangeFilter::stripForSaving).orElse(null))));
                    } else {
                        logger.warn("{}: SubAtlas on ChangeAtlas for {} returned nothing.", (Object)level, (Object)countryShard.getName());
                    }
                } else {
                    numberOfShards = "0";
                }
                AtlasMutatorHelper.logTime(start, level, "Shard {}: Applying Change to Atlas. Loaded {} shards for that which took {}. ChangeFilter operation took {}.", countryShard.getName(), numberOfShards, dynamicAtlasDuration, changeFilterDuration);
                return result.iterator();
            }
            catch (Exception e) {
                throw AtlasMutatorHelper.exception(start, level, "Shard {}: Applying Change to Atlas. Loaded {} shards for that which took {}. ChangeFilter operation took {}.", e, countryShard.getName(), numberOfShards, dynamicAtlasDuration, changeFilterDuration).get();
            }
        };
    }

    protected static <I> JavaPairRDD<String, I> embedCountryNameInKey(String logFileName, JavaPairRDD<CountryShard, I> atlasRDD) {
        return atlasRDD.mapToPair((PairFunction & Serializable)tuple -> new Tuple2((Object)PersistenceJsonParser.createJsonKey(((CountryShard)tuple._1()).getCountry() + logFileName, ((CountryShard)tuple._1()).getShard().getName(), Maps.hashMap((Object[])new String[0])), tuple._2()));
    }

    protected static PairFunction<Tuple2<CountryShard, List<FeatureChange>>, CountryShard, Change> featureChangeListToChange(AtlasMutationLevel level) {
        String message = "Shard {}: Translate FeatureChange objects to a Change.";
        return (PairFunction & Serializable)tuple -> {
            CountryShard shard = (CountryShard)tuple._1();
            Time start = AtlasMutatorHelper.startTime(level, "Shard {}: Translate FeatureChange objects to a Change.", shard.getName());
            try {
                ChangeBuilder builder = ChangeBuilder.newInstance();
                builder.addAll((Iterable)tuple._2());
                Change result = builder.get();
                AtlasMutatorHelper.logTime(start, level, "Shard {}: Translate FeatureChange objects to a Change.", shard.getName());
                return new Tuple2((Object)((CountryShard)tuple._1()), (Object)result);
            }
            catch (Exception e) {
                throw AtlasMutatorHelper.exception(start, level, "Shard {}: Translate FeatureChange objects to a Change.", e, shard.getName()).get();
            }
        };
    }

    protected static PairFlatMapFunction<Tuple2<CountryShard, PackedAtlas>, CountryShard, PackedAtlas> inputDependencyFilteredAtlas(AtlasMutationLevel level, InputDependency inputDependency) {
        String message = "Shard {}: Filter Mutated Atlas to provide input dependency {}";
        return (PairFlatMapFunction & Serializable)tuple -> {
            CountryShard countryShard = (CountryShard)tuple._1();
            String shardName = countryShard.getName();
            PackedAtlas atlas = (PackedAtlas)tuple._2();
            Time start = AtlasMutatorHelper.startTime(level.toString(), "Shard {}: Filter Mutated Atlas to provide input dependency {}", shardName, inputDependency.toString());
            try {
                ArrayList result = new ArrayList();
                ConfiguredSubAtlas subAtlasFunction = inputDependency.getSubAtlas();
                subAtlasFunction.apply((Atlas)atlas).ifPresent(subAtlas -> result.add(new Tuple2((Object)countryShard, (Object)((PackedAtlas)subAtlas))));
                AtlasMutatorHelper.logTime(start, level.toString(), "Shard {}: Filter Mutated Atlas to provide input dependency {}", shardName, inputDependency.toString());
                return result.iterator();
            }
            catch (Exception e) {
                throw AtlasMutatorHelper.exception(start, level.toString(), "Shard {}: Filter Mutated Atlas to provide input dependency {}", e, shardName, inputDependency.toString()).get();
            }
        };
    }

    protected static PairFlatMapFunction<Tuple2<CountryShard, List<FeatureChange>>, CountryShard, List<FeatureChange>> shardFeatureChangesToAssignedShardFeatureChanges(AtlasMutationLevel level) {
        String message = "Shard {}: Assigning FeatureChanges to application shards.";
        return (PairFlatMapFunction & Serializable)tuple -> {
            String shardName = ((CountryShard)tuple._1()).getName();
            String country = ((CountryShard)tuple._1()).getCountry();
            List featureChanges = (List)tuple._2();
            MultiMap shardToApplied = new MultiMap();
            Time start = AtlasMutatorHelper.startTime(level, "Shard {}: Assigning FeatureChanges to application shards.", shardName);
            try {
                for (FeatureChange featureChange : featureChanges) {
                    Iterable candidateShards = level.getAtlasMutatorConfiguration().getSharding().shards((GeometricSurface)featureChange.bounds());
                    candidateShards.forEach(shard -> shardToApplied.add((Object)new CountryShard(country, shard), (Object)featureChange));
                }
                ArrayList result = new ArrayList();
                shardToApplied.forEach((shard, featureChangeList) -> result.add(new Tuple2(shard, featureChangeList)));
                AtlasMutatorHelper.logTime(start, level, "Shard {}: Assigning FeatureChanges to application shards.", shardName);
                return result.iterator();
            }
            catch (Exception e) {
                throw AtlasMutatorHelper.exception(start, level, "Shard {}: Assigning FeatureChanges to application shards.", e, shardName).get();
            }
        };
    }

    protected static PairFlatMapFunction<CountryShard, CountryShard, PackedAtlas> shardToAtlas(AtlasMutationLevel level) {
        String message1 = "Shard {}: Load Atlas to initial RDD.";
        String message2 = "Shard {}: Load Atlas to initial RDD. Downloaded {} shards for that.";
        return (PairFlatMapFunction & Serializable)countryShard -> {
            Time start = AtlasMutatorHelper.startTime(level, "Shard {}: Load Atlas to initial RDD.", countryShard.getName());
            ArrayList result = new ArrayList();
            try {
                Optional<Atlas> atlasOption = level.getSourceFetcher().apply((CountryShard)countryShard);
                atlasOption.ifPresent(atlas -> {
                    if (!(atlas instanceof PackedAtlas)) {
                        throw new CoreException("Expected fetcher to return a {} for {}", new Object[]{PackedAtlas.class.getSimpleName(), countryShard.getName()});
                    }
                    result.add(new Tuple2(countryShard, (Object)((PackedAtlas)atlas)));
                });
                AtlasMutatorHelper.logTime(start, level, "Shard {}: Load Atlas to initial RDD. Downloaded {} shards for that.", countryShard.getName(), String.valueOf(result.size()));
                return result.iterator();
            }
            catch (Exception e) {
                throw AtlasMutatorHelper.exception(start, level, "Shard {}: Load Atlas to initial RDD. Downloaded {} shards for that.", e, countryShard.getName(), String.valueOf(result.size())).get();
            }
        };
    }

    protected static PairFlatMapFunction<Tuple2<CountryShard, Map<CountryShard, PackedAtlas>>, CountryShard, List<FeatureChange>> shardToAtlasMapToFeatureChanges(AtlasMutationLevel level) {
        return (PairFlatMapFunction & Serializable)tuple -> {
            CountryShard countryShard = (CountryShard)tuple._1();
            Map shardToAtlasMap = (Map)tuple._2();
            Serializable getThePolicyFunction = (BiFunction<AtlasMutationLevel, CountryShard, DynamicAtlasPolicy> & Serializable)(levelInternal, shardInternal) -> levelInternal.getRDDBasedGenerationPolicy((CountryShard)shardInternal, shardToAtlasMap);
            return AtlasMutatorHelper.shardToFeatureChanges(level, (BiFunction<AtlasMutationLevel, CountryShard, DynamicAtlasPolicy>)((Object)getThePolicyFunction)).call((Object)countryShard);
        };
    }

    protected static PairFlatMapFunction<CountryShard, CountryShard, List<FeatureChange>> shardToFeatureChanges(AtlasMutationLevel level) {
        return (PairFlatMapFunction & Serializable)countryShard -> AtlasMutatorHelper.shardToFeatureChanges(level, AtlasMutationLevel::getGenerationPolicy).call(countryShard);
    }

    protected static PairFlatMapFunction<CountryShard, CountryShard, List<FeatureChange>> shardToFeatureChanges(AtlasMutationLevel level, BiFunction<AtlasMutationLevel, CountryShard, DynamicAtlasPolicy> levelAndShardToPolicyFunction) {
        String message1 = "Shard {}: Generate FeatureChange objects.";
        String message2 = "Shard {}: Generate FeatureChange objects. Loaded {} shards for that which took {}.";
        return (PairFlatMapFunction & Serializable)countryShard -> {
            Time start = AtlasMutatorHelper.startTime(level, "Shard {}: Generate FeatureChange objects.", countryShard.getName());
            String numberOfShards = "0";
            String dynamicAtlasDuration = Duration.ZERO.toString();
            final String country = countryShard.getCountry();
            try {
                List<Object> result = new ArrayList();
                DynamicAtlasPolicy policy = (DynamicAtlasPolicy)levelAndShardToPolicyFunction.apply(level, (CountryShard)countryShard);
                if (((Optional)policy.getAtlasFetcher().apply(countryShard.getShard())).isPresent()) {
                    Time dynamicAtlasStart = Time.now();
                    DynamicAtlas source = new DynamicAtlas(policy){
                        private static final long serialVersionUID = -1379576156041355921L;

                        public AtlasMetaData metaData() {
                            AtlasMetaData metaData = super.metaData();
                            return new AtlasMetaData(metaData.getSize(), false, (String)metaData.getCodeVersion().orElse(null), (String)metaData.getDataVersion().orElse(null), country, (String)metaData.getShardName().orElse(null), metaData.getTags());
                        }
                    };
                    source.preemptiveLoad();
                    dynamicAtlasDuration = dynamicAtlasStart.elapsedSince().toString();
                    numberOfShards = String.valueOf(source.getNumberOfShardsLoaded());
                    result = AtlasMutatorHelper.executeMutations(level, (Atlas)source, countryShard);
                } else {
                    logger.warn("{}: Shard {}: No shard could be loaded when generating FeatureChanges. Skipping!", (Object)level, (Object)countryShard.getName());
                }
                AtlasMutatorHelper.logTime(start, level, "Shard {}: Generate FeatureChange objects. Loaded {} shards for that which took {}.", countryShard.getName(), numberOfShards, dynamicAtlasDuration);
                if (result.isEmpty()) {
                    return new ArrayList().iterator();
                }
                return Lists.newArrayList((Object[])new Tuple2[]{new Tuple2(countryShard, result)}).iterator();
            }
            catch (Exception e) {
                throw AtlasMutatorHelper.exception(start, level, "Shard {}: Generate FeatureChange objects. Loaded {} shards for that which took {}.", e, countryShard.getName(), numberOfShards, dynamicAtlasDuration).get();
            }
        };
    }

    protected static PairFlatMapFunction<Tuple2<CountryShard, Map<CountryShard, PackedAtlas>>, CountryShard, PackedAtlas> untouchedShardAndMapToPotentialSourcePackedAtlas(AtlasMutationLevel level) {
        return (PairFlatMapFunction & Serializable)tuple -> {
            CountryShard untouchedShard = (CountryShard)tuple._1();
            Map shardToAtlasMap = (Map)tuple._2();
            if (!level.canSourceAtlasObjectsFromRDD()) {
                throw new CoreException("{} should not pull untouched shards from RDD", new Object[]{level});
            }
            Function<CountryShard, Optional<Atlas>> fetcher = shard -> Optional.ofNullable((Atlas)shardToAtlasMap.get(shard));
            return AtlasMutatorHelper.untouchedShardToPotentialSourcePackedAtlas(level, fetcher).call((Object)untouchedShard);
        };
    }

    protected static PairFlatMapFunction<CountryShard, CountryShard, PackedAtlas> untouchedShardToPotentialSourcePackedAtlas(AtlasMutationLevel level) {
        return (PairFlatMapFunction & Serializable)shard -> AtlasMutatorHelper.untouchedShardToPotentialSourcePackedAtlas(level, level.getSourceFetcher()).call(shard);
    }

    protected static PairFlatMapFunction<CountryShard, CountryShard, PackedAtlas> untouchedShardToPotentialSourcePackedAtlas(AtlasMutationLevel level, Function<CountryShard, Optional<Atlas>> fetcher) {
        String message = "Shard {}: Get source PackedAtlas for untouched shards.";
        return (PairFlatMapFunction & Serializable)countryShard -> {
            Time start = AtlasMutatorHelper.startTime(level, "Shard {}: Get source PackedAtlas for untouched shards.", countryShard.getName());
            try {
                Optional untouchedSourceOption = (Optional)fetcher.apply((CountryShard)countryShard);
                ArrayList result = new ArrayList();
                untouchedSourceOption.ifPresent(atlas -> result.add(new Tuple2(countryShard, (Object)((PackedAtlas)atlas))));
                AtlasMutatorHelper.logTime(start, level, "Shard {}: Get source PackedAtlas for untouched shards.", countryShard.getName());
                return result.iterator();
            }
            catch (Exception e) {
                throw AtlasMutatorHelper.exception(start, level, "Shard {}: Get source PackedAtlas for untouched shards.", e, countryShard.getName()).get();
            }
        };
    }

    private static ChangeAtlas attemptNewChangeAtlas(AtlasMutationLevel level, CountryShard shard, String changeAtlasName, Change change) {
        Optional<Change> stripped = AtlasMutatorHelper.stripShallowFeatureChanges(change);
        if (stripped.isPresent() && stripped.get().changes().anyMatch(featureChange -> featureChange.getChangeType() == ChangeType.ADD)) {
            logger.warn("{}: Creating new shard {} that did not exist before! Using {} non-shallow feature changes for that.", new Object[]{level, shard.getName(), stripped.get().getFeatureChanges().size()});
            return AtlasMutatorHelper.createChangeAtlas(Optional.empty(), changeAtlasName, stripped.get());
        }
        return null;
    }

    private static Optional<Change> createChange(Iterable<FeatureChange> featureChanges) {
        ChangeBuilder result = new ChangeBuilder();
        featureChanges.forEach(arg_0 -> ((ChangeBuilder)result).add(arg_0));
        if (result.peekNumberOfChanges() > 0) {
            return Optional.of(result.get());
        }
        return Optional.empty();
    }

    private static ChangeAtlas createChangeAtlas(Optional<Atlas> source, String name, Change change) {
        Predicate<FeatureChange> entitiesToMoveMutatorTagsToAtlasMetaData = featureChange -> ItemType.RELATION == featureChange.getItemType() && source.isPresent() && ((Atlas)source.get()).relation(featureChange.getIdentifier()) != null && !((Atlas)source.get()).relation(featureChange.getIdentifier()).getTags().keySet().stream().anyMatch(key -> key.startsWith("mutator:"));
        Map<String, String> newMetaDataTags = ChangeFilter.mutatorMetaDataFromTags(change, entitiesToMoveMutatorTagsToAtlasMetaData);
        final UnaryOperator metaDataEnhancer = metaData -> {
            HashMap newMetaDataTagsInternal = new HashMap(newMetaDataTags);
            newMetaDataTagsInternal.putAll(metaData.getTags());
            return new AtlasMetaData(metaData.getSize(), false, (String)metaData.getCodeVersion().orElse(null), (String)metaData.getDataVersion().orElse(null), (String)metaData.getCountry().orElse(null), (String)metaData.getShardName().orElse(null), newMetaDataTagsInternal);
        };
        Change changeWithoutMetaDataTags = ChangeFilter.changeWithoutMutatorTag(change, entitiesToMoveMutatorTagsToAtlasMetaData);
        if (source.isPresent()) {
            return new ChangeAtlas(source.get(), name, new Change[]{changeWithoutMetaDataTags}){
                private static final long serialVersionUID = 2368717812777432282L;

                public synchronized AtlasMetaData metaData() {
                    return (AtlasMetaData)metaDataEnhancer.apply(super.metaData());
                }
            };
        }
        return new ChangeAtlas(name, new Change[]{changeWithoutMetaDataTags}){
            private static final long serialVersionUID = 2368717812777432282L;

            public synchronized AtlasMetaData metaData() {
                return (AtlasMetaData)metaDataEnhancer.apply(super.metaData());
            }
        };
    }

    private static Supplier<CoreException> exception(Time start, AtlasMutationLevel level, String message, Exception sourceException, String ... elements) {
        return AtlasMutatorHelper.exception(start, level.toString(), message, sourceException, elements);
    }

    private static Supplier<CoreException> exception(Time start, String level, String message, Exception sourceException, String ... elements) {
        Object[] objects = AtlasMutatorHelper.logObjectsEnd(start, level, elements);
        return () -> new CoreException(MessageFormatter.arrayFormat((String)("{}: Failure after {}: " + message), (Object[])objects).getMessage(), (Throwable)sourceException);
    }

    private static List<FeatureChange> executeMutation(AtlasMutationLevel level, ConfiguredAtlasChangeGenerator mutator, Atlas source, CountryShard countryShard) {
        ArrayList<FeatureChange> result = new ArrayList<FeatureChange>();
        Set<String> debugIncludeListedMutators = level.getDebugIncludeListedMutators();
        if (!debugIncludeListedMutators.isEmpty() && !level.getDebugIncludeListedMutators().contains(mutator.getName())) {
            logger.warn("{}: Shard {}: Skipping Mutation {}", new Object[]{level, countryShard.getName(), mutator.getName()});
            return result;
        }
        Time start = Time.now();
        try {
            String mutatorName = mutator.getName();
            logger.info("{}: Shard {}: Starting Mutation {}", new Object[]{level, countryShard.getName(), mutatorName});
            level.getBroadcastVariables().forEach(mutator::addBroadcastVariable);
            Set mutations = (Set)mutator.apply(source);
            mutations.stream().filter(featureChange -> countryShard.bounds().overlaps((PolyLine)featureChange.bounds())).map(featureChange -> AtlasMutatorHelper.withMetaData(featureChange, mutatorName, (Shard)countryShard)).map(featureChange -> AtlasMutatorHelper.withTags(level, source, featureChange, mutatorName, countryShard.getCountry())).map(featureChange -> AtlasMutatorHelper.withGeometry(source, featureChange)).forEach(result::add);
            logger.info("{}: Shard {}: Finished Mutation {} in {}", new Object[]{level, countryShard.getName(), mutator.getName(), start.elapsedSince()});
            return result;
        }
        catch (Exception e) {
            throw new CoreException(ERROR_IN_MUTATION, new Object[]{level, countryShard.getName(), mutator.getName(), start.elapsedSince(), e});
        }
    }

    private static List<FeatureChange> executeMutations(AtlasMutationLevel level, Atlas source, CountryShard shard) {
        ArrayList<FeatureChange> result = new ArrayList<FeatureChange>();
        ArrayList<Result> poolResults = new ArrayList<Result>();
        try (Pool mutationsPool = new Pool(5, level.toString() + "_executeMutation");){
            for (ConfiguredAtlasChangeGenerator mutation : level.getMutators()) {
                poolResults.add(mutationsPool.queue(() -> AtlasMutatorHelper.executeMutation(level, mutation, source, shard)));
            }
            for (Result poolResult : poolResults) {
                result.addAll((Collection)poolResult.get());
            }
        }
        return result;
    }

    private static FeatureChangeKey featureChangeKey(FeatureChange featureChange) {
        return new FeatureChangeKey(featureChange.getIdentifier(), featureChange.getItemType());
    }

    private static Object[] logObjectsEnd(Time start, String level, String[] elements) {
        Object[] objects = new Object[elements.length + 2];
        objects[0] = level;
        objects[1] = start.elapsedSince();
        for (int index = 2; index < objects.length; ++index) {
            objects[index] = elements[index - 2];
        }
        return objects;
    }

    private static Object[] logObjectsStart(String level, String[] elements) {
        Object[] objects = new Object[elements.length + 1];
        objects[0] = level;
        for (int index = 1; index < objects.length; ++index) {
            objects[index] = elements[index - 1];
        }
        return objects;
    }

    private static void logTime(Time start, AtlasMutationLevel level, String message, String ... elements) {
        AtlasMutatorHelper.logTime(start, level.toString(), message, elements);
    }

    private static void logTime(Time start, String level, String message, String ... elements) {
        Object[] objects = AtlasMutatorHelper.logObjectsEnd(start, level, elements);
        logger.info(MessageFormatter.arrayFormat((String)("{}: Processed in {}: " + message), (Object[])objects).getMessage());
    }

    private static FeatureChange merge(AtlasMutationLevel level, FeatureChange first, FeatureChange second) {
        ConfiguredMergeForgivenessPolicy policy = level.getAtlasMutatorConfiguration().getGlobalMergeForgivenessPolicy();
        try {
            return first.merge(second);
        }
        catch (FeatureChangeMergeException exception) {
            Optional<FeatureChange> featureChangeFromPolicy = policy.applyPolicy(exception, first, second);
            if (!featureChangeFromPolicy.isPresent()) {
                throw new CoreException("Conflict merging level {}, failed to apply forgiveness policy:\n{}\nFeatureChanges:\n{}\nvs\n{}", new Object[]{level, policy, first.prettify(), second.prettify(), exception});
            }
            logger.warn("Conflict merging level {}, successfully applied forgiveness policy:\n{}\nFeatureChanges:\n{}\nvs\n{}\nChose:\n{}", new Object[]{level, policy, first.prettify(), second.prettify(), featureChangeFromPolicy.get().prettify(), exception});
            return featureChangeFromPolicy.get();
        }
    }

    private static Time startTime(AtlasMutationLevel level, String message, String ... elements) {
        return AtlasMutatorHelper.startTime(level.toString(), message, elements);
    }

    private static Time startTime(String level, String message, String ... elements) {
        Object[] objects = AtlasMutatorHelper.logObjectsStart(level, elements);
        logger.info(MessageFormatter.arrayFormat((String)("{}: Starting: " + message), (Object[])objects).getMessage());
        return Time.now();
    }

    private static Optional<Change> stripShallowFeatureChanges(Change change) {
        return AtlasMutatorHelper.stripShallowFeatureChanges(change, FeatureChange::afterViewIsFull);
    }

    private static Optional<Change> stripShallowFeatureChanges(Change change, Predicate<FeatureChange> filter) {
        return AtlasMutatorHelper.createChange(change.changes().filter(filter).collect(Collectors.toList()));
    }

    private static FeatureChange withGeometry(Atlas source, FeatureChange origin) {
        if (origin.getItemType() == ItemType.RELATION) {
            return origin;
        }
        AtlasEntity sourceEntity = source.entity(origin.getIdentifier(), origin.getItemType());
        if (sourceEntity == null) {
            return origin;
        }
        if (sourceEntity instanceof Area && ((CompleteArea)origin.getAfterView()).asPolygon() == null) {
            ((CompleteArea)origin.getBeforeView()).withPolygon(((Area)sourceEntity).asPolygon());
        }
        if (sourceEntity instanceof LineItem && ((CompleteLineItem)origin.getAfterView()).asPolyLine() == null) {
            ((CompleteLineItem)origin.getBeforeView()).withPolyLine(((LineItem)sourceEntity).asPolyLine());
        }
        if (sourceEntity instanceof LocationItem && ((CompleteLocationItem)origin.getAfterView()).getLocation() == null) {
            ((CompleteLocationItem)origin.getBeforeView()).withLocation(((LocationItem)sourceEntity).getLocation());
        }
        return origin;
    }

    private static FeatureChange withMetaData(FeatureChange original, String mutatorName, Shard shard) {
        original.addMetaData("mutator", mutatorName + ":" + shard.getName());
        return original;
    }

    private static FeatureChange withTags(AtlasMutationLevel level, Atlas source, FeatureChange origin, String mutatorName, String country) {
        if (origin.getChangeType() == ChangeType.REMOVE || !level.isAddMutationTags()) {
            return origin;
        }
        Map<Object, String> tags = origin.getAfterView().getTags();
        if (tags == null) {
            tags = origin.getBeforeView().getTags();
        }
        if (tags == null) {
            tags = source.entity(origin.getIdentifier(), origin.getItemType()).getTags();
        }
        tags = new HashMap(tags);
        if (origin.getBeforeView() == null) {
            tags.put("iso_country_code", country);
        }
        tags.put("mutator:" + mutatorName, String.valueOf(level.getLevelIndex()));
        AtlasEntity newAfterView = (AtlasEntity)((CompleteEntity)origin.getAfterView()).withTags(tags);
        FeatureChange featureChangeWithTags = FeatureChange.add((AtlasEntity)newAfterView, (Atlas)source);
        origin.getMetaData().forEach((arg_0, arg_1) -> ((FeatureChange)featureChangeWithTags).addMetaData(arg_0, arg_1));
        return featureChangeWithTags;
    }

    private AtlasMutatorHelper() {
    }

    public static final class FeatureChangeKey
    implements Serializable {
        private static final long serialVersionUID = -9078313497297437479L;
        private final long identifier;
        private final ItemType itemType;

        public FeatureChangeKey(long identifier, ItemType itemType) {
            this.identifier = identifier;
            this.itemType = itemType;
        }

        public boolean equals(Object other) {
            if (other instanceof FeatureChangeKey) {
                return ((FeatureChangeKey)other).getIdentifier() == this.getIdentifier() && ((FeatureChangeKey)other).getItemType() == this.getItemType();
            }
            return false;
        }

        public long getIdentifier() {
            return this.identifier;
        }

        public ItemType getItemType() {
            return this.itemType;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.identifier, this.itemType});
        }
    }
}

