/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.mutator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.api.java.function.PairFunction;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlas;
import org.openstreetmap.atlas.geography.sharding.CountryShard;
import org.openstreetmap.atlas.mutator.configuration.AtlasMutationLevel;
import org.openstreetmap.atlas.mutator.configuration.InputDependency;
import org.openstreetmap.atlas.utilities.time.Time;
import org.openstreetmap.atlas.utilities.tuples.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public final class AtlasMutatorDriver {
    private static final Logger logger = LoggerFactory.getLogger(AtlasMutatorDriver.class);

    protected static JavaPairRDD<CountryShard, Map<CountryShard, PackedAtlas>> getAtlasGroupsRDD(String name, int size, JavaPairRDD<CountryShard, PackedAtlas> atlasRDD, java.util.function.Function<CountryShard, Set<CountryShard>> shardExplorer, Optional<InputDependency> inputDependencyOption) {
        JavaRDD shardsRDD = atlasRDD.keys().coalesce(size);
        shardsRDD.setName(name + ": shardsRDD");
        JavaPairRDD requestedAtlasShardToKeyShardRDD = shardsRDD.flatMapToPair((PairFlatMapFunction & Serializable)countryShard -> {
            List result = ((Set)shardExplorer.apply((CountryShard)countryShard)).stream().map(shardExplored -> new Tuple2(shardExplored, countryShard)).collect(Collectors.toList());
            if (logger.isInfoEnabled()) {
                logger.info("{}: Exploring shards for preemptive expansion for {}. Found {}", new Object[]{name, countryShard.getName(), result.stream().map(tuple -> ((CountryShard)tuple._2()).getName()).collect(Collectors.toList())});
            }
            return result.iterator();
        });
        requestedAtlasShardToKeyShardRDD.setName(name + ": requestedAtlasShardToKeyShardRDD");
        JavaPairRDD requestedAtlasShardToKeyShardAtlasRDD = requestedAtlasShardToKeyShardRDD.join(atlasRDD).filter((Function & Serializable)tuple -> ((Tuple2)tuple._2())._2() != null);
        requestedAtlasShardToKeyShardAtlasRDD.setName(name + ": requestedAtlasShardToKeyShardAtlasRDD");
        JavaPairRDD keyShardToRequestedAtlasRDD = requestedAtlasShardToKeyShardAtlasRDD.mapToPair((PairFunction & Serializable)tuple2 -> new Tuple2((Object)((CountryShard)((Tuple2)tuple2._2())._1()), (Object)new Tuple((Object)((CountryShard)tuple2._1()), (Object)((PackedAtlas)((Tuple2)tuple2._2())._2()))));
        keyShardToRequestedAtlasRDD.setName(name + ": keyShardToRequestedAtlasRDD");
        InputDependency inputDependency = inputDependencyOption.orElse(null);
        JavaPairRDD atlasGroupsRDD = keyShardToRequestedAtlasRDD.groupByKey().coalesce(size).mapToPair((PairFunction & Serializable)tuple -> new Tuple2((Object)((CountryShard)tuple._1()), AtlasMutatorDriver.iterableToMap(name, (Iterable)tuple._2(), (CountryShard)tuple._1(), inputDependency)));
        atlasGroupsRDD.setName(name + ": atlasGroupsRDD");
        return atlasGroupsRDD;
    }

    protected static JavaPairRDD<CountryShard, Map<CountryShard, PackedAtlas>> getAtlasGroupsRDDSimple(String name, JavaPairRDD<CountryShard, PackedAtlas> atlasRDD) {
        JavaPairRDD atlasGroupsRDDSimple = atlasRDD.mapToPair((PairFunction & Serializable)tuple -> {
            CountryShard countryShard = (CountryShard)tuple._1();
            HashMap<CountryShard, PackedAtlas> result = new HashMap<CountryShard, PackedAtlas>();
            result.put(countryShard, (PackedAtlas)tuple._2());
            return new Tuple2((Object)countryShard, result);
        });
        atlasGroupsRDDSimple.setName(name + ": atlasGroupsRDDSimple");
        return atlasGroupsRDDSimple;
    }

    protected static JavaPairRDD<CountryShard, PackedAtlas> getAtlasRDD(AtlasMutationLevel level, JavaRDD<CountryShard> shardsRDD) {
        return shardsRDD.flatMapToPair((PairFlatMapFunction & Serializable)countryShard -> {
            ArrayList result = new ArrayList();
            ((Optional)level.getGenerationPolicy((CountryShard)countryShard).getAtlasFetcher().apply(countryShard)).ifPresent(atlas -> result.add(new Tuple2(countryShard, (Object)((PackedAtlas)atlas))));
            return result.iterator();
        });
    }

    protected static Map<CountryShard, PackedAtlas> iterableToMap(String name, Iterable<Tuple<CountryShard, PackedAtlas>> iterable, CountryShard originShard, InputDependency inputDependency) {
        HashMap<CountryShard, PackedAtlas> result = new HashMap<CountryShard, PackedAtlas>();
        iterable.forEach(tuple -> {
            CountryShard expansionShard = (CountryShard)tuple.getFirst();
            PackedAtlas expansionAtlas = (PackedAtlas)tuple.getSecond();
            if (inputDependency != null && !originShard.getShard().equals(expansionShard.getShard())) {
                Time start = Time.now();
                expansionAtlas = inputDependency.getSubAtlas().apply((Atlas)expansionAtlas).orElse(null);
                if (logger.isInfoEnabled()) {
                    logger.info("{}: For {}, filtered down expansion shard {} using {} in {}", new Object[]{name, originShard.getName(), expansionShard.getName(), inputDependency.getPathName(), start.elapsedSince()});
                }
            }
            if (result.containsKey(expansionShard)) {
                throw new CoreException("For origin shard {} there was a conflict with expansion shard {} being supplied more than one Atlas.\nFirst Atlas is {}, Second Atlas is {}", new Object[]{originShard.getName(), expansionShard.getName(), result.get(expansionShard), expansionAtlas});
            }
            if (expansionAtlas != null) {
                result.put(expansionShard, expansionAtlas);
            }
        });
        return result;
    }

    private AtlasMutatorDriver() {
    }
}

