/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.generator.world;

import java.util.Map;
import org.apache.hadoop.fs.LocalFileSystem;
import org.openstreetmap.atlas.generator.tools.filesystem.FileSystemHelper;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.AtlasMetaData;
import org.openstreetmap.atlas.geography.atlas.pbf.AtlasLoadingOption;
import org.openstreetmap.atlas.geography.atlas.pbf.BridgeConfiguredFilter;
import org.openstreetmap.atlas.geography.atlas.raw.creation.RawAtlasGenerator;
import org.openstreetmap.atlas.geography.atlas.raw.sectioning.AtlasSectionProcessor;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.RawAtlasSlicer;
import org.openstreetmap.atlas.geography.atlas.statistics.AtlasStatistics;
import org.openstreetmap.atlas.geography.atlas.statistics.Counter;
import org.openstreetmap.atlas.geography.boundary.CountryBoundaryMap;
import org.openstreetmap.atlas.geography.sharding.SlippyTile;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.streaming.resource.StringResource;
import org.openstreetmap.atlas.streaming.resource.WritableResource;
import org.openstreetmap.atlas.tags.filters.ConfiguredTaggableFilter;
import org.openstreetmap.atlas.utilities.collections.Maps;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.configuration.StandardConfiguration;
import org.openstreetmap.atlas.utilities.conversion.StringConverter;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;
import org.openstreetmap.atlas.utilities.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorldAtlasGenerator
extends Command {
    public static final Command.Switch<CountryBoundaryMap> BOUNDARIES = new Command.Switch("boundaries", "The boundary map to use", value -> CountryBoundaryMap.fromPlainText((Resource)new File(value)), Command.Optionality.OPTIONAL);
    public static final Command.Switch<String> CODE_VERSION = new Command.Switch("codeVersion", "The code version", StringConverter.IDENTITY, Command.Optionality.OPTIONAL, "unknown");
    public static final Command.Switch<String> DATA_VERSION = new Command.Switch("dataVersion", "The data version", StringConverter.IDENTITY, Command.Optionality.OPTIONAL, "unknown");
    public static final Command.Switch<String> EDGE_CONFIGURATION = new Command.Switch("edgeConfiguration", "The path to the configuration file that defines what OSM Way becomes an Edge", StringConverter.IDENTITY, Command.Optionality.OPTIONAL);
    public static final Command.Switch<String> SHOULD_ALWAYS_SLICE_CONFIGURATION = new Command.Switch("shouldAlwaysSliceConfiguration", "The path to the configuration file that defines which entities on which country slicing will always be attempted regardless of the number of countries it intersects according to the country boundary map's grid index.", StringConverter.IDENTITY, Command.Optionality.OPTIONAL);
    public static final Command.Switch<File> PBF_WAY_CONFIGURATION = new Command.Switch("osmPbfWayConfiguration", "The path to the configuration file that defines which PBF Ways becomes an Atlas Entity.", File::new, Command.Optionality.OPTIONAL);
    public static final Command.Switch<File> PBF_NODE_CONFIGURATION = new Command.Switch("osmPbfNodeConfiguration", "The path to the configuration file that defines which PBF Nodes becomes an Atlas Entity.", File::new, Command.Optionality.OPTIONAL);
    public static final Command.Switch<File> PBF_RELATION_CONFIGURATION = new Command.Switch("osmPbfRelationConfiguration", "The path to the configuration file that defines which PBF Relations becomes an Atlas Entity", File::new, Command.Optionality.OPTIONAL);
    private static final Logger logger = LoggerFactory.getLogger(WorldAtlasGenerator.class);
    private static final Command.Switch<File> STATISTICS = new Command.Switch("statistics", "The file that will contain the statistics", File::new, Command.Optionality.OPTIONAL);
    private static final ConfiguredTaggableFilter PBF_NO_FILTER_CONFIGURATION = new ConfiguredTaggableFilter((Configuration)new StandardConfiguration((Resource)new StringResource("{\"filters\": []}")));
    private static Map<String, String> configuration = Maps.hashMap((Object[])new String[]{"fs.file.impl", LocalFileSystem.class.getName()});
    private static final Command.Switch<Resource> PBF = new Command.Switch("pbf", "The pbf file or folder containing the OSM pbfs", WorldAtlasGenerator::openResource, Command.Optionality.REQUIRED);
    private static final Command.Switch<WritableResource> ATLAS = new Command.Switch("atlas", "The atlas file to which the Atlas will be saved", WorldAtlasGenerator::openWritableResource, Command.Optionality.REQUIRED);

    public static void main(String[] args) {
        new WorldAtlasGenerator().run(args);
    }

    public static void setHadoopFileSystemConfiguration(Map<String, String> newConfiguration) {
        configuration = newConfiguration;
    }

    private static Resource openResource(String value) {
        return FileSystemHelper.resource(value, configuration);
    }

    private static WritableResource openWritableResource(String value) {
        return FileSystemHelper.writableResource(value, configuration);
    }

    protected int onRun(CommandMap command) {
        CountryBoundaryMap countryBoundaryMap = (CountryBoundaryMap)command.get(BOUNDARIES);
        if (countryBoundaryMap == null) {
            StringResource wholeWorld = new StringResource("AAA||" + Rectangle.MAXIMUM.toWkt());
            countryBoundaryMap = CountryBoundaryMap.fromPlainText((Resource)wholeWorld);
        }
        File edgeConfiguration = (File)command.get(EDGE_CONFIGURATION);
        File pbfWayConfiguration = (File)command.get(PBF_WAY_CONFIGURATION);
        File pbfNodeConfiguration = (File)command.get(PBF_NODE_CONFIGURATION);
        File pbfRelationConfiguration = (File)command.get(PBF_RELATION_CONFIGURATION);
        Resource pbf = (Resource)command.get(PBF);
        WritableResource output = (WritableResource)command.get(ATLAS);
        File statisticsOutput = (File)command.get(STATISTICS);
        String codeVersion = (String)command.get(CODE_VERSION);
        String dataVersion = (String)command.get(DATA_VERSION);
        SlippyTile world = SlippyTile.ROOT;
        Time start = Time.now();
        AtlasLoadingOption loadingOptions = AtlasLoadingOption.createOptionWithAllEnabled((CountryBoundaryMap)countryBoundaryMap);
        if (edgeConfiguration != null) {
            loadingOptions.setEdgeFilter(new BridgeConfiguredFilter("", "atlas-edge", (Configuration)new StandardConfiguration((Resource)edgeConfiguration)));
        }
        if (pbfWayConfiguration == null) {
            loadingOptions.setOsmPbfWayFilter(PBF_NO_FILTER_CONFIGURATION);
        } else {
            loadingOptions.setOsmPbfWayFilter(new ConfiguredTaggableFilter((Configuration)new StandardConfiguration((Resource)pbfWayConfiguration)));
        }
        if (pbfNodeConfiguration == null) {
            loadingOptions.setOsmPbfNodeFilter(PBF_NO_FILTER_CONFIGURATION);
        } else {
            loadingOptions.setOsmPbfNodeFilter(new ConfiguredTaggableFilter((Configuration)new StandardConfiguration((Resource)pbfNodeConfiguration)));
        }
        if (pbfRelationConfiguration == null) {
            loadingOptions.setOsmPbfRelationFilter(PBF_NO_FILTER_CONFIGURATION);
        } else {
            loadingOptions.setOsmPbfRelationFilter(new ConfiguredTaggableFilter((Configuration)new StandardConfiguration((Resource)pbfRelationConfiguration)));
        }
        AtlasMetaData metaData = new AtlasMetaData(null, true, codeVersion, dataVersion, "WORLD", world.getName(), Maps.hashMap((Object[])new String[0]));
        Counter counter = new Counter();
        counter.setCountsDefinition((Resource)Counter.POI_COUNTS_DEFINITION.getDefault());
        logger.info("Generating world atlas from {}", (Object)pbf);
        Atlas atlas = new RawAtlasGenerator(pbf, loadingOptions, MultiPolygon.MAXIMUM).withMetaData(metaData).build();
        if (loadingOptions.isCountrySlicing()) {
            atlas = new RawAtlasSlicer(loadingOptions, atlas).slice();
        }
        if (loadingOptions.isWaySectioning()) {
            atlas = new AtlasSectionProcessor(atlas, loadingOptions).run();
        }
        if (atlas == null) {
            logger.warn("There was no data to add to the Atlas.");
            return 0;
        }
        logger.info("Saving world atlas to {}", (Object)output);
        atlas.save(output);
        if (statisticsOutput != null) {
            logger.info("Generating world statistics...");
            AtlasStatistics statistics = counter.processAtlas(atlas);
            logger.info("Saving world statistics to {}", (Object)statisticsOutput);
            statistics.save((WritableResource)statisticsOutput);
        }
        logger.info("Finished creating world atlas in {}", (Object)start.elapsedSince());
        return 0;
    }

    protected Command.SwitchList switches() {
        return new Command.SwitchList().with(new Command.Switch[]{PBF, ATLAS, STATISTICS, BOUNDARIES, CODE_VERSION, DATA_VERSION, EDGE_CONFIGURATION, SHOULD_ALWAYS_SLICE_CONFIGURATION, PBF_WAY_CONFIGURATION, PBF_NODE_CONFIGURATION, PBF_RELATION_CONFIGURATION});
    }
}

