/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.generator.tools.spark.sharded;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.prep.PreparedPolygon;
import org.openstreetmap.atlas.generator.sharding.AtlasSharding;
import org.openstreetmap.atlas.generator.tools.spark.SparkJob;
import org.openstreetmap.atlas.geography.GeometricSurface;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.boundary.CountryBoundaryMap;
import org.openstreetmap.atlas.geography.boundary.CountryBoundaryMapArchiver;
import org.openstreetmap.atlas.geography.converters.jts.JtsPolygonConverter;
import org.openstreetmap.atlas.geography.sharding.Shard;
import org.openstreetmap.atlas.geography.sharding.Sharding;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.conversion.StringConverter;
import org.openstreetmap.atlas.utilities.maps.MultiMap;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public abstract class ShardedSparkJob
extends SparkJob {
    private static final long serialVersionUID = -5341594024010883883L;
    private static final Logger logger = LoggerFactory.getLogger(ShardedSparkJob.class);
    public static final Command.Switch<StringList> COUNTRIES = new Command.Switch("countries", "Comma separated list of countries to be included in the final Atlas", value -> StringList.split((String)value, (String)","), Command.Optionality.REQUIRED);
    public static final Command.Switch<String> SHARDING_TYPE = new Command.Switch("sharding", "The sharding definition.", StringConverter.IDENTITY, Command.Optionality.REQUIRED);
    public static final Command.Switch<String> COUNTRY_SHAPES = new Command.Switch("countryShapes", "Shape file containing the countries", StringConverter.IDENTITY, Command.Optionality.REQUIRED);

    private static PairFlatMapFunction<String, String, Shard> countryToShards(CountryBoundaryMap worldBoundaries, Sharding sharding) {
        return (PairFlatMapFunction & Serializable)countryName -> {
            List boundaries = worldBoundaries.getCountryNameToBoundaryMap().get(countryName);
            if (boundaries == null) {
                logger.error("No boundaries found for country {}!", countryName);
                return new ArrayList().iterator();
            }
            logger.info("Generating shards for country {}", countryName);
            HashSet shards = new HashSet();
            for (PreparedPolygon boundary : boundaries) {
                JtsPolygonConverter converter = new JtsPolygonConverter();
                shards.addAll(Iterables.asList((Iterable)Iterables.filter((Iterable)sharding.shards((GeometricSurface)converter.backwardConvert((org.locationtech.jts.geom.Polygon)boundary.getGeometry())), shard -> boundary.overlaps((Geometry)converter.convert((Polygon)shard.bounds())))));
            }
            ArrayList countryShards = new ArrayList();
            shards.forEach(shard -> countryShards.add(new Tuple2(countryName, shard)));
            return countryShards.iterator();
        };
    }

    @Override
    public void start(CommandMap command) {
        StringList countries = (StringList)command.get(COUNTRIES);
        String shardingType = (String)command.get(SHARDING_TYPE);
        Sharding sharding = AtlasSharding.forString(shardingType, this.configuration());
        String countryShapes = (String)command.get(COUNTRY_SHAPES);
        logger.info("Reading country boundaries from {}", (Object)countryShapes);
        CountryBoundaryMap worldBoundaries = new CountryBoundaryMapArchiver().read(this.resource(countryShapes));
        logger.info("Done Reading {} country boundaries from {}", (Object)worldBoundaries.size(), (Object)countryShapes);
        JavaRDD countriesRDD = this.getContext().parallelize(Iterables.asList((Iterable)countries), countries.size());
        JavaPairRDD preCountryShardsRDD = countriesRDD.flatMapToPair(ShardedSparkJob.countryToShards(worldBoundaries, sharding));
        List countryShards = preCountryShardsRDD.collect();
        MultiMap countryToShardMap = new MultiMap();
        countryShards.forEach(tuple -> countryToShardMap.add((Object)((String)tuple._1()), (Object)((Shard)tuple._2())));
        this.start2(command, sharding, (MultiMap<String, Shard>)countryToShardMap);
    }

    public abstract void start2(CommandMap var1, Sharding var2, MultiMap<String, Shard> var3);

    @Override
    public Command.SwitchList switches() {
        return super.switches().with(new Command.Switch[]{COUNTRIES, SHARDING_TYPE, COUNTRY_SHAPES});
    }
}

