/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.generator.tools.spark;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.generator.tools.filesystem.FileSystemCreator;
import org.openstreetmap.atlas.streaming.compression.Decompressor;
import org.openstreetmap.atlas.streaming.resource.FileSuffix;
import org.openstreetmap.atlas.streaming.resource.InputStreamResource;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DataLocator<T>
implements Serializable {
    private static final long serialVersionUID = 6569907149273805927L;
    private static final Logger logger = LoggerFactory.getLogger(DataLocator.class);
    private final Map<String, String> sparkContext;

    private static boolean fileExists(FileSystem fileSystem, Path value) {
        FileStatus fileStatus = null;
        try {
            fileStatus = fileSystem.getFileStatus(value);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException e) {
            throw new CoreException("Cannot test if {} exists.", new Object[]{value.toString(), e});
        }
        if (fileStatus == null || !fileStatus.isFile()) {
            logger.warn("Resource {} does not exist.", (Object)(logger.isWarnEnabled() ? value.toString() : ""));
            return false;
        }
        return true;
    }

    public DataLocator(Map<String, String> sparkContext) {
        this.sparkContext = sparkContext;
    }

    public Iterable<T> retrieve(Iterable<String> paths) {
        return Iterables.stream(paths).map(this::retrieve).filter(Optional::isPresent).map(Optional::get).collect();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<T> retrieve(String path) {
        Path value = new Path(path);
        try (FileSystem fileSystem = new FileSystemCreator().get(value.toUri().toString(), this.sparkContext);){
            if (!DataLocator.fileExists(fileSystem, value)) {
                Optional optional2 = Optional.empty();
                return optional2;
            }
            InputStreamResource resource = new InputStreamResource(() -> {
                try {
                    return fileSystem.open(value);
                }
                catch (Exception e) {
                    throw new CoreException("Cannot translate {} to a resource.", new Object[]{value, e});
                }
            }).withName(path);
            if (path.endsWith(FileSuffix.GZIP.toString())) {
                resource.setDecompressor(Decompressor.GZIP);
            }
            Optional<T> optional = this.readFrom((Resource)resource);
            return optional;
        }
        catch (IOException e) {
            logger.error("FileSystem not properly closed", (Throwable)e);
            return Optional.empty();
        }
    }

    protected abstract Optional<T> readFrom(Resource var1);

    public static final class ResourceLocator
    extends DataLocator<Resource> {
        private static final long serialVersionUID = 3528162777067011094L;

        public ResourceLocator(Map<String, String> sparkContext) {
            super(sparkContext);
        }

        @Override
        protected Optional<Resource> readFrom(Resource resource) {
            return Optional.ofNullable(resource);
        }
    }
}

