/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.generator.tools.filesystem;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.generator.tools.filesystem.FileSystemCreator;
import org.openstreetmap.atlas.generator.tools.streaming.resource.HDFSWalker;
import org.openstreetmap.atlas.streaming.compression.Compressor;
import org.openstreetmap.atlas.streaming.compression.Decompressor;
import org.openstreetmap.atlas.streaming.resource.FileSuffix;
import org.openstreetmap.atlas.streaming.resource.InputStreamResource;
import org.openstreetmap.atlas.streaming.resource.OutputStreamWritableResource;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.streaming.resource.WritableResource;
import org.openstreetmap.atlas.utilities.collections.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileSystemHelper {
    public static final String FILE_NOT_FOUND = "File not found";
    private static final Map<String, String> DEFAULT = Maps.hashMap((Object[])new String[]{"fs.file.impl", RawLocalFileSystem.class.getCanonicalName()});
    private static final Logger logger = LoggerFactory.getLogger(FileSystemHelper.class);
    private static final String UNABLE_TO_READ = "Unable to read {}";
    private static final String UNABLE_TO_OPEN = "Unable to open {}";
    private static final String FILESYSTEM_NOT_CLOSED = "FileSystem not properly closed";

    public static boolean delete(String path, boolean recursive, Map<String, String> configuration) {
        boolean bl;
        block8: {
            FileSystem fileSystem = new FileSystemCreator().get(path, configuration);
            try {
                bl = fileSystem.delete(new Path(path), recursive);
                if (fileSystem == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (fileSystem != null) {
                        try {
                            fileSystem.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new CoreException("Unable to delete {}", new Object[]{path, e});
                }
            }
            fileSystem.close();
        }
        return bl;
    }

    public static boolean exists(String path) {
        return FileSystemHelper.exists(path, DEFAULT);
    }

    public static boolean exists(String path, Map<String, String> configuration) {
        boolean bl;
        block8: {
            FileSystem fileSystem = new FileSystemCreator().get(path, configuration);
            try {
                bl = fileSystem.exists(new Path(path));
                if (fileSystem == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (fileSystem != null) {
                        try {
                            fileSystem.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    throw new CoreException("Failed to determine existence of {}", new Object[]{path, exception});
                }
            }
            fileSystem.close();
        }
        return bl;
    }

    public static boolean isDirectory(String path, Map<String, String> configuration) {
        boolean bl;
        block8: {
            FileSystem fileSystem = new FileSystemCreator().get(path, configuration);
            try {
                bl = fileSystem.isDirectory(new Path(path));
                if (fileSystem == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (fileSystem != null) {
                        try {
                            fileSystem.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    throw new CoreException("Failed to determine existence of directory {}", new Object[]{path, exception});
                }
            }
            fileSystem.close();
        }
        return bl;
    }

    public static boolean isFile(String path, Map<String, String> configuration) {
        boolean bl;
        block8: {
            FileSystem fileSystem = new FileSystemCreator().get(path, configuration);
            try {
                bl = fileSystem.isFile(new Path(path));
                if (fileSystem == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (fileSystem != null) {
                        try {
                            fileSystem.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    throw new CoreException("Failed to determine existence of file {}", new Object[]{path, exception});
                }
            }
            fileSystem.close();
        }
        return bl;
    }

    public static List<Resource> listResourcesRecursively(String directory, Map<String, String> configuration, PathFilter filter) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        try (FileSystem fileSystem = new FileSystemCreator().get(directory, configuration);){
            FileSystemHelper.streamPathsRecursively(directory, configuration, filter).map(path -> FileSystemHelper.getResource(fileSystem, path)).forEach(resources::add);
        }
        catch (IOException e) {
            logger.error(FILESYSTEM_NOT_CLOSED, (Throwable)e);
        }
        return resources;
    }

    public static boolean mkdir(String path, Map<String, String> configuration) {
        boolean bl;
        block8: {
            FileSystem fileSystem = new FileSystemCreator().get(path, configuration);
            try {
                bl = fileSystem.mkdirs(new Path(path));
                if (fileSystem == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (fileSystem != null) {
                        try {
                            fileSystem.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new CoreException("Unable to mkdir {}", new Object[]{path, e});
                }
            }
            fileSystem.close();
        }
        return bl;
    }

    public static boolean rename(String sourcePath, String destinationPath, Map<String, String> configuration) {
        boolean bl;
        block8: {
            FileSystem fileSystem = new FileSystemCreator().get(sourcePath, configuration);
            try {
                bl = fileSystem.rename(new Path(sourcePath), new Path(destinationPath));
                if (fileSystem == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (fileSystem != null) {
                        try {
                            fileSystem.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new CoreException("Unable to rename {} to {}", new Object[]{sourcePath, destinationPath, e});
                }
            }
            fileSystem.close();
        }
        return bl;
    }

    public static Resource resource(String path) {
        return FileSystemHelper.resource(path, DEFAULT);
    }

    public static Resource resource(String path, Map<String, String> configuration) {
        InputStreamResource inputStreamResource;
        block9: {
            Path hadoopPath = new Path(path);
            FileSystem fileSystem = new FileSystemCreator().get(path, configuration);
            try {
                InputStreamResource resource = new InputStreamResource(() -> {
                    try {
                        return fileSystem.open(hadoopPath);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        throw new CoreException("Unable to open {}. {}", new Object[]{hadoopPath, FILE_NOT_FOUND, fileNotFoundException});
                    }
                    catch (Exception e) {
                        throw new CoreException(UNABLE_TO_OPEN, new Object[]{hadoopPath, e});
                    }
                }).withName(hadoopPath.getName());
                if (hadoopPath.getName().endsWith(FileSuffix.GZIP.toString())) {
                    resource.setDecompressor(Decompressor.GZIP);
                }
                inputStreamResource = resource;
                if (fileSystem == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (fileSystem != null) {
                        try {
                            fileSystem.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new CoreException(UNABLE_TO_READ, new Object[]{hadoopPath, e});
                }
            }
            fileSystem.close();
        }
        return inputStreamResource;
    }

    public static List<Resource> resources(String directory, Map<String, String> configuration) {
        return FileSystemHelper.resources(directory, configuration, path -> !path.getName().endsWith("_SUCCESS"));
    }

    public static List<Resource> resources(String directory, Map<String, String> configuration, PathFilter filter) {
        block10: {
            List<Resource> list;
            block9: {
                FileSystem fileSystem = new FileSystemCreator().get(directory, configuration);
                try {
                    FileStatus[] fileStatusList = filter == null ? fileSystem.listStatus(new Path(directory)) : fileSystem.listStatus(new Path(directory), filter);
                    list = Stream.of(fileStatusList).map(FileStatus::getPath).map(path -> FileSystemHelper.getResource(fileSystem, path)).collect(Collectors.toList());
                    if (fileSystem == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (fileSystem != null) {
                            try {
                                fileSystem.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        logger.error(FILESYSTEM_NOT_CLOSED, (Throwable)e);
                        break block10;
                    }
                    catch (Exception e) {
                        throw new CoreException("Could not locate files on directory {}", new Object[]{directory, e});
                    }
                }
                fileSystem.close();
            }
            return list;
        }
        return Collections.emptyList();
    }

    public static Stream<Path> streamPathsRecursively(String directory, Map<String, String> configuration, PathFilter filter) {
        return FileSystemHelper.streamPathsRecursively(directory, configuration, filter, -1);
    }

    public static Stream<Path> streamPathsRecursively(String directory, Map<String, String> configuration, PathFilter filter, int maxDepth) {
        Stream<Path> stream;
        block8: {
            FileSystem fileSystem = new FileSystemCreator().get(directory, configuration);
            try {
                stream = new HDFSWalker(maxDepth).usingConfiguration(fileSystem.getConf()).walk(new Path(directory)).map(HDFSWalker.debug(path -> logger.trace("{}", path))).map(FileStatus::getPath).filter(path -> filter == null || filter.accept(path));
                if (fileSystem == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (fileSystem != null) {
                        try {
                            fileSystem.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    logger.error(FILESYSTEM_NOT_CLOSED, (Throwable)e);
                    return Stream.empty();
                }
            }
            fileSystem.close();
        }
        return stream;
    }

    public static WritableResource writableResource(String path) {
        return FileSystemHelper.writableResource(path, DEFAULT);
    }

    public static WritableResource writableResource(String path, Map<String, String> configuration) {
        OutputStreamWritableResource outputStreamWritableResource;
        block11: {
            Path hadoopPath = new Path(path);
            FileSystem fileSystem = new FileSystemCreator().get(path, configuration);
            try {
                FSDataOutputStream out;
                try {
                    out = fileSystem.create(hadoopPath);
                }
                catch (Exception e) {
                    throw new CoreException(UNABLE_TO_OPEN, new Object[]{hadoopPath, e});
                }
                OutputStreamWritableResource resource = new OutputStreamWritableResource((OutputStream)out);
                resource.setName(hadoopPath.getName());
                if (resource.isGzipped()) {
                    resource.setCompressor(Compressor.GZIP);
                }
                outputStreamWritableResource = resource;
                if (fileSystem == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (fileSystem != null) {
                        try {
                            fileSystem.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new CoreException(UNABLE_TO_READ, new Object[]{hadoopPath, e});
                }
            }
            fileSystem.close();
        }
        return outputStreamWritableResource;
    }

    private static InputStreamResource getResource(FileSystem fileSystem, Path path) {
        try {
            InputStreamResource resource = new InputStreamResource(() -> {
                try {
                    return fileSystem.open(path);
                }
                catch (Exception e) {
                    throw new CoreException(UNABLE_TO_OPEN, new Object[]{path, e});
                }
            }).withName(path.getName());
            if (path.getName().endsWith(FileSuffix.GZIP.toString())) {
                resource.setDecompressor(Decompressor.GZIP);
            }
            return resource;
        }
        catch (Exception e) {
            throw new CoreException(UNABLE_TO_READ, new Object[]{path, e});
        }
    }

    private FileSystemHelper() {
    }
}

