/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.generator.tools.caching;

import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.generator.AtlasGeneratorParameters;
import org.openstreetmap.atlas.generator.persistence.scheme.SlippyTilePersistenceScheme;
import org.openstreetmap.atlas.generator.tools.filesystem.FileSystemHelper;
import org.openstreetmap.atlas.generator.tools.spark.utilities.SparkFileHelper;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlas;
import org.openstreetmap.atlas.geography.sharding.Shard;
import org.openstreetmap.atlas.geography.sharding.SlippyTile;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.streaming.resource.FileSuffix;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.utilities.caching.ConcurrentResourceCache;
import org.openstreetmap.atlas.utilities.caching.strategies.CachingStrategy;
import org.openstreetmap.atlas.utilities.caching.strategies.NamespaceCachingStrategy;
import org.openstreetmap.atlas.utilities.runtime.Retry;
import org.openstreetmap.atlas.utilities.scalars.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopAtlasFileCache
extends ConcurrentResourceCache {
    private static final Logger logger = LoggerFactory.getLogger(HadoopAtlasFileCache.class);
    private static final String GLOBAL_HADOOP_FILE_CACHE_NAMESPACE = "__HadoopAtlasFileCache_global_namespace__";
    private static final int RETRY_ATTEMPTS = 5;
    private final String parentAtlasPath;
    private final SlippyTilePersistenceScheme atlasScheme;

    public HadoopAtlasFileCache(String parentAtlasPath, Map<String, String> configuration) {
        this(parentAtlasPath, GLOBAL_HADOOP_FILE_CACHE_NAMESPACE, (SlippyTilePersistenceScheme)AtlasGeneratorParameters.ATLAS_SCHEME.getDefault(), configuration);
    }

    public HadoopAtlasFileCache(String parentAtlasPath, Function<URI, Optional<Resource>> fetcher) {
        this(parentAtlasPath, GLOBAL_HADOOP_FILE_CACHE_NAMESPACE, (SlippyTilePersistenceScheme)AtlasGeneratorParameters.ATLAS_SCHEME.getDefault(), fetcher);
    }

    public HadoopAtlasFileCache(String parentAtlasPath, CachingStrategy cachingStrategy, Function<URI, Optional<Resource>> fetcher) {
        this(parentAtlasPath, (SlippyTilePersistenceScheme)AtlasGeneratorParameters.ATLAS_SCHEME.getDefault(), cachingStrategy, fetcher);
    }

    public HadoopAtlasFileCache(String parentAtlasPath, SlippyTilePersistenceScheme atlasScheme, Map<String, String> configuration) {
        this(parentAtlasPath, GLOBAL_HADOOP_FILE_CACHE_NAMESPACE, atlasScheme, configuration);
    }

    public HadoopAtlasFileCache(String parentAtlasPath, String namespace, Map<String, String> configuration) {
        this(parentAtlasPath, namespace, (SlippyTilePersistenceScheme)AtlasGeneratorParameters.ATLAS_SCHEME.getDefault(), configuration);
    }

    public HadoopAtlasFileCache(String parentAtlasPath, String namespace, SlippyTilePersistenceScheme atlasScheme, Map<String, String> configuration) {
        this(parentAtlasPath, atlasScheme, (CachingStrategy)new NamespaceCachingStrategy(namespace){

            protected void validateLocalFile(File localFile) {
                PackedAtlas.load((Resource)localFile);
            }
        }, (URI uri) -> {
            Retry retry = new Retry(5, Duration.ONE_SECOND).withQuadratic(true);
            boolean exists = (Boolean)retry.run(() -> {
                Boolean bl;
                block9: {
                    InputStream ignored = FileSystemHelper.resource(uri.toString(), configuration).read();
                    try {
                        bl = true;
                        if (ignored == null) break block9;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (ignored != null) {
                                try {
                                    ignored.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception exception) {
                            if (exception.getMessage().contains("File not found")) {
                                return false;
                            }
                            throw new CoreException("Unable to test existence of {}", new Object[]{uri, exception});
                        }
                    }
                    ignored.close();
                }
                return bl;
            });
            if (!exists) {
                logger.warn("Fetcher: resource {} does not exist!", uri);
                return Optional.empty();
            }
            return Optional.ofNullable(FileSystemHelper.resource(uri.toString(), configuration));
        });
    }

    public HadoopAtlasFileCache(String parentAtlasPath, String namespace, SlippyTilePersistenceScheme atlasScheme, Function<URI, Optional<Resource>> fetcher) {
        this(parentAtlasPath, atlasScheme, (CachingStrategy)new NamespaceCachingStrategy(namespace){

            protected void validateLocalFile(File localFile) {
                PackedAtlas.load((Resource)localFile);
            }
        }, fetcher);
    }

    public HadoopAtlasFileCache(String parentAtlasPath, SlippyTilePersistenceScheme atlasScheme, CachingStrategy cachingStrategy, Function<URI, Optional<Resource>> fetcher) {
        super(cachingStrategy, fetcher);
        this.parentAtlasPath = parentAtlasPath;
        this.atlasScheme = atlasScheme;
    }

    public Optional<Resource> get(String country, Shard shard) {
        return this.get(this.getURIFromCountryAndShard(country, shard));
    }

    public void invalidate(String country, Shard shard) {
        this.invalidate(this.getURIFromCountryAndShard(country, shard));
    }

    private URI getURIFromCountryAndShard(String country, Shard shard) {
        URI atlasURI;
        String compiledAtlasScheme = "";
        if (shard instanceof SlippyTile) {
            compiledAtlasScheme = this.atlasScheme.compile((SlippyTile)shard);
        }
        String atlasName = String.format("%s_%s", country, shard.getName());
        String atlasURIString = SparkFileHelper.combine(this.parentAtlasPath, country, compiledAtlasScheme, atlasName + FileSuffix.ATLAS.toString());
        try {
            atlasURI = new URI(atlasURIString);
        }
        catch (URISyntaxException exception) {
            throw new CoreException("Bad URI syntax: {}", new Object[]{atlasURIString, exception});
        }
        return atlasURI;
    }
}

