/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.generator.sharding;

import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.generator.tools.filesystem.FileSystemHelper;
import org.openstreetmap.atlas.generator.tools.spark.converters.SparkOptionsStringConverter;
import org.openstreetmap.atlas.geography.sharding.CountryShard;
import org.openstreetmap.atlas.streaming.resource.WritableResource;
import org.openstreetmap.atlas.streaming.writers.SafeBufferedWriter;
import org.openstreetmap.atlas.utilities.collections.Sets;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.conversion.StringConverter;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;
import org.openstreetmap.atlas.utilities.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasShardVerifier
extends Command {
    public static final Command.Switch<String> ATLAS_FOLDER = new Command.Switch("atlasFolder", "Folder containing Atlas Shards named by the AtlasGenerator", StringConverter.IDENTITY, Command.Optionality.REQUIRED);
    public static final Command.Switch<String> EXPECTED_SHARDS = new Command.Switch("expectedShards", "Path to file containing all the expected shards, or to folder containing reference atlas files", StringConverter.IDENTITY, Command.Optionality.REQUIRED);
    public static final Command.Switch<String> OUTPUT = new Command.Switch("output", "The file to list all the missing shards", StringConverter.IDENTITY, Command.Optionality.REQUIRED);
    public static final Command.Switch<Map<String, String>> SPARK_OPTIONS = new Command.Switch("sparkOptions", "Comma separated list of Spark options, i.e. key1=value1,key2=value2", (StringConverter)new SparkOptionsStringConverter(), Command.Optionality.OPTIONAL, "");
    public static final Command.Switch<Integer> LIST_DEPTH = new Command.Switch("listDepth", "Depth to list recursive folders", Integer::valueOf, Command.Optionality.OPTIONAL, "2");
    public static final Command.Switch<Pattern> PATH_FILTER_REGEX = new Command.Switch("pathFilterRegex", "Regex to filter paths to list", Pattern::compile, Command.Optionality.OPTIONAL, ".*\\.atlas");
    public static final Command.Switch<Set<String>> COUNTRIES = new Command.Switch("countries", "Comma separated list of countries to be checked for", value -> "".equals(value) ? Sets.hashSet((Object[])new String[0]) : StringList.split((String)value, (String)",").stream().collect(Collectors.toSet()), Command.Optionality.OPTIONAL, "");
    private static final Logger logger = LoggerFactory.getLogger(AtlasShardVerifier.class);

    public static void main(String[] args) {
        new AtlasShardVerifier().run(args);
    }

    public String getPathFor(CommandMap command, Command.Switch<?> zwitch) {
        return (String)command.get(zwitch);
    }

    public Map<String, String> sparkOptions(CommandMap command) {
        Map result = (Map)command.get(SPARK_OPTIONS);
        return result;
    }

    protected int onRun(CommandMap command) {
        Set<Object> expectedShards;
        String atlasFolder = this.getPathFor(command, ATLAS_FOLDER);
        int depth = (Integer)command.get(LIST_DEPTH);
        Pattern pattern = (Pattern)command.get(PATH_FILTER_REGEX);
        Set countries = (Set)command.get(COUNTRIES);
        logger.debug("Using regex filter \"{}\"", (Object)pattern);
        PathFilter filter = path -> pattern.matcher(path.toString()).matches();
        Map<String, String> sparkConfiguration = this.sparkOptions(command);
        WritableResource output = FileSystemHelper.writableResource(this.getPathFor(command, OUTPUT), sparkConfiguration);
        String expectedShardsPath = this.getPathFor(command, EXPECTED_SHARDS);
        if (FileSystemHelper.isFile(expectedShardsPath, sparkConfiguration)) {
            logger.trace("isFile: {}", (Object)expectedShardsPath);
            expectedShards = FileSystemHelper.resource(expectedShardsPath, sparkConfiguration).linesList().stream().map(CountryShard::forName).collect(Collectors.toSet());
        } else if (FileSystemHelper.isDirectory(expectedShardsPath, sparkConfiguration)) {
            logger.trace("isDirectory: {}", (Object)expectedShardsPath);
            expectedShards = this.shardsFromFolder(expectedShardsPath, sparkConfiguration, depth, filter);
        } else {
            throw new CoreException("{} does not exist.", new Object[]{expectedShardsPath});
        }
        expectedShards = expectedShards.stream().filter(countryShard -> countries.isEmpty() || countries.contains(countryShard.getCountry())).collect(Collectors.toSet());
        Set existingShards = this.shardsFromFolder(atlasFolder, sparkConfiguration, depth, filter).stream().filter(countryShard -> countries.isEmpty() || countries.contains(countryShard.getCountry())).collect(Collectors.toSet());
        expectedShards.removeAll(existingShards);
        try (SafeBufferedWriter writer = output.writer();){
            expectedShards.stream().map(CountryShard::getName).forEach(arg_0 -> ((SafeBufferedWriter)writer).writeLine(arg_0));
        }
        catch (Exception e) {
            throw new CoreException("Verification failed", (Throwable)e);
        }
        return 0;
    }

    protected Command.SwitchList switches() {
        return new Command.SwitchList().with(new Command.Switch[]{ATLAS_FOLDER, EXPECTED_SHARDS, OUTPUT, SPARK_OPTIONS, LIST_DEPTH, PATH_FILTER_REGEX, COUNTRIES});
    }

    private Set<CountryShard> shardsFromFolder(String expectedShardsPath, Map<String, String> sparkConfiguration, int depth, PathFilter filter) {
        logger.trace("listResourcesRecursively: {}", (Object)expectedShardsPath);
        Time start = Time.now();
        Set<CountryShard> result = FileSystemHelper.streamPathsRecursively(expectedShardsPath, sparkConfiguration, filter, depth).map(Path::getName).map(name -> StringList.split((String)name, (String)".").get(0)).map(CountryShard::forName).collect(Collectors.toSet());
        logger.debug("Took {} to find {} countryShards in {}", new Object[]{start.elapsedSince(), result.size(), expectedShardsPath});
        return result;
    }
}

