/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.generator.persistence.scheme;

import java.io.Serializable;
import org.openstreetmap.atlas.generator.persistence.scheme.SlippyTilePersistenceSchemeType;
import org.openstreetmap.atlas.geography.sharding.SlippyTile;
import org.openstreetmap.atlas.streaming.resource.FileSuffix;

public class SlippyTilePersistenceScheme
implements Serializable {
    public static final String ZOOM = "zz";
    public static final String X_INDEX = "xx";
    public static final String Y_INDEX = "yy";
    static final String HYPHEN = "-";
    private static final long serialVersionUID = -7098822765716165700L;
    private final SlippyTilePersistenceSchemeType type;
    private final String scheme;
    private final FileSuffix suffix;

    public static SlippyTilePersistenceScheme getSchemeInstanceFromString(String string) {
        SlippyTilePersistenceSchemeType type = SlippyTilePersistenceSchemeType.legacyArbitrarySchemeToSchemeType(string);
        if (type == null) {
            type = SlippyTilePersistenceSchemeType.enumNameToSchemeType(string);
        }
        return new SlippyTilePersistenceScheme(type);
    }

    public SlippyTilePersistenceScheme(SlippyTilePersistenceSchemeType type) {
        this.type = type;
        this.scheme = type.getValue();
        this.suffix = type.getSuffix();
    }

    public String compile(SlippyTile tile) {
        return this.compile(String.valueOf(tile.getZoom()), String.valueOf(tile.getX()), String.valueOf(tile.getY()));
    }

    public String compile(String zoom, String xIndex, String yIndex) {
        return this.scheme.replaceAll(ZOOM, String.valueOf(zoom)).replaceAll(X_INDEX, String.valueOf(xIndex)).replaceAll(Y_INDEX, String.valueOf(yIndex)) + this.suffix;
    }

    public String getScheme() {
        return this.scheme + this.suffix;
    }

    public SlippyTilePersistenceSchemeType getType() {
        return this.type;
    }
}

