/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.generator.persistence;

import java.util.Optional;
import org.apache.hadoop.mapred.lib.MultipleOutputFormat;
import org.openstreetmap.atlas.generator.persistence.scheme.SlippyTilePersistenceScheme;
import org.openstreetmap.atlas.generator.tools.json.PersistenceJsonParser;
import org.openstreetmap.atlas.generator.tools.spark.utilities.SparkFileHelper;
import org.openstreetmap.atlas.geography.sharding.CountryShard;
import org.openstreetmap.atlas.geography.sharding.Shard;
import org.openstreetmap.atlas.geography.sharding.SlippyTile;
import org.openstreetmap.atlas.geography.sharding.converters.StringToShardConverter;

public abstract class AbstractMultipleAtlasBasedOutputFormat<T>
extends MultipleOutputFormat<String, T> {
    protected String generateFileNameForKeyValue(String key, T value, String name) {
        String countryString = PersistenceJsonParser.parseCountry(key);
        String shardString = PersistenceJsonParser.parseShard(key);
        Optional<String> schemeString = PersistenceJsonParser.parseScheme(key);
        StringToShardConverter converter = new StringToShardConverter();
        Shard shard = converter.convert(shardString);
        SlippyTilePersistenceScheme scheme = null;
        if (schemeString.isPresent() && !schemeString.get().isEmpty() && shard instanceof SlippyTile) {
            scheme = SlippyTilePersistenceScheme.getSchemeInstanceFromString(schemeString.get());
        }
        CountryShard countryShard = new CountryShard(countryString, shard);
        if (scheme != null) {
            return SparkFileHelper.combine(countryString, scheme.compile((SlippyTile)shard), countryShard.getName());
        }
        return SparkFileHelper.combine(countryString, countryShard.getName());
    }
}

