/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.generator.persistence;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.streaming.Streams;
import org.openstreetmap.atlas.streaming.compression.Compressor;
import org.openstreetmap.atlas.streaming.resource.AbstractWritableResource;
import org.openstreetmap.atlas.streaming.resource.FileSuffix;
import org.openstreetmap.atlas.streaming.resource.OutputStreamWritableResource;
import org.openstreetmap.atlas.utilities.runtime.Retry;
import org.openstreetmap.atlas.utilities.scalars.Duration;

public abstract class AbstractFileOutputFormat<T>
extends FileOutputFormat<String, T> {
    private static final int RETRY_NUMBER = 5;

    public RecordWriter<String, T> getRecordWriter(FileSystem ignored, final JobConf job, final String name, final Progressable progress) throws IOException {
        return new RecordWriter<String, T>(){
            private final String resourceName;
            private final Path outputPath;
            private final Path path;
            private final FileSystem fileSystem;
            private FSDataOutputStream dataOutputStream;
            private String lastKey;
            private T lastValue;
            {
                this.resourceName = AbstractFileOutputFormat.this.getQualifiedFileNameWithExtension(name);
                this.outputPath = FileOutputFormat.getOutputPath((JobConf)job);
                this.path = new Path(this.outputPath, this.resourceName);
                this.fileSystem = this.path.getFileSystem((Configuration)job);
            }

            public void close(Reporter reporter) {
                AbstractFileOutputFormat.this.retry().run(() -> {
                    try {
                        Streams.close((Closeable)this.dataOutputStream);
                    }
                    catch (Exception e) {
                        throw new CoreException("Unable to close stream for last key {}", new Object[]{this.lastKey, e});
                    }
                }, () -> {
                    if (this.lastKey != null && this.lastValue != null) {
                        this.write(this.lastKey, this.lastValue);
                    }
                });
                this.lastKey = null;
                this.lastValue = null;
            }

            public void write(String key, T value) {
                this.lastKey = key;
                this.lastValue = value;
                AbstractFileOutputFormat.this.retry().run(() -> {
                    try {
                        this.dataOutputStream = this.fileSystem.create(this.path, progress);
                        OutputStreamWritableResource out = new OutputStreamWritableResource((OutputStream)this.dataOutputStream);
                        out.setName(this.path.toString());
                        if (AbstractFileOutputFormat.this.isCompressed()) {
                            out.setCompressor(Compressor.GZIP);
                        }
                        AbstractFileOutputFormat.this.save(value, (AbstractWritableResource)out);
                    }
                    catch (Exception e) {
                        throw new CoreException("File Output Format: Failed to save {}", new Object[]{this.path.toString(), e});
                    }
                });
            }
        };
    }

    protected abstract String fileExtension();

    protected abstract boolean isCompressed();

    protected Retry retry() {
        return new Retry(5, Duration.seconds((double)2.0)).withQuadratic(true);
    }

    protected abstract void save(T var1, AbstractWritableResource var2);

    private String getQualifiedFileNameWithExtension(String name) {
        if (this.isCompressed()) {
            return String.format("%s%s%s", name, this.fileExtension(), FileSuffix.GZIP.toString());
        }
        return String.format("%s%s", name, this.fileExtension());
    }
}

