/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.generator.dataframe;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import scala.collection.JavaConversions;

public final class AtlasDataFrame {
    private static final String IDENTIFIER = "identifier";
    private static final String GEOMETRY = "geometry";
    private static final String RELATIONS = "relations";

    public static Dataset<Row> atlasAreasToDataFrame(JavaRDD<Atlas> atlasRDD, JavaSparkContext javaSparkContext) {
        ArrayList<StructField> fields = new ArrayList<StructField>();
        StructField identifier = DataTypes.createStructField((String)IDENTIFIER, (DataType)DataTypes.StringType, (boolean)true);
        fields.add(identifier);
        StructField geometry = DataTypes.createStructField((String)GEOMETRY, (DataType)DataTypes.StringType, (boolean)true);
        fields.add(geometry);
        StructField bounds = DataTypes.createStructField((String)"bounds", (DataType)DataTypes.StringType, (boolean)true);
        fields.add(bounds);
        StructField tags = DataTypes.createStructField((String)"tags", (DataType)DataTypes.createMapType((DataType)DataTypes.StringType, (DataType)DataTypes.StringType), (boolean)true);
        fields.add(tags);
        StructField relations = DataTypes.createStructField((String)RELATIONS, (DataType)DataTypes.createArrayType((DataType)DataTypes.StringType), (boolean)true);
        fields.add(relations);
        StructType schema = DataTypes.createStructType(fields);
        JavaRDD rowRDD = atlasRDD.flatMap((FlatMapFunction & Serializable)atlas -> {
            ArrayList rows = new ArrayList();
            atlas.areas().forEach(area -> {
                long nodeIdentifier = area.getIdentifier();
                String idString = String.valueOf(nodeIdentifier);
                String wktGeometry = area.toWkt();
                String areaBounds = area.bounds().toWkt();
                String[] relationArray = (String[])area.relations().stream().map(relation -> String.valueOf(relation.getIdentifier())).toArray(String[]::new);
                rows.add(RowFactory.create((Object[])new Object[]{idString, wktGeometry, areaBounds, JavaConversions.mapAsScalaMap((Map)area.getTags()), relationArray}));
            });
            return rows.iterator();
        });
        SparkContext sparkContext = JavaSparkContext.toSparkContext((JavaSparkContext)javaSparkContext);
        return SparkSession.builder().sparkContext(sparkContext).getOrCreate().createDataFrame(rowRDD, schema);
    }

    public static Dataset<Row> atlasEdgesToDataFrame(JavaRDD<Atlas> atlasRDD, JavaSparkContext javaSparkContext) {
        ArrayList<StructField> fields = new ArrayList<StructField>();
        StructField identifier = DataTypes.createStructField((String)IDENTIFIER, (DataType)DataTypes.StringType, (boolean)true);
        fields.add(identifier);
        StructField geometry = DataTypes.createStructField((String)GEOMETRY, (DataType)DataTypes.StringType, (boolean)true);
        fields.add(geometry);
        StructField start = DataTypes.createStructField((String)"start", (DataType)DataTypes.StringType, (boolean)true);
        fields.add(start);
        StructField end = DataTypes.createStructField((String)"end", (DataType)DataTypes.StringType, (boolean)true);
        fields.add(end);
        StructField inEdges = DataTypes.createStructField((String)"inEdges", (DataType)DataTypes.createArrayType((DataType)DataTypes.StringType), (boolean)true);
        fields.add(inEdges);
        StructField outEdges = DataTypes.createStructField((String)"outEdges", (DataType)DataTypes.createArrayType((DataType)DataTypes.StringType), (boolean)true);
        fields.add(outEdges);
        StructField hasReverse = DataTypes.createStructField((String)"hasReverseEdge", (DataType)DataTypes.BooleanType, (boolean)true);
        fields.add(hasReverse);
        StructField isClosed = DataTypes.createStructField((String)"isClosed", (DataType)DataTypes.BooleanType, (boolean)true);
        fields.add(isClosed);
        StructField tags = DataTypes.createStructField((String)"tags", (DataType)DataTypes.createMapType((DataType)DataTypes.StringType, (DataType)DataTypes.StringType), (boolean)true);
        fields.add(tags);
        StructField relations = DataTypes.createStructField((String)RELATIONS, (DataType)DataTypes.createArrayType((DataType)DataTypes.StringType), (boolean)true);
        fields.add(relations);
        StructType schema = DataTypes.createStructType(fields);
        JavaRDD rowRDD = atlasRDD.flatMap((FlatMapFunction & Serializable)atlas -> {
            ArrayList rows = new ArrayList();
            atlas.edges().forEach(edge -> {
                long nodeIdentifier = edge.getIdentifier();
                String idString = String.valueOf(nodeIdentifier);
                String wktGeometry = edge.toWkt();
                String[] inEdgeArray = (String[])edge.inEdges().stream().map(inEdge -> String.valueOf(inEdge.getIdentifier())).toArray(String[]::new);
                String[] outEdgeArray = (String[])edge.inEdges().stream().map(outEdge -> String.valueOf(outEdge.getIdentifier())).toArray(String[]::new);
                String startNode = String.valueOf(edge.start().getIdentifier());
                String endNode = String.valueOf(edge.end().getIdentifier());
                Boolean hasReverseEdge = edge.hasReverseEdge();
                Boolean isClosedEdge = edge.isClosed();
                String[] relationArray = (String[])edge.relations().stream().map(relation -> String.valueOf(relation.getIdentifier())).toArray(String[]::new);
                rows.add(RowFactory.create((Object[])new Object[]{idString, wktGeometry, startNode, endNode, inEdgeArray, outEdgeArray, hasReverseEdge, isClosedEdge, JavaConversions.mapAsScalaMap((Map)edge.getTags()), relationArray}));
            });
            return rows.iterator();
        });
        SparkContext sparkContext = JavaSparkContext.toSparkContext((JavaSparkContext)javaSparkContext);
        return SparkSession.builder().sparkContext(sparkContext).getOrCreate().createDataFrame(rowRDD, schema);
    }

    public static Dataset<Row> atlasLinesToDataFrame(JavaRDD<Atlas> atlasRDD, JavaSparkContext javaSparkContext) {
        ArrayList<StructField> fields = new ArrayList<StructField>();
        StructField identifier = DataTypes.createStructField((String)IDENTIFIER, (DataType)DataTypes.StringType, (boolean)true);
        fields.add(identifier);
        StructField geometry = DataTypes.createStructField((String)GEOMETRY, (DataType)DataTypes.StringType, (boolean)true);
        fields.add(geometry);
        StructField bounds = DataTypes.createStructField((String)"bounds", (DataType)DataTypes.StringType, (boolean)true);
        fields.add(bounds);
        StructField isClosed = DataTypes.createStructField((String)"isClosed", (DataType)DataTypes.BooleanType, (boolean)true);
        fields.add(isClosed);
        StructField tags = DataTypes.createStructField((String)"tags", (DataType)DataTypes.createMapType((DataType)DataTypes.StringType, (DataType)DataTypes.StringType), (boolean)true);
        fields.add(tags);
        StructField relations = DataTypes.createStructField((String)RELATIONS, (DataType)DataTypes.createArrayType((DataType)DataTypes.StringType), (boolean)true);
        fields.add(relations);
        StructType schema = DataTypes.createStructType(fields);
        JavaRDD rowRDD = atlasRDD.flatMap((FlatMapFunction & Serializable)atlas -> {
            ArrayList rows = new ArrayList();
            atlas.lines().forEach(line -> {
                long nodeIdentifier = line.getIdentifier();
                String idString = String.valueOf(nodeIdentifier);
                String wktGeometry = line.toWkt();
                String lineBounds = line.bounds().toWkt();
                Boolean isClosedLine = line.isClosed();
                String[] relationArray = (String[])line.relations().stream().map(relation -> String.valueOf(relation.getIdentifier())).toArray(String[]::new);
                rows.add(RowFactory.create((Object[])new Object[]{idString, wktGeometry, lineBounds, isClosedLine, JavaConversions.mapAsScalaMap((Map)line.getTags()), relationArray}));
            });
            return rows.iterator();
        });
        SparkContext sparkContext = JavaSparkContext.toSparkContext((JavaSparkContext)javaSparkContext);
        return SparkSession.builder().sparkContext(sparkContext).getOrCreate().createDataFrame(rowRDD, schema);
    }

    public static Dataset<Row> atlasNodesToDataFrame(JavaRDD<Atlas> atlasRDD, JavaSparkContext javaSparkContext) {
        ArrayList<StructField> fields = new ArrayList<StructField>();
        StructField identifier = DataTypes.createStructField((String)IDENTIFIER, (DataType)DataTypes.StringType, (boolean)true);
        fields.add(identifier);
        StructField location = DataTypes.createStructField((String)"location", (DataType)DataTypes.StringType, (boolean)true);
        fields.add(location);
        StructField inEdges = DataTypes.createStructField((String)"inEdges", (DataType)DataTypes.createArrayType((DataType)DataTypes.StringType), (boolean)true);
        fields.add(inEdges);
        StructField outEdges = DataTypes.createStructField((String)"outEdges", (DataType)DataTypes.createArrayType((DataType)DataTypes.StringType), (boolean)true);
        fields.add(outEdges);
        StructField tags = DataTypes.createStructField((String)"tags", (DataType)DataTypes.createMapType((DataType)DataTypes.StringType, (DataType)DataTypes.StringType), (boolean)true);
        fields.add(tags);
        StructField relations = DataTypes.createStructField((String)RELATIONS, (DataType)DataTypes.createArrayType((DataType)DataTypes.StringType), (boolean)true);
        fields.add(relations);
        StructType schema = DataTypes.createStructType(fields);
        JavaRDD rowRDD = atlasRDD.flatMap((FlatMapFunction & Serializable)atlas -> {
            ArrayList rows = new ArrayList();
            atlas.nodes().forEach(node -> {
                long nodeIdentifier = node.getIdentifier();
                String idString = String.valueOf(nodeIdentifier);
                String locationString = node.getLocation().toWkt();
                String[] inEdgeArray = (String[])node.inEdges().stream().map(edge -> String.valueOf(edge.getIdentifier())).toArray(String[]::new);
                String[] outEdgeArray = (String[])node.outEdges().stream().map(edge -> String.valueOf(edge.getIdentifier())).toArray(String[]::new);
                String[] relationArray = (String[])node.relations().stream().map(relation -> String.valueOf(relation.getIdentifier())).toArray(String[]::new);
                rows.add(RowFactory.create((Object[])new Object[]{idString, locationString, inEdgeArray, outEdgeArray, JavaConversions.mapAsScalaMap((Map)node.getTags()), relationArray}));
            });
            return rows.iterator();
        });
        SparkContext sparkContext = JavaSparkContext.toSparkContext((JavaSparkContext)javaSparkContext);
        return SparkSession.builder().sparkContext(sparkContext).getOrCreate().createDataFrame(rowRDD, schema);
    }

    public static Dataset<Row> atlasPointsToDataFrame(JavaRDD<Atlas> atlasRDD, JavaSparkContext javaSparkContext) {
        ArrayList<StructField> fields = new ArrayList<StructField>();
        StructField identifier = DataTypes.createStructField((String)IDENTIFIER, (DataType)DataTypes.StringType, (boolean)true);
        fields.add(identifier);
        StructField location = DataTypes.createStructField((String)"location", (DataType)DataTypes.StringType, (boolean)true);
        fields.add(location);
        StructField tags = DataTypes.createStructField((String)"tags", (DataType)DataTypes.createMapType((DataType)DataTypes.StringType, (DataType)DataTypes.StringType), (boolean)true);
        fields.add(tags);
        StructField relations = DataTypes.createStructField((String)RELATIONS, (DataType)DataTypes.createArrayType((DataType)DataTypes.StringType), (boolean)true);
        fields.add(relations);
        StructType schema = DataTypes.createStructType(fields);
        JavaRDD rowRDD = atlasRDD.flatMap((FlatMapFunction & Serializable)atlas -> {
            ArrayList rows = new ArrayList();
            atlas.points().forEach(point -> {
                long nodeIdentifier = point.getIdentifier();
                String idString = String.valueOf(nodeIdentifier);
                String locationString = point.getLocation().toWkt();
                String[] relationArray = (String[])point.relations().stream().map(relation -> String.valueOf(relation.getIdentifier())).toArray(String[]::new);
                rows.add(RowFactory.create((Object[])new Object[]{idString, locationString, JavaConversions.mapAsScalaMap((Map)point.getTags()), relationArray}));
            });
            return rows.iterator();
        });
        SparkContext sparkContext = JavaSparkContext.toSparkContext((JavaSparkContext)javaSparkContext);
        return SparkSession.builder().sparkContext(sparkContext).getOrCreate().createDataFrame(rowRDD, schema);
    }

    public static Dataset<Row> atlasRelationsToDataFrame(JavaRDD<Atlas> atlasRDD, JavaSparkContext javaSparkContext) {
        ArrayList<StructField> fields = new ArrayList<StructField>();
        StructField identifier = DataTypes.createStructField((String)IDENTIFIER, (DataType)DataTypes.StringType, (boolean)true);
        fields.add(identifier);
        StructField geometry = DataTypes.createStructField((String)GEOMETRY, (DataType)DataTypes.StringType, (boolean)true);
        fields.add(geometry);
        StructField members = DataTypes.createStructField((String)"memberIds", (DataType)DataTypes.createArrayType((DataType)DataTypes.StringType), (boolean)true);
        fields.add(members);
        StructField memberTypes = DataTypes.createStructField((String)"memberTypes", (DataType)DataTypes.createArrayType((DataType)DataTypes.StringType), (boolean)true);
        fields.add(memberTypes);
        StructField memberRoles = DataTypes.createStructField((String)"memberRoles", (DataType)DataTypes.createArrayType((DataType)DataTypes.StringType), (boolean)true);
        fields.add(memberRoles);
        StructField tags = DataTypes.createStructField((String)"tags", (DataType)DataTypes.createMapType((DataType)DataTypes.StringType, (DataType)DataTypes.StringType), (boolean)true);
        fields.add(tags);
        StructField relations = DataTypes.createStructField((String)RELATIONS, (DataType)DataTypes.createArrayType((DataType)DataTypes.StringType), (boolean)true);
        fields.add(relations);
        StructType schema = DataTypes.createStructType(fields);
        JavaRDD rowRDD = atlasRDD.flatMap((FlatMapFunction & Serializable)atlas -> {
            ArrayList rows = new ArrayList();
            atlas.relations().forEach(relation -> {
                long nodeIdentifier = relation.getIdentifier();
                String idString = String.valueOf(nodeIdentifier);
                String wktGeometry = relation.toWkt();
                String[] relationMemberIdentifiers = (String[])relation.members().stream().sorted().map(member -> String.valueOf(member.getEntity().getIdentifier())).toArray(String[]::new);
                String[] relationMemberRoles = (String[])relation.members().stream().sorted().map(member -> String.valueOf(member.getRole())).toArray(String[]::new);
                String[] relationMemberTypes = (String[])relation.members().stream().sorted().map(member -> String.valueOf(AtlasDataFrame.typeValueToString(member.getEntity().getType().getValue()))).toArray(String[]::new);
                String[] relationArray = (String[])relation.relations().stream().map(parentRrelation -> String.valueOf(parentRrelation.getIdentifier())).toArray(String[]::new);
                rows.add(RowFactory.create((Object[])new Object[]{idString, wktGeometry, relationMemberIdentifiers, relationMemberTypes, relationMemberRoles, JavaConversions.mapAsScalaMap((Map)relation.getTags()), relationArray}));
            });
            return rows.iterator();
        });
        SparkContext sparkContext = JavaSparkContext.toSparkContext((JavaSparkContext)javaSparkContext);
        return SparkSession.builder().sparkContext(sparkContext).getOrCreate().createDataFrame(rowRDD, schema);
    }

    private static String typeValueToString(int value) {
        boolean node = false;
        boolean edge = true;
        int area = 2;
        int line = 3;
        int point = 4;
        int relation = 5;
        switch (value) {
            case 0: {
                return "NODE";
            }
            case 1: {
                return "EDGE";
            }
            case 2: {
                return "AREA";
            }
            case 3: {
                return "LINE";
            }
            case 4: {
                return "POINT";
            }
            case 5: {
                return "RELATION";
            }
        }
        throw new CoreException("Invalid type {}", new Object[]{value});
    }

    private AtlasDataFrame() {
    }
}

