/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.generator;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.generator.PbfContext;
import org.openstreetmap.atlas.generator.tools.filesystem.FileSystemCreator;
import org.openstreetmap.atlas.generator.tools.spark.utilities.SparkFileHelper;
import org.openstreetmap.atlas.geography.GeometricSurface;
import org.openstreetmap.atlas.geography.Located;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.sharding.Shard;
import org.openstreetmap.atlas.geography.sharding.SlippyTile;
import org.openstreetmap.atlas.streaming.resource.FileSuffix;
import org.openstreetmap.atlas.streaming.resource.InputStreamResource;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.collections.StreamIterable;
import org.openstreetmap.atlas.utilities.runtime.Retry;
import org.openstreetmap.atlas.utilities.scalars.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PbfLocator
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(PbfLocator.class);
    public static final String DEFAULT_SCHEME = "zz-xx-yy" + FileSuffix.PBF.toString();
    private final PbfContext pbfContext;
    private final Function<SlippyTile, Optional<LocatedPbf>> pbfFetcher;
    private final Retry retry = new Retry(5, Duration.ONE_SECOND);
    private final FileSystem fileSystem;

    public PbfLocator(PbfContext pbfContext, Map<String, String> spark) {
        this.pbfContext = pbfContext;
        this.fileSystem = new FileSystemCreator().get(this.pbfContext.getPbfPath(), spark);
        this.pbfFetcher = (Function<SlippyTile, Optional> & Serializable)shard -> {
            Path pbfName = new Path(SparkFileHelper.combine(this.pbfContext.getPbfPath(), this.pbfContext.getScheme().compile((SlippyTile)shard)));
            if (!this.exists(this.fileSystem, pbfName)) {
                logger.warn("PBF Resource {} does not exist.", (Object)pbfName);
                return Optional.empty();
            }
            LocatedPbf locatedPbf = new LocatedPbf((Resource)new InputStreamResource(() -> {
                try {
                    return this.open(this.fileSystem, pbfName);
                }
                catch (Exception e) {
                    throw new CoreException("Cannot translate {} to a PBF resource.", new Object[]{shard, e});
                }
            }).withName(pbfName.toString()), shard.bounds());
            return Optional.of(locatedPbf);
        };
    }

    @Override
    public void close() throws IOException {
        this.fileSystem.close();
    }

    public Iterable<LocatedPbf> pbfsCovering(MultiPolygon multiPolygon) {
        if (logger.isTraceEnabled()) {
            logger.trace("Seeking tiles for MultiPolygon {}", (Object)multiPolygon.toSimpleString());
        }
        List inners = multiPolygon.inners();
        StreamIterable tileIterable = Iterables.stream((Iterable)multiPolygon.outers()).flatMap(this::tilesCoveringPartially);
        Set tileSet = Iterables.asSet((Iterable)tileIterable);
        if (logger.isTraceEnabled()) {
            logger.trace("Found tiles {} for MultiPolygon {}", (Object)tileSet, (Object)multiPolygon.toSimpleString());
        }
        return Iterables.stream((Iterable)tileSet).filter(tile -> !this.innerCovers((Shard)tile, inners)).map(shard -> (SlippyTile)shard).map(this.pbfFetcher).filter(Optional::isPresent).map(Optional::get).collect();
    }

    public Iterable<LocatedPbf> pbfsCovering(Polygon polygon) {
        if (logger.isTraceEnabled()) {
            logger.trace("Seeking tiles for Polygon {}", (Object)polygon.toSimpleString());
        }
        return Iterables.stream(this.tilesCoveringPartially(polygon)).map(shard -> (SlippyTile)shard).map(this.pbfFetcher).filter(Optional::isPresent).map(Optional::get).collect();
    }

    private boolean exists(FileSystem fileSystem, Path path) {
        return (Boolean)this.retry.run(() -> {
            try {
                return fileSystem.exists(path);
            }
            catch (IOException e) {
                throw new CoreException("Unable to test if {} exists.", new Object[]{path, e});
            }
        });
    }

    private boolean innerCovers(Shard shard, List<Polygon> inners) {
        for (Polygon inner : inners) {
            if (!inner.fullyGeometricallyEncloses(shard.bounds())) continue;
            return true;
        }
        return false;
    }

    private FSDataInputStream open(FileSystem fileSystem, Path path) {
        return (FSDataInputStream)this.retry.run(() -> {
            try {
                return fileSystem.open(path);
            }
            catch (IOException e) {
                throw new CoreException("Unable to open {}.", new Object[]{path, e});
            }
        });
    }

    private Iterable<? extends Shard> tilesCoveringPartially(Polygon polygon) {
        return this.pbfContext.getSharding().shards((GeometricSurface)polygon);
    }

    public static class LocatedPbf
    implements Located {
        private final Resource resource;
        private final Rectangle bounds;

        public LocatedPbf(Resource resource, Rectangle bounds) {
            this.resource = resource;
            this.bounds = bounds;
        }

        public Rectangle bounds() {
            return this.bounds;
        }

        public Resource getResource() {
            return this.resource;
        }
    }
}

