/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.generator;

import java.util.Map;
import java.util.Optional;
import org.openstreetmap.atlas.generator.tools.spark.DataLocator;
import org.openstreetmap.atlas.generator.tools.spark.utilities.SparkFileHelper;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.AtlasResourceLoader;
import org.openstreetmap.atlas.streaming.resource.FileSuffix;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.collections.MultiIterable;

public class AtlasLocator
extends DataLocator<Atlas> {
    private static final long serialVersionUID = 245229416973321209L;

    public AtlasLocator(Map<String, String> sparkContext) {
        super(sparkContext);
    }

    public Iterable<Atlas> atlasForShard(String atlasPath, Iterable<String> countryShards) {
        Iterable clear = this.retrieve(Iterables.stream(countryShards).map(countryShard -> this.fullPath(atlasPath, (String)countryShard)).collect());
        Iterable gzipped = this.retrieve(Iterables.stream(countryShards).map(countryShard -> this.fullPathGzipped(atlasPath, (String)countryShard)).collect());
        return new MultiIterable(new Iterable[]{clear, gzipped});
    }

    public Optional<Atlas> atlasForShard(String atlasPath, String countryShard) {
        Optional<Atlas> clear = this.retrieve(this.fullPath(atlasPath, countryShard));
        if (clear.isPresent()) {
            return clear;
        }
        return this.retrieve(this.fullPathGzipped(atlasPath, countryShard));
    }

    @Override
    protected Optional<Atlas> readFrom(Resource resource) {
        return Optional.ofNullable(new AtlasResourceLoader().load(new Resource[]{resource}));
    }

    private String fullPath(String atlasPath, String countryShard) {
        return SparkFileHelper.combine(atlasPath, countryShard + FileSuffix.ATLAS);
    }

    private String fullPathGzipped(String atlasPath, String countryShard) {
        return SparkFileHelper.combine(atlasPath, countryShard + FileSuffix.ATLAS + FileSuffix.GZIP);
    }
}

