/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.generator.tools.json;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.utilities.collections.Maps;

public final class PersistenceJsonParser {
    private static final String COUNTRY_KEY = "country";
    private static final String SHARD_KEY = "shard";
    private static final String METADATA_KEY = "metadata";
    private static final String SCHEME_KEY = "scheme";

    public static String createJsonKey(String country, String shard, String scheme) {
        return PersistenceJsonParser.createJsonKey(country, shard, Maps.hashMap((Object[])new String[]{SCHEME_KEY, scheme}));
    }

    public static String createJsonKey(String country, String shard, Map<String, String> metadata) {
        JsonObject jsonKey = new JsonObject();
        jsonKey.addProperty(COUNTRY_KEY, country);
        jsonKey.addProperty(SHARD_KEY, shard);
        JsonObject metadataObject = new JsonObject();
        for (Map.Entry<String, String> entry : metadata.entrySet()) {
            metadataObject.addProperty(entry.getKey(), entry.getValue());
        }
        jsonKey.add(METADATA_KEY, (JsonElement)metadataObject);
        return jsonKey.toString();
    }

    public static String parseCountry(String json) {
        return PersistenceJsonParser.parseStringProperty(json, COUNTRY_KEY);
    }

    public static Map<String, String> parseMetadata(String json) {
        JsonParser parser = new JsonParser();
        JsonObject parsedObject = parser.parse(json).getAsJsonObject();
        JsonObject metadataObject = parsedObject.get(METADATA_KEY).getAsJsonObject();
        HashMap<String, String> map = new HashMap<String, String>();
        for (Map.Entry entry : metadataObject.entrySet()) {
            String key = (String)entry.getKey();
            String value = ((JsonElement)entry.getValue()).getAsString();
            map.put(key, value);
        }
        return map;
    }

    public static Optional<String> parseScheme(String json) {
        JsonParser parser = new JsonParser();
        JsonObject parsedObject = parser.parse(json).getAsJsonObject();
        JsonObject metadataObject = parsedObject.get(METADATA_KEY).getAsJsonObject();
        if (metadataObject.get(SCHEME_KEY) == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(metadataObject.get(SCHEME_KEY).getAsString());
    }

    public static String parseShard(String json) {
        return PersistenceJsonParser.parseStringProperty(json, SHARD_KEY);
    }

    private static String parseStringProperty(String json, String property) {
        JsonParser parser = new JsonParser();
        JsonObject parsedObject = parser.parse(json).getAsJsonObject();
        if (parsedObject.get(property) == null) {
            throw new CoreException("Property \"{}\" not found in JSON object {}", new Object[]{property, json});
        }
        return parsedObject.get(property).getAsString();
    }

    private PersistenceJsonParser() {
    }
}

