/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.generator.sharding;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.generator.sharding.PbfFilePathFilter;
import org.openstreetmap.atlas.generator.tools.filesystem.FileSystemHelper;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.Polygon;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.atlas.pbf.AtlasLoadingOption;
import org.openstreetmap.atlas.geography.atlas.raw.creation.RawAtlasGenerator;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.maps.MultiMap;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;
import org.openstreetmap.atlas.utilities.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PbfVerifier
extends Command {
    private static final Command.Switch<File> SLIPPY_TILE_FILE = new Command.Switch("slippyTileFile", "The slippy tile file that lists all pbf files that should have been generated.", File::new, Command.Optionality.REQUIRED);
    private static final Command.Switch<String> PBF_PATH = new Command.Switch("pbfPath", "The path to the pbf root directory", value -> value, Command.Optionality.REQUIRED);
    private static final int LOGGING_RATE = 1000;
    private static final Logger logger = LoggerFactory.getLogger(PbfVerifier.class);

    public static MultiPolygon forPolygon(Polygon polygon) {
        MultiMap multiMap = new MultiMap();
        multiMap.put((Object)polygon, new ArrayList());
        return new MultiPolygon(multiMap);
    }

    public static void main(String[] args) {
        new PbfVerifier().run(args);
    }

    public static HashMap<String, Rectangle> parseSlippyTileFile(Resource slippyTileFile) {
        Integer size = Integer.parseInt(slippyTileFile.firstLine());
        HashMap<String, Rectangle> shardToBounds = new HashMap<String, Rectangle>(size);
        for (String line : slippyTileFile.lines()) {
            StringList splitLine = StringList.split((String)line, (String)"|");
            if (splitLine.size() != 2) continue;
            String boundsString = splitLine.get(0);
            String name = splitLine.get(1);
            Rectangle bounds = Rectangle.forString((String)boundsString);
            shardToBounds.put(name, bounds);
        }
        return shardToBounds;
    }

    public int buildAllPbfs(List<Resource> pbfFiles) {
        AtomicInteger count = new AtomicInteger();
        pbfFiles.parallelStream().forEach(pbfFile -> {
            RawAtlasGenerator rawAtlasGenerator = new RawAtlasGenerator(pbfFile, AtlasLoadingOption.createOptionWithNoSlicing(), MultiPolygon.MAXIMUM);
            try {
                rawAtlasGenerator.buildNoTrim();
                int currentCount = count.getAndIncrement();
                if (currentCount % 1000 == 0) {
                    logger.info("Processed {} PBF files.", (Object)currentCount);
                }
            }
            catch (Exception e) {
                throw new CoreException("Error while building {}!", new Object[]{pbfFile.getName(), e});
            }
        });
        return 0;
    }

    public int checkForMissingPbfs(HashMap<String, Rectangle> shardToBounds, List<Resource> pbfFiles, int expectedPbfCount) {
        List pbfFileNames = pbfFiles.stream().map(file -> file.getName()).collect(Collectors.toList());
        int pbfFileCount = pbfFileNames.size();
        Integer missingPbfCount = expectedPbfCount - pbfFileCount;
        if (missingPbfCount != 0) {
            logger.error("There are {} pbfs missing!", (Object)missingPbfCount);
            shardToBounds.keySet().forEach(pbfName -> {
                if (!pbfFileNames.contains(pbfName)) {
                    logger.error("{} is missing!", pbfName);
                }
            });
            return 1;
        }
        int returnCode = 0;
        for (Resource pbfFile : pbfFiles) {
            if (pbfFile.length() != 0L) continue;
            logger.error("{} is empty, and most likely corrupt!", (Object)pbfFile.getName());
            returnCode = 1;
        }
        if (returnCode == 0) {
            logger.info("There are no pbfs missing!");
        }
        return returnCode;
    }

    protected int onRun(CommandMap command) {
        Integer expectedPbfCount;
        String pbfPath = (String)command.get(PBF_PATH);
        File slippyTileFile = (File)command.get(SLIPPY_TILE_FILE);
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("fs.file.impl", "org.apache.hadoop.fs.LocalFileSystem");
        List<Resource> pbfFiles = FileSystemHelper.listResourcesRecursively(pbfPath, configuration, new PbfFilePathFilter());
        Time start = Time.now();
        HashMap<String, Rectangle> shardToBounds = PbfVerifier.parseSlippyTileFile((Resource)slippyTileFile);
        try {
            expectedPbfCount = Integer.parseInt(slippyTileFile.firstLine());
            int returnCode = this.checkForMissingPbfs(shardToBounds, pbfFiles, expectedPbfCount);
            if (returnCode != 0) {
                return returnCode;
            }
            this.buildAllPbfs(pbfFiles);
        }
        catch (NumberFormatException e) {
            logger.error("Couldn't parse the pbf count from the slippy tile file!");
            return 1;
        }
        logger.info("---------------------------------------------");
        logger.info("All {} pbfs are present and valid!", (Object)expectedPbfCount);
        logger.info("Verification ran in: {} minutes.", (Object)start.elapsedSince().asMinutes());
        logger.info("---------------------------------------------");
        return 0;
    }

    protected Command.SwitchList switches() {
        return new Command.SwitchList().with(new Command.Switch[]{SLIPPY_TILE_FILE, PBF_PATH});
    }
}

