/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.generator.creator;

import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.function.Function;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.generator.PbfLoader;
import org.openstreetmap.atlas.generator.PbfLocator;
import org.openstreetmap.atlas.generator.persistence.scheme.SlippyTilePersistenceScheme;
import org.openstreetmap.atlas.generator.sharding.AtlasSharding;
import org.openstreetmap.atlas.generator.tools.spark.utilities.SparkFileHelper;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.AtlasMetaData;
import org.openstreetmap.atlas.geography.atlas.AtlasResourceLoader;
import org.openstreetmap.atlas.geography.atlas.packed.PackedAtlas;
import org.openstreetmap.atlas.geography.atlas.pbf.AtlasLoadingOption;
import org.openstreetmap.atlas.geography.atlas.raw.creation.RawAtlasGenerator;
import org.openstreetmap.atlas.geography.atlas.raw.sectioning.WaySectionProcessor;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.RawAtlasCountrySlicer;
import org.openstreetmap.atlas.geography.boundary.CountryBoundaryMap;
import org.openstreetmap.atlas.geography.sharding.Shard;
import org.openstreetmap.atlas.geography.sharding.Sharding;
import org.openstreetmap.atlas.geography.sharding.SlippyTile;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.streaming.resource.FileSuffix;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.streaming.resource.WritableResource;
import org.openstreetmap.atlas.utilities.collections.Maps;
import org.openstreetmap.atlas.utilities.conversion.StringConverter;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawAtlasCreator
extends Command {
    public static final Command.Switch<CountryBoundaryMap> BOUNDARIES = new Command.Switch("boundaries", "The boundary map to use", value -> CountryBoundaryMap.fromPlainText((Resource)new File(value)), Command.Optionality.REQUIRED);
    public static final Command.Switch<String> COUNTRY = new Command.Switch("country", "The country code", StringConverter.IDENTITY, Command.Optionality.REQUIRED);
    public static final Command.Switch<File> OUTPUT = new Command.Switch("output", "The path where the output will be saved", value -> {
        File result = new File(value);
        result.mkdirs();
        return result;
    }, Command.Optionality.REQUIRED);
    public static final Command.Switch<String> PBF_PATH = new Command.Switch("pbfs", "The path to PBF shards needed to build the desired atlas", StringConverter.IDENTITY, Command.Optionality.REQUIRED);
    public static final Command.Switch<Boolean> FAIL_FAST_CACHE_MISS = new Command.Switch("failFastOnSlicedCacheMiss", "Fail fast on a sliced cache miss", Boolean::parseBoolean, Command.Optionality.OPTIONAL, "true");
    public static final Command.Switch<String> PBF_SHARDING = new Command.Switch("pbfSharding", "The sharding tree of the pbf files. If not specified, this will default to the general Atlas sharding.", StringConverter.IDENTITY, Command.Optionality.OPTIONAL);
    public static final Command.Switch<String> SHARDING_TYPE = new Command.Switch("sharding", "The sharding definition.", StringConverter.IDENTITY, Command.Optionality.REQUIRED);
    public static final Command.Switch<Shard> TILE = new Command.Switch("tile", "The SlippyTile name to use", SlippyTile::forName, Command.Optionality.REQUIRED);
    public static final Command.Switch<RawAtlasFlavor> ATLAS_FLAVOR = new Command.Switch("rawAtlasFlavor", "Which flavor of raw atlas - " + RawAtlasFlavor.RAW_ATLAS.toString() + ", " + RawAtlasFlavor.SLICED_ATLAS.toString() + ", or " + RawAtlasFlavor.SECTIONED_ATLAS.toString(), RawAtlasFlavor::flavorStringToRawAtlasFlavor, Command.Optionality.OPTIONAL, RawAtlasFlavor.SECTIONED_ATLAS.toString());
    public static final Command.Switch<Boolean> USE_JAVA_ATLAS = new Command.Switch("useJavaAtlas", "Use the Java serialization format.", Boolean::parseBoolean, Command.Optionality.OPTIONAL, "false");
    private static final Logger logger = LoggerFactory.getLogger(RawAtlasCreator.class);
    private static final String DEFAULT_RAW_ATLAS_CACHE_NAME = "__RawAtlasCreator_rawAtlasCache__";
    private static final String DEFAULT_LINE_SLICED_ATLAS_CACHE_NAME = "__RawAtlasCreator_lineSlicedAtlasCache__";
    private static final String DEFAULT_FULLY_SLICED_ATLAS_CACHE_NAME = "__RawAtlasCreator_fullySlicedAtlasCache__";
    private static final String DEFAULT_WATER_RELATION_SUB_ATLAS_CACHE_PATH = "__RawAtlasCreator_waterRelationSubAtlasCache__";
    private static final String USER_HOME = System.getProperty("user.home");
    public static final Command.Switch<String> LINE_SLICED_ATLAS_CACHE_PATH = new Command.Switch("lineSlicedAtlasCache", "The path to the line sliced atlas cache for DynamicAtlas", StringConverter.IDENTITY, Command.Optionality.OPTIONAL, SparkFileHelper.combine(USER_HOME, "__RawAtlasCreator_lineSlicedAtlasCache__"));
    public static final Command.Switch<String> WATER_RELATION_SUB_ATLAS_CACHE_PATH = new Command.Switch("waterRelationSubAtlasCache", "The path to the line-sliced water relation subatlas cache for DynamicAtlas", StringConverter.IDENTITY, Command.Optionality.OPTIONAL, SparkFileHelper.combine(USER_HOME, "__RawAtlasCreator_waterRelationSubAtlasCache__"));
    public static final Command.Switch<String> FULLY_SLICED_ATLAS_CACHE_PATH = new Command.Switch("fullySlicedAtlasCache", "The path to the fully sliced atlas cache for DynamicAtlas", StringConverter.IDENTITY, Command.Optionality.OPTIONAL, SparkFileHelper.combine(USER_HOME, "__RawAtlasCreator_fullySlicedAtlasCache__"));
    public static final Command.Switch<String> RAW_ATLAS_CACHE_PATH = new Command.Switch("rawAtlasCache", "The path to the sliced atlas cache for DynamicAtlas", StringConverter.IDENTITY, Command.Optionality.OPTIONAL, SparkFileHelper.combine(USER_HOME, "__RawAtlasCreator_rawAtlasCache__"));

    public static void main(String[] args) {
        new RawAtlasCreator().run(args);
    }

    protected int onRun(CommandMap command) {
        CountryBoundaryMap countryBoundaryMap = (CountryBoundaryMap)command.get(BOUNDARIES);
        Shard shardToBuild = (Shard)command.get(TILE);
        String pbfPath = (String)command.get(PBF_PATH);
        String rawAtlasCachePath = (String)command.get(RAW_ATLAS_CACHE_PATH);
        String lineSlicedAtlasCachePath = (String)command.get(LINE_SLICED_ATLAS_CACHE_PATH);
        String fullySlicedAtlasCachePath = (String)command.get(FULLY_SLICED_ATLAS_CACHE_PATH);
        boolean failFastOnSlicedCacheMiss = (Boolean)command.get(FAIL_FAST_CACHE_MISS);
        SlippyTilePersistenceScheme pbfScheme = SlippyTilePersistenceScheme.getSchemeInstanceFromString(PbfLocator.DEFAULT_SCHEME);
        String pbfShardingName = (String)command.get(PBF_SHARDING);
        String shardingName = (String)command.get(SHARDING_TYPE);
        Sharding sharding = AtlasSharding.forString(shardingName, Maps.stringMap((String[])new String[0]));
        Sharding pbfSharding = pbfShardingName != null ? AtlasSharding.forString(shardingName, Maps.stringMap((String[])new String[0])) : sharding;
        String countryName = (String)command.get(COUNTRY);
        File output = (File)command.get(OUTPUT);
        RawAtlasFlavor atlasFlavor = (RawAtlasFlavor)((Object)command.get(ATLAS_FLAVOR));
        boolean useJavaFormat = (Boolean)command.get(USE_JAVA_ATLAS);
        PbfLoader.setAtlasSaveFolder(output);
        PackedAtlas atlas = this.runGenerationForFlavor(atlasFlavor, countryBoundaryMap, shardToBuild, pbfPath, rawAtlasCachePath, lineSlicedAtlasCachePath, fullySlicedAtlasCachePath, failFastOnSlicedCacheMiss, failFastOnSlicedCacheMiss, pbfScheme, pbfSharding, sharding, countryName);
        if (useJavaFormat) {
            atlas.setSaveSerializationFormat(PackedAtlas.AtlasSerializationFormat.JAVA);
        } else {
            atlas.setSaveSerializationFormat(PackedAtlas.AtlasSerializationFormat.PROTOBUF);
        }
        atlas.save((WritableResource)output.child(countryName + "_" + shardToBuild.getName() + FileSuffix.ATLAS));
        atlas.saveAsGeoJson((WritableResource)output.child(countryName + "_" + shardToBuild.getName() + FileSuffix.GEO_JSON));
        return 0;
    }

    protected Command.SwitchList switches() {
        return new Command.SwitchList().with(new Command.Switch[]{BOUNDARIES, TILE, SHARDING_TYPE, PBF_PATH, RAW_ATLAS_CACHE_PATH, LINE_SLICED_ATLAS_CACHE_PATH, FULLY_SLICED_ATLAS_CACHE_PATH, FAIL_FAST_CACHE_MISS, PBF_SHARDING, COUNTRY, OUTPUT, ATLAS_FLAVOR, USE_JAVA_ATLAS});
    }

    private Optional<Atlas> fetchCachedAtlas(Shard shard, String countryName, String cachePath) {
        String shardName = shard.getName();
        String atlasName = countryName + "_" + shardName + FileSuffix.ATLAS;
        AtlasResourceLoader loader = new AtlasResourceLoader();
        Path cacheFile = Paths.get(cachePath, atlasName);
        Optional<Atlas> atlasOption = Optional.ofNullable(loader.load(new Resource[]{new File(cacheFile.toString())}));
        if (!atlasOption.isPresent()) {
            logger.warn("Sliced cache miss for {}", (Object)atlasName);
        } else {
            logger.info("Sliced cache hit for {}", (Object)atlasName);
        }
        return atlasOption;
    }

    private Function<Shard, Optional<Atlas>> fullySlicedAtlasFetcher(String countryName, CountryBoundaryMap countryBoundaryMap, String cachePath, Sharding sharding, Function<Shard, Optional<Atlas>> lineSlicedAtlasFetcher) {
        return (Function<Shard, Optional> & Serializable)shard -> {
            String filename = countryName + "_" + shard.getName() + FileSuffix.ATLAS;
            Optional<Atlas> fetchedAtlas = this.fetchCachedAtlas((Shard)shard, countryName, cachePath);
            if (fetchedAtlas.isPresent()) {
                return fetchedAtlas;
            }
            Atlas lineSlicedAtlas = this.generateFullySlicedAtlas(countryName, (Shard)shard, countryBoundaryMap, sharding, lineSlicedAtlasFetcher);
            this.saveAtlas(cachePath, filename, (PackedAtlas)lineSlicedAtlas);
            return Optional.of(lineSlicedAtlas);
        };
    }

    private Atlas generateFullySlicedAtlas(String countryName, Shard shardToBuild, CountryBoundaryMap countryBoundaryMap, Sharding sharding, Function<Shard, Optional<Atlas>> lineSlicedAtlasFetcher) {
        return new RawAtlasCountrySlicer(AtlasLoadingOption.createOptionWithAllEnabled((CountryBoundaryMap)countryBoundaryMap).setAdditionalCountryCodes(new String[]{countryName}), sharding, lineSlicedAtlasFetcher).sliceRelations(shardToBuild);
    }

    private Atlas generateLineSlicedAtlas(String countryName, CountryBoundaryMap countryBoundaryMap, Atlas rawAtlas) {
        return new RawAtlasCountrySlicer(AtlasLoadingOption.createOptionWithAllEnabled((CountryBoundaryMap)countryBoundaryMap).setAdditionalCountryCodes(new String[]{countryName})).sliceLines(rawAtlas);
    }

    private Atlas generateRawAtlas(String pbfPath, Shard shardToBuild) {
        String unknown = "unknown";
        RawAtlasGenerator rawAtlasGenerator = new RawAtlasGenerator((Resource)new File(this.getPBFFilePathFromDirectory(pbfPath, shardToBuild))).withMetaData(new AtlasMetaData(null, true, "unknown", "unknown", "unknown", shardToBuild.getName(), Maps.hashMap((Object[])new String[0])));
        return rawAtlasGenerator.build();
    }

    private Atlas generateSectionedAtlas(Shard shardToBuild, CountryBoundaryMap countryBoundaryMap, Sharding sharding, Function<Shard, Optional<Atlas>> fullySlicedAtlasFetcher) {
        WaySectionProcessor processor = new WaySectionProcessor(shardToBuild, AtlasLoadingOption.createOptionWithAllEnabled((CountryBoundaryMap)countryBoundaryMap), sharding, fullySlicedAtlasFetcher);
        return processor.run();
    }

    private String getPBFFilePathFromDirectory(String pbfPath, Shard shardToBuild) {
        Path pbfPathWithFile = Paths.get(pbfPath, shardToBuild.getName() + FileSuffix.PBF);
        return pbfPathWithFile.toString();
    }

    private Function<Shard, Optional<Atlas>> lineSlicedAtlasFetcher(String countryName, CountryBoundaryMap countryBoundaryMap, String lineSlicedCachePath, Function<Shard, Optional<Atlas>> rawAtlasFetcher) {
        return (Function<Shard, Optional> & Serializable)shard -> {
            String filename = countryName + "_" + shard.getName() + FileSuffix.ATLAS;
            Optional<Atlas> fetchedAtlas = this.fetchCachedAtlas((Shard)shard, countryName, lineSlicedCachePath);
            if (fetchedAtlas.isPresent()) {
                return fetchedAtlas;
            }
            Optional fetchedRawAtlas = (Optional)rawAtlasFetcher.apply((Shard)shard);
            if (fetchedRawAtlas.isPresent()) {
                Atlas lineSlicedAtlas = this.generateLineSlicedAtlas(countryName, countryBoundaryMap, (Atlas)fetchedRawAtlas.get());
                this.saveAtlas(lineSlicedCachePath, filename, (PackedAtlas)lineSlicedAtlas);
                return Optional.of(lineSlicedAtlas);
            }
            return Optional.empty();
        };
    }

    private Function<Shard, Optional<Atlas>> rawAtlasFetcher(String countryName, String cachePath, String pbfPath, boolean failFastOnRawAtlasCacheMiss) {
        return (Function<Shard, Optional> & Serializable)shard -> {
            String filename = countryName + "_" + shard.getName() + FileSuffix.ATLAS;
            Optional<Atlas> fetchedAtlas = this.fetchCachedAtlas((Shard)shard, countryName, cachePath);
            if (fetchedAtlas.isPresent()) {
                return fetchedAtlas;
            }
            if (failFastOnRawAtlasCacheMiss) {
                throw new CoreException("Failed to find raw Atlas file {} in cache!", new Object[]{shard});
            }
            Atlas rawAtlas = this.generateRawAtlas(pbfPath, (Shard)shard);
            this.saveAtlas(cachePath, filename, (PackedAtlas)rawAtlas);
            return Optional.of(rawAtlas);
        };
    }

    private PackedAtlas runGenerationForFlavor(RawAtlasFlavor atlasFlavor, CountryBoundaryMap countryBoundaryMap, Shard shardToBuild, String pbfPath, String rawAtlasCachePath, String lineSlicedCachePath, String fullySlicedCachePath, boolean failFastOnRawAtlasCacheMiss, boolean failFastOnSlicedCacheMiss, SlippyTilePersistenceScheme pbfScheme, Sharding pbfSharding, Sharding sharding, String countryName) {
        logger.info("Using raw atlas flavor {}", (Object)atlasFlavor);
        String filename = countryName + "_" + shardToBuild.getName() + FileSuffix.ATLAS;
        if (atlasFlavor == RawAtlasFlavor.RAW_ATLAS) {
            Atlas rawAtlas = this.generateRawAtlas(pbfPath, shardToBuild);
            this.saveAtlas(rawAtlasCachePath, filename, (PackedAtlas)rawAtlas);
            return (PackedAtlas)rawAtlas;
        }
        Function<Shard, Optional<Atlas>> rawAtlasFetcher = this.rawAtlasFetcher(countryName, rawAtlasCachePath, pbfPath, failFastOnRawAtlasCacheMiss);
        Function<Shard, Optional<Atlas>> lineSlicedAtlasFetcher = this.lineSlicedAtlasFetcher(countryName, countryBoundaryMap, lineSlicedCachePath, rawAtlasFetcher);
        Atlas fullySlicedAtlas = this.generateFullySlicedAtlas(countryName, shardToBuild, countryBoundaryMap, sharding, lineSlicedAtlasFetcher);
        if (atlasFlavor == RawAtlasFlavor.SLICED_ATLAS) {
            this.saveAtlas(fullySlicedCachePath, filename, (PackedAtlas)fullySlicedAtlas);
            return (PackedAtlas)fullySlicedAtlas;
        }
        Function<Shard, Optional<Atlas>> fullySlicedAtlasFetcher = this.fullySlicedAtlasFetcher(countryName, countryBoundaryMap, fullySlicedCachePath, sharding, lineSlicedAtlasFetcher);
        Atlas sectionedAtlas = this.generateSectionedAtlas(shardToBuild, countryBoundaryMap, sharding, fullySlicedAtlasFetcher);
        if (atlasFlavor == RawAtlasFlavor.SECTIONED_ATLAS) {
            return (PackedAtlas)sectionedAtlas;
        }
        throw new CoreException("RawAtlasFlavor value {} was invalid!", new Object[]{atlasFlavor.toString()});
    }

    private void saveAtlas(String cachePath, String filename, PackedAtlas atlas) {
        Path cacheFile = Paths.get(cachePath, filename);
        File atlasFile = new File(cacheFile.toString());
        atlas.setSaveSerializationFormat(PackedAtlas.AtlasSerializationFormat.PROTOBUF);
        atlas.save((WritableResource)atlasFile);
    }

    private static enum RawAtlasFlavor {
        RAW_ATLAS("raw"),
        LINE_SLICED_ATLAS("lineSliced"),
        RELATION_SLICED_ATLAS("relationSliced"),
        SLICED_ATLAS("sliced"),
        SECTIONED_ATLAS("sectioned");

        private final String flavorString;

        public static RawAtlasFlavor flavorStringToRawAtlasFlavor(String string) {
            for (RawAtlasFlavor flavor : RawAtlasFlavor.values()) {
                if (!flavor.toString().equalsIgnoreCase(string)) continue;
                return flavor;
            }
            throw new CoreException("Invalid RawAtlasFlavor {}", new Object[]{string});
        }

        private RawAtlasFlavor(String flavorString) {
            this.flavorString = flavorString;
        }

        public String toString() {
            return this.flavorString;
        }
    }
}

