/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.generator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.broadcast.Broadcast;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.generator.AtlasGenerationTask;
import org.openstreetmap.atlas.generator.AtlasGeneratorJobGroup;
import org.openstreetmap.atlas.generator.AtlasGeneratorParameters;
import org.openstreetmap.atlas.generator.AtlasLocator;
import org.openstreetmap.atlas.generator.PbfContext;
import org.openstreetmap.atlas.generator.PbfLoader;
import org.openstreetmap.atlas.generator.persistence.scheme.SlippyTilePersistenceScheme;
import org.openstreetmap.atlas.generator.tools.caching.HadoopAtlasFileCache;
import org.openstreetmap.atlas.generator.tools.json.PersistenceJsonParser;
import org.openstreetmap.atlas.generator.tools.spark.utilities.SparkFileHelper;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.AtlasResourceLoader;
import org.openstreetmap.atlas.geography.atlas.change.Change;
import org.openstreetmap.atlas.geography.atlas.change.FeatureChange;
import org.openstreetmap.atlas.geography.atlas.change.description.ChangeDescriptorType;
import org.openstreetmap.atlas.geography.atlas.change.diff.AtlasDiff;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.multi.MultiAtlas;
import org.openstreetmap.atlas.geography.atlas.pbf.AtlasLoadingOption;
import org.openstreetmap.atlas.geography.atlas.raw.sectioning.WaySectionProcessor;
import org.openstreetmap.atlas.geography.atlas.raw.slicing.RawAtlasCountrySlicer;
import org.openstreetmap.atlas.geography.atlas.statistics.AtlasStatistics;
import org.openstreetmap.atlas.geography.atlas.statistics.Counter;
import org.openstreetmap.atlas.geography.atlas.sub.AtlasCutType;
import org.openstreetmap.atlas.geography.boundary.CountryBoundaryMap;
import org.openstreetmap.atlas.geography.sharding.CountryShard;
import org.openstreetmap.atlas.geography.sharding.Shard;
import org.openstreetmap.atlas.geography.sharding.Sharding;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.utilities.collections.Maps;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.configuration.ConfiguredFilter;
import org.openstreetmap.atlas.utilities.runtime.system.memory.Memory;
import org.openstreetmap.atlas.utilities.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public final class AtlasGeneratorHelper
implements Serializable {
    public static final String STARTED_MESSAGE = "Starting task {} for shard {}";
    public static final String FINISHED_MESSAGE = "Finished task {} for shard {} in {}";
    public static final String ERROR_MESSAGE = "Error during task {} for shard {} :";
    public static final String MEMORY_MESSAGE = "Printing memory after task {} for shard{} :";
    private static final long serialVersionUID = 1300098384789754747L;
    private static final Logger logger = LoggerFactory.getLogger(AtlasGeneratorHelper.class);
    private static final String LINE_SLICED_SUBATLAS_NAMESPACE = "lineSlicedSubAtlas";
    private static final AtlasResourceLoader ATLAS_LOADER = new AtlasResourceLoader();

    public static Function<Shard, Optional<Atlas>> atlasFetcher(HadoopAtlasFileCache lineSlicedSubAtlasCache, Atlas initialShardAtlas, CountryBoundaryMap boundaries, String countryBeingSliced, Shard initialShard) {
        return (Function<Shard, Optional> & Serializable)shard -> {
            StringList countriesForShardList = boundaries.countryCodesOverlappingWith(shard.bounds());
            HashSet countriesForShard = new HashSet();
            AtlasResourceLoader loader = new AtlasResourceLoader();
            countriesForShardList.forEach(countriesForShard::add);
            HashSet atlases = new HashSet();
            countriesForShard.forEach(country -> {
                if (initialShard.equals(shard) && countryBeingSliced.equals(country)) {
                    logger.debug("While slicing {}, adding initial atlas for shard {} and country {}", new Object[]{countryBeingSliced, shard, country});
                    atlases.add(initialShardAtlas);
                } else {
                    Optional<Resource> cachedAtlas = lineSlicedSubAtlasCache.get((String)country, (Shard)shard);
                    if (cachedAtlas.isPresent()) {
                        logger.debug("{}: Cache hit, loading sliced subAtlas for Shard {} and country {}", new Object[]{countryBeingSliced, shard, country});
                        atlases.add(loader.load(new Resource[]{cachedAtlas.get()}));
                    }
                }
            });
            return atlases.isEmpty() ? Optional.empty() : Optional.ofNullable(new MultiAtlas(atlases));
        };
    }

    public static Function<Shard, Optional<Atlas>> atlasFetcher(HadoopAtlasFileCache subAtlasCache, HadoopAtlasFileCache atlasCache, String countryBeingSliced, Shard initialShard) {
        return (Function<Shard, Optional> & Serializable)shard -> {
            Optional<Resource> cachedInitialShardResource = shard.equals(initialShard) ? atlasCache.get(countryBeingSliced, (Shard)shard) : subAtlasCache.get(countryBeingSliced, (Shard)shard);
            if (!cachedInitialShardResource.isPresent()) {
                logger.error("{}: No Atlas file found for initial Shard {}!", (Object)countryBeingSliced, shard);
                return Optional.empty();
            }
            return Optional.ofNullable(ATLAS_LOADER.load(new Resource[]{cachedInitialShardResource.get()}));
        };
    }

    protected static PairFunction<Tuple2<String, Atlas>, String, List<FeatureChange>> computeAtlasDiff(Map<String, String> sparkContext, String previousOutputForDelta) {
        return (PairFunction & Serializable)tuple -> {
            String countryShardName = AtlasGeneratorHelper.getCountryShard((String)tuple._1()).getName();
            Atlas current = (Atlas)tuple._2();
            logger.info(STARTED_MESSAGE, (Object)AtlasGeneratorJobGroup.DIFFS.getDescription(), (Object)countryShardName);
            Time start = Time.now();
            Optional<Atlas> alter = new AtlasLocator(sparkContext).atlasForShard(SparkFileHelper.combine(previousOutputForDelta, StringList.split((String)countryShardName, (String)"_").get(0)), countryShardName);
            if (!alter.isPresent()) {
                logger.error("No atlas found for {}!", (Object)countryShardName);
                return new Tuple2((Object)((String)tuple._1()), null);
            }
            Optional diffChange = new AtlasDiff(alter.get(), current).generateChange();
            ArrayList diffsList = new ArrayList();
            if (diffChange.isPresent()) {
                diffsList.addAll(((Change)diffChange.get()).changes().collect(Collectors.toList()));
                Map tagMap = ((Change)diffChange.get()).tagCountMap();
                for (ItemType itemType : ItemType.values()) {
                    for (ChangeDescriptorType changeDescriptorType : ChangeDescriptorType.values()) {
                        ((Map)((Map)tagMap.get(itemType)).get(changeDescriptorType)).entrySet().forEach(entry -> logger.info("AtlasDiff Tag Summary: {} {} tag {} for {} {}", new Object[]{countryShardName, changeDescriptorType, entry.getKey(), entry.getValue(), itemType}));
                        long count = diffsList.stream().filter(diff -> diff.getItemType().equals((Object)itemType) && diff.explain().getChangeDescriptorType().equals((Object)changeDescriptorType)).count();
                        logger.info("AtlasDiff Change Summary: {} {} {} {}", new Object[]{countryShardName, changeDescriptorType, count, itemType});
                    }
                }
            }
            logger.info(FINISHED_MESSAGE, new Object[]{AtlasGeneratorJobGroup.DIFFS.getDescription(), countryShardName, start.elapsedSince().asMilliseconds()});
            logger.info(MEMORY_MESSAGE, (Object)AtlasGeneratorJobGroup.DIFFS.getDescription(), (Object)countryShardName);
            Memory.printCurrentMemory();
            return new Tuple2((Object)((String)tuple._1()), diffsList);
        };
    }

    protected static PairFunction<Tuple2<String, Atlas>, String, AtlasStatistics> generateAtlasStatistics(Broadcast<Sharding> sharding) {
        return (PairFunction & Serializable)tuple -> {
            String countryShardName = AtlasGeneratorHelper.getCountryShard((String)tuple._1()).getName();
            logger.info(STARTED_MESSAGE, (Object)AtlasGeneratorJobGroup.SHARD_STATISTICS.getDescription(), (Object)countryShardName);
            Time start = Time.now();
            Counter counter = new Counter().withSharding((Sharding)sharding.getValue());
            counter.setCountsDefinition((Resource)Counter.POI_COUNTS_DEFINITION.getDefault());
            AtlasStatistics statistics = new AtlasStatistics();
            try {
                statistics = counter.processAtlas((Atlas)tuple._2());
            }
            catch (Exception e) {
                logger.error(ERROR_MESSAGE, new Object[]{AtlasGeneratorJobGroup.SHARD_STATISTICS.getDescription(), countryShardName, e});
            }
            logger.info(FINISHED_MESSAGE, new Object[]{AtlasGeneratorJobGroup.SHARD_STATISTICS.getDescription(), countryShardName, start.elapsedSince().asMilliseconds()});
            return new Tuple2((Object)((String)tuple._1()), (Object)statistics);
        };
    }

    protected static PairFunction<AtlasGenerationTask, String, Atlas> generateRawAtlas(Broadcast<CountryBoundaryMap> boundaries, Map<String, String> sparkContext, Broadcast<Map<String, String>> loadingOptions, PbfContext pbfContext, SlippyTilePersistenceScheme atlasScheme) {
        return (PairFunction & Serializable)task -> {
            Atlas atlas;
            String countryName = task.getCountry();
            Shard shard = task.getShard();
            String name = countryName + "_" + shard.getName();
            logger.info(STARTED_MESSAGE, (Object)AtlasGeneratorJobGroup.RAW.getDescription(), (Object)name);
            Time start = Time.now();
            AtlasLoadingOption atlasLoadingOption = AtlasGeneratorParameters.buildAtlasLoadingOption((CountryBoundaryMap)boundaries.getValue(), (Map)loadingOptions.getValue());
            atlasLoadingOption.setAdditionalCountryCodes(new String[]{countryName});
            PbfLoader loader = new PbfLoader(pbfContext, sparkContext, (CountryBoundaryMap)boundaries.getValue(), atlasLoadingOption, (String)((Map)loadingOptions.getValue()).get(AtlasGeneratorParameters.CODE_VERSION.getName()), (String)((Map)loadingOptions.getValue()).get(AtlasGeneratorParameters.DATA_VERSION.getName()), task.getAllShards());
            try {
                atlas = loader.generateRawAtlas(countryName, shard);
            }
            catch (Throwable e) {
                throw new CoreException(ERROR_MESSAGE, new Object[]{AtlasGeneratorJobGroup.RAW.getDescription(), name, e});
            }
            logger.info(FINISHED_MESSAGE, new Object[]{AtlasGeneratorJobGroup.RAW.getDescription(), name, start.elapsedSince().asMilliseconds()});
            logger.info(MEMORY_MESSAGE, (Object)AtlasGeneratorJobGroup.RAW.getDescription(), (Object)name);
            Memory.printCurrentMemory();
            String persistenceKey = PersistenceJsonParser.createJsonKey(countryName, shard.getName(), atlasScheme.getScheme());
            return new Tuple2((Object)persistenceKey, (Object)atlas);
        };
    }

    protected static PairFunction<Tuple2<String, AtlasStatistics>, String, NamedAtlasStatistics> groupAtlasStatisticsByCountry() {
        return (PairFunction & Serializable)tuple -> {
            CountryShard countryShardName = AtlasGeneratorHelper.getCountryShard((String)tuple._1());
            String countryName = countryShardName.getCountry();
            return new Tuple2((Object)PersistenceJsonParser.createJsonKey(countryName, "N/A", Maps.hashMap((Object[])new String[0])), (Object)new NamedAtlasStatistics(countryName, (AtlasStatistics)tuple._2()));
        };
    }

    protected static Function2<NamedAtlasStatistics, NamedAtlasStatistics, NamedAtlasStatistics> reduceAtlasStatistics() {
        return (Function2 & Serializable)(left, right) -> {
            try {
                return new NamedAtlasStatistics(left.getName(), AtlasStatistics.merge((AtlasStatistics[])new AtlasStatistics[]{left.getAtlasStatistics(), right.getAtlasStatistics()}));
            }
            catch (Throwable e) {
                logger.error("Unable to merge AtlasStatistics for {}! Returning the first one only.\nLeft:\n{}\nRight:\n{}", new Object[]{left.getName(), left.getAtlasStatistics(), right.getAtlasStatistics(), e});
                return left;
            }
        };
    }

    protected static PairFunction<Tuple2<String, Atlas>, String, Atlas> sectionAtlas(Broadcast<CountryBoundaryMap> boundaries, Broadcast<Sharding> sharding, Map<String, String> sparkContext, Broadcast<Map<String, String>> loadingOptions, String edgeSubAtlasPath, String slicedAtlasPath, SlippyTilePersistenceScheme atlasScheme) {
        return (PairFunction & Serializable)tuple -> {
            Atlas atlas;
            CountryShard countryShard = AtlasGeneratorHelper.getCountryShard((String)tuple._1());
            String countryShardName = countryShard.getName();
            logger.info(STARTED_MESSAGE, (Object)AtlasGeneratorJobGroup.FULLY_SLICED.getDescription(), (Object)countryShardName);
            Time start = Time.now();
            AtlasLoadingOption atlasLoadingOption = AtlasGeneratorParameters.buildAtlasLoadingOption((CountryBoundaryMap)boundaries.getValue(), (Map)loadingOptions.getValue());
            HadoopAtlasFileCache atlasCache = new HadoopAtlasFileCache(slicedAtlasPath, atlasScheme, sparkContext);
            HadoopAtlasFileCache edgeSubCache = new HadoopAtlasFileCache(edgeSubAtlasPath, atlasScheme, sparkContext);
            Function<Shard, Optional<Atlas>> slicedRawAtlasFetcher = AtlasGeneratorHelper.atlasFetcher(edgeSubCache, atlasCache, countryShard.getCountry(), countryShard.getShard());
            try {
                atlas = new WaySectionProcessor(countryShard.getShard(), atlasLoadingOption, (Sharding)sharding.getValue(), slicedRawAtlasFetcher).run();
            }
            catch (Throwable e) {
                throw new CoreException(ERROR_MESSAGE, new Object[]{AtlasGeneratorJobGroup.WAY_SECTIONED_PBF.getDescription(), countryShardName, e});
            }
            logger.info(FINISHED_MESSAGE, new Object[]{AtlasGeneratorJobGroup.WAY_SECTIONED_PBF.getDescription(), countryShardName, start.elapsedSince().asMilliseconds()});
            logger.info(MEMORY_MESSAGE, (Object)AtlasGeneratorJobGroup.WAY_SECTIONED_PBF.getDescription(), (Object)countryShardName);
            Memory.printCurrentMemory();
            return new Tuple2((Object)((String)tuple._1()), (Object)atlas);
        };
    }

    protected static PairFunction<Tuple2<String, Atlas>, String, Atlas> sliceLines(Broadcast<CountryBoundaryMap> boundaries, Broadcast<Map<String, String>> loadingOptions) {
        return (PairFunction & Serializable)tuple -> {
            Atlas slicedAtlas;
            CountryShard countryShard = AtlasGeneratorHelper.getCountryShard((String)tuple._1());
            String countryShardName = countryShard.getName();
            Atlas rawAtlas = (Atlas)tuple._2();
            logger.info(STARTED_MESSAGE, (Object)AtlasGeneratorJobGroup.LINE_SLICED.getDescription(), (Object)countryShardName);
            Time start = Time.now();
            try {
                AtlasLoadingOption atlasLoadingOption = AtlasGeneratorParameters.buildAtlasLoadingOption((CountryBoundaryMap)boundaries.getValue(), (Map)loadingOptions.getValue());
                atlasLoadingOption.setAdditionalCountryCodes(new String[]{countryShard.getCountry()});
                logger.error("Country codes during line slicing was: {}", (Object)atlasLoadingOption.getCountryCodes());
                slicedAtlas = new RawAtlasCountrySlicer(atlasLoadingOption).sliceLines(rawAtlas);
            }
            catch (Throwable e) {
                throw new CoreException(ERROR_MESSAGE, new Object[]{AtlasGeneratorJobGroup.LINE_SLICED.getDescription(), countryShardName, e});
            }
            logger.info(FINISHED_MESSAGE, new Object[]{AtlasGeneratorJobGroup.LINE_SLICED.getDescription(), countryShardName, start.elapsedSince().asMilliseconds()});
            logger.info(MEMORY_MESSAGE, (Object)AtlasGeneratorJobGroup.LINE_SLICED.getDescription(), (Object)countryShardName);
            Memory.printCurrentMemory();
            return new Tuple2((Object)((String)tuple._1()), (Object)slicedAtlas);
        };
    }

    protected static PairFunction<Tuple2<String, Atlas>, String, Atlas> sliceRelations(Broadcast<CountryBoundaryMap> boundaries, Broadcast<Map<String, String>> loadingOptions, Broadcast<Sharding> sharding, String lineSlicedSubAtlasPath, SlippyTilePersistenceScheme atlasScheme, Map<String, String> sparkContext) {
        return (PairFunction & Serializable)tuple -> {
            Atlas slicedAtlas;
            CountryShard countryShard = AtlasGeneratorHelper.getCountryShard((String)tuple._1());
            String countryShardName = countryShard.getName();
            Atlas rawAtlas = (Atlas)tuple._2();
            logger.info(STARTED_MESSAGE, (Object)AtlasGeneratorJobGroup.FULLY_SLICED.getDescription(), (Object)countryShardName);
            Time start = Time.now();
            try {
                HadoopAtlasFileCache lineSlicedSubAtlasCache = new HadoopAtlasFileCache(lineSlicedSubAtlasPath, LINE_SLICED_SUBATLAS_NAMESPACE, atlasScheme, sparkContext);
                Function<Shard, Optional<Atlas>> atlasFetcher = AtlasGeneratorHelper.atlasFetcher(lineSlicedSubAtlasCache, rawAtlas, (CountryBoundaryMap)boundaries.getValue(), countryShard.getCountry(), countryShard.getShard());
                AtlasLoadingOption atlasLoadingOption = AtlasGeneratorParameters.buildAtlasLoadingOption((CountryBoundaryMap)boundaries.getValue(), (Map)loadingOptions.getValue());
                atlasLoadingOption.setAdditionalCountryCodes(new String[]{countryShard.getCountry()});
                slicedAtlas = new RawAtlasCountrySlicer(atlasLoadingOption, (Sharding)sharding.getValue(), atlasFetcher).sliceRelations(countryShard.getShard());
            }
            catch (Throwable e) {
                throw new CoreException(ERROR_MESSAGE, new Object[]{AtlasGeneratorJobGroup.FULLY_SLICED.getDescription(), countryShardName, e});
            }
            logger.info(FINISHED_MESSAGE, new Object[]{AtlasGeneratorJobGroup.FULLY_SLICED.getDescription(), countryShardName, start.elapsedSince().asMilliseconds()});
            logger.info(MEMORY_MESSAGE, (Object)AtlasGeneratorJobGroup.FULLY_SLICED.getDescription(), (Object)countryShardName);
            Memory.printCurrentMemory();
            return new Tuple2((Object)((String)tuple._1()), (Object)slicedAtlas);
        };
    }

    protected static PairFunction<Tuple2<String, Atlas>, String, Atlas> subatlas(ConfiguredFilter filter, AtlasCutType cutType) {
        return (PairFunction & Serializable)tuple -> {
            Atlas subAtlas;
            String countryShardName = AtlasGeneratorHelper.getCountryShard((String)tuple._1()).getName();
            Atlas originalAtlas = (Atlas)tuple._2();
            logger.info("Starting sub Atlas for for Atlas {}", (Object)originalAtlas.getName());
            Time start = Time.now();
            try {
                Optional subAtlasOptional = originalAtlas.subAtlas(arg_0 -> ((ConfiguredFilter)filter).test(arg_0), cutType);
                if (subAtlasOptional.isPresent()) {
                    subAtlas = (Atlas)subAtlasOptional.get();
                } else {
                    subAtlas = null;
                    logger.error("Unable to extract valid subAtlas code for {}", (Object)countryShardName);
                }
            }
            catch (Exception e) {
                throw new CoreException("Sub Atlas failed for {}", new Object[]{countryShardName, e});
            }
            logger.info("Finished sub Atlas for {} in {}", (Object)countryShardName, (Object)start.elapsedSince());
            logger.info("Printing memory after loading sub Atlas for {}", (Object)countryShardName);
            Memory.printCurrentMemory();
            return new Tuple2((Object)((String)tuple._1()), (Object)subAtlas);
        };
    }

    protected static PairFunction<Tuple2<String, Atlas>, String, Atlas> subatlas(Predicate<Taggable> filter, AtlasCutType cutType) {
        return (PairFunction & Serializable)tuple -> {
            Atlas subAtlas;
            String countryShardName = AtlasGeneratorHelper.getCountryShard((String)tuple._1()).getName();
            Atlas originalAtlas = (Atlas)tuple._2();
            logger.info("Starting sub Atlas for for Atlas {}", (Object)originalAtlas.getName());
            Time start = Time.now();
            try {
                Optional subAtlasOptional = originalAtlas.subAtlas(filter::test, cutType);
                if (subAtlasOptional.isPresent()) {
                    subAtlas = (Atlas)subAtlasOptional.get();
                } else {
                    subAtlas = null;
                    logger.error("Unable to extract valid subAtlas code for {}", (Object)countryShardName);
                }
            }
            catch (Exception e) {
                throw new CoreException("Sub Atlas failed for {}", new Object[]{countryShardName, e});
            }
            logger.info("Finished sub Atlas for {} in {}", (Object)countryShardName, (Object)start.elapsedSince());
            logger.info("Printing memory after loading sub Atlas for {}", (Object)countryShardName);
            Memory.printCurrentMemory();
            return new Tuple2((Object)((String)tuple._1()), (Object)subAtlas);
        };
    }

    private static CountryShard getCountryShard(String jsonKey) {
        return new CountryShard(PersistenceJsonParser.parseCountry(jsonKey), PersistenceJsonParser.parseShard(jsonKey));
    }

    private AtlasGeneratorHelper() {
    }

    protected static class NamedAtlasStatistics
    implements Serializable {
        private static final long serialVersionUID = 1593790111775268766L;
        private final String name;
        private final AtlasStatistics atlasStatistics;

        public NamedAtlasStatistics(String name, AtlasStatistics atlasStatistics) {
            this.name = name;
            this.atlasStatistics = atlasStatistics;
        }

        public AtlasStatistics getAtlasStatistics() {
            return this.atlasStatistics;
        }

        public String getName() {
            return this.name;
        }
    }
}

