/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.generator.tools.spark.persistence;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.generator.sharding.AtlasSharding;
import org.openstreetmap.atlas.generator.tools.spark.SparkJob;
import org.openstreetmap.atlas.generator.tools.spark.converters.ConfigurationConverter;
import org.openstreetmap.atlas.geography.boundary.CountryBoundaryMap;
import org.openstreetmap.atlas.geography.sharding.Sharding;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.utilities.runtime.Command;

public class PersistenceTools {
    public static final String SHARDING_FILE = "sharding.txt";
    public static final String BOUNDARIES_FILE = "boundaries.txt.gz";
    public static final String SHARDING_META = "sharding.meta";
    public static final String BOUNDARIES_META = "boundaries.meta";
    public static final Command.Switch<Boolean> COPY_SHARDING_AND_BOUNDARIES = new Command.Switch("copyShardingAndBoundaries", "Copy the sharding tree and boundary file used in this job, if any", Boolean::parseBoolean, Command.Optionality.OPTIONAL, "false");
    private static final Integer BUFFER_SIZE = 4096;
    private final Map<String, String> configurationMap;

    public PersistenceTools(Map<String, String> configurationMap) {
        this.configurationMap = configurationMap;
    }

    public CountryBoundaryMap boundaries(String input) {
        return CountryBoundaryMap.fromPlainText((Resource)SparkJob.resource(this.appendDirectorySeparator(input) + BOUNDARIES_FILE, this.configurationMap));
    }

    public void copyShardingAndBoundariesToOutput(String input, String output) {
        this.copyToOutput(input, output, SHARDING_FILE);
        this.copyToOutput(input, output, SHARDING_META);
        this.copyToOutput(input, output, BOUNDARIES_FILE);
        this.copyToOutput(input, output, BOUNDARIES_META);
    }

    public Sharding sharding(String input) {
        Configuration hadoopConfiguration = this.hadoopConfiguration();
        Path inputPath = new Path(this.appendDirectorySeparator(input) + SHARDING_FILE);
        return AtlasSharding.forString("dynamic@" + inputPath.toUri().toString(), hadoopConfiguration);
    }

    private String appendDirectorySeparator(String input) {
        String inputString = input.endsWith("/") ? input : input + "/";
        return inputString;
    }

    private void copyToOutput(String input, String output, String name) {
        Path inputPath = new Path(this.appendDirectorySeparator(input) + name);
        Path outputPath = new Path(this.appendDirectorySeparator(output) + name);
        Configuration configuration = this.hadoopConfiguration();
        try (FSDataInputStream inputStream = inputPath.getFileSystem(configuration).open(inputPath);
             FSDataOutputStream outputStream = outputPath.getFileSystem(configuration).create(outputPath);){
            if (inputStream == null) {
                throw new CoreException("{} does not exist and thus cannot be copied to the output.", new Object[]{inputPath});
            }
            IOUtils.copyBytes((InputStream)inputStream, (OutputStream)outputStream, (int)BUFFER_SIZE, (boolean)true);
        }
        catch (IOException e) {
            throw new CoreException("Unable to copy {} to {}", new Object[]{input, output, e});
        }
    }

    private Configuration hadoopConfiguration() {
        return ConfigurationConverter.mapToHadoopConfiguration(this.configurationMap);
    }
}

