/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.generator.sharding;

import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.atlas.AtlasResourceLoader;
import org.openstreetmap.atlas.geography.sharding.CountryShard;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.streaming.writers.SafeBufferedWriter;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;

public class AtlasShardVerifier
extends Command {
    private static final Command.Switch<File> ATLAS_FOLDER = new Command.Switch("atlasFolder", "Folder containing Atlas Shards named by the AtlasGenerator", File::new);
    private static final Command.Switch<Set<CountryShard>> EXPECTED_SHARDS = new Command.Switch("expectedShards", "Text file containing all the expected shards", value -> new File(value).linesList().stream().map(CountryShard::forName).collect(Collectors.toSet()));
    private static final Command.Switch<File> OUTPUT = new Command.Switch("output", "The file to list all the missing shards", File::new);

    public static void main(String[] args) {
        new AtlasShardVerifier().run(args);
    }

    protected int onRun(CommandMap command) {
        File atlasFolder = (File)command.get(ATLAS_FOLDER);
        File output = (File)command.get(OUTPUT);
        Set expectedShards = (Set)command.get(EXPECTED_SHARDS);
        Set existingShards = atlasFolder.listFilesRecursively().stream().filter(AtlasResourceLoader.IS_ATLAS).map(File::getName).map(name -> StringList.split((String)name, (String)".").get(0)).map(CountryShard::forName).collect(Collectors.toSet());
        expectedShards.removeAll(existingShards);
        try (SafeBufferedWriter writer = output.writer();){
            expectedShards.stream().map(CountryShard::toString).forEach(arg_0 -> ((SafeBufferedWriter)writer).writeLine(arg_0));
        }
        catch (Exception e) {
            throw new CoreException("Verification failed", (Throwable)e);
        }
        return 0;
    }

    protected Command.SwitchList switches() {
        return new Command.SwitchList().with(new Command.Switch[]{ATLAS_FOLDER, EXPECTED_SHARDS, OUTPUT});
    }
}

