/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.generator.tools.streaming.resource;

import com.google.common.collect.AbstractIterator;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.generator.tools.streaming.resource.HDFSFile;

public final class HDFSWalker {
    public static final int WALK_ALL = -1;
    private Configuration configuration;
    private final int maxDepth;

    public static HDFSFile convert(FileStatus status) {
        try {
            return new HDFSFile(status.getPath());
        }
        catch (IOException oops) {
            throw new CoreException("Error when converting FileStatus to HDFSFile", (Throwable)oops);
        }
    }

    public static Function<FileStatus, FileStatus> debug(Consumer<String> printer) {
        return status -> {
            char type = status.isSymlink() ? (char)'S' : (status.isDirectory() ? (char)'D' : (char)'F');
            printer.accept(String.format("[%c] %s", Character.valueOf(type), status.getPath()));
            return status;
        };
    }

    public static Function<FileStatus, FileStatus> size(AtomicLong value) {
        return status -> {
            value.addAndGet(status.getLen());
            return status;
        };
    }

    public HDFSWalker() {
        this.maxDepth = -1;
    }

    public HDFSWalker(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    public HDFSWalker usingConfiguration(Configuration configuration) {
        this.configuration = configuration;
        return this;
    }

    public Stream<FileStatus> walk(Path root) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new HDFSIterator(root, this.getConfiguration(), this.maxDepth), 16), false);
    }

    public Stream<HDFSFile> walkFiles(Path root) {
        return this.walk(root).filter(FileStatus::isFile).map(HDFSWalker::convert);
    }

    private Configuration getConfiguration() {
        return this.configuration == null ? new Configuration() : this.configuration;
    }

    private static final class HDFSIterator
    extends AbstractIterator<FileStatus> {
        private static final int ONE = 1;
        private final Queue<FileStatusAtDepth> currentPaths;
        private final FileSystem fileSystem;
        private final int maxDepth;

        private HDFSIterator(Path root, Configuration configuration) {
            this(root, configuration, -1);
        }

        private HDFSIterator(Path root, Configuration configuration, int maxDepth) {
            if (root == null) {
                throw new CoreException("Error when creating an HDFSIterator: root can't be null");
            }
            this.maxDepth = maxDepth;
            try {
                this.currentPaths = new LinkedList<FileStatusAtDepth>();
                this.fileSystem = root.getFileSystem(configuration);
                Stream.of(this.fileSystem.listStatus(root)).forEach(status -> this.currentPaths.add(new FileStatusAtDepth((FileStatus)status, 1)));
            }
            catch (IOException oops) {
                throw new CoreException("Error when creating an HDFSIterator", (Throwable)oops);
            }
        }

        protected FileStatus computeNext() {
            if (this.currentPaths.isEmpty()) {
                return (FileStatus)this.endOfData();
            }
            FileStatusAtDepth returnValue = this.currentPaths.remove();
            FileStatus currentFileStatus = returnValue.getFileStatus();
            int currentFileDepth = returnValue.getFileDepth();
            if (currentFileStatus.isDirectory()) {
                int childDepth = currentFileDepth + 1;
                if (this.maxDepth == -1 || childDepth <= this.maxDepth) {
                    try {
                        Stream.of(this.fileSystem.listStatus(currentFileStatus.getPath())).forEach(status -> this.currentPaths.add(new FileStatusAtDepth((FileStatus)status, childDepth)));
                    }
                    catch (IOException oops) {
                        throw new CoreException("Can't locate children of {}", new Object[]{currentFileStatus, oops});
                    }
                }
            }
            return currentFileStatus;
        }
    }

    private static final class FileStatusAtDepth {
        private final int fileDepth;
        private final FileStatus fileStatus;

        private FileStatusAtDepth(FileStatus fileStatus, int fileLevel) {
            this.fileStatus = fileStatus;
            this.fileDepth = fileLevel;
        }

        public int getFileDepth() {
            return this.fileDepth;
        }

        public FileStatus getFileStatus() {
            return this.fileStatus;
        }
    }
}

