/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.generator.tools.spark.utilities;

import java.io.Serializable;
import java.util.function.Consumer;
import org.openstreetmap.atlas.generator.tools.spark.utilities.SparkFileHelper;
import org.openstreetmap.atlas.generator.tools.spark.utilities.SparkFilePath;
import org.openstreetmap.atlas.streaming.resource.WritableResource;

public final class SparkFileOutput
implements Serializable {
    private static final long serialVersionUID = 4719291632105671724L;
    private final Consumer<WritableResource> saveFunction;
    private final SparkFilePath path;
    private final String operationName;

    public static SparkFileOutput from(Consumer<WritableResource> saveFunction, SparkFilePath folderPath, String fileName, String extension, String operationName) {
        String fileNameWithExtension = fileName + SparkFileHelper.extensionStartingWithSeparator(extension);
        SparkFilePath filePath = new SparkFilePath(SparkFileHelper.combine(folderPath.getTemporaryPath(), fileNameWithExtension), SparkFileHelper.combine(folderPath.getTargetPath(), fileNameWithExtension));
        return new SparkFileOutput(saveFunction, filePath, operationName);
    }

    public static SparkFileOutput from(Consumer<WritableResource> saveFunction, String parentFolder, String targetFolder, String folder, String fileName, String extension, String operationName) {
        return new SparkFileOutput(saveFunction, SparkFileOutput.getFilePath(targetFolder, parentFolder, folder, fileName, extension), operationName);
    }

    private static SparkFilePath getFilePath(String targetFolder, String parentFolder, String folder, String fileName, String extension) {
        String fileNameWithFolderAndExtension = SparkFileHelper.combine(folder, fileName + SparkFileHelper.extensionStartingWithSeparator(extension));
        return new SparkFilePath(SparkFileHelper.combine(parentFolder, fileNameWithFolderAndExtension), SparkFileHelper.combine(targetFolder, fileNameWithFolderAndExtension));
    }

    private SparkFileOutput(Consumer<WritableResource> saveFunc, SparkFilePath path, String operationName) {
        this.saveFunction = saveFunc;
        this.path = path;
        this.operationName = operationName;
    }

    public String getOperationName() {
        return this.operationName;
    }

    public SparkFilePath getPath() {
        return this.path;
    }

    public Consumer<WritableResource> getSaveFunction() {
        return this.saveFunction;
    }
}

