/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.generator.tools.spark.context;

import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.generator.tools.spark.context.SparkContextProvider;
import org.openstreetmap.atlas.utilities.conversion.StringConverter;

public class SparkContextProviderFinder
implements StringConverter<SparkContextProvider> {
    public SparkContextProvider convert(String value) {
        try {
            Class<?> clazz = Class.forName(value);
            if (!SparkContextProvider.class.isAssignableFrom(clazz)) {
                throw new CoreException("Class {} is not a SparkContextProvider.", new Object[]{clazz.getName()});
            }
            return (SparkContextProvider)clazz.newInstance();
        }
        catch (Exception e) {
            throw new CoreException("Cannot instantiate SparkContextProvider", (Throwable)e);
        }
    }
}

