/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.generator.tools.filesystem;

import java.util.concurrent.Callable;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.utilities.scalars.Duration;
import org.openstreetmap.atlas.utilities.threads.Pool;
import org.openstreetmap.atlas.utilities.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileSystemPerformanceHelper {
    private static final Logger logger = LoggerFactory.getLogger(FileSystemPerformanceHelper.class);
    public static final int NUMBER_POOL_THREADS = 50;
    public static final int POOL_MINUTES_BEFORE_KILL = 30;
    private static Pool RENAME_POOL = null;

    public static boolean executeRename(Callable<Boolean> renameOperation) {
        if (RENAME_POOL == null) {
            try {
                return renameOperation.call();
            }
            catch (Exception e) {
                throw new CoreException("Unable to run rename operation", (Throwable)e);
            }
        }
        RENAME_POOL.queue(renameOperation);
        return true;
    }

    public static void openRenamePool() {
        logger.warn("Opening rename thread pool!");
        RENAME_POOL = new Pool(50, "renamePool");
    }

    public static void waitForAndCloseRenamePool() {
        logger.warn("Closing rename thread pool!");
        Time start = Time.now();
        Duration maxDuration = Duration.minutes((double)30.0);
        RENAME_POOL.end(maxDuration);
        RENAME_POOL = null;
        logger.warn("Closed rename thread pool in {}!", (Object)start.elapsedSince());
    }

    private FileSystemPerformanceHelper() {
    }
}

