/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.generator.sharding;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.http.HttpHost;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.index.strtree.STRtree;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.generator.sharding.OverpassClient;
import org.openstreetmap.atlas.generator.sharding.OverpassOsmNode;
import org.openstreetmap.atlas.generator.sharding.OverpassOsmWay;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.MultiPolygon;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Rectangle;
import org.openstreetmap.atlas.geography.boundary.CountryBoundary;
import org.openstreetmap.atlas.geography.boundary.CountryBoundaryMap;
import org.openstreetmap.atlas.geography.clipping.Clip;
import org.openstreetmap.atlas.geography.sharding.CountryShard;
import org.openstreetmap.atlas.streaming.resource.File;
import org.openstreetmap.atlas.streaming.resource.InputStreamResource;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.streaming.writers.SafeBufferedWriter;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.filters.ConfiguredTaggableFilter;
import org.openstreetmap.atlas.utilities.collections.StringList;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.configuration.StandardConfiguration;
import org.openstreetmap.atlas.utilities.runtime.Command;
import org.openstreetmap.atlas.utilities.runtime.CommandMap;
import org.openstreetmap.atlas.utilities.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtlasMissingShardVerifier
extends Command {
    private static final Logger logger = LoggerFactory.getLogger(AtlasMissingShardVerifier.class);
    private static final String FILTER_CONFIG = "/org/openstreetmap/atlas/geography/atlas/pbf/osm-pbf-way.json";
    private static final Command.Switch<CountryBoundaryMap> BOUNDARIES = new Command.Switch("boundaries", "The country boundaries.", value -> AtlasMissingShardVerifier.initializeCountryBoundaryMap(value), Command.Optionality.REQUIRED);
    private static final Command.Switch<File> OUTPUT = new Command.Switch("output", "The output file", File::new, Command.Optionality.REQUIRED);
    private static final Command.Switch<File> MISSING_SHARDS = new Command.Switch("shards", "Country shards that are listed as missing", File::new, Command.Optionality.REQUIRED);
    private static final Command.Switch<String> OVERPASS_SERVER = new Command.Switch("server", "The overpass server to query from", value -> value, Command.Optionality.OPTIONAL);
    private static final Command.Switch<StringList> PROXY_SETTINGS = new Command.Switch("proxySettings", "Proxy host and port number, split by comma", value -> StringList.split((String)value, (String)","), Command.Optionality.OPTIONAL);
    private static final Command.Switch<File> WAY_FILTER = new Command.Switch("wayFilter", "The json resource that defines what ways are ingested to atlas", File::new, Command.Optionality.OPTIONAL);

    public static void main(String[] args) {
        new AtlasMissingShardVerifier().run(args);
    }

    private static String createMasterQuery(CountryBoundaryMap boundaries, Set<CountryShard> missingCountryShards) {
        StringBuilder masterQuery = new StringBuilder("(");
        for (CountryShard countryShard : missingCountryShards) {
            Clip clip = AtlasMissingShardVerifier.intersectionClip(countryShard, boundaries);
            Rectangle clipBounds = clip.getClipMultiPolygon().bounds();
            masterQuery.append(OverpassClient.buildCompactQuery("node", clipBounds));
        }
        masterQuery.append(");out body;");
        return masterQuery.toString();
    }

    private static HttpHost createProxy(StringList proxySettings) throws NumberFormatException {
        String proxyHost = proxySettings.get(0);
        int proxyPort = Integer.parseInt(proxySettings.get(1));
        logger.info("Proxy Host: " + proxyHost + " Port: " + proxyPort);
        return new HttpHost(proxyHost, proxyPort);
    }

    private static CountryBoundaryMap initializeCountryBoundaryMap(String value) {
        Time start = Time.now();
        logger.info("Loading boundaries");
        CountryBoundaryMap result = CountryBoundaryMap.fromPlainText((Resource)new File(value));
        logger.info("Loaded boundaries in {}", (Object)start.elapsedSince());
        return result;
    }

    private static STRtree initializeNodeTree(List<OverpassOsmNode> nodes) {
        STRtree nodeTree = new STRtree();
        nodes.forEach(node -> nodeTree.insert(new Envelope(new Coordinate(Double.parseDouble(node.getLongitude()), Double.parseDouble(node.getLatitude()))), node));
        logger.info("Imported " + nodeTree.size() + " nodes to tree");
        return nodeTree;
    }

    private static STRtree initializeWayTree(List<OverpassOsmNode> nodes, List<OverpassOsmWay> ways) {
        STRtree wayTree = new STRtree();
        HashMap nodeIds = new HashMap();
        nodes.forEach(node -> nodeIds.put(node.getIdentifier(), node));
        ways.forEach(way -> {
            Envelope startPoint = new Envelope();
            for (String nodeId : way.getNodeIdentifiers()) {
                if (startPoint == null && nodeIds.containsKey(nodeId)) {
                    startPoint = new Envelope(new Coordinate(Double.parseDouble(((OverpassOsmNode)nodeIds.get(nodeId)).getLongitude()), Double.parseDouble(((OverpassOsmNode)nodeIds.get(nodeId)).getLatitude())));
                    continue;
                }
                if (!nodeIds.containsKey(nodeId)) continue;
                Coordinate nextPoint = new Coordinate(Double.parseDouble(((OverpassOsmNode)nodeIds.get(nodeId)).getLongitude()), Double.parseDouble(((OverpassOsmNode)nodeIds.get(nodeId)).getLatitude()));
                startPoint.expandToInclude(nextPoint);
            }
            wayTree.insert(startPoint, way);
        });
        logger.info("Imported " + wayTree.size() + " ways to tree");
        return wayTree;
    }

    private static Clip intersectionClip(CountryShard countryShard, CountryBoundaryMap boundaries) {
        return new Clip(Clip.ClipType.AND, (PolyLine)countryShard.bounds(), ((CountryBoundary)boundaries.countryBoundary(countryShard.getCountry()).get(0)).getBoundary());
    }

    private static Set<CountryShard> removeShardsWithZeroIntersection(Set<CountryShard> missingCountryShards, CountryBoundaryMap boundaries) {
        missingCountryShards.removeIf(countryShard -> {
            Clip clip = AtlasMissingShardVerifier.intersectionClip(countryShard, boundaries);
            return clip.getClipMultiPolygon().surface().asDm7Squared() == 0L;
        });
        return missingCountryShards;
    }

    public int verifier(CountryBoundaryMap boundaries, Set<CountryShard> missingCountryShardsUntrimmed, File output, String server, HttpHost proxy, ConfiguredTaggableFilter filter) {
        int returnCode = 0;
        Set<CountryShard> missingCountryShards = AtlasMissingShardVerifier.removeShardsWithZeroIntersection(missingCountryShardsUntrimmed, boundaries);
        String masterQuery = AtlasMissingShardVerifier.createMasterQuery(boundaries, missingCountryShards);
        OverpassClient client = new OverpassClient(server, proxy);
        try (SafeBufferedWriter writer = output.writer();){
            List<OverpassOsmNode> nodes = client.nodesFromQuery(masterQuery);
            List<OverpassOsmWay> ways = client.waysFromQuery(masterQuery);
            if (client.hasTooMuchResponseData()) {
                throw new CoreException("The overpass query returned too much data. This means that there are large amounts of data missing! Check the missing shard list for outliers.");
            }
            if (client.hasUnknownError()) {
                throw new CoreException("The overpass query encountered an error. Validation has failed.");
            }
            STRtree nodeTree = AtlasMissingShardVerifier.initializeNodeTree(nodes);
            STRtree wayTree = AtlasMissingShardVerifier.initializeWayTree(nodes, ways);
            block7: for (CountryShard countryShard : missingCountryShards) {
                Clip clip = AtlasMissingShardVerifier.intersectionClip(countryShard, boundaries);
                MultiPolygon clipMulti = clip.getClipMultiPolygon();
                Rectangle clipBounds = clipMulti.bounds();
                List nodeList = nodeTree.query(clipBounds.asEnvelope());
                nodeList.removeIf(node -> !clipBounds.fullyGeometricallyEncloses(Location.forString((String)(node.getLatitude() + "," + node.getLongitude()))));
                List wayList = wayTree.query(clipBounds.asEnvelope());
                wayList.stream().filter(way -> !filter.test(Taggable.with(way.getTags()))).forEach(way -> nodeList.removeIf(node -> way.getNodeIdentifiers().contains(node.getIdentifier())));
                for (OverpassOsmNode node2 : nodeList) {
                    Location nodeLocation = Location.forString((String)(node2.getLatitude() + "," + node2.getLongitude()));
                    if (!clipMulti.fullyGeometricallyEncloses(nodeLocation)) continue;
                    returnCode = -1;
                    writer.writeLine(countryShard.toString());
                    writer.writeLine("Boundary/Shard intersection zone: " + clipMulti.toString());
                    writer.writeLine("Id of node that should have been imported: " + node2.getIdentifier());
                    writer.writeLine("Node Location: " + nodeLocation.toString() + "\n");
                    logger.info(countryShard.toString() + " is missing!");
                    continue block7;
                }
            }
        }
        catch (Exception e) {
            logger.error("Error!", (Throwable)e);
            return -1;
        }
        if (returnCode == 0) {
            logger.info("No shards are missing!");
        }
        return returnCode;
    }

    protected int onRun(CommandMap command) {
        int returnCode;
        CountryBoundaryMap boundaries = (CountryBoundaryMap)command.get(BOUNDARIES);
        File missingShardFile = (File)command.get(MISSING_SHARDS);
        File output = (File)command.get(OUTPUT);
        if (!missingShardFile.exists() || missingShardFile.all().equals("")) {
            logger.info("No missing shards to check!");
            return 0;
        }
        Set<CountryShard> missingCountryShards = missingShardFile.linesList().stream().map(CountryShard::forName).collect(Collectors.toSet());
        File wayFilterFile = (File)command.get(WAY_FILTER);
        ConfiguredTaggableFilter wayFilter = wayFilterFile != null ? new ConfiguredTaggableFilter((Configuration)new StandardConfiguration((Resource)wayFilterFile)) : new ConfiguredTaggableFilter((Configuration)new StandardConfiguration((Resource)new InputStreamResource(AtlasMissingShardVerifier.class.getResourceAsStream(FILTER_CONFIG))));
        String server = (String)command.get(OVERPASS_SERVER);
        StringList proxySettings = (StringList)command.get(PROXY_SETTINGS);
        HttpHost proxy = null;
        if (proxySettings != null) {
            try {
                proxy = AtlasMissingShardVerifier.createProxy(proxySettings);
            }
            catch (Exception e) {
                logger.error("Proxy settings not correctly set", (Throwable)e);
                return -1;
            }
        }
        Time fullStart = Time.now();
        try {
            returnCode = this.verifier(boundaries, missingCountryShards, output, server, proxy, wayFilter);
        }
        catch (Exception e) {
            return -1;
        }
        logger.info("Verification ran in: " + fullStart.elapsedSince());
        return returnCode;
    }

    protected Command.SwitchList switches() {
        return new Command.SwitchList().with(new Command.Switch[]{BOUNDARIES, OUTPUT, MISSING_SHARDS, OVERPASS_SERVER, PROXY_SETTINGS, WAY_FILTER});
    }
}

