/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.tag;

import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.checks.utility.KeyFullyChecked;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.walker.OsmWayWalker;
import org.openstreetmap.atlas.tags.BridgeTag;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.LayerTag;
import org.openstreetmap.atlas.tags.NaturalTag;
import org.openstreetmap.atlas.tags.ServiceTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.TunnelTag;
import org.openstreetmap.atlas.tags.WaterwayTag;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class UnusualLayerTagsCheck
extends BaseCheck<Long> {
    private static final String LANDUSE_INSTRUCTION = "Landuse feature is not on the ground";
    private static final String NATURAL_INSTRUCTION = "Natural feature is not on the ground";
    private static final String HIGHWAY_NOT_ON_GROUND_INSTRUCTION = "Highway not on ground and no tunnel, bridge or covered tags";
    private static final String WATERWAY_NOT_ON_GROUND_INSTRUCTION = "Waterway not on ground and no tunnel, bridge or covered tags";
    private static final String LAYER_LEVEL_IS_ZERO = "Layer level should not be 0";
    @KeyFullyChecked(value=KeyFullyChecked.Type.TAGGABLE_FILTER)
    static final Predicate<Taggable> ALLOWED_TAGS;
    private static final long BRIDGE_LAYER_TAG_MAX_VALUE;
    private static final long BRIDGE_LAYER_TAG_MIN_VALUE = 1L;
    private static final String BRIDGE_INSTRUCTION;
    private static final long TUNNEL_LAYER_TAG_MAX_VALUE = -1L;
    private static final long TUNNEL_LAYER_TAG_MIN_VALUE;
    private static final String TUNNEL_INSTRUCTION;
    private static final Predicate<Taggable> ELIGIBLE_TUNNEL_TAGS;
    private static final long serialVersionUID = 7040472721500502360L;

    public UnusualLayerTagsCheck(Configuration configuration) {
        super(configuration);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return (object instanceof Node || object instanceof Area || object instanceof Line || object instanceof Edge && ((Edge)object).isMainEdge()) && ALLOWED_TAGS.test((Taggable)object) && !this.isFlagged(object.getOsmIdentifier());
    }

    @Override
    protected CheckFlag createFlag(AtlasObject object, String instruction) {
        if (object instanceof Edge) {
            return super.createFlag((Set<AtlasObject>)new OsmWayWalker((Edge)object).collectEdges(), instruction);
        }
        return super.createFlag(object, instruction);
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Optional layerTagValue = LayerTag.getTaggedValue((Taggable)object);
        boolean isTagValueValid = layerTagValue.isPresent();
        this.markAsFlagged(object.getOsmIdentifier());
        if (object.tag("layer") != null && object.tag("layer").equals("0")) {
            return Optional.of(this.createFlag(object, LAYER_LEVEL_IS_ZERO));
        }
        if (this.landUseNotOnGround(object, isTagValueValid)) {
            return Optional.of(this.createFlag(object, LANDUSE_INSTRUCTION));
        }
        if (this.naturalNotOnGround(object, isTagValueValid)) {
            return Optional.of(this.createFlag(object, NATURAL_INSTRUCTION));
        }
        if (this.highwayNotOnGround(object, isTagValueValid)) {
            return Optional.of(this.createFlag(object, HIGHWAY_NOT_ON_GROUND_INSTRUCTION));
        }
        if (this.waterNotOnGround(object, isTagValueValid)) {
            return Optional.of(this.createFlag(object, WATERWAY_NOT_ON_GROUND_INSTRUCTION));
        }
        if (!this.checkLayerValue(object, layerTagValue, isTagValueValid).isEmpty()) {
            return Optional.of(this.createFlag(object, this.checkLayerValue(object, layerTagValue, isTagValueValid)));
        }
        return Optional.empty();
    }

    private boolean checkBridgeLayerValue(AtlasObject object, Optional<Long> layerTagValue, boolean isTagValueValid) {
        return this.objectIsBridge(object) && (!isTagValueValid || layerTagValue.isPresent() && (layerTagValue.get() > BRIDGE_LAYER_TAG_MAX_VALUE || layerTagValue.get() < 1L));
    }

    private String checkLayerValue(AtlasObject object, Optional<Long> layerTagValue, boolean isTagValueValid) {
        if (this.checkTunnelLayerValue(object, layerTagValue, isTagValueValid) && this.properWithoutLayer(object)) {
            return TUNNEL_INSTRUCTION;
        }
        if (this.checkBridgeLayerValue(object, layerTagValue, isTagValueValid) && this.properWithoutLayer(object)) {
            return BRIDGE_INSTRUCTION;
        }
        return "";
    }

    private boolean checkTunnelLayerValue(AtlasObject object, Optional<Long> layerTagValue, boolean isTagValueValid) {
        return this.objectIsTunnel(object) && (!isTagValueValid || layerTagValue.isPresent() && layerTagValue.get() > -1L || layerTagValue.isPresent() && layerTagValue.get() < TUNNEL_LAYER_TAG_MIN_VALUE);
    }

    private boolean highwayNotOnGround(AtlasObject object, boolean isTagValueValid) {
        return isTagValueValid && HighwayTag.highwayTag((Taggable)object).isPresent() && this.properWithoutLayer(object) && !this.objectIsTunnel(object) && !this.objectIsBridge(object) && !this.objectIsCovered(object);
    }

    private boolean landUseNotOnGround(AtlasObject object, boolean isTagValueValid) {
        return isTagValueValid && object.tag("landuse") != null && !this.objectIsTunnel(object) && !this.objectIsBridge(object) && !this.objectIsCovered(object);
    }

    private boolean naturalNotOnGround(AtlasObject object, boolean isTagValueValid) {
        Optional natural = NaturalTag.get((Taggable)object);
        return isTagValueValid && natural.isPresent() && !((NaturalTag)natural.get()).equals((Object)NaturalTag.WATER) && !this.objectIsTunnel(object) && !this.objectIsBridge(object) && !this.objectIsCovered(object);
    }

    private boolean objectIsBridge(AtlasObject object) {
        return BridgeTag.isBridge((Taggable)object) || object.tag("man_made") != null && object.tag("man_made").equalsIgnoreCase("bridge");
    }

    private boolean objectIsCovered(AtlasObject object) {
        return object.tag("covered") != null && !object.tag("covered").equalsIgnoreCase("no");
    }

    private boolean objectIsTunnel(AtlasObject object) {
        return TunnelTag.isTunnel((Taggable)object) || object.tag("man_made") != null && object.tag("man_made").equalsIgnoreCase("tunnel");
    }

    private boolean properWithoutLayer(AtlasObject object) {
        Optional highway = HighwayTag.highwayTag((Taggable)object);
        return !(highway.isPresent() && ((HighwayTag)highway.get()).equals((Object)HighwayTag.STEPS) || object.tag("service") != null && object.tag("service").equalsIgnoreCase(ServiceTag.PARKING_AISLE.toString()));
    }

    private boolean waterNotOnGround(AtlasObject object, boolean isTagValueValid) {
        Optional natural = NaturalTag.get((Taggable)object);
        return isTagValueValid && (WaterwayTag.get((Taggable)object).isPresent() || natural.isPresent() && ((NaturalTag)natural.get()).equals((Object)NaturalTag.WATER)) && !this.objectIsTunnel(object) && !this.objectIsBridge(object) && !this.objectIsCovered(object) && (object.tag("location") == null || !object.tag("location").equalsIgnoreCase("underground"));
    }

    static {
        BRIDGE_LAYER_TAG_MAX_VALUE = LayerTag.getMaxValue();
        BRIDGE_INSTRUCTION = String.format("Bridges must have a layer tag set to a value in [%d, %d].", 1L, BRIDGE_LAYER_TAG_MAX_VALUE);
        TUNNEL_LAYER_TAG_MIN_VALUE = LayerTag.getMinValue();
        TUNNEL_INSTRUCTION = String.format("Tunnels must have layer tags set to a value in [%d, %d].", TUNNEL_LAYER_TAG_MIN_VALUE, -1L);
        ELIGIBLE_TUNNEL_TAGS = object -> Validators.hasValuesFor((Taggable)object, (Class[])new Class[]{TunnelTag.class}) && !Validators.isOfType((Taggable)object, TunnelTag.class, (Enum[])new TunnelTag[]{TunnelTag.BUILDING_PASSAGE});
        ALLOWED_TAGS = Validators.hasValuesFor((Class[])new Class[]{BridgeTag.class}).or(Validators.hasValuesFor((Class[])new Class[]{LayerTag.class})).or(ELIGIBLE_TUNNEL_TAGS);
    }
}

