/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.tag;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.walker.OsmWayWalker;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class StreetNameCheck
extends BaseCheck<Long> {
    private static final List<String> ALL_COUNTRIES_ISO_DEFAULT = List.of("AUT", "CHE", "DEU", "LIE");
    private static final List<List<String>> ALL_VALUES_TO_FLAG_DEFAULT = List.of(List.of("strasse"), List.of("stra\u00dfe"), List.of("strasse"), List.of("stra\u00dfe"));
    private static final List<List<String>> ALL_VALUES_NOT_FLAG_DEFAULT = List.of(List.of("strasser"), List.of(), List.of("strasser"), List.of());
    private static final List<List<String>> ALL_ITEMS_TO_FLAG_DEFAULT = List.of(List.of("ss"), List.of("\u00df"), List.of("ss"), List.of("\u00df"));
    private static final List<List<String>> ALL_CORRECT_ITEMS_TO_SUBSTITUTE = List.of(List.of("\u00df"), List.of("ss"), List.of("\u00df"), List.of("ss"));
    private static final String CONTAINS_VALUE_INSTRUCTION = "The name of the object contains the value {0}. Please substitute it with an appropriate value {1}.";
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("The name of the object contains the value {0}. Please substitute it with an appropriate value {1}.");
    private final List<String> allCountriesIsoConfig;
    private final List<List<String>> allValuesToFlagConfig;
    private final List<List<String>> allValuesNotFlagConfig;
    private final List<List<String>> allItemsToFlagConfig;
    private final List<List<String>> allCorrectValuesToSubstitute;
    private static final long serialVersionUID = 3579562381907303707L;

    public StreetNameCheck(Configuration configuration) {
        super(configuration);
        this.allCountriesIsoConfig = this.configurationValue(configuration, "check.countries", ALL_COUNTRIES_ISO_DEFAULT);
        this.allValuesToFlagConfig = this.configurationValue(configuration, "check.containsValues", ALL_VALUES_TO_FLAG_DEFAULT);
        this.allValuesNotFlagConfig = this.configurationValue(configuration, "check.notContainsValues", ALL_VALUES_NOT_FLAG_DEFAULT);
        this.allItemsToFlagConfig = this.configurationValue(configuration, "check.tags", ALL_ITEMS_TO_FLAG_DEFAULT);
        this.allCorrectValuesToSubstitute = this.configurationValue(configuration, "check.correctTags", ALL_CORRECT_ITEMS_TO_SUBSTITUTE);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return !this.isFlagged(object.getOsmIdentifier()) && (object instanceof Node || object instanceof Edge && ((Edge)object).isMainEdge() || object instanceof Relation);
    }

    @Override
    protected CheckFlag createFlag(AtlasObject object, String instruction) {
        if (object instanceof Edge) {
            return super.createFlag((Set<AtlasObject>)new OsmWayWalker((Edge)object).collectEdges(), instruction);
        }
        return super.createFlag(object, instruction);
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        CountryInfo countryInfo = this.createCountryInfo(object);
        if (countryInfo != null) {
            ArrayList<ArrayList<String>> allValuesFoundInObject = this.objectContainsValues(object, countryInfo);
            this.markAsFlagged(object.getOsmIdentifier());
            if (!allValuesFoundInObject.get(0).isEmpty() && allValuesFoundInObject.get(1).isEmpty()) {
                return Optional.of(this.createFlag(object, this.getLocalizedInstruction(0, countryInfo.getTagValues(), countryInfo.getCorrectValues())));
            }
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private CountryInfo createCountryInfo(AtlasObject object) {
        String isoTag = object.tag("iso_country_code");
        int objectIndex = isoTag != null ? this.allCountriesIsoConfig.indexOf(object.tag("iso_country_code")) : -1;
        if (objectIndex < 0) {
            return null;
        }
        return new CountryInfo(this.allValuesToFlagConfig.get(objectIndex), this.allValuesNotFlagConfig.get(objectIndex), this.allItemsToFlagConfig.get(objectIndex), this.allCorrectValuesToSubstitute.get(objectIndex));
    }

    private ArrayList<String> findValuesToFlag(String streetTag, String nameTag, List<String> containTags) {
        ArrayList<String> valuesToFlagInObject = new ArrayList<String>();
        if (!(containTags.isEmpty() || streetTag == null && nameTag == null)) {
            containTags.forEach(tag -> {
                if (streetTag != null && streetTag.toLowerCase().contains(String.valueOf(tag)) || nameTag != null && nameTag.toLowerCase().contains(String.valueOf(tag))) {
                    valuesToFlagInObject.add(String.valueOf(tag));
                }
            });
        }
        return valuesToFlagInObject;
    }

    private ArrayList<String> findValuesToNotFlag(String streetTag, String nameTag, List<String> notContainTags) {
        ArrayList<String> valuesToNotFlagInObject = new ArrayList<String>();
        if (!(notContainTags.isEmpty() || streetTag == null && nameTag == null)) {
            notContainTags.forEach(tag -> {
                if (streetTag != null && streetTag.toLowerCase().contains(String.valueOf(tag)) || nameTag != null && nameTag.toLowerCase().contains(String.valueOf(tag))) {
                    valuesToNotFlagInObject.add(String.valueOf(tag));
                }
            });
        }
        return valuesToNotFlagInObject;
    }

    private ArrayList<ArrayList<String>> objectContainsValues(AtlasObject object, CountryInfo countryInfo) {
        Map tags = object.getTags();
        String streetTag = (String)tags.get("addr:street");
        String nameTag = (String)tags.get("name");
        List<String> valuesToFlag = countryInfo.getTagContains();
        List<String> valuesToNotFlag = countryInfo.getTagNotContains();
        ArrayList<ArrayList<String>> contains = new ArrayList<ArrayList<String>>(2);
        contains.add(0, this.findValuesToFlag(streetTag, nameTag, valuesToFlag));
        contains.add(1, this.findValuesToNotFlag(streetTag, nameTag, valuesToNotFlag));
        return contains;
    }

    class CountryInfo {
        private List<String> tagContains;
        private List<String> tagNotContains;
        private List<String> tagValues;
        private List<String> correctValues;

        CountryInfo(List<String> contains, List<String> notContains, List<String> tags, List<String> correctTags) {
            this.tagContains = contains;
            this.tagNotContains = notContains;
            this.tagValues = tags;
            this.correctValues = correctTags;
        }

        public List<String> getCorrectValues() {
            return this.correctValues;
        }

        public List<String> getTagContains() {
            return this.tagContains;
        }

        public List<String> getTagNotContains() {
            return this.tagNotContains;
        }

        public List<String> getTagValues() {
            return this.tagValues;
        }
    }
}

