/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.tag;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.walker.OsmWayWalker;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.TurnLanesTag;
import org.openstreetmap.atlas.tags.TurnTag;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class InvalidTurnLanesValueCheck
extends BaseCheck<Long> {
    private static final long serialVersionUID = -1459761692833694715L;
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("Way {0,number,#} has an invalid turn:lanes value.");

    public InvalidTurnLanesValueCheck(Configuration configuration) {
        super(configuration);
    }

    public final String trimKeywords(String input) {
        String result = input.toLowerCase();
        for (TurnTag.TurnType turnType : TurnTag.TurnType.values()) {
            if (turnType == TurnTag.TurnType.LEFT || turnType == TurnTag.TurnType.RIGHT) continue;
            result = result.replaceAll(turnType.name().toLowerCase(), "");
        }
        result = result.replaceAll(TurnTag.TurnType.LEFT.name().toLowerCase(), "");
        result = result.replaceAll(TurnTag.TurnType.RIGHT.name().toLowerCase(), "");
        result = result.replaceAll("\\|".toLowerCase(), "");
        result = result.replaceAll(";".toLowerCase(), "");
        return result.trim();
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return TurnLanesTag.hasTurnLane((Taggable)object) && HighwayTag.isCarNavigableHighway((Taggable)object) && object instanceof Edge && ((Edge)object).isMainEdge() && !this.isFlagged(object.getOsmIdentifier());
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        String turnLanesTag = object.getTag("turn:lanes").orElse("");
        String turnLanesForwardTag = object.getTag("turn:lanes:forward").orElse("");
        String turnLanesBackwardTag = object.getTag("turn:lanes:backward").orElse("");
        if (!(this.trimKeywords(turnLanesTag).isEmpty() && this.trimKeywords(turnLanesForwardTag).isEmpty() && this.trimKeywords(turnLanesBackwardTag).isEmpty())) {
            this.markAsFlagged(object.getOsmIdentifier());
            return Optional.of(this.createFlag((Set<AtlasObject>)new OsmWayWalker((Edge)object).collectEdges(), this.getLocalizedInstruction(0, object.getOsmIdentifier())));
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }
}

