/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.tag;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.walker.OsmWayWalker;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.filters.RegexTaggableFilter;
import org.openstreetmap.atlas.tags.filters.TaggableFilter;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.tuples.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvalidTagsCheck
extends BaseCheck<String> {
    public static final int INLINE_REGEX_FILTER_SIZE = 3;
    private static final long serialVersionUID = 5150282147895785829L;
    private static final String KEY_VALUE_SEPARATOR = "->";
    private static final String DEFAULT_FILTER_RESOURCE = "invalidTags.txt";
    private static final String DEFAULT_NR_TAGS_INSTRUCTION = "OSM feature {0,number,#} has invalid tags.";
    private static final String DEFAULT_INSTRUCTION = "Check the following tags for missing, conflicting, or incorrect values: {0}";
    private static final String INSTRUCTION_INVALID_TAGS = "OSM feature {0,number,#} has invalid tags.";
    private static final List<String> FALLBACK_INSTRUCTIONS = Stream.of("OSM feature {0,number,#} has invalid tags.", "Check the following tags for missing, conflicting, or incorrect values: {0}", "OSM feature {0,number,#} has invalid tags.").collect(Collectors.toCollection(ArrayList::new));
    private static final Logger logger = LoggerFactory.getLogger(InvalidTagsCheck.class);
    private static final String REGEX = "regex";
    private static final int REGEX_INSTRUCTION_INDEX = 3;
    private final List<String> fallbackInstructions = new ArrayList<String>();
    private final List<Tuple<? extends Class<AtlasEntity>, List<Tuple<? extends Predicate<Taggable>, Integer>>>> classTagFilters;

    private static Set<String> getFilterKeys(TaggableFilter filter) {
        return Arrays.stream(filter.toString().split("[|&]+")).filter(string -> string.contains(KEY_VALUE_SEPARATOR)).map(tag -> tag.split(KEY_VALUE_SEPARATOR)[0]).collect(Collectors.toSet());
    }

    private static Set<String> getSetFromJsonArray(JsonArray array) {
        return StreamSupport.stream(array.spliterator(), false).map(JsonElement::getAsString).collect(Collectors.toSet());
    }

    public InvalidTagsCheck(Configuration configuration) {
        super(configuration);
        this.fallbackInstructions.add("OSM feature {0,number,#} has invalid tags.");
        this.fallbackInstructions.add(DEFAULT_INSTRUCTION);
        boolean overrideResourceFilters = this.configurationValue(configuration, "filters.resource.override", false);
        if (overrideResourceFilters) {
            this.classTagFilters = this.getFiltersFromConfiguration(configuration);
        } else {
            List<Tuple<? extends Class<AtlasEntity>, List<Tuple<? extends Predicate<Taggable>, Integer>>>> defaultFilters = this.getDefaultFilters();
            defaultFilters.addAll(this.getFiltersFromConfiguration(configuration));
            this.classTagFilters = defaultFilters;
        }
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return !this.isFlagged(this.getUniqueOSMIdentifier(object));
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        List<String> instructions = this.classTagFilters.stream().filter(classTagFilter -> ((Class)classTagFilter.getFirst()).isInstance(object)).map(Tuple::getSecond).flatMap(Collection::stream).filter(filter -> ((Predicate)filter.getFirst()).test(object)).map(filter -> {
            if (filter.getFirst() instanceof TaggableFilter) {
                return this.getLocalizedInstruction((Integer)filter.getSecond(), InvalidTagsCheck.getFilterKeys((TaggableFilter)filter.getFirst()));
            }
            return this.getLocalizedInstruction((Integer)filter.getSecond(), ((RegexTaggableFilter)filter.getFirst()).getMatchedTags((Taggable)object));
        }).collect(Collectors.toList());
        if (!instructions.isEmpty()) {
            this.markAsFlagged(this.getUniqueOSMIdentifier(object));
            String instruction = this.getLocalizedInstruction(FALLBACK_INSTRUCTIONS.indexOf("OSM feature {0,number,#} has invalid tags."), object.getOsmIdentifier());
            CheckFlag flag = object instanceof Edge ? this.createFlag((Set<AtlasObject>)new OsmWayWalker((Edge)object).collectEdges(), instruction) : this.createFlag(object, instruction);
            instructions.forEach(flag::addInstruction);
            return Optional.of(flag);
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return this.fallbackInstructions;
    }

    private int addInstruction(String instruction) {
        if (Objects.nonNull(instruction) && !instruction.isEmpty()) {
            this.fallbackInstructions.add(instruction);
            return this.fallbackInstructions.size() - 1;
        }
        return 1;
    }

    private List<Tuple<? extends Class<AtlasEntity>, List<Tuple<? extends Predicate<Taggable>, Integer>>>> getDefaultFilters() {
        ArrayList<Tuple<? extends Class<AtlasEntity>, List<Tuple<? extends Predicate<Taggable>, Integer>>>> arrayList;
        BufferedReader reader = new BufferedReader(new InputStreamReader(InvalidTagsCheck.class.getResourceAsStream(DEFAULT_FILTER_RESOURCE)));
        try {
            String line;
            ArrayList<Tuple<? extends Class<AtlasEntity>, List<Tuple<? extends Predicate<Taggable>, Integer>>>> listOfClassToFilters = new ArrayList<Tuple<? extends Class<AtlasEntity>, List<Tuple<? extends Predicate<Taggable>, Integer>>>>();
            while ((line = reader.readLine()) != null) {
                String[] split = line.split(":");
                if (split.length < 2) continue;
                List<Tuple<? extends Predicate<Taggable>, Integer>> filters = split[1].contains(REGEX) ? this.getRegexFiltersFromResource(split[1]) : this.getFiltersFromResource(split[1]);
                listOfClassToFilters.add((Tuple<? extends Class<AtlasEntity>, List<Tuple<? extends Predicate<Taggable>, Integer>>>)new Tuple((Object)ItemType.valueOf((String)split[0].toUpperCase()).getMemberClass(), filters));
            }
            arrayList = listOfClassToFilters;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException exception) {
                logger.error(String.format("Could not read %s", DEFAULT_FILTER_RESOURCE), (Throwable)exception);
                return Collections.emptyList();
            }
        }
        reader.close();
        return arrayList;
    }

    private List<Tuple<? extends Class<AtlasEntity>, List<Tuple<? extends Predicate<Taggable>, Integer>>>> getFiltersFromConfiguration(Configuration configuration) {
        List<Tuple<? extends Class<AtlasEntity>, List<Tuple<? extends Predicate<Taggable>, Integer>>>> filters = this.readConfigurationFilter(configuration);
        ArrayList<Tuple<? extends Class<AtlasEntity>, List<Tuple<? extends Predicate<Taggable>, Integer>>>> allFilters = new ArrayList<Tuple<? extends Class<AtlasEntity>, List<Tuple<? extends Predicate<Taggable>, Integer>>>>(filters);
        List<Tuple<? extends Class<AtlasEntity>, List<Tuple<? extends Predicate<Taggable>, Integer>>>> regexFilters = this.readRegexConfigurationFilter(configuration);
        allFilters.addAll(regexFilters);
        return allFilters;
    }

    private List<Tuple<? extends Predicate<Taggable>, Integer>> getFiltersFromResource(String filterResourcePath) {
        ArrayList<Tuple<? extends Predicate<Taggable>, Integer>> arrayList;
        InputStreamReader reader = new InputStreamReader(InvalidTagsCheck.class.getResourceAsStream(filterResourcePath));
        try {
            ArrayList<Tuple<? extends Predicate<Taggable>, Integer>> result = new ArrayList<Tuple<? extends Predicate<Taggable>, Integer>>();
            JsonElement element = new JsonParser().parse((Reader)reader);
            JsonArray filters = element.getAsJsonObject().get("filters").getAsJsonArray();
            List taggableFilters = StreamSupport.stream(filters.spliterator(), false).map(jsonElement -> TaggableFilter.forDefinition((String)jsonElement.getAsString())).collect(Collectors.toList());
            JsonArray instructionsArray = element.getAsJsonObject().get("instructions").getAsJsonArray();
            List instructions = StreamSupport.stream(instructionsArray.spliterator(), false).map(JsonElement::getAsString).collect(Collectors.toList());
            for (int i = 0; i < taggableFilters.size(); ++i) {
                String instruction = i < instructions.size() ? (String)instructions.get(i) : "";
                int instructionIndex = this.addInstruction(instruction);
                result.add((Tuple<? extends Predicate<Taggable>, Integer>)Tuple.createTuple((Object)((TaggableFilter)taggableFilters.get(i)), (Object)instructionIndex));
            }
            arrayList = result;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                logger.error("There was a problem parsing invalid-tags-check-inconsistent-highway-filter.json. Check if the JSON file has valid structure.", (Throwable)exception);
                return Collections.emptyList();
            }
        }
        reader.close();
        return arrayList;
    }

    private List<Tuple<? extends Predicate<Taggable>, Integer>> getRegexFiltersFromResource(String filterResourcePath) {
        List<Tuple<? extends Predicate<Taggable>, Integer>> list;
        InputStreamReader reader = new InputStreamReader(InvalidTagsCheck.class.getResourceAsStream(filterResourcePath));
        try {
            JsonElement element = new JsonParser().parse((Reader)reader);
            JsonArray filters = element.getAsJsonObject().get("filters").getAsJsonArray();
            list = StreamSupport.stream(filters.spliterator(), false).map(JsonElement::getAsJsonObject).map(jsonObject -> {
                Set<String> tagNames = InvalidTagsCheck.getSetFromJsonArray(jsonObject.getAsJsonArray("tagNames"));
                Set<String> regex = InvalidTagsCheck.getSetFromJsonArray(jsonObject.getAsJsonArray(REGEX));
                JsonArray exceptionArray = jsonObject.getAsJsonArray("exceptions");
                HashMap exceptions = new HashMap();
                StreamSupport.stream(exceptionArray.spliterator(), false).map(JsonElement::getAsJsonObject).forEach(exception -> {
                    String tagName = exception.get("tagName").getAsString();
                    Set<String> values = InvalidTagsCheck.getSetFromJsonArray(exception.getAsJsonArray("values"));
                    exceptions.putIfAbsent(tagName, values);
                });
                RegexTaggableFilter filter = new RegexTaggableFilter(tagNames, regex, exceptions);
                String instruction = jsonObject.get("instruction").getAsString();
                int instructionIndex = this.addInstruction(instruction);
                return Tuple.createTuple((Object)filter, (Object)instructionIndex);
            }).collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                logger.error("There was a problem parsing {}. Check if the JSON file has valid structure.", (Object)filterResourcePath, (Object)exception);
                return Collections.emptyList();
            }
        }
        reader.close();
        return list;
    }

    private List<Tuple<? extends Class<AtlasEntity>, List<Tuple<? extends Predicate<Taggable>, Integer>>>> readConfigurationFilter(Configuration configuration) {
        return this.configurationValue(configuration, "filters.classes.tags", Collections.emptyList(), configList -> configList.stream().map(classTagValue -> {
            List classTagList = (List)classTagValue;
            if (classTagList.size() > 1) {
                String instruction = classTagList.size() > 2 ? (String)classTagList.get(2) : "";
                return Optional.of(this.stringsToClassTagFilter((String)classTagList.get(0), (String)classTagList.get(1), instruction));
            }
            return Optional.empty();
        }).filter(Optional::isPresent).map(tuple -> (Tuple)tuple.get()).collect(Collectors.toList()));
    }

    private List<Tuple<? extends Class<AtlasEntity>, List<Tuple<? extends Predicate<Taggable>, Integer>>>> readRegexConfigurationFilter(Configuration configuration) {
        return this.configurationValue(configuration, "filters.classes.regex", Collections.emptyList(), configList -> configList.stream().map(classTagValue -> {
            List classTagList = (List)classTagValue;
            if (classTagList.size() >= 3) {
                String element = (String)classTagList.get(0);
                List tagNames = (List)classTagList.get(1);
                List regex = (List)classTagList.get(2);
                ArrayList<Tuple> filters = new ArrayList<Tuple>();
                String instruction = classTagList.size() > 3 ? (String)classTagList.get(3) : "";
                RegexTaggableFilter filter = new RegexTaggableFilter(new HashSet(tagNames), new HashSet(regex), null);
                int instructionIndex = this.addInstruction(instruction);
                filters.add(Tuple.createTuple((Object)filter, (Object)instructionIndex));
                return Optional.of(Tuple.createTuple((Object)ItemType.valueOf((String)element.toUpperCase()).getMemberClass(), filters));
            }
            return Optional.empty();
        }).filter(Optional::isPresent).map(tuple -> (Tuple)tuple.get()).collect(Collectors.toList()));
    }

    private Tuple<? extends Class<AtlasEntity>, List<Tuple<TaggableFilter, Integer>>> stringsToClassTagFilter(String classString, String tagFilterString, String instruction) {
        int instructionIndex = this.addInstruction(instruction);
        ArrayList<Tuple> filters = new ArrayList<Tuple>();
        filters.add(Tuple.createTuple((Object)TaggableFilter.forDefinition((String)tagFilterString), (Object)instructionIndex));
        return Tuple.createTuple((Object)ItemType.valueOf((String)classString.toUpperCase()).getMemberClass(), filters);
    }
}

