/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.tag;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.walker.OsmWayWalker;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class HighwayAccessCheck
extends BaseCheck<Long> {
    private static final long serialVersionUID = -5533238262833368666L;
    private static final List<String> ACCESS_TAGS_TO_FLAG_DEFAULT = Arrays.asList("yes", "permissive");
    private static final List<String> HIGHWAY_TAGS_TO_FLAG_DEFAULT = Arrays.asList("motorway", "trunk", "footway", "bridleway", "steps", "path", "cycleway", "pedestrian", "track", "bus_guideway", "busway", "raceway");
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("The access tag value is probably too generic for this way. A tag value of \"yes\" or \"permissive\" allows access to all types of traffic. If special access is granted or restricted on this way then please specify it or remove the access tag. See https://wiki.openstreetmap.org/wiki/Key:access?uselang=en#Transport_mode_restrictions for more information.");
    private final List<String> accessTagsToFlag;
    private final List<String> highwayTagsToFlag;

    public HighwayAccessCheck(Configuration configuration) {
        super(configuration);
        this.accessTagsToFlag = this.configurationValue(configuration, "tags.accessTags", ACCESS_TAGS_TO_FLAG_DEFAULT);
        this.highwayTagsToFlag = this.configurationValue(configuration, "tags.highwayTags", HIGHWAY_TAGS_TO_FLAG_DEFAULT);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return !this.isFlagged(object.getOsmIdentifier()) && object instanceof Edge && ((Edge)object).isMainEdge();
    }

    @Override
    protected CheckFlag createFlag(AtlasObject object, String instruction) {
        if (object instanceof Edge) {
            return super.createFlag((Set<AtlasObject>)new OsmWayWalker((Edge)object).collectEdges(), instruction);
        }
        return super.createFlag(object, instruction);
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        this.markAsFlagged(object.getOsmIdentifier());
        String accessTag = object.tag("access");
        String highwayTag = object.tag("highway");
        if (this.accessTagsToFlag.contains(accessTag) && this.highwayTagsToFlag.contains(highwayTag)) {
            return Optional.of(this.createFlag(object, this.getLocalizedInstruction(0, new Object[0])));
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }
}

