/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.tag;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.base.ExternalDataFetcher;
import org.openstreetmap.atlas.checks.database.taginfo.TagInfoKeyTagCommon;
import org.openstreetmap.atlas.checks.database.taginfo.TagInfoKeys;
import org.openstreetmap.atlas.checks.database.taginfo.TagInfoTags;
import org.openstreetmap.atlas.checks.database.wikidata.WikiData;
import org.openstreetmap.atlas.checks.database.wikidata.WikiDataItem;
import org.openstreetmap.atlas.checks.database.wikidata.WikiProperty;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.checks.utility.AtlasToOsmType;
import org.openstreetmap.atlas.checks.utility.KeyFullyCheckedUtils;
import org.openstreetmap.atlas.checks.utility.SQLiteUtils;
import org.openstreetmap.atlas.checks.utility.feature_change.IFeatureChange;
import org.openstreetmap.atlas.checks.utility.feature_change.RemoveTagFeatureChange;
import org.openstreetmap.atlas.checks.utility.feature_change.ReplaceTagFeatureChange;
import org.openstreetmap.atlas.exception.CoreException;
import org.openstreetmap.atlas.geography.atlas.change.FeatureChange;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.LineItem;
import org.openstreetmap.atlas.geography.atlas.items.LocationItem;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.RelationMember;
import org.openstreetmap.atlas.geography.atlas.walker.OsmWayWalker;
import org.openstreetmap.atlas.locale.IsoCountry;
import org.openstreetmap.atlas.streaming.resource.Resource;
import org.openstreetmap.atlas.tags.ISOCountryTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.utilities.collections.Iterables;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.testing.TestTaggable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericTagCheck
extends BaseCheck<String> {
    private static final long serialVersionUID = 5150282147895785829L;
    private static final String DEFAULT_NR_TAGS_INSTRUCTION = "OSM feature {0,number,#} has invalid tags";
    private static final String DEFAULT_INSTRUCTION = "Check the following tags for missing, conflicting, or incorrect values: {0}";
    private static final String INSTRUCTION_CONFLICTING_TAGS = "Check the following tags for missing, conflicting, or incorrect values: {0}";
    private static final String INSTRUCTION_INVALID_TAGS = "OSM feature {0,number,#} has invalid tags";
    private static final String INSTRUCTION_MISMATCHED_REGEX = "{0} does not match the regex {1} for the key {2} (see https://wiki.osm.org/Item:{3})";
    private static final String INSTRUCTION_PROHIBITED_USAGE = "{0}={1} is prohibited on {2}. To determine whether to remove or change this tag please see this tag's Wiki Data page, https://wiki.osm.org/Item:{3} or the associated documentation Wiki Page on the Wiki Data page).";
    private static final String INSTRUCTION_REPLACE = "{0} should probably be replaced with {1} (see https://wiki.osm.org/Item:{2})";
    private static final String INSTRUCTION_TAGINFO_POPULAR = "{0} is probably an undocumented {1} ({2} instances). This should be documented on the wiki at https://wiki.osm.org/{3} and in the OpenStreetMap Wiki Data ( https://wiki.osm.org/Data_items ).";
    private static final String INSTRUCTION_TAGINFO_UNPOPULAR = "{0} is an unpopular key ({1} instances)";
    private static final String INSTRUCTION_TAG_SHOULD_NOT_BE_USED_IN_REGION = "{0}={1} should not be used in {2} (see https://wiki.osm.org/Item:{3})";
    private static final String INSTRUCTION_UNDOCUMENTED_POPULAR_TAG = "{0}={1} is not currently documented. Its global popularity ({2} uses) may merit adding wiki documentation for this value. Please consider adding a new Wiki Data page for {0}={1}.";
    private static final String INSTRUCTION_UNKNOWN_RELATION_ROLE = "{0}={1} is an unknown relation role for {0} ({2} {3,number,#} on relation {4,number,#}, see https://wiki.osm.org/Item:{5})";
    private static final String INSTRUCTION_UNKNOWN_RELATION_TYPE = "type={0} is an unknown relation type (relation {1,number,#}, see https://wiki.osm.org/Item:{2})";
    private static final String INSTRUCTION_WELL_DEFINED_TAG_UNKNOWN_VALUE = "{0} is not a well-known value for {1}";
    private static final String INSTRUCTION_WIKI_DATA_REMOVAL = "{0}={1} should probably be removed (it is {2}, see https://wiki.osm.org/Item:{3})";
    private static final List<String> FALLBACK_INSTRUCTIONS = Stream.of("OSM feature {0,number,#} has invalid tags", "Check the following tags for missing, conflicting, or incorrect values: {0}", "OSM feature {0,number,#} has invalid tags", "Check the following tags for missing, conflicting, or incorrect values: {0}", "{0} does not match the regex {1} for the key {2} (see https://wiki.osm.org/Item:{3})", "{0}={1} is not currently documented. Its global popularity ({2} uses) may merit adding wiki documentation for this value. Please consider adding a new Wiki Data page for {0}={1}.", "{0} is not a well-known value for {1}", "{0}={1} should probably be removed (it is {2}, see https://wiki.osm.org/Item:{3})", "{0}={1} is prohibited on {2}. To determine whether to remove or change this tag please see this tag's Wiki Data page, https://wiki.osm.org/Item:{3} or the associated documentation Wiki Page on the Wiki Data page).", "{0} is an unpopular key ({1} instances)", "{0} is probably an undocumented {1} ({2} instances). This should be documented on the wiki at https://wiki.osm.org/{3} and in the OpenStreetMap Wiki Data ( https://wiki.osm.org/Data_items ).", "{0} should probably be replaced with {1} (see https://wiki.osm.org/Item:{2})", "{0}={1} is an unknown relation role for {0} ({2} {3,number,#} on relation {4,number,#}, see https://wiki.osm.org/Item:{5})", "type={0} is an unknown relation type (relation {1,number,#}, see https://wiki.osm.org/Item:{2})", "{0}={1} should not be used in {2} (see https://wiki.osm.org/Item:{3})").collect(Collectors.toCollection(ArrayList::new));
    private static final long DEFAULT_MIN_TAG_USAGE = 100L;
    private static final String DEFAULT_WIKI_TABLE = "wiki_data";
    private static final String DEFAULT_TAGINFO_TAG_TABLE = "tags";
    private static final String DEFAULT_TAGINFO_KEY_TABLE = "keys";
    private static final boolean DEFAULT_ERROR_IF_DATABASE_IS_MISSING = true;
    private static final Logger logger = LoggerFactory.getLogger(GenericTagCheck.class);
    private final Long minTagUsage;
    private transient Collection<Predicate<Taggable>> ignoreTags = KeyFullyCheckedUtils.populateIgnoreTags();
    private static final List<String> DEFAULT_TAGS_TO_REMOVE = Arrays.asList("abandoned", "discardable", "imported", "obsolete", "rejected");
    private final List<String> tagsToRemove;
    private SQLiteUtils sqliteUtilsTagInfoTagTable;
    private SQLiteUtils sqliteUtilsTagInfoKeyTable;
    private SQLiteUtils sqliteUtilsWikiData;
    private static final String DEFAULT_TAGINFO_DB = "taginfo-db.db";
    private static final String DEFAULT_WIKIDATA_DB = "wikidata.db";
    private static final int DEFAULT_TAG_PERCENTAGE_KEY = 10;
    private final String tagInfoDB;
    private final String wikiDataDB;
    private final String wikiTable;
    private final String tagInfoTagTable;
    private final String tagInfoKeyTable;
    private final int popularTagPercentageKey;

    private static boolean isArea(Taggable object) {
        return object instanceof Area || object instanceof Relation && ((Relation)object).isMultiPolygon();
    }

    private static boolean isClosedLine(Taggable object) {
        return object instanceof LineItem && ((LineItem)object).isClosed();
    }

    private static String tagToString(Map.Entry<String, String> tag) {
        return Stream.of(tag.getKey(), tag.getValue()).filter(Objects::nonNull).filter(string -> !string.isBlank()).collect(Collectors.joining("="));
    }

    public GenericTagCheck(Configuration configuration, ExternalDataFetcher fileFetcher) {
        super(configuration);
        this.minTagUsage = this.configurationValue(configuration, "tag.usage.min", 100L);
        this.tagsToRemove = this.configurationValue(configuration, "wikidata.tag_removal", DEFAULT_TAGS_TO_REMOVE);
        this.wikiTable = DEFAULT_WIKI_TABLE;
        this.tagInfoTagTable = DEFAULT_TAGINFO_TAG_TABLE;
        this.tagInfoKeyTable = DEFAULT_TAGINFO_KEY_TABLE;
        this.tagInfoDB = this.configurationValue(configuration, "database.taginfo", this.configurationValue(configuration, "db.taginfo", DEFAULT_TAGINFO_DB));
        this.wikiDataDB = this.configurationValue(configuration, "database.wikidata", this.configurationValue(configuration, "db.wikidata", DEFAULT_WIKIDATA_DB));
        this.popularTagPercentageKey = this.configurationValue(configuration, "tag.percentage_of_key_for_popular", Integer.valueOf(10).longValue()).intValue();
        if (fileFetcher == null) {
            return;
        }
        for (String file : Arrays.asList(this.tagInfoDB, this.wikiDataDB)) {
            Optional<Resource> resource = fileFetcher.apply(file);
            if (resource.isPresent() || !logger.isDebugEnabled()) continue;
            logger.debug(MessageFormat.format("{0} is not present", file));
        }
        this.fetchWikiData(fileFetcher);
        this.fetchTagInfo(fileFetcher);
        boolean errorIfDatabaseNotFound = this.configurationValue(configuration, "database.require_all", true);
        if (errorIfDatabaseNotFound && (this.sqliteUtilsTagInfoKeyTable == null || this.sqliteUtilsTagInfoTagTable == null || this.sqliteUtilsWikiData == null)) {
            throw new CoreException("GenericTagCheck: All databases are required and must be readable");
        }
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return !object.getOsmTags().isEmpty() && !this.isFlagged(this.getUniqueOSMIdentifier(object));
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        TreeMap<String, Collection<IFeatureChange>> instructions = new TreeMap<String, Collection<IFeatureChange>>();
        if (this.sqliteUtilsTagInfoTagTable != null && this.sqliteUtilsWikiData != null) {
            if (this.ignoreTags == null || this.ignoreTags.isEmpty()) {
                this.ignoreTags = KeyFullyCheckedUtils.populateIgnoreTags();
            }
            this.flagTags(object, instructions);
        }
        if (!instructions.isEmpty()) {
            this.markAsFlagged(this.getUniqueOSMIdentifier(object));
            String instruction = this.getLocalizedInstruction(FALLBACK_INSTRUCTIONS.indexOf("OSM feature {0,number,#} has invalid tags"), object.getOsmIdentifier());
            CheckFlag flag = object instanceof Edge ? this.createFlag((Set<AtlasObject>)new OsmWayWalker((Edge)object).collectEdges(), instruction) : this.createFlag(object, instruction);
            instructions.keySet().forEach(flag::addInstruction);
            if (instructions.entrySet().stream().noneMatch(entry -> ((Collection)entry.getValue()).isEmpty())) {
                flag.addFixSuggestions(Collections.singleton(IFeatureChange.createFeatureChange(FeatureChange::add, (AtlasEntity)object, instructions.values().stream().flatMap(Collection::stream).filter(Objects::nonNull).distinct().collect(Collectors.toList()))));
            }
            return Optional.of(flag);
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private boolean checkCountrySpecific(Map<String, Collection<IFeatureChange>> instructions, Taggable object, Map.Entry<String, String> tag, WikiData wikiMap) {
        if (!(wikiMap == null || wikiMap.getMustOnlyBeUsedInRegionP29().isEmpty() && wikiMap.getNotToBeUsedInRegionP30().isEmpty())) {
            UnaryOperator toWikiData = countries -> countries.stream().map(this::getWikiDataId).filter(Objects::nonNull).map(WikiData::getGeographicCodeP49).filter(Objects::nonNull).flatMap(Collection::stream).map(IsoCountry::iso3ForIso2).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            List countries2 = Iterables.asList((Iterable)ISOCountryTag.all((Taggable)object));
            String instruction = null;
            if (!wikiMap.getMustOnlyBeUsedInRegionP29().isEmpty()) {
                Collection onlyUsedInRegion = (Collection)toWikiData.apply(wikiMap.getMustOnlyBeUsedInRegionP29());
                if (countries2.stream().noneMatch(onlyUsedInRegion::contains)) {
                    instruction = INSTRUCTION_TAG_SHOULD_NOT_BE_USED_IN_REGION;
                }
            } else {
                Collection notUsedInRegion = (Collection)toWikiData.apply(wikiMap.getNotToBeUsedInRegionP30());
                if (!countries2.isEmpty()) {
                    if (countries2.stream().allMatch(notUsedInRegion::contains)) {
                        instruction = INSTRUCTION_TAG_SHOULD_NOT_BE_USED_IN_REGION;
                    }
                }
            }
            if (instruction != null) {
                instructions.put(this.getLocalizedInstruction(FALLBACK_INSTRUCTIONS.indexOf(instruction), tag.getKey(), tag.getValue(), String.join((CharSequence)", ", countries2), wikiMap.getId()), Collections.singleton(new RemoveTagFeatureChange(tag)));
            }
            return instruction != null;
        }
        return false;
    }

    private void checkFallback(Map<String, Collection<IFeatureChange>> instructions, Map.Entry<String, String> tag, WikiData keyInfo, boolean popular, TagInfoTags tagOccurrence, TagInfoKeys keyOccurrence) {
        if (keyInfo == null) {
            Map.Entry<String, String> messageTag;
            Object count;
            if (tagOccurrence.getCountAll() != null) {
                count = tagOccurrence.getCountAll().toString();
                messageTag = tag;
            } else if (keyOccurrence.getCountAll() != null) {
                count = keyOccurrence.getCountAll().toString();
                messageTag = Map.entry(tag.getKey(), "");
            } else {
                count = "<" + this.minTagUsage.toString();
                messageTag = tag;
            }
            if (!popular) {
                instructions.put(this.getLocalizedInstruction(FALLBACK_INSTRUCTIONS.indexOf(INSTRUCTION_TAGINFO_UNPOPULAR), GenericTagCheck.tagToString(tag), count), Collections.emptyList());
            } else {
                String type = messageTag.getValue().isBlank() ? "Key" : "Tag";
                instructions.put(this.getLocalizedInstruction(FALLBACK_INSTRUCTIONS.indexOf(INSTRUCTION_TAGINFO_POPULAR), GenericTagCheck.tagToString(messageTag), type.toLowerCase(Locale.ENGLISH), count, type + ':' + GenericTagCheck.tagToString(messageTag)), Collections.emptyList());
            }
        }
    }

    private boolean checkRedirectTo(Map<String, Collection<IFeatureChange>> instructions, Map.Entry<String, String> tag, WikiData checkInfo) {
        if (checkInfo != null && !checkInfo.getRedirectToP17().isEmpty()) {
            List featureChanges;
            String value = checkInfo.getInstanceOfP2().contains("key") ? checkInfo.getPermanentKeyIdP16() : checkInfo.getPermanentTagIdP19();
            Collection<String> redirects = checkInfo.getRedirectToP17();
            Map<String, String> replacements = redirects.stream().map(replacementId -> WikiData.getWikiData(this.sqliteUtilsWikiData.getRows(Map.of("id", replacementId)))).filter(Objects::nonNull).map(this::parseTags).filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            if (!replacements.isEmpty()) {
                featureChanges = new ArrayList();
                featureChanges.add(new RemoveTagFeatureChange(tag));
                for (Map.Entry<String, String> newTag : replacements.entrySet()) {
                    featureChanges.add(new ReplaceTagFeatureChange(tag, newTag));
                }
            } else {
                featureChanges = Collections.emptyList();
            }
            instructions.put(this.getLocalizedInstruction(FALLBACK_INSTRUCTIONS.indexOf(INSTRUCTION_REPLACE), value, replacements.entrySet().stream().map(GenericTagCheck::tagToString).collect(Collectors.joining(", ")), checkInfo.getId()), featureChanges);
            return true;
        }
        return false;
    }

    private boolean checkRegex(Map<String, Collection<IFeatureChange>> instructions, Map.Entry<String, String> tag, WikiData checkInfo) {
        Pattern pattern;
        if (checkInfo != null && checkInfo.getValueValidationRegexP13() != null && !(pattern = checkInfo.getValueValidationRegexP13()).matcher(tag.getValue()).matches()) {
            instructions.put(this.getLocalizedInstruction(FALLBACK_INSTRUCTIONS.indexOf(INSTRUCTION_MISMATCHED_REGEX), tag.getValue(), pattern.toString(), tag.getKey(), checkInfo.getId()), Collections.emptyList());
            return true;
        }
        return false;
    }

    private boolean checkRelations(Map<String, Collection<IFeatureChange>> instructions, Taggable object, Map.Entry<String, String> tag, WikiData checkInfo) {
        if (checkInfo != null && object instanceof Relation && checkInfo.isUseOnRelationsP36() && "type".equals(tag.getKey())) {
            Relation relation = (Relation)object;
            WikiData relationInfo = this.getWikiData(Map.of(WikiProperty.PERMANENT_RELATION_TYPE_ID_P41.getId(), tag.getValue()));
            if (relationInfo == null) {
                instructions.put(this.getLocalizedInstruction(FALLBACK_INSTRUCTIONS.indexOf(INSTRUCTION_UNKNOWN_RELATION_TYPE), tag.getValue(), relation.getOsmIdentifier(), checkInfo.getId()), Collections.emptyList());
                return true;
            }
            TreeSet<String> additionalInstructions = new TreeSet<String>();
            for (RelationMember relationMember : relation.members()) {
                String role = relationMember.getRole();
                WikiData roleInfo = this.getWikiData(Map.of(WikiProperty.RELATION_ROLE_ID_P21.getId(), relationInfo.getPermanentRelationTypeIdP41() + "=" + role));
                if (roleInfo != null) continue;
                AtlasEntity roleMember = relationMember.getEntity();
                additionalInstructions.add(this.getLocalizedInstruction(FALLBACK_INSTRUCTIONS.indexOf(INSTRUCTION_UNKNOWN_RELATION_ROLE), relationInfo.getPermanentRelationTypeIdP41(), role, AtlasToOsmType.convert(roleMember.getType()), roleMember.getOsmIdentifier(), relation.getOsmIdentifier(), checkInfo.getId()));
            }
            additionalInstructions.forEach(instruction -> instructions.put((String)instruction, Collections.emptyList()));
            return !additionalInstructions.isEmpty();
        }
        return false;
    }

    private boolean checkStatus(Map<String, Collection<IFeatureChange>> instructions, Map.Entry<String, String> tag, WikiData checkInfo, boolean wellKnown) {
        if (wellKnown && checkInfo != null && checkInfo.getStatusP6() != null && this.tagsToRemove.stream().anyMatch(t -> checkInfo.getStatusP6().matches(t))) {
            instructions.put(this.getLocalizedInstruction(FALLBACK_INSTRUCTIONS.indexOf(INSTRUCTION_WIKI_DATA_REMOVAL), tag.getKey(), tag.getValue(), checkInfo.getStatusP6().getDescriptor().toLowerCase(Locale.ENGLISH), checkInfo.getId()), Collections.singleton(new RemoveTagFeatureChange(tag)));
            return true;
        }
        return false;
    }

    private boolean checkUndocumentedPopularWellDefined(Map<String, Collection<IFeatureChange>> instructions, Map.Entry<String, String> tag, WikiData checkInfo, boolean wellKnown, boolean popular, TagInfoTags tagOccurrence) {
        if (wellKnown && checkInfo == null) {
            if (popular) {
                instructions.put(this.getLocalizedInstruction(FALLBACK_INSTRUCTIONS.indexOf(INSTRUCTION_UNDOCUMENTED_POPULAR_TAG), tag.getKey(), tag.getValue(), tagOccurrence.getCountAll()), Collections.emptyList());
            } else {
                instructions.put(this.getLocalizedInstruction(FALLBACK_INSTRUCTIONS.indexOf(INSTRUCTION_WELL_DEFINED_TAG_UNKNOWN_VALUE), tag.getValue(), tag.getKey()), Collections.singleton(new RemoveTagFeatureChange(tag)));
            }
            return true;
        }
        return false;
    }

    private boolean checkUnwantedTagOnObject(Taggable object, Map<String, Collection<IFeatureChange>> instructions, Map.Entry<String, String> tag, WikiData checkInfo) {
        ArrayList<String> newInstructions = new ArrayList<String>();
        if (object instanceof LocationItem && !checkInfo.isUseOnNodesP33()) {
            newInstructions.add(this.getLocalizedInstruction(FALLBACK_INSTRUCTIONS.indexOf(INSTRUCTION_PROHIBITED_USAGE), tag.getKey(), tag.getValue(), "node", checkInfo.getId()));
        }
        if ((GenericTagCheck.isArea(object) || GenericTagCheck.isClosedLine(object)) && !checkInfo.isUseOnWaysP34() && !checkInfo.isUseOnAreasP35()) {
            newInstructions.add(this.getLocalizedInstruction(FALLBACK_INSTRUCTIONS.indexOf(INSTRUCTION_PROHIBITED_USAGE), tag.getKey(), tag.getValue(), "area", checkInfo.getId()));
        } else if (object instanceof LineItem && !checkInfo.isUseOnWaysP34() && !GenericTagCheck.isClosedLine(object)) {
            newInstructions.add(this.getLocalizedInstruction(FALLBACK_INSTRUCTIONS.indexOf(INSTRUCTION_PROHIBITED_USAGE), tag.getKey(), tag.getValue(), "way", checkInfo.getId()));
        }
        if (object instanceof Relation && !checkInfo.isUseOnRelationsP36() && !GenericTagCheck.isArea(object)) {
            newInstructions.add(this.getLocalizedInstruction(FALLBACK_INSTRUCTIONS.indexOf(INSTRUCTION_PROHIBITED_USAGE), tag.getKey(), tag.getValue(), "relation", checkInfo.getId()));
        }
        if (!newInstructions.isEmpty()) {
            Set<RemoveTagFeatureChange> delete = Collections.singleton(new RemoveTagFeatureChange(tag));
            newInstructions.forEach(instruction -> instructions.put((String)instruction, (Collection<IFeatureChange>)delete));
            return true;
        }
        return false;
    }

    private void checkWikiData(Taggable object, Map<String, Collection<IFeatureChange>> instructions, Map.Entry<String, String> tag, WikiData keyInfo, WikiData checkInfo, boolean wellKnown) {
        TagInfoTags tagOccurrence = (TagInfoTags)this.getTagInfo(tag.getKey(), tag.getValue());
        TagInfoKeys keyOccurrence = (TagInfoKeys)this.getTagInfo(tag.getKey(), null);
        boolean popular = this.isPopular(keyOccurrence, tagOccurrence);
        if (this.checkRegex(instructions, tag, checkInfo) || this.checkUndocumentedPopularWellDefined(instructions, tag, checkInfo, wellKnown, popular, tagOccurrence) || this.checkStatus(instructions, tag, checkInfo, wellKnown) || this.checkRedirectTo(instructions, tag, checkInfo) || this.checkRelations(instructions, object, tag, checkInfo) || this.checkCountrySpecific(instructions, object, tag, checkInfo) || checkInfo != null && this.checkUnwantedTagOnObject(object, instructions, tag, checkInfo)) {
            return;
        }
        this.checkFallback(instructions, tag, keyInfo, popular, tagOccurrence, keyOccurrence);
    }

    private void fetchTagInfo(ExternalDataFetcher fileFetcher) {
        this.sqliteUtilsTagInfoKeyTable = new SQLiteUtils(fileFetcher, this.tagInfoDB, this.tagInfoKeyTable);
        if (!SQLiteUtils.isValidDatabase(this.sqliteUtilsTagInfoKeyTable.getFile())) {
            this.sqliteUtilsTagInfoKeyTable = null;
        }
        this.sqliteUtilsTagInfoTagTable = new SQLiteUtils(fileFetcher, this.tagInfoDB, this.tagInfoTagTable);
        if (!SQLiteUtils.isValidDatabase(this.sqliteUtilsTagInfoTagTable.getFile())) {
            this.sqliteUtilsTagInfoTagTable = null;
        }
    }

    private void fetchWikiData(ExternalDataFetcher fileFetcher) {
        this.sqliteUtilsWikiData = new SQLiteUtils(fileFetcher, this.wikiDataDB, this.wikiTable);
        if (!SQLiteUtils.isValidDatabase(this.sqliteUtilsWikiData.getFile())) {
            this.sqliteUtilsWikiData = null;
        }
    }

    private void flagTags(AtlasObject object, Map<String, Collection<IFeatureChange>> instructions) {
        for (Map.Entry entry : object.getOsmTags().entrySet()) {
            for (String value : ((String)entry.getValue()).split(";", -1)) {
                Map.Entry<String, String> tagEntry = Map.entry((String)entry.getKey(), value);
                if (this.ignoreTags.parallelStream().anyMatch(p -> p.test(new TestTaggable((String)tagEntry.getKey(), (String)tagEntry.getValue())))) continue;
                WikiData keyInfo = this.getWikiData(tagEntry.getKey(), null);
                boolean wellKnown = keyInfo != null && WikiDataItem.WELL_KNOWN_VALUES_Q8.matches(keyInfo.getKeyTypeP9());
                WikiData checkInfo = this.getWikiData(tagEntry.getKey(), tagEntry.getValue());
                if (checkInfo == null && !wellKnown) {
                    checkInfo = keyInfo;
                }
                this.checkWikiData((Taggable)object, instructions, tagEntry, keyInfo, checkInfo, wellKnown);
            }
        }
    }

    @Nonnull
    private TagInfoKeyTagCommon getTagInfo(String key, String value) {
        if (value != null) {
            Map<String, Object> map = this.sqliteUtilsTagInfoTagTable.getRows(Map.of("key", key, "value", value));
            return new TagInfoTags(map);
        }
        Map<String, Object> map = this.sqliteUtilsTagInfoKeyTable.getRows(Map.of("key", key));
        return new TagInfoKeys(map);
    }

    @Nullable
    private WikiData getWikiData(String key, String value) {
        Objects.requireNonNull(key, "key cannot be null");
        if (value == null || value.isBlank()) {
            return this.getWikiData(Map.of(WikiProperty.PERMANENT_KEY_ID_P16.getId(), key));
        }
        String tag = String.join((CharSequence)"=", key, value);
        return this.getWikiData(Map.of(WikiProperty.PERMANENT_TAG_ID_P19.getId(), tag));
    }

    @Nullable
    private WikiData getWikiData(Map<String, String> searchValues) {
        return WikiData.getWikiData(this.sqliteUtilsWikiData.getRows(searchValues));
    }

    @Nullable
    private WikiData getWikiDataId(String identifier) {
        Objects.requireNonNull(identifier, "id cannot be null");
        WikiData data = WikiData.getWikiData(identifier);
        if (data != null) {
            return data;
        }
        return this.getWikiData(Map.of(WikiProperty.ID.getDescriptor(), identifier));
    }

    private boolean isPopular(TagInfoKeys keyOccurrence, TagInfoTags tagOccurrence) {
        if (tagOccurrence != null && tagOccurrence.getCountAll() != null && tagOccurrence.getCountAll().longValue() > this.minTagUsage) {
            return true;
        }
        return keyOccurrence.getCountAll() != null && keyOccurrence.getCountAll().longValue() > this.minTagUsage && keyOccurrence.getCountAll().longValue() / keyOccurrence.getValuesAll().longValue() < (long)this.popularTagPercentageKey;
    }

    @Nullable
    private Map.Entry<String, String> parseTags(@Nonnull WikiData map) {
        String[] tagId;
        String key = map.getPermanentKeyIdP16();
        if (!key.isBlank()) {
            return Map.entry(key, "");
        }
        String tag = map.getPermanentTagIdP19();
        if (!tag.isBlank() && (tagId = tag.split("=", 2)).length == 2) {
            return Map.entry(tagId[0], tagId[1]);
        }
        return null;
    }
}

