/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.tag;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.walker.OsmWayWalker;
import org.openstreetmap.atlas.tags.HighwayTag;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class FixMeReviewCheck
extends BaseCheck<Long> {
    private static final long serialVersionUID = -2191776278923026805L;
    private static final String HAS_FIXME_TAG = "Object {0, number, #} has 'fixme' tag and needs to be investigated.";
    private static final List<String> FALLBACK_INSTRUCTIONS = Collections.singletonList("Object {0, number, #} has 'fixme' tag and needs to be investigated.");
    private static final List<String> FIX_ME_SUPPLEMENTARY_TAGS = List.of("waterway", "oneway", "building", "highway", "name", "ref", "place", "surface");
    private static final List<String> FIX_ME_SUPPORTED_VALUES_DEFAULT = List.of("verify", "position", "resurvey", "Revisar: este punto fue creado por importaci\u00f3n directa", "continue", "name", "incomplete", "draw geometry and delete this point", "unfinished", "recheck");
    private final List<String> fixMeSupportedValues;
    private final HighwayTag minHighwayTag;
    private static final String MIN_HIGHWAY_TAG_DEFAULT = "tertiary";

    public FixMeReviewCheck(Configuration configuration) {
        super(configuration);
        this.fixMeSupportedValues = this.configurationValue(configuration, "fixMe.supported.values", FIX_ME_SUPPORTED_VALUES_DEFAULT);
        this.minHighwayTag = Enum.valueOf(HighwayTag.class, this.configurationValue(configuration, "min.highway.type", MIN_HIGHWAY_TAG_DEFAULT).toUpperCase());
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        Map tags = object.getTags();
        return !this.isFlagged(object.getOsmIdentifier()) && (tags.containsKey("fixme") || tags.containsKey("fixme".toUpperCase()));
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        this.markAsFlagged(object.getOsmIdentifier());
        Map tags = object.getTags();
        if (this.featureHasSupplementaryTags(tags) && this.featureHasPriorityFixMeValues(tags)) {
            if (object instanceof Edge) {
                if (((Edge)object).highwayTag().isMoreImportantThanOrEqualTo(this.minHighwayTag)) {
                    return Optional.of(this.createFlag((Set<AtlasObject>)new OsmWayWalker((Edge)object).collectEdges(), this.getLocalizedInstruction(0, object.getOsmIdentifier())));
                }
                return Optional.empty();
            }
            return Optional.of(this.createFlag(object, this.getLocalizedInstruction(0, object.getOsmIdentifier())));
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private boolean featureHasPriorityFixMeValues(Map<String, String> tags) {
        for (String priorityTagValue : this.fixMeSupportedValues) {
            if ((!tags.containsKey("fixme".toUpperCase()) || !tags.get("fixme".toUpperCase()).equals(priorityTagValue)) && (!tags.containsKey("fixme") || !tags.get("fixme").equals(priorityTagValue))) continue;
            return true;
        }
        return false;
    }

    private boolean featureHasSupplementaryTags(Map<String, String> tags) {
        for (String supplementaryTag : FIX_ME_SUPPLEMENTARY_TAGS) {
            if (!tags.containsKey(supplementaryTag)) continue;
            return true;
        }
        return false;
    }
}

