/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.tag;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.GeometricSurface;
import org.openstreetmap.atlas.geography.atlas.items.Area;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasItem;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.LocationItem;
import org.openstreetmap.atlas.geography.atlas.items.Node;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.RelationMember;
import org.openstreetmap.atlas.tags.LeisureTag;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.tuples.Tuple;

public class DuplicateMapFeatureCheck
extends BaseCheck<Object> {
    private static final String DUPLICATE_FEATURE_INSTRUCTIONS = "{0} and {1} are duplicate feature {2}.";
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("{0} and {1} are duplicate feature {2}.");
    private static final List<String> Features_Tags_Should_Represent_Only_Once = Arrays.asList("amenity", "leisure", "building", "shop");
    private static final List<ItemType> WayNodeItemsTypesToCompare = Arrays.asList(ItemType.AREA, ItemType.EDGE, ItemType.LINE, ItemType.NODE, ItemType.POINT);
    private static final long serialVersionUID = 7595976166632982218L;
    private final List<String> featuresTagsShouldRepresentOnlyOnce;

    public DuplicateMapFeatureCheck(Configuration configuration) {
        super(configuration);
        this.featuresTagsShouldRepresentOnlyOnce = this.configurationValue(configuration, "features.tags.should.represent.only.once.in.area", Features_Tags_Should_Represent_Only_Once);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return (object instanceof Area || object instanceof Edge || object instanceof Relation) && !this.isFlagged(this.getUniqueOSMIdentifier(object));
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        this.markAsFlagged(this.getUniqueOSMIdentifier(object));
        if (object.getOsmTags().isEmpty()) {
            return Optional.empty();
        }
        Optional<Object> duplicateFeatures = Optional.empty();
        Object objectInstructionString = "";
        if (object instanceof Area) {
            objectInstructionString = "Area type Way " + Long.toString(object.getOsmIdentifier());
            Area area = (Area)object;
            duplicateFeatures = this.checkArea(area);
        }
        if (object instanceof Edge) {
            objectInstructionString = "Way " + Long.toString(object.getOsmIdentifier());
            Edge edge = (Edge)object;
            duplicateFeatures = this.checkEdge(edge);
        }
        if (object instanceof Relation) {
            objectInstructionString = "Relation " + Long.toString(object.getOsmIdentifier());
            Relation relation = (Relation)object;
            duplicateFeatures = this.checkRelation(relation);
        }
        if (duplicateFeatures.isPresent()) {
            Set duplicateFeatureIds = (Set)((Tuple)duplicateFeatures.get()).getFirst();
            Map duplicateFeaturesTags = (Map)((Tuple)duplicateFeatures.get()).getSecond();
            String duplicateFeatureString = this.getStringForList(duplicateFeatureIds);
            return Optional.of(this.createFlag(object, this.getLocalizedInstruction(0, objectInstructionString, duplicateFeatureString, duplicateFeaturesTags)));
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private Optional<Tuple<Set<String>, Map<String, String>>> checkArea(Area area) {
        HashSet<String> duplicateFeaturesIds = new HashSet<String>();
        HashMap duplicateFeaturesTags = new HashMap();
        try {
            Iterable locationItems = area.getAtlas().locationItemsWithin((GeometricSurface)area.bounds());
            for (LocationItem locationItem : locationItems) {
                Optional<Tuple<String, Map<String, String>>> duplicateFeature = this.verifyDuplicateFeature((AtlasEntity)area, (AtlasEntity)locationItem);
                if (!duplicateFeature.isPresent()) continue;
                duplicateFeaturesIds.add((String)duplicateFeature.get().getFirst());
                duplicateFeaturesTags.putAll((Map)duplicateFeature.get().getSecond());
            }
            if (!duplicateFeaturesIds.isEmpty()) {
                Tuple duplicateFeatures = Tuple.createTuple(duplicateFeaturesIds, duplicateFeaturesTags);
                return Optional.of(duplicateFeatures);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Optional.empty();
    }

    private Optional<Tuple<Set<String>, Map<String, String>>> checkEdge(Edge edge) {
        HashSet<String> duplicateFeaturesIds = new HashSet<String>();
        HashMap duplicateFeaturesTags = new HashMap();
        Set nodes = edge.connectedNodes();
        for (Node node : nodes) {
            Optional<Tuple<String, Map<String, String>>> duplicateFeature = this.verifyDuplicateFeature((AtlasEntity)edge, (AtlasEntity)node);
            if (!duplicateFeature.isPresent()) continue;
            duplicateFeaturesIds.add((String)duplicateFeature.get().getFirst());
            duplicateFeaturesTags.putAll((Map)duplicateFeature.get().getSecond());
        }
        if (!duplicateFeaturesIds.isEmpty()) {
            Tuple duplicateFeatures = Tuple.createTuple(duplicateFeaturesIds, duplicateFeaturesTags);
            return Optional.of(duplicateFeatures);
        }
        return Optional.empty();
    }

    private Optional<Tuple<Set<String>, Map<String, String>>> checkRelation(Relation relation) {
        HashSet<String> duplicateFeaturesIds = new HashSet<String>();
        HashMap duplicateFeaturesTags = new HashMap();
        List members = relation.members().stream().filter(member -> WayNodeItemsTypesToCompare.contains(member.getEntity().getType())).collect(Collectors.toList());
        for (RelationMember member2 : members) {
            Optional<Tuple<String, Map<String, String>>> duplicateFeature = this.verifyDuplicateFeature((AtlasEntity)relation, member2.getEntity());
            if (!duplicateFeature.isPresent()) continue;
            duplicateFeaturesIds.add((String)duplicateFeature.get().getFirst());
            duplicateFeaturesTags.putAll((Map)duplicateFeature.get().getSecond());
        }
        if (relation.isGeometric()) {
            try {
                Iterable items = relation.getAtlas().itemsWithin((GeometricSurface)relation.bounds());
                for (AtlasItem item : items) {
                    Optional<Tuple<String, Map<String, String>>> duplicateFeature;
                    if (this.isRelationMember(relation, (AtlasEntity)item) || !(duplicateFeature = this.verifyDuplicateFeature((AtlasEntity)relation, (AtlasEntity)item)).isPresent()) continue;
                    duplicateFeaturesIds.add((String)duplicateFeature.get().getFirst());
                    duplicateFeaturesTags.putAll((Map)duplicateFeature.get().getSecond());
                }
            }
            catch (Exception items) {
                // empty catch block
            }
        }
        if (!duplicateFeaturesIds.isEmpty()) {
            Tuple duplicateFeatures = Tuple.createTuple(duplicateFeaturesIds, duplicateFeaturesTags);
            return Optional.of(duplicateFeatures);
        }
        return Optional.empty();
    }

    private String getStringForList(Set<String> list) {
        return list.toString().replace("[", "").replace("]", "");
    }

    private boolean hasDifferentValueOfKey(Map<String, String> firstTags, Map<String, String> secondTags, String key) {
        return firstTags.get(key) != null && secondTags.get(key) != null && !firstTags.get(key).equals(secondTags.get(key));
    }

    private boolean hasOnlyBuildingWithoutName(Map<String, String> firstTags, Map<String, String> secondTags, Map<String, String> featuresTaggedTwice) {
        return featuresTaggedTwice.keySet().contains("building") && featuresTaggedTwice.keySet().size() == 1 && (firstTags.get("name") == null || secondTags.get("name") == null);
    }

    private boolean isRelationMember(Relation relation, AtlasEntity entity) {
        return relation.members().stream().anyMatch(member -> member.getEntity().getType().equals((Object)entity.getType()) && member.getEntity().getOsmIdentifier() == entity.getOsmIdentifier());
    }

    private Optional<Tuple<String, Map<String, String>>> verifyDuplicateFeature(AtlasEntity firstEntity, AtlasEntity secondEntity) {
        if (firstEntity.getOsmTags().isEmpty() || secondEntity.getOsmTags().isEmpty()) {
            return Optional.empty();
        }
        if (firstEntity.getOsmTags().equals(secondEntity.getOsmTags())) {
            String firstEntityString = (firstEntity instanceof Relation ? "Relation " : "Way ") + Long.toString(firstEntity.getOsmIdentifier());
            String duplicateFeatureString = secondEntity instanceof LocationItem ? "Node " + Long.toString(secondEntity.getOsmIdentifier()) + " with the same tags as " + firstEntityString : "Way " + Long.toString(secondEntity.getOsmIdentifier()) + " with the same tags as " + firstEntityString;
            Tuple duplicateFeature = Tuple.createTuple((Object)duplicateFeatureString, (Object)firstEntity.getOsmTags());
            return Optional.of(duplicateFeature);
        }
        Optional<Map<String, String>> featuresTaggedTwice = this.verifyObjectTaggedTwice(firstEntity.getTags(), secondEntity.getOsmTags());
        if (featuresTaggedTwice.isPresent()) {
            String duplicateFeatureString = secondEntity instanceof LocationItem ? "Node " + Long.toString(secondEntity.getOsmIdentifier()) : "Way " + Long.toString(secondEntity.getOsmIdentifier());
            Tuple duplicateFeature = Tuple.createTuple((Object)duplicateFeatureString, featuresTaggedTwice.get());
            return Optional.of(duplicateFeature);
        }
        return Optional.empty();
    }

    private Optional<Map<String, String>> verifyObjectTaggedTwice(Map<String, String> firstTags, Map<String, String> secondTags) {
        Map<String, String> inFirstTagsFeatureAllowRepresentOnce = firstTags.entrySet().stream().filter(map -> this.featuresTagsShouldRepresentOnlyOnce.contains(map.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<String, String> inSecondTagsFeatureAllowRepresentOnce = secondTags.entrySet().stream().filter(map -> this.featuresTagsShouldRepresentOnlyOnce.contains(map.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<String, String> featuresTaggedTwice = inFirstTagsFeatureAllowRepresentOnce.entrySet().stream().filter(map -> ((String)map.getValue()).equals(inSecondTagsFeatureAllowRepresentOnce.get(map.getKey()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (featuresTaggedTwice.isEmpty()) {
            return Optional.empty();
        }
        if (this.hasOnlyBuildingWithoutName(firstTags, secondTags, featuresTaggedTwice)) {
            return Optional.empty();
        }
        if (this.hasDifferentValueOfKey(firstTags, secondTags, "building")) {
            return Optional.empty();
        }
        if (LeisureTag.PITCH.name().toLowerCase().equals(featuresTaggedTwice.get("leisure")) || LeisureTag.TRACK.name().toLowerCase().equals(featuresTaggedTwice.get("leisure"))) {
            if (Objects.equals(firstTags.get("sport"), secondTags.get("sport"))) {
                if (firstTags.get("sport") != null) {
                    featuresTaggedTwice.put("sport", firstTags.get("sport"));
                }
                return Optional.of(featuresTaggedTwice);
            }
            if (this.hasDifferentValueOfKey(firstTags, secondTags, "sport")) {
                return Optional.empty();
            }
        }
        if (Objects.equals(firstTags.get("name"), secondTags.get("name"))) {
            if (firstTags.get("name") != null) {
                featuresTaggedTwice.put("name", firstTags.get("name"));
            }
            return Optional.of(featuresTaggedTwice);
        }
        return Optional.empty();
    }
}

