/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.tag;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.checks.utility.KeyFullyChecked;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class ConditionalRestrictionCheck
extends BaseCheck<String> {
    private static final long serialVersionUID = 6726352951073801440L;
    @KeyFullyChecked(value=KeyFullyChecked.Type.PARTIAL)
    public static final String CONDITIONAL = ":conditional";
    private static final List<String> RESTRICTION_TYPES = List.of("access", "restriction", "maxspeed", "minspeed", "maxweight", "maxaxleload", "maxheight", "maxlength", "maxstay", "maxgcweight", "maxgcweightrating", "interval", "duration", "overtaking", "oneway", "fee", "toll", "noexit", "snowplowing", "disabled", "lanes", "parking");
    private static final List<String> TRANSPORTATION_MODE = List.of("foot", "ski", "inline_skates", "horse", "vehicle", "bicycle", "carriage", "trailer", "caravan", "motor_vehicle", "motorcycle", "moped", "mofa", "motorcar", "motorhome", "tourist_bus", "coach", "goods", "hgv", "hgv_articulated", "agricultural", "golf_cart", "atv", "snowmobile", "psv", "bus", "minibus", "share_taxi", "taxi", "hov", "hazmat", "emergency", "canoe", "electric_vehicle", "cycleway", "busway");
    private static final List<String> DIRECTION = List.of("forward", "backward", "left", "right", "both");
    private static final List<String> ACCESS_RESTRICTION_VALUE = List.of("yes", "no", "private", "permissive", "destination", "delivery", "customers", "designated", "use_sidepath", "dismount", "agricultural", "forestry", "discouraged", "official", "lane", "share_busway", "opposite_share_busway");
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("The conditional key \"{0}\" does not respect the \"<restriction-type>[:<transportation mode>][:<direction>]:conditional\" format", "The conditional value \"{0}\" does not respect the format \"<restriction-value> @ <condition>[;<restriction-value> @ <condition>]\" ", "The element with id {0,number,#} does not follow the conditional restriction pattern.");
    private static final int TWO_PARTS = 2;
    private static final int THREE_PARTS = 3;
    private static final int FOUR_PARTS = 4;
    private static final Pattern VALUE_PATTERN = Pattern.compile("([a-zA-Z0-9_.-|\\s]*?)\\s@\\s(\\([^)\\s][^)]+?\\)|[^();\\s][^();]*)\\s*(;\\s*([^@\\s][^@]*?)\\s*@\\s*(\\([^)\\s][^)]+?\\)|[^();\\s][^();]*?)\\s*)*");

    public ConditionalRestrictionCheck(Configuration configuration) {
        super(configuration);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object.getOsmTags().keySet().stream().anyMatch(key -> key.contains(CONDITIONAL));
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        HashSet<String> instructions = new HashSet<String>();
        List conditionalKeys = object.getOsmTags().keySet().stream().filter(key -> key.contains(CONDITIONAL)).collect(Collectors.toList());
        for (String key2 : conditionalKeys) {
            String value;
            if (!this.isKeyValid(key2)) {
                instructions.add(this.getLocalizedInstruction(0, key2));
            }
            if (this.isValueValid(value = (String)object.getOsmTags().get(key2), key2)) continue;
            instructions.add(this.getLocalizedInstruction(1, value));
        }
        if (!instructions.isEmpty()) {
            CheckFlag flag = this.createFlag(object, this.getLocalizedInstruction(2, object.getOsmIdentifier()));
            instructions.forEach(flag::addInstruction);
            return Optional.of(flag);
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private boolean containsTransportationMode(String key) {
        String[] parts;
        for (String part : parts = key.split(":")) {
            if (!this.isTransportationMode(part)) continue;
            return true;
        }
        return false;
    }

    private boolean isAccessType(String value) {
        return "access".equals(value);
    }

    private boolean isAccessValue(String value) {
        return ACCESS_RESTRICTION_VALUE.contains(value);
    }

    private boolean isDirection(String value) {
        return DIRECTION.contains(value);
    }

    private boolean isKeyValid(String key) {
        String[] parts = key.split(":");
        boolean isAccessLanes = parts.length > 2 && this.isAccessType(parts[0]) && this.isLanes(parts[1]);
        switch (parts.length) {
            case 2: {
                return this.isRestrictionType(parts[0]) || this.isTransportationMode(parts[0]);
            }
            case 3: {
                boolean isRestrictionTypeFormat = this.isRestrictionType(parts[0]) && (this.isTransportationMode(parts[1]) || this.isDirection(parts[1]));
                boolean isTransportTypeFormat = this.isTransportationMode(parts[0]) && (this.isDirection(parts[1]) || this.isLanes(parts[1]));
                return isRestrictionTypeFormat || isTransportTypeFormat || isAccessLanes;
            }
            case 4: {
                boolean isRestrictionTransport = this.isRestrictionType(parts[0]) && this.isTransportationMode(parts[1]);
                boolean isTransportLanes = this.isTransportationMode(parts[0]) && this.isLanes(parts[1]);
                return (isRestrictionTransport || isTransportLanes || isAccessLanes) && this.isDirection(parts[2]);
            }
        }
        return false;
    }

    private boolean isLanes(String value) {
        return "lanes".equals(value);
    }

    private boolean isNotLanesType(String key) {
        String[] parts = key.split(":");
        return !this.isLanes(parts[0]);
    }

    private boolean isRestrictionType(String value) {
        return RESTRICTION_TYPES.contains(value);
    }

    private boolean isTransportationMode(String value) {
        return TRANSPORTATION_MODE.contains(value);
    }

    private boolean isValueValid(String value, String key) {
        Matcher matcher = VALUE_PATTERN.matcher(value);
        if (matcher.matches()) {
            if (this.containsTransportationMode(key) && this.isNotLanesType(key)) {
                String[] parts = value.split("@");
                for (int i = 0; i < parts.length - 1; i += 2) {
                    String[] subParts;
                    for (String part : subParts = parts[i].split("\\|")) {
                        String trimmedPart = part.trim();
                        if (trimmedPart.isEmpty() || this.isAccessValue(trimmedPart)) continue;
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
        return true;
    }
}

