/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.tag;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.change.FeatureChange;
import org.openstreetmap.atlas.geography.atlas.complete.CompleteEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbbreviatedAddressStreetCheck
extends BaseCheck<String> {
    private static final String INSTRUCTION_FORMAT = "OSM entity {0,number,#} has address {1} with abbreviated road type \"{2}\". According to conventions, it should be changed to \"{3}\".";
    private static final List<String> FALLBACK_INSTRUCTIONS = Collections.singletonList("OSM entity {0,number,#} has address {1} with abbreviated road type \"{2}\". According to conventions, it should be changed to \"{3}\".");
    private static final String DEFAULT_ABBREVIATION_RESOURCE = "StreetName.txt";
    private static final Logger logger = LoggerFactory.getLogger(AbbreviatedAddressStreetCheck.class);
    private final Map<String, List<String>> roadTypeAbbreviationsMap = new HashMap<String, List<String>>();

    public AbbreviatedAddressStreetCheck(Configuration configuration) {
        super(configuration);
        this.parseAddressConventionConfig();
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof AtlasEntity && !this.isFlagged(this.getUniqueOSMIdentifier(object));
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        this.markAsFlagged(this.getUniqueOSMIdentifier(object));
        String addressStreet = object.getTag("addr:street").orElse(null);
        if (addressStreet != null) {
            String[] splitStreetName = addressStreet.split("\\s+");
            Pair<String, Integer> roadTypeWithIndex = this.getRoadTypeWithPositionalIndex(splitStreetName);
            String roadType = (String)roadTypeWithIndex.getLeft();
            Integer roadTypeIndex = (Integer)roadTypeWithIndex.getRight();
            for (Map.Entry<String, List<String>> listEntry : this.roadTypeAbbreviationsMap.entrySet()) {
                for (String abbreviation : listEntry.getValue()) {
                    if (!roadType.matches(abbreviation + "\\.?$")) continue;
                    return Optional.of(this.createFlag(object, this.getLocalizedInstruction(0, object.getOsmIdentifier(), addressStreet, roadType, listEntry.getKey())).addFixSuggestion(FeatureChange.add((AtlasEntity)((AtlasEntity)((CompleteEntity)CompleteEntity.from((AtlasEntity)((AtlasEntity)object))).withTags(object.getTags()).withReplacedTag("addr:street", "addr:street", this.updateStreetAddress(splitStreetName, roadTypeIndex, listEntry.getKey()))), (Atlas)object.getAtlas())));
                }
            }
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private Pair<String, Integer> getRoadTypeWithPositionalIndex(String[] splitStreetName) {
        return this.isAddressStreetContainDirectional(splitStreetName[splitStreetName.length - 1]) ? Pair.of((Object)splitStreetName[splitStreetName.length - 2], (Object)(splitStreetName.length - 2)) : Pair.of((Object)splitStreetName[splitStreetName.length - 1], (Object)(splitStreetName.length - 1));
    }

    private boolean isAddressStreetContainDirectional(String streetAddressToken) {
        return streetAddressToken.matches("^(N|S|E|W|NE|SE|SW|NW)\\.?$");
    }

    private void parseAddressConventionConfig() {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(Objects.requireNonNull(AbbreviatedAddressStreetCheck.class.getResourceAsStream(DEFAULT_ABBREVIATION_RESOURCE))));
            String line = reader.readLine();
            while (line != null) {
                if (line.startsWith("#")) {
                    line = reader.readLine();
                    continue;
                }
                String roadType = line.split(":")[0];
                String roadTypeAbbreviations = line.split(":")[1];
                String[] abbreviationsVariations = roadTypeAbbreviations.split("\\|");
                ArrayList<String> temp = new ArrayList<String>(Arrays.asList(abbreviationsVariations));
                this.roadTypeAbbreviationsMap.put(roadType, temp);
                line = reader.readLine();
            }
            reader.close();
        }
        catch (IOException exception) {
            logger.error(String.format("Could not read %s", DEFAULT_ABBREVIATION_RESOURCE), (Throwable)exception);
        }
    }

    private String updateStreetAddress(String[] streetAddress, Integer roadTypeIndex, String correctRoadType) {
        streetAddress[roadTypeIndex.intValue()] = correctRoadType;
        return String.join((CharSequence)" ", streetAddress);
    }
}

