/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.relations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.PolyLine;
import org.openstreetmap.atlas.geography.Snapper;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasItem;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Edge;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.LineItem;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.RelationMember;
import org.openstreetmap.atlas.tags.RelationTypeTag;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.scalars.Distance;

public class RouteRelationCheck
extends BaseCheck<Object> {
    private static final String GAPS_IN_ROUTE_TRACK_INSTRUCTION = "The route in relation with ID = {0,number,#} has gaps in the track.";
    private static final String STOP_TOO_FAR_FROM_ROUTE_TRACK_INSTRUCTION = "The stops in the route relation with ID={0,number,#} are too far from the track.";
    private static final String PLATFORM_TOO_FAR_FROM_ROUTE_TRACK_INSTRUCTION = "The platforms in the route relation with ID={0,number,#} are too far from the track.";
    private static final String ROUTE_MASTER_HAS_NON_ROUTE_ELEMENT_INSTRUCTION = "The route master relation with ID={0,number,#} contains non route element.";
    private static final String PUBLIC_TRANSPORT_ROUTE_NOT_IN_ROUTE_MASTER_INSTRUCTION = "The relation with ID={0,number,#} is a public transportation route and has route type being {1}. It should be contained in a Route Master relation.";
    private static final String INCONSISTENT_NETWORK_OPERATOR_REF_COLOUR_TAGS_INSTRUCTION = "The relation with ID={0,number,#} has inconsistent network, operator, ref, or colour tag with its route master.";
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("The route in relation with ID = {0,number,#} has gaps in the track.", "The stops in the route relation with ID={0,number,#} are too far from the track.", "The platforms in the route relation with ID={0,number,#} are too far from the track.", "The route master relation with ID={0,number,#} contains non route element.", "The relation with ID={0,number,#} is a public transportation route and has route type being {1}. It should be contained in a Route Master relation.", "The relation with ID={0,number,#} has inconsistent network, operator, ref, or colour tag with its route master.");
    private static final int GAPS_IN_ROUTE_TRACK_INDEX = 0;
    private static final int STOP_TOO_FAR_FROM_ROUTE_TRACK_INDEX = 1;
    private static final int PLATFORM_TOO_FAR_FROM_ROUTE_TRACK_INDEX = 2;
    private static final int ROUTE_MASTER_HAS_NON_ROUTE_ELEMENT_INDEX = 3;
    private static final int PUBLIC_TRANSPORT_ROUTE_NOT_IN_ROUTE_MASTER_INDEX = 4;
    private static final int INCONSISTENT_NETWORK_OPERATOR_REF_COLOUR_TAGS_INDEX = 5;
    private static final List<String> Public_Transport_Types_Default = Arrays.asList("train", "subway", "bus", "trolleybus", "minibus", "light_rail", "share_taxi", "railway", "rail", "tram", "aircraft", "ferry");
    private final List<String> publicTransportTypes;
    private static final long serialVersionUID = 7671409062471623430L;

    public RouteRelationCheck(Configuration configuration) {
        super(configuration);
        this.publicTransportTypes = this.configurationValue(configuration, "features.public.transport", Public_Transport_Types_Default);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Relation && Validators.isOfType((Taggable)object, RelationTypeTag.class, (Enum[])new RelationTypeTag[]{RelationTypeTag.ROUTE_MASTER, RelationTypeTag.ROUTE}) && !this.isFlagged(object.getOsmIdentifier());
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Relation routeRel = (Relation)object;
        ArrayList<String> instructions = new ArrayList<String>();
        FlagTransferData routeSignInstructions = null;
        if (Validators.isOfType((Taggable)object, RelationTypeTag.class, (Enum[])new RelationTypeTag[]{RelationTypeTag.ROUTE_MASTER})) {
            routeSignInstructions = this.processRouteMasterRelation(routeRel);
        }
        if (Validators.isOfType((Taggable)object, RelationTypeTag.class, (Enum[])new RelationTypeTag[]{RelationTypeTag.ROUTE})) {
            routeSignInstructions = this.processRouteRelation(routeRel);
        }
        HashSet<AtlasEntity> atlasObjectFlagged = new HashSet<AtlasEntity>();
        if (Objects.nonNull(routeSignInstructions)) {
            instructions.addAll(routeSignInstructions.getInstructions());
            atlasObjectFlagged.addAll(routeSignInstructions.getEdgesLines());
            atlasObjectFlagged.addAll(routeSignInstructions.getAllSigns());
            if (routeSignInstructions.getNonRouteMembers() != null) {
                atlasObjectFlagged.addAll(routeSignInstructions.getNonRouteMembers());
            }
            if (atlasObjectFlagged.isEmpty()) {
                AtlasEntity firstMember = routeRel.members().stream().map(RelationMember::getEntity).findFirst().orElse(null);
                try {
                    atlasObjectFlagged.add(firstMember);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.markAsFlagged(object.getOsmIdentifier());
        return instructions.isEmpty() ? Optional.empty() : Optional.of(this.createFlag(atlasObjectFlagged, instructions));
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private EdgeLineData polylineRouteRel(Relation rel) {
        List allEdges = rel.members().stream().map(RelationMember::getEntity).filter(member -> member.getType().equals((Object)ItemType.EDGE)).map(Edge.class::cast).filter(Edge::isMainEdge).collect(Collectors.toList());
        List allLines = rel.members().stream().map(RelationMember::getEntity).filter(member -> member.getType().equals((Object)ItemType.LINE)).map(Line.class::cast).collect(Collectors.toList());
        ArrayList<LineItem> edgesLines = new ArrayList<LineItem>();
        ArrayList<PolyLine> allPolyLines = new ArrayList<PolyLine>();
        edgesLines.addAll(allEdges);
        edgesLines.addAll(allLines);
        edgesLines.forEach(lineItem -> allPolyLines.add(lineItem.asPolyLine()));
        return new EdgeLineData(allPolyLines, edgesLines);
    }

    private FlagTransferData processRouteMasterRelation(Relation routeMasterRelation) {
        ArrayList<String> instructionsAdd = new ArrayList<String>();
        ArrayList<AtlasEntity> allEdgesLinesFlagged = new ArrayList<AtlasEntity>();
        ArrayList<AtlasEntity> allSignsEntitiesFlagged = new ArrayList<AtlasEntity>();
        ArrayList<Location> allSignsLocationsFlagged = new ArrayList<Location>();
        HashSet<AtlasEntity> nonRouteMembers = new HashSet<AtlasEntity>();
        Set<Relation> routeSet = this.routeSetMemberRelations(routeMasterRelation);
        for (Relation relation : routeSet) {
            FlagTransferData routeSignInstructions = this.processRouteRelationHelper(relation);
            instructionsAdd.addAll(routeSignInstructions.getInstructions());
            allEdgesLinesFlagged.addAll(routeSignInstructions.getEdgesLines());
            allSignsEntitiesFlagged.addAll(routeSignInstructions.getAllSigns());
            allSignsLocationsFlagged.addAll(routeSignInstructions.getAllSignsLocations());
        }
        List<String> tempInstructions = this.testNetworkOperatorRefColourTag(routeMasterRelation);
        if (!tempInstructions.isEmpty()) {
            instructionsAdd.addAll(tempInstructions);
        }
        if (routeSet.size() < routeMasterRelation.members().size()) {
            Set otherMembers = routeMasterRelation.members().stream().map(RelationMember::getEntity).filter(member -> !Validators.isOfType((Taggable)member, RelationTypeTag.class, (Enum[])new RelationTypeTag[]{RelationTypeTag.ROUTE})).collect(Collectors.toSet());
            nonRouteMembers.addAll(otherMembers);
            instructionsAdd.add(this.getLocalizedInstruction(3, routeMasterRelation.getOsmIdentifier()));
        }
        return new FlagTransferData(instructionsAdd, allEdgesLinesFlagged, allSignsEntitiesFlagged, allSignsLocationsFlagged, nonRouteMembers);
    }

    private FlagTransferData processRouteRelation(Relation relation) {
        Set relationsContained;
        FlagTransferData routeSignInstructions = this.processRouteRelationHelper(relation);
        List<String> instructionsAdd = routeSignInstructions.getInstructions();
        List<AtlasEntity> allEdgesLinesFlagged = routeSignInstructions.getEdgesLines();
        List<AtlasEntity> allSignsEntitiesFlagged = routeSignInstructions.getAllSigns();
        List<Location> allSignsLocationsFlagged = routeSignInstructions.getAllSignsLocations();
        Optional transportType = relation.getTag("route");
        if (transportType.isPresent() && this.publicTransportTypes.contains(transportType.get()) && (relationsContained = relation.relations()).stream().noneMatch(member -> Validators.isOfType((Taggable)member, RelationTypeTag.class, (Enum[])new RelationTypeTag[]{RelationTypeTag.ROUTE_MASTER}))) {
            instructionsAdd.add(this.getLocalizedInstruction(4, relation.getOsmIdentifier(), transportType.get()));
        }
        return new FlagTransferData(instructionsAdd, allEdgesLinesFlagged, allSignsEntitiesFlagged, allSignsLocationsFlagged, null);
    }

    private FlagTransferData processRouteRelationHelper(Relation relation) {
        FlagTransferData platformsFlaggedInfo;
        List<AtlasEntity> platformsEntitiesFlagged;
        FlagTransferData routeResults = this.routeForGaps(relation);
        List<String> instructionsAdd = routeResults.getInstructions();
        List<AtlasEntity> edgesLinesFlagged = routeResults.getEdgesLines();
        ArrayList<AtlasEntity> allSignsFlagged = new ArrayList<AtlasEntity>();
        ArrayList<Location> allStopsPlatformsFlagged = new ArrayList<Location>();
        FlagTransferData stopsFlaggedInfo = this.stopPlatformTooFarFromTrack(relation, "stop");
        List<AtlasEntity> stopsEntitiesFlagged = stopsFlaggedInfo.getAllSigns();
        if (!stopsEntitiesFlagged.isEmpty()) {
            allSignsFlagged.addAll(stopsEntitiesFlagged);
            instructionsAdd.add(this.getLocalizedInstruction(1, relation.getOsmIdentifier()));
        }
        if (!(platformsEntitiesFlagged = (platformsFlaggedInfo = this.stopPlatformTooFarFromTrack(relation, "platform")).getAllSigns()).isEmpty()) {
            allSignsFlagged.addAll(platformsEntitiesFlagged);
            instructionsAdd.add(this.getLocalizedInstruction(2, relation.getOsmIdentifier()));
        }
        return new FlagTransferData(instructionsAdd, edgesLinesFlagged, allSignsFlagged, allStopsPlatformsFlagged, null);
    }

    private FlagTransferData routeForGaps(Relation relation) {
        List<PolyLine> disconnectedMembers;
        ArrayList<String> instructionsAdd = new ArrayList<String>();
        EdgeLineData edgesPolyLines = this.polylineRouteRel(relation);
        List<LineItem> edgesLines = edgesPolyLines.getEdgesLines();
        List<PolyLine> allPolyLines = edgesPolyLines.getAllPolyLines();
        ArrayList<AtlasEntity> edgesLinesFlagged = new ArrayList<AtlasEntity>();
        if (allPolyLines.size() > 1 && !(disconnectedMembers = this.routeFromNonArrangedEdgeSet(allPolyLines)).isEmpty()) {
            for (int index = 0; index < allPolyLines.size(); ++index) {
                if (!disconnectedMembers.contains(allPolyLines.get(index))) continue;
                edgesLinesFlagged.add((AtlasEntity)edgesLines.get(index));
            }
            instructionsAdd.add(this.getLocalizedInstruction(0, relation.getOsmIdentifier()));
        }
        return new FlagTransferData(instructionsAdd, edgesLinesFlagged, null, null, null);
    }

    private List<PolyLine> routeFromNonArrangedEdgeSet(List<PolyLine> linesInRoute) {
        ArrayList<LinkedList<PolyLine>> routes = new ArrayList<LinkedList<PolyLine>>();
        List<LinkedList<PolyLine>> routeInformation = this.routeSet(linesInRoute);
        routes.add(routeInformation.get(0));
        List<Object> membersLeft = new ArrayList<PolyLine>((Collection)routeInformation.get(1));
        while (!membersLeft.isEmpty()) {
            List<LinkedList<PolyLine>> memberRouteInformation = this.routeSet(membersLeft);
            routes.add(memberRouteInformation.get(0));
            membersLeft = memberRouteInformation.get(1);
        }
        ArrayList<PolyLine> disconnectedMembers = new ArrayList<PolyLine>();
        if (routes.size() > 1) {
            disconnectedMembers.addAll(this.routeSetDisconnected(routes));
        }
        return disconnectedMembers;
    }

    private List<LinkedList<PolyLine>> routeSet(List<PolyLine> linesInRoute) {
        ArrayList<PolyLine> members = new ArrayList<PolyLine>(linesInRoute);
        LinkedList<PolyLine> membersLeft = new LinkedList<PolyLine>();
        LinkedList<PolyLine> routeCreated = new LinkedList<PolyLine>();
        routeCreated.add((PolyLine)members.get(0));
        int previousSize = -1;
        int currentSize = routeCreated.size();
        while (routeCreated.size() < members.size() && previousSize < currentSize) {
            previousSize = routeCreated.size();
            for (PolyLine lineMember : members) {
                if (routeCreated.contains(lineMember)) continue;
                if (lineMember.first().equals((Object)((PolyLine)routeCreated.getLast()).last())) {
                    routeCreated.addLast(lineMember);
                    continue;
                }
                if (!lineMember.last().equals((Object)((PolyLine)routeCreated.getFirst()).first())) continue;
                routeCreated.addFirst(lineMember);
            }
            currentSize = routeCreated.size();
        }
        for (PolyLine lineMember : members) {
            if (routeCreated.contains(lineMember)) continue;
            membersLeft.add(lineMember);
        }
        return Arrays.asList(routeCreated, membersLeft);
    }

    private boolean routeSetConnectedCheck(LinkedList<PolyLine> routeOne, LinkedList<PolyLine> routeTwo) {
        for (PolyLine lineOne : routeOne) {
            for (PolyLine lineTwo : routeTwo) {
                if (!lineOne.stream().anyMatch(arg_0 -> ((PolyLine)lineTwo).contains(arg_0))) continue;
                return true;
            }
        }
        return false;
    }

    private List<PolyLine> routeSetDisconnected(List<LinkedList<PolyLine>> routes) {
        HashSet<PolyLine> disconnectedRoutes = new HashSet<PolyLine>();
        HashSet<PolyLine> routeCreated = new HashSet<PolyLine>();
        HashSet<Integer> connectedIndex = new HashSet<Integer>();
        for (int routeOneIndex = 0; routeOneIndex < routes.size(); ++routeOneIndex) {
            if (connectedIndex.contains(routeOneIndex)) continue;
            boolean connected = false;
            LinkedList<PolyLine> routeOne = routes.get(routeOneIndex);
            for (int routeTwoIndex = 0; routeTwoIndex < routes.size(); ++routeTwoIndex) {
                LinkedList<PolyLine> routeTwo = routes.get(routeTwoIndex);
                if (routeTwoIndex == routeOneIndex || connected || !this.routeSetConnectedCheck(routeOne, routeTwo)) continue;
                connected = true;
                connectedIndex.add(routeOneIndex);
                connectedIndex.add(routeTwoIndex);
                routeCreated.addAll((Collection<PolyLine>)routes.get(routeOneIndex));
                routeCreated.addAll((Collection<PolyLine>)routes.get(routeTwoIndex));
            }
            if (connected) continue;
            disconnectedRoutes.addAll(routeOne);
        }
        ArrayList<PolyLine> disconnectedMembersMinimal = new ArrayList<PolyLine>();
        if (!disconnectedRoutes.isEmpty()) {
            disconnectedMembersMinimal.addAll(this.routeSetDisconnectedClosest(routeCreated, disconnectedRoutes));
        }
        return disconnectedMembersMinimal;
    }

    private List<PolyLine> routeSetDisconnectedClosest(Set<PolyLine> routeCreated, Set<PolyLine> disconnectedMembers) {
        ArrayList<PolyLine> disconnectedMembersMinimal = new ArrayList<PolyLine>();
        Distance minimumDistance = null;
        HashMap<Distance, Set<PolyLine>> disconnectedDistance = new HashMap<Distance, Set<PolyLine>>();
        if (!routeCreated.isEmpty() && !disconnectedMembers.isEmpty()) {
            for (PolyLine lineOne : disconnectedMembers) {
                for (PolyLine lineTwo : routeCreated) {
                    Distance tempDistance = this.routeSetDisconnectedClosestDistance(lineOne, lineTwo);
                    minimumDistance = this.routeSetDisconnectedClosestMap(disconnectedDistance, tempDistance, Set.of(lineOne, lineTwo), true, minimumDistance);
                }
            }
            disconnectedMembersMinimal.addAll((Collection)disconnectedDistance.get(minimumDistance));
        } else if (!disconnectedMembers.isEmpty()) {
            HashMap<Distance, Set<PolyLine>> lengthMap = new HashMap<Distance, Set<PolyLine>>();
            Distance maxLength = null;
            for (PolyLine polyline : disconnectedMembers) {
                Distance length = polyline.length();
                maxLength = this.routeSetDisconnectedClosestMap(lengthMap, length, Set.of(polyline), false, maxLength);
            }
            disconnectedMembersMinimal.addAll((Collection)lengthMap.get(maxLength));
        }
        return disconnectedMembersMinimal;
    }

    private Distance routeSetDisconnectedClosestDistance(PolyLine lineOne, PolyLine lineTwo) {
        Location lineOneStart = lineOne.first();
        Location lineOneEnd = lineOne.last();
        Location lineTwoStart = lineTwo.first();
        Location lineTwoEnd = lineTwo.last();
        Distance startDistanceStart = lineOneStart.distanceTo(lineTwoStart);
        Distance startDistanceEnd = lineOneStart.distanceTo(lineTwoEnd);
        Distance endDistanceStart = lineOneEnd.distanceTo(lineTwoStart);
        Distance endDistanceEnd = lineOneEnd.distanceTo(lineTwoEnd);
        Distance tempMin = startDistanceStart;
        if (startDistanceEnd.isLessThan(tempMin)) {
            tempMin = startDistanceEnd;
        }
        if (endDistanceStart.isLessThan(tempMin)) {
            tempMin = endDistanceStart;
        }
        if (endDistanceEnd.isLessThan(tempMin)) {
            tempMin = endDistanceEnd;
        }
        return tempMin;
    }

    private Distance routeSetDisconnectedClosestMap(Map<Distance, Set<PolyLine>> map, Distance currentValue, Set<PolyLine> lineSet, boolean findMin, Distance lengthOrDistance) {
        if (map.containsKey(currentValue)) {
            HashSet<PolyLine> lineDistance = new HashSet<PolyLine>();
            lineDistance.addAll((Collection)map.get(currentValue));
            lineDistance.addAll(lineSet);
            map.put(currentValue, lineDistance);
        } else {
            map.put(currentValue, lineSet);
        }
        if (findMin) {
            if (lengthOrDistance == null || currentValue.isLessThan(lengthOrDistance)) {
                return currentValue;
            }
            return lengthOrDistance;
        }
        if (lengthOrDistance == null || currentValue.isGreaterThan(lengthOrDistance)) {
            return currentValue;
        }
        return lengthOrDistance;
    }

    private Set<Relation> routeSetMemberRelations(Relation rel) {
        return rel.members().stream().map(RelationMember::getEntity).filter(member -> member.getType().equals((Object)ItemType.RELATION)).map(Relation.class::cast).filter(member -> Validators.isOfType((Taggable)member, RelationTypeTag.class, (Enum[])new RelationTypeTag[]{RelationTypeTag.ROUTE})).collect(Collectors.toSet());
    }

    private FlagTransferData stopPlatformTooFarFromTrack(Relation relation, String stopOrPlatform) {
        List allSigns = relation.members().stream().filter(member -> member.getRole().equals(stopOrPlatform)).map(RelationMember::getEntity).collect(Collectors.toList());
        List<PolyLine> allEdgePolyLines = this.polylineRouteRel(relation).getAllPolyLines();
        ArrayList<Location> signLocationsFlagged = new ArrayList<Location>();
        ArrayList<AtlasEntity> allSignsEntitiesFlagged = new ArrayList<AtlasEntity>();
        for (AtlasEntity entity : allSigns) {
            ArrayList<Location> signLocations = new ArrayList<Location>();
            if (entity instanceof AtlasItem) {
                AtlasItem signPositions = (AtlasItem)entity;
                signPositions.getRawGeometry().forEach(signLocations::add);
            }
            if (!this.stopPlatformTooFarFromTrackCheck(signLocations, allEdgePolyLines)) continue;
            allSignsEntitiesFlagged.add(entity);
        }
        return new FlagTransferData(null, null, allSignsEntitiesFlagged, signLocationsFlagged, null);
    }

    private boolean stopPlatformTooFarFromTrackCheck(List<Location> signLocations, List<PolyLine> allEdgePolyLines) {
        Distance threshHold = Distance.meters((double)15.0);
        Snapper.SnappedLocation minimumSnap = null;
        for (Location location : signLocations) {
            for (PolyLine edges : allEdgePolyLines) {
                Snapper.SnappedLocation snappedTo = location.snapTo(edges);
                if (minimumSnap != null && snappedTo.compareTo(minimumSnap) >= 0) continue;
                minimumSnap = snappedTo;
            }
        }
        return minimumSnap != null && minimumSnap.getDistance().isGreaterThan(threshHold);
    }

    private List<String> testNetworkOperatorRefColourTag(Relation relation) {
        ArrayList<String> instructionsAdd = new ArrayList<String>();
        Optional networkTag = relation.getTag("network");
        Optional operatorTag = relation.getTag("operator");
        Optional refTag = relation.getTag("ref");
        Optional colourTag = relation.getTag("colour");
        Set<Relation> routeSet = this.routeSetMemberRelations(relation);
        for (Relation relRoute : routeSet) {
            Optional routeNetwork = relRoute.getTag("network");
            Optional routeOperator = relRoute.getTag("operator");
            Optional routeRef = relRoute.getTag("ref");
            Optional routeColour = relRoute.getTag("colour");
            if (!(routeNetwork.isPresent() && networkTag.isPresent() && !routeNetwork.equals(networkTag) || routeOperator.isPresent() && operatorTag.isPresent() && !routeOperator.equals(operatorTag) || routeRef.isPresent() && refTag.isPresent() && !routeRef.equals(refTag)) && (!routeColour.isPresent() || !colourTag.isPresent() || routeColour.equals(colourTag))) continue;
            instructionsAdd.add(this.getLocalizedInstruction(5, relRoute.getOsmIdentifier()));
        }
        return instructionsAdd;
    }

    private static final class FlagTransferData {
        private final List<String> instructions;
        private final List<AtlasEntity> edgesLines;
        private final List<AtlasEntity> allSigns;
        private final List<Location> allSignsLocations;
        private final Set<AtlasEntity> nonRouteMembers;

        FlagTransferData(List<String> instructions, List<AtlasEntity> edgesLines, List<AtlasEntity> allSigns, List<Location> allSignsLocations, Set<AtlasEntity> nonRouteMembers) {
            this.instructions = instructions;
            this.edgesLines = edgesLines;
            this.allSigns = allSigns;
            this.allSignsLocations = allSignsLocations;
            this.nonRouteMembers = nonRouteMembers;
        }

        public List<AtlasEntity> getAllSigns() {
            return this.allSigns;
        }

        public List<Location> getAllSignsLocations() {
            return this.allSignsLocations;
        }

        public List<AtlasEntity> getEdgesLines() {
            return this.edgesLines;
        }

        public List<String> getInstructions() {
            return this.instructions;
        }

        public Set<AtlasEntity> getNonRouteMembers() {
            return this.nonRouteMembers;
        }
    }

    private static final class EdgeLineData {
        private final List<PolyLine> allPolyLines;
        private final List<LineItem> edgesLines;

        EdgeLineData(List<PolyLine> allPolyLines, List<LineItem> edgesLines) {
            this.allPolyLines = allPolyLines;
            this.edgesLines = edgesLines;
        }

        public List<PolyLine> getAllPolyLines() {
            return this.allPolyLines;
        }

        public List<LineItem> getEdgesLines() {
            return this.edgesLines;
        }
    }
}

