/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.relations;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.atlas.items.AtlasEntity;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.complex.RelationOrAreaToMultiPolygonConverter;
import org.openstreetmap.atlas.geography.converters.MultiplePolyLineToPolygonsConverter;
import org.openstreetmap.atlas.tags.RelationTypeTag;
import org.openstreetmap.atlas.tags.SyntheticGeometrySlicedTag;
import org.openstreetmap.atlas.tags.SyntheticRelationMemberAdded;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class OpenBoundaryCheck
extends BaseCheck<Long> {
    private static final long serialVersionUID = 6655863145391887741L;
    private static final String OPEN_BOUNDARY_INSTRUCTIONS = "The Multipolygon relation {0,number,#} with members : {1} is not closed at some locations : {2}";
    private static final List<String> FALLBACK_INSTRUCTIONS = Collections.singletonList("The Multipolygon relation {0,number,#} with members : {1} is not closed at some locations : {2}");
    private static final RelationOrAreaToMultiPolygonConverter RELATION_OR_AREA_TO_MULTI_POLYGON_CONVERTER = new RelationOrAreaToMultiPolygonConverter();

    public OpenBoundaryCheck(Configuration configuration) {
        super(configuration);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        Map tags = object.getTags();
        return object instanceof Relation && !this.isFlagged(object.getOsmIdentifier()) && Validators.isOfType((Taggable)object, RelationTypeTag.class, (Enum[])new RelationTypeTag[]{RelationTypeTag.BOUNDARY}) && !SyntheticRelationMemberAdded.hasAddedRelationMember((Taggable)object) && !SyntheticGeometrySlicedTag.isGeometrySliced((Taggable)object) && this.hasAdminLevelTag(tags) && !this.hasIsInCountry(tags);
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        this.markAsFlagged(object.getOsmIdentifier());
        Relation relation = (Relation)object;
        if (this.hasAllMembersLoaded(relation)) {
            try {
                RELATION_OR_AREA_TO_MULTI_POLYGON_CONVERTER.convert((AtlasEntity)relation);
                return Optional.empty();
            }
            catch (MultiplePolyLineToPolygonsConverter.OpenPolygonException exception) {
                List openLocations = exception.getOpenLocations();
                HashSet latlonSet = new HashSet();
                Set memberIds = relation.members().stream().map(member -> member.getEntity().getOsmIdentifier()).collect(Collectors.toSet());
                openLocations.stream().map(this::getLatLon).forEach(latlonSet::add);
                if (!openLocations.isEmpty()) {
                    return Optional.of(this.createFlag(object, this.getLocalizedInstruction(0, relation.getOsmIdentifier(), memberIds, latlonSet)));
                }
            }
            catch (Exception exception) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private String getLatLon(Location openLocation) {
        String lat = openLocation.getLatitude().toString();
        String lon = openLocation.getLongitude().toString();
        return lat + ", " + lon;
    }

    private boolean hasAdminLevelTag(Map<String, String> tags) {
        return tags.containsKey("admin_level");
    }

    private boolean hasAllMembersLoaded(Relation relation) {
        return relation.members().size() == relation.allKnownOsmMembers().size();
    }

    private boolean hasIsInCountry(Map<String, String> tags) {
        return tags.containsKey("is_in:country_code");
    }
}

