/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.relations;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.checks.utility.CommonMethods;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.ItemType;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.RelationMemberList;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class OneMemberRelationCheck
extends BaseCheck<Object> {
    public static final String OMR_INSTRUCTIONS = "This relation, {0,number,#}, contains only one member.";
    public static final String MULTIPOLYGON_OMR_INSTRUCTIONS = "This relation, {0,number,#}, contains only one member. Multi-polygon relations need multiple polygons.";
    public static final String MEMBER_RELATION_INSTRUCTIONS = "This relation, {0,number,#}, contains only relation {1,number,#}.";
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("This relation, {0,number,#}, contains only one member.", "This relation, {0,number,#}, contains only one member. Multi-polygon relations need multiple polygons.", "This relation, {0,number,#}, contains only relation {1,number,#}.");
    private static final long serialVersionUID = -4435597321329026191L;

    public OneMemberRelationCheck(Configuration configuration) {
        super(configuration);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Relation;
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Relation relation = (Relation)object;
        RelationMemberList members = relation.members();
        if (CommonMethods.getOSMRelationMemberSize(relation) == 1L) {
            if (members.get(0).getEntity().getType().equals((Object)ItemType.RELATION)) {
                return Optional.of(this.createFlag(this.getRelationMembers((Relation)object), this.getLocalizedInstruction(2, relation.getOsmIdentifier(), members.get(0).getEntity().getOsmIdentifier())));
            }
            if (relation.isGeometric()) {
                return Optional.of(this.createFlag(this.getRelationMembers((Relation)object), this.getLocalizedInstruction(1, relation.getOsmIdentifier())));
            }
            return Optional.of(this.createFlag(this.getRelationMembers((Relation)object), this.getLocalizedInstruction(0, relation.getOsmIdentifier())));
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private Set<AtlasObject> getRelationMembers(Relation relation) {
        HashSet<AtlasObject> relationMembers = new HashSet<AtlasObject>();
        ArrayDeque<Relation> toProcess = new ArrayDeque<Relation>();
        toProcess.add(relation);
        while (!toProcess.isEmpty()) {
            AtlasObject polledMember = (AtlasObject)toProcess.poll();
            if (polledMember instanceof Relation) {
                ((Relation)polledMember).members().forEach(member -> toProcess.add((Relation)member.getEntity()));
                continue;
            }
            relationMembers.add(polledMember);
        }
        return relationMembers;
    }
}

