/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.relations;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.Heading;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Line;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.RelationMember;
import org.openstreetmap.atlas.geography.atlas.items.TurnRestriction;
import org.openstreetmap.atlas.tags.Taggable;
import org.openstreetmap.atlas.tags.TurnRestrictionTag;
import org.openstreetmap.atlas.tags.annotations.validation.Validators;
import org.openstreetmap.atlas.utilities.configuration.Configuration;
import org.openstreetmap.atlas.utilities.scalars.Angle;

public class InvalidTurnRestrictionCheck
extends BaseCheck<Long> {
    private static final List<String> FALLBACK_INSTRUCTIONS = Collections.singletonList("Relation ID: {0,number,#} is marked as turn restriction, but it is not well-formed: {1}");
    private static final String MISSING_TO_FROM_VIA_INSTRUCTION = "Missing a FROM and/or TO member and/or VIA member";
    private static final String INVALID_MEMBER_TYPE_INSTRUCTION = "Invalid member type: ways are disused or under construction ";
    private static final String TOPOLOGY_NOT_MATCH_RESTRICTION_INSTRUCTION = "Restriction doesn't match topology";
    private static final String UNKNOWN_ISSUE = "Unable to specify issue";
    private static final Map<String, String> INVALID_REASON_INSTRUCTION_MAP = new HashMap<String, String>();
    private static final long serialVersionUID = -983698716949386657L;
    public static final double STRAIGHT_ROUTE_ANGLE_THRESHOLD_DEFAULT = 80.0;
    public static final double UTURN_ROUTE_ANGLE_THRESHOLD_DEFAULT = 40.0;
    private static final int MAXIMUM_ANGLE = 180;
    private final Angle straightOnAngleThreshold;
    private final Angle uturnAngleThreshold;

    public InvalidTurnRestrictionCheck(Configuration configuration) {
        super(configuration);
        this.straightOnAngleThreshold = this.configurationValue(configuration, "straight.on.angle.threshold", 80.0, Angle::degrees);
        this.uturnAngleThreshold = this.configurationValue(configuration, "uturn.angle.threshold", 40.0, Angle::degrees);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Relation && TurnRestrictionTag.isRestriction((Taggable)object);
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Relation relation = (Relation)object;
        Set members = relation.members().stream().map(RelationMember::getEntity).collect(Collectors.toSet());
        if (relation.members().stream().noneMatch(member -> member.getRole().equals("from")) || relation.members().stream().noneMatch(member -> member.getRole().equals("to")) || relation.members().stream().noneMatch(member -> member.getRole().equals("via"))) {
            return Optional.of(this.createFlag(members, this.getLocalizedInstruction(0, relation.getOsmIdentifier(), MISSING_TO_FROM_VIA_INSTRUCTION)));
        }
        if (relation.members().stream().anyMatch(member -> member.getEntity() instanceof Line)) {
            return Optional.of(this.createFlag(members, this.getLocalizedInstruction(0, relation.getOsmIdentifier(), INVALID_MEMBER_TYPE_INSTRUCTION)));
        }
        TurnRestriction turnRestriction = new TurnRestriction(relation);
        if (!turnRestriction.isValid()) {
            return Optional.of(this.createFlag(members, this.getLocalizedInstruction(0, relation.getOsmIdentifier(), this.getInstructionFromInvalidReason(turnRestriction.getInvalidReason()))));
        }
        if (!this.isValidTopology(relation)) {
            return Optional.of(this.createFlag(members, this.getLocalizedInstruction(0, relation.getOsmIdentifier(), TOPOLOGY_NOT_MATCH_RESTRICTION_INSTRUCTION)));
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private String getInstructionFromInvalidReason(String invalidReason) {
        String instruction = UNKNOWN_ISSUE;
        for (Map.Entry<String, String> entry : INVALID_REASON_INSTRUCTION_MAP.entrySet()) {
            if (!invalidReason.contains(entry.getKey())) continue;
            instruction = entry.getValue();
            break;
        }
        return instruction;
    }

    private boolean isHeadingStraight(Angle angle) {
        return Math.abs(angle.asDegrees()) < this.straightOnAngleThreshold.asDegrees();
    }

    private boolean isLeftTurn(Angle angle) {
        return angle.asDegrees() < 0.0 && angle.asDegrees() > -180.0;
    }

    private boolean isLeftTurnTopologyViolated(TurnRestrictionTag turnRestrictionTag, Angle turnAngle) {
        return (TurnRestrictionTag.ONLY_LEFT_TURN == turnRestrictionTag || TurnRestrictionTag.NO_LEFT_TURN == turnRestrictionTag) && this.isRightTurn(turnAngle);
    }

    private boolean isRightTurn(Angle angle) {
        return angle.asDegrees() > 0.0 && angle.asDegrees() < 180.0;
    }

    private boolean isRightTurnTopologyViolated(TurnRestrictionTag turnRestrictionTag, Angle turnAngle) {
        return (TurnRestrictionTag.ONLY_RIGHT_TURN == turnRestrictionTag || TurnRestrictionTag.NO_RIGHT_TURN == turnRestrictionTag) && this.isLeftTurn(turnAngle);
    }

    private boolean isStaightOnTopologyViolated(TurnRestrictionTag turnRestrictionTag, Angle turnAngle) {
        return (TurnRestrictionTag.ONLY_STRAIGHT_ON == turnRestrictionTag || TurnRestrictionTag.NO_STRAIGHT_ON == turnRestrictionTag) && !this.isHeadingStraight(turnAngle);
    }

    private boolean isUTurn(Angle angle) {
        return Math.abs(angle.asDegrees()) > this.uturnAngleThreshold.asDegrees();
    }

    private boolean isUTurnTopologyViolated(TurnRestrictionTag turnRestrictionTag, Angle turnAngle) {
        return TurnRestrictionTag.NO_U_TURN == turnRestrictionTag && !this.isUTurn(turnAngle);
    }

    private boolean isValidTopology(Relation relation) {
        TurnRestriction turnRestriction = new TurnRestriction(relation);
        Optional toAngle = turnRestriction.getTo().asPolyLine().initialHeading();
        Optional fromAngle = turnRestriction.getFrom().asPolyLine().finalHeading();
        Angle turnAngle = toAngle.isPresent() && fromAngle.isPresent() ? ((Heading)toAngle.get()).subtract((Angle)fromAngle.get()) : Angle.NONE;
        Optional turnRestrictionTag = Validators.from(TurnRestrictionTag.class, (Taggable)relation);
        return turnRestrictionTag.isPresent() && !this.isStaightOnTopologyViolated((TurnRestrictionTag)turnRestrictionTag.get(), turnAngle) && !this.isLeftTurnTopologyViolated((TurnRestrictionTag)turnRestrictionTag.get(), turnAngle) && !this.isRightTurnTopologyViolated((TurnRestrictionTag)turnRestrictionTag.get(), turnAngle) && !this.isUTurnTopologyViolated((TurnRestrictionTag)turnRestrictionTag.get(), turnAngle);
    }

    static {
        String routeInstruction = "There is not a single navigable route to restrict, this restriction may be redundant or need to be split in to multiple relations";
        INVALID_REASON_INSTRUCTION_MAP.put("Cannot have a route with no members", "There is not a single navigable route to restrict, this restriction may be redundant or need to be split in to multiple relations");
        INVALID_REASON_INSTRUCTION_MAP.put("Restriction relation should not have more than 1 via node.", "A Turn Restriction should only have 1 via Node");
        INVALID_REASON_INSTRUCTION_MAP.put("has same members in from and to, but has no via members to disambiguate.", "Via member is required for restrictions with the same to and from members");
        INVALID_REASON_INSTRUCTION_MAP.put("Can't build route from", "There is not a single navigable route to restrict, this restriction may be redundant or need to be split in to multiple relations");
        INVALID_REASON_INSTRUCTION_MAP.put("Unable to build a route from edges", "There is not a single navigable route to restrict, this restriction may be redundant or need to be split in to multiple relations");
        INVALID_REASON_INSTRUCTION_MAP.put("A route was found from start to end, but not every unique edge was used", "There is not a single navigable route to restrict, this restriction may be redundant or need to be split in to multiple relations");
        INVALID_REASON_INSTRUCTION_MAP.put("No edge that connects to the current route", "There is not a single navigable route to restrict, this restriction may be redundant or need to be split in to multiple relations");
    }
}

