/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.relations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.checks.utility.CommonMethods;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Relation;
import org.openstreetmap.atlas.geography.atlas.items.RelationMember;
import org.openstreetmap.atlas.geography.atlas.items.RelationMemberList;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class DuplicateRelationCheck
extends BaseCheck<Object> {
    public static final String DUPLICATE_RELATION_INSTRUCTIONS = "Relation {0} and {1} are duplicates with same OSM tags and same members with same roles.";
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("Relation {0} and {1} are duplicates with same OSM tags and same members with same roles.");
    private static final long serialVersionUID = 2723186269280026809L;

    public DuplicateRelationCheck(Configuration configuration) {
        super(configuration);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Relation && !this.isFlagged(object.getOsmIdentifier());
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        Relation relation = (Relation)object;
        this.markAsFlagged(relation.getOsmIdentifier());
        if (CommonMethods.getOSMRelationMemberSize(relation) == 1L) {
            return Optional.empty();
        }
        HashSet relations = new HashSet();
        List members = relation.members().stream().collect(Collectors.toList());
        for (Object member : members) {
            relations.addAll(member.getEntity().relations());
        }
        relations.remove(relation);
        ArrayList<Long> duplicates = new ArrayList<Long>();
        for (Relation possibleDuplicate : relations) {
            if (!relation.getOsmTags().equals(possibleDuplicate.getOsmTags()) || !this.areSameMembers(relation.members(), possibleDuplicate.members())) continue;
            duplicates.add(possibleDuplicate.getOsmIdentifier());
            this.markAsFlagged(possibleDuplicate.getOsmIdentifier());
        }
        String duplicatesString = ((Object)duplicates).toString().replace("[", "").replace("]", "");
        if (!duplicates.isEmpty()) {
            return Optional.of(this.createFlag(object, this.getLocalizedInstruction(0, Long.toString(relation.getOsmIdentifier()), duplicatesString)));
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private boolean areSameMembers(RelationMemberList first, RelationMemberList second) {
        List firstMembers = first.stream().collect(Collectors.toList());
        List<RelationMember> secondMembers = second.stream().collect(Collectors.toList());
        if (firstMembers.size() != secondMembers.size()) {
            return false;
        }
        for (RelationMember relationMember : first) {
            Optional<RelationMember> secondMember = this.containsMember(secondMembers, relationMember);
            if (secondMember.isPresent()) {
                secondMembers.remove(secondMember.get());
                continue;
            }
            return false;
        }
        return secondMembers.isEmpty();
    }

    private Optional<RelationMember> containsMember(List<RelationMember> membersList, RelationMember member) {
        for (RelationMember relationMember : membersList) {
            if (relationMember.compareTo(member) != 0) continue;
            return Optional.of(relationMember);
        }
        return Optional.empty();
    }
}

