/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.points;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Point;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class OrphanNodeCheck
extends BaseCheck<Long> {
    private static final List<String> FALLBACK_INSTRUCTIONS = Arrays.asList("Node with OSM ID {0,number,#} is an orphan, no tags and not connected to any ways.");
    private static final long serialVersionUID = 7621363218174632277L;

    public OrphanNodeCheck(Configuration configuration) {
        super(configuration);
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        return object instanceof Point && object.getOsmTags().size() == 0 && ((Point)object).relations().size() == 0;
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        return Optional.of(this.createFlag(object, this.getLocalizedInstruction(0, object.getOsmIdentifier())));
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }
}

