/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.atlas.checks.validation.points;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.openstreetmap.atlas.checks.base.BaseCheck;
import org.openstreetmap.atlas.checks.flag.CheckFlag;
import org.openstreetmap.atlas.geography.Location;
import org.openstreetmap.atlas.geography.atlas.Atlas;
import org.openstreetmap.atlas.geography.atlas.items.AtlasObject;
import org.openstreetmap.atlas.geography.atlas.items.Point;
import org.openstreetmap.atlas.utilities.configuration.Configuration;

public class LoneNodeCheck
extends BaseCheck<Long> {
    private static final long serialVersionUID = -1489101405354234053L;
    private static final List<String> DEFAULT_HIGHWAY_VALUES_CHECKED = List.of("crossing", "turning_circle", "traffic_signals", "stop", "give_way", "motorway_junction", "mini_roundabout", "passing_place", "turning_loop");
    private static final Predicate<? extends AtlasObject> HAS_HIGHWAY_RAILWAY = obj -> obj.getTag("highway").isPresent() || obj.getTag("railway").isPresent();
    private static final String LONE_NODE_INSTRUCTION = "This node {0,number,#} has a Highway tag but is not part of any way that has a highway or railway tag. Either add such a tag to the appropriate parent or remove the highway tag from the node.";
    private static final List<String> FALLBACK_INSTRUCTIONS = Collections.singletonList("This node {0,number,#} has a Highway tag but is not part of any way that has a highway or railway tag. Either add such a tag to the appropriate parent or remove the highway tag from the node.");
    private List<String> highwayValuesToCheck;

    public LoneNodeCheck(Configuration configuration) {
        super(configuration);
        this.highwayValuesToCheck = this.configurationValue(configuration, "valid.highway.tag", DEFAULT_HIGHWAY_VALUES_CHECKED).stream().map(String::toLowerCase).collect(Collectors.toList());
    }

    @Override
    public boolean validCheckForObject(AtlasObject object) {
        Optional highwayValue = object.getTag("highway");
        return object instanceof Point && highwayValue.isPresent() && this.highwayValuesToCheck.contains(highwayValue.get()) && !this.isFlagged(object.getOsmIdentifier());
    }

    @Override
    protected Optional<CheckFlag> flag(AtlasObject object) {
        this.markAsFlagged(object.getOsmIdentifier());
        if (this.isLoneNode(object)) {
            return Optional.of(this.createFlag(object, this.getLocalizedInstruction(0, object.getOsmIdentifier())));
        }
        return Optional.empty();
    }

    @Override
    protected List<String> getFallbackInstructions() {
        return FALLBACK_INSTRUCTIONS;
    }

    private boolean isLoneNode(AtlasObject object) {
        Atlas atlas = object.getAtlas();
        Location pointLocation = ((Point)object).getLocation();
        Iterable connectedLines = atlas.lineItemsContaining(pointLocation, HAS_HIGHWAY_RAILWAY);
        Iterable connectedAreas = atlas.areasCovering(pointLocation, HAS_HIGHWAY_RAILWAY);
        return StreamSupport.stream(connectedAreas.spliterator(), false).count() == 0L && StreamSupport.stream(connectedLines.spliterator(), false).count() == 0L;
    }
}

